/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.util.LongSummaryStatistics;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.stream.LongStream;
import org.infinispan.BaseCacheStream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.DoubleCacheStream;
import org.infinispan.IntCacheStream;
import org.infinispan.LongCacheStream;
import org.infinispan.commons.util.IntSet;
import org.infinispan.stream.impl.DistributedLongCacheStream;
import org.infinispan.stream.impl.IntermediateCacheStream;
import org.infinispan.stream.impl.IntermediateCacheStreamSupplier;
import org.infinispan.stream.impl.IntermediateDoubleCacheStream;
import org.infinispan.stream.impl.IntermediateIntCacheStream;
import org.infinispan.stream.impl.IntermediateType;
import org.infinispan.stream.impl.local.LocalLongCacheStream;

public class IntermediateLongCacheStream
implements LongCacheStream {
    private BaseCacheStream remoteStream;
    private final IntermediateType type;
    private LocalLongCacheStream localLongStream;
    private IntermediateCacheStreamSupplier supplier;

    public IntermediateLongCacheStream(DistributedLongCacheStream remoteStream) {
        this.remoteStream = remoteStream;
        this.type = IntermediateType.LONG;
        this.supplier = new IntermediateCacheStreamSupplier(this.type, remoteStream);
        this.localLongStream = new LocalLongCacheStream(this.supplier, remoteStream.parallel, remoteStream.registry);
    }

    public IntermediateLongCacheStream(BaseCacheStream remoteStream, IntermediateType type, LocalLongCacheStream localLongStream, IntermediateCacheStreamSupplier supplier) {
        this.remoteStream = remoteStream;
        this.type = type;
        this.localLongStream = localLongStream;
        this.supplier = supplier;
    }

    @Override
    public LongCacheStream sequentialDistribution() {
        this.remoteStream = this.remoteStream.sequentialDistribution();
        return this;
    }

    @Override
    public LongCacheStream parallelDistribution() {
        this.remoteStream = this.remoteStream.parallelDistribution();
        return this;
    }

    @Override
    public LongCacheStream filterKeySegments(Set<Integer> segments) {
        this.remoteStream = this.remoteStream.filterKeySegments(segments);
        return this;
    }

    @Override
    public LongCacheStream filterKeySegments(IntSet segments) {
        this.remoteStream = this.remoteStream.filterKeySegments(segments);
        return this;
    }

    @Override
    public LongCacheStream filterKeys(Set<?> keys) {
        this.remoteStream = this.remoteStream.filterKeys(keys);
        return this;
    }

    @Override
    public LongCacheStream distributedBatchSize(int batchSize) {
        this.remoteStream = this.remoteStream.distributedBatchSize(batchSize);
        return this;
    }

    @Override
    public LongCacheStream segmentCompletionListener(BaseCacheStream.SegmentCompletionListener listener) {
        throw new UnsupportedOperationException("Segment completion listener is only supported when no intermediate operation is provided (sorted, distinct, limit, skip)");
    }

    @Override
    public LongCacheStream disableRehashAware() {
        this.remoteStream = this.remoteStream.disableRehashAware();
        return this;
    }

    @Override
    public LongCacheStream timeout(long timeout, TimeUnit unit) {
        this.remoteStream = this.remoteStream.timeout(timeout, unit);
        return this;
    }

    @Override
    public boolean isParallel() {
        return this.localLongStream.isParallel();
    }

    @Override
    public LongCacheStream sorted() {
        this.localLongStream = this.localLongStream.sorted();
        return this;
    }

    @Override
    public LongCacheStream limit(long maxSize) {
        this.localLongStream = this.localLongStream.limit(maxSize);
        return this;
    }

    @Override
    public LongCacheStream skip(long n) {
        this.localLongStream = this.localLongStream.skip(n);
        return this;
    }

    @Override
    public LongCacheStream peek(LongConsumer action) {
        this.localLongStream = this.localLongStream.peek(action);
        return this;
    }

    @Override
    public LongCacheStream distinct() {
        this.localLongStream = this.localLongStream.distinct();
        return this;
    }

    @Override
    public LongCacheStream filter(LongPredicate predicate) {
        this.localLongStream = this.localLongStream.filter(predicate);
        return this;
    }

    @Override
    public LongCacheStream map(LongUnaryOperator mapper) {
        this.localLongStream.map(mapper);
        return this;
    }

    @Override
    public <U> CacheStream<U> mapToObj(LongFunction<? extends U> mapper) {
        return new IntermediateCacheStream(this.remoteStream, this.type, this.localLongStream.mapToObj((LongFunction)mapper), this.supplier);
    }

    @Override
    public IntCacheStream mapToInt(LongToIntFunction mapper) {
        return new IntermediateIntCacheStream(this.remoteStream, this.type, this.localLongStream.mapToInt(mapper), this.supplier);
    }

    @Override
    public DoubleCacheStream mapToDouble(LongToDoubleFunction mapper) {
        return new IntermediateDoubleCacheStream(this.remoteStream, this.type, this.localLongStream.mapToDouble(mapper), this.supplier);
    }

    @Override
    public LongCacheStream flatMap(LongFunction<? extends LongStream> mapper) {
        this.localLongStream.flatMap((LongFunction)mapper);
        return this;
    }

    @Override
    public LongCacheStream parallel() {
        this.remoteStream = (BaseCacheStream)this.remoteStream.parallel();
        this.localLongStream = (LocalLongCacheStream)this.localLongStream.parallel();
        return this;
    }

    @Override
    public PrimitiveIterator.OfLong iterator() {
        return this.localLongStream.iterator();
    }

    @Override
    public Spliterator.OfLong spliterator() {
        return this.localLongStream.spliterator();
    }

    @Override
    public LongCacheStream sequential() {
        this.remoteStream = (BaseCacheStream)this.remoteStream.sequential();
        this.localLongStream = (LocalLongCacheStream)this.localLongStream.sequential();
        return this;
    }

    @Override
    public LongCacheStream unordered() {
        this.localLongStream = (LocalLongCacheStream)this.localLongStream.unordered();
        return this;
    }

    @Override
    public void forEach(LongConsumer action) {
        this.localLongStream.forEach(action);
    }

    @Override
    public <K, V> void forEach(ObjLongConsumer<Cache<K, V>> action) {
        this.localLongStream.forEach(action);
    }

    @Override
    public void forEachOrdered(LongConsumer action) {
        this.localLongStream.forEachOrdered(action);
    }

    @Override
    public long[] toArray() {
        return this.localLongStream.toArray();
    }

    @Override
    public long reduce(long identity, LongBinaryOperator op) {
        return this.localLongStream.reduce(identity, op);
    }

    @Override
    public OptionalLong reduce(LongBinaryOperator op) {
        return this.localLongStream.reduce(op);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return this.localLongStream.collect(supplier, accumulator, combiner);
    }

    @Override
    public long sum() {
        return this.localLongStream.sum();
    }

    @Override
    public OptionalLong min() {
        return this.localLongStream.min();
    }

    @Override
    public OptionalLong max() {
        return this.localLongStream.max();
    }

    @Override
    public long count() {
        return this.localLongStream.count();
    }

    @Override
    public OptionalDouble average() {
        return this.localLongStream.average();
    }

    @Override
    public LongSummaryStatistics summaryStatistics() {
        return this.localLongStream.summaryStatistics();
    }

    @Override
    public boolean anyMatch(LongPredicate predicate) {
        return this.localLongStream.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(LongPredicate predicate) {
        return this.localLongStream.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(LongPredicate predicate) {
        return this.localLongStream.noneMatch(predicate);
    }

    @Override
    public OptionalLong findFirst() {
        return this.localLongStream.findFirst();
    }

    @Override
    public OptionalLong findAny() {
        return this.localLongStream.findAny();
    }

    @Override
    public CacheStream<Long> boxed() {
        return this.mapToObj(Long::valueOf);
    }

    @Override
    public DoubleCacheStream asDoubleStream() {
        return this.mapToDouble(l -> l);
    }

    @Override
    public LongCacheStream onClose(Runnable closeHandler) {
        this.remoteStream = (BaseCacheStream)this.remoteStream.onClose(closeHandler);
        return this;
    }

    @Override
    public void close() {
        this.localLongStream.close();
        this.remoteStream.close();
    }
}

