/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.transformation.function;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.transformation.CascadeFunction;
import org.apache.inlong.sort.protocol.transformation.ConstantParam;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;
import org.apache.inlong.sort.protocol.transformation.StringConstantParam;

@JsonTypeName(value="regexpReplace")
public class RegexpReplaceFunction
implements CascadeFunction,
Serializable {
    private static final long serialVersionUID = -2701547146694616429L;
    @JsonProperty(value="field")
    private FieldInfo field;
    @JsonProperty(value="regex")
    private StringConstantParam regex;
    @JsonProperty(value="replacement")
    private StringConstantParam replacement;

    @JsonCreator
    public RegexpReplaceFunction(@JsonProperty(value="field") FieldInfo field, @JsonProperty(value="regex") StringConstantParam regex, @JsonProperty(value="replacement") StringConstantParam replacement) {
        this.field = Preconditions.checkNotNull(field, "field is null");
        this.regex = Preconditions.checkNotNull(regex, "regex is null");
        this.replacement = Preconditions.checkNotNull(replacement, "replacement is null");
    }

    @Override
    public String getName() {
        return "REGEXP_REPLACE";
    }

    @Override
    public List<FunctionParam> getParams() {
        return Arrays.asList(this.field, this.regex, this.replacement);
    }

    @Override
    public String format() {
        return String.format("%s(%s, %s, %s)", this.getName(), this.field.format(), this.regex.format(), this.replacement.format());
    }

    @Override
    public ConstantParam apply(ConstantParam constantParam) {
        return new ConstantParam(String.format("%s(%s, %s, %s)", this.getName(), constantParam.format(), this.regex.format(), this.replacement.format()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegexpReplaceFunction)) {
            return false;
        }
        RegexpReplaceFunction other = (RegexpReplaceFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FieldInfo this$field = this.getField();
        FieldInfo other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        StringConstantParam this$regex = this.getRegex();
        StringConstantParam other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !((Object)this$regex).equals(other$regex)) {
            return false;
        }
        StringConstantParam this$replacement = this.getReplacement();
        StringConstantParam other$replacement = other.getReplacement();
        return !(this$replacement == null ? other$replacement != null : !((Object)this$replacement).equals(other$replacement));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegexpReplaceFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FieldInfo $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        StringConstantParam $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : ((Object)$regex).hashCode());
        StringConstantParam $replacement = this.getReplacement();
        result = result * 59 + ($replacement == null ? 43 : ((Object)$replacement).hashCode());
        return result;
    }

    public FieldInfo getField() {
        return this.field;
    }

    public StringConstantParam getRegex() {
        return this.regex;
    }

    public StringConstantParam getReplacement() {
        return this.replacement;
    }

    public void setField(FieldInfo field) {
        this.field = field;
    }

    public void setRegex(StringConstantParam regex) {
        this.regex = regex;
    }

    public void setReplacement(StringConstantParam replacement) {
        this.replacement = replacement;
    }

    public String toString() {
        return "RegexpReplaceFunction(field=" + this.getField() + ", regex=" + this.getRegex() + ", replacement=" + this.getReplacement() + ")";
    }
}

