/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.HSetCommand;
import com.moilioncircle.redis.replicator.util.ByteArrayMap;

public class HSetParser
implements CommandParser<HSetCommand> {
    @Override
    public HSetCommand parse(Object[] command) {
        int idx = 1;
        byte[] key = CommandParsers.toBytes(command[idx]);
        ++idx;
        ByteArrayMap fields = new ByteArrayMap();
        byte[] firstField = null;
        byte[] firstValue = null;
        while (idx < command.length) {
            byte[] field = CommandParsers.toBytes(command[idx]);
            byte[] value = ++idx == command.length ? null : CommandParsers.toBytes(command[idx]);
            ++idx;
            if (firstField == null) {
                firstField = field;
            }
            if (firstValue == null) {
                firstValue = value;
            }
            fields.put(field, value);
        }
        HSetCommand hSetCommand = new HSetCommand(key, fields);
        hSetCommand.setField(firstField);
        hSetCommand.setValue(firstValue);
        return hSetCommand;
    }
}

