/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.utils;

import java.util.Date;
import java.util.HashMap;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.metrics.AgentEventMetricItem;
import org.apache.inlong.agent.metrics.AgentEventMetricItemSet;
import org.apache.inlong.common.metric.MetricItemSet;
import org.apache.inlong.common.metric.MetricRegister;

public class EventReportUtils {
    private static final String COMPONENT_TYPE_AGENT = "AGENT";
    private static final String COMPONENT_NAME_AGENT = "AGENT";
    public static final String EVENT_TYPE_CONFIG_UPDATE = "CONFIG_UPDATE";
    public static final String EVENT_LEVEL_INFO = "INFO";
    public static final String EVENT_LEVEL_WARN = "WARN";
    public static final String EVENT_LEVEL_ERROR = "ERROR";
    private static AgentEventMetricItemSet metricItemSet;

    private EventReportUtils() {
    }

    public static void init() {
        metricItemSet = new AgentEventMetricItemSet("AGENT");
        MetricRegister.register((MetricItemSet)metricItemSet);
    }

    public static void report(String groupId, String streamId, long eventTime, String eventType, String eventLevel, EvenCodeEnum evenCode, String ext, String desc) {
        HashMap<String, String> dims = new HashMap<String, String>();
        dims.put("groupId", groupId);
        dims.put("streamId", streamId);
        dims.put("componentType", "AGENT");
        dims.put("componentName", "AGENT");
        dims.put("agentIp", AgentConfiguration.getAgentConf().get("agent.local.ip"));
        dims.put("componentVersion", EventReportUtils.class.getPackage().getImplementationVersion());
        dims.put("eventTime", AgentEventMetricItem.FORMAT.format(new Date(eventTime)));
        dims.put("eventType", eventType);
        dims.put("eventLevel", eventLevel);
        dims.put("eventCode", String.valueOf(evenCode.getCode()));
        dims.put("ext", ext.replaceAll("\\|", "-"));
        dims.put("eventDesc", desc);
        ((AgentEventMetricItem)EventReportUtils.metricItemSet.findMetricItem(dims)).count.addAndGet(1L);
    }

    public static enum EvenCodeEnum {
        CONFIG_UPDATE_SUC(0, "config update suc"),
        CONFIG_NO_UPDATE(1, "config no update"),
        CONFIG_UPDATE_VERSION_NO_CHANGE(2, "config update version no change"),
        CONFIG_INVALID_RET_CODE(3, "config invalid ret code"),
        CONFIG_INVALID_RESULT(4, "config invalid result maybe visit manager failed"),
        TASK_ADD(5, "task add"),
        TASK_DELETE(6, "task delete");

        private final int code;
        private final String message;

        private EvenCodeEnum(int code, String message) {
            this.code = code;
            this.message = message;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

