/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.conf.OffsetProfile;
import org.apache.inlong.agent.core.FileStaticManager;
import org.apache.inlong.agent.core.task.MemoryManager;
import org.apache.inlong.agent.core.task.OffsetManager;
import org.apache.inlong.agent.except.FileException;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.sources.extend.DefaultExtendedHandler;
import org.apache.inlong.agent.plugin.sources.file.AbstractSource;
import org.apache.inlong.agent.plugin.utils.cos.COSUtils;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class COSSource
extends AbstractSource {
    public static final int LEN_OF_FILE_OFFSET_ARRAY = 2;
    public static final String AGENT_GLOBAL_COS_SOURCE_PERMIT = "agent.global.cos.source.permit";
    public static final int DEFAULT_AGENT_GLOBAL_COS_SOURCE_PERMIT = 128000000;
    private static final Logger LOGGER = LoggerFactory.getLogger(COSSource.class);
    public static final String OFFSET_SEP = ":";
    protected final Integer WAIT_TIMEOUT_MS = 10;
    private final Integer SIZE_OF_BUFFER_TO_READ_FILE = 0x100000;
    private final Long META_UPDATE_INTERVAL_MS = 10000L;
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String fileName;
    private byte[] bufferToReadFile;
    public volatile long linePosition = 0L;
    public volatile long bytePosition = 0L;
    private volatile boolean fileExist = true;
    private volatile long lastInodeUpdateTime = 0L;
    private COSClient cosClient;
    private String bucketName;
    private String secretId;
    private String secretKey;
    private String strRegion;
    private ObjectMetadata metadata;
    protected BlockingQueue<AbstractSource.SourceData> queue;
    private static final ThreadPoolExecutor EXECUTOR_SERVICE = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new AgentThreadFactory("cos-source-pool"));
    private volatile boolean running = false;

    @Override
    protected void initExtendClass() {
        this.extendClass = DefaultExtendedHandler.class.getCanonicalName();
    }

    @Override
    protected void initSource(InstanceProfile profile) {
        try {
            String offset = "";
            if (this.offsetProfile != null) {
                offset = this.offsetProfile.toJsonStr();
            }
            LOGGER.info("COS source init: {} offset: {}", (Object)profile.toJsonStr(), (Object)offset);
            AgentConfiguration conf = AgentConfiguration.getAgentConf();
            int permit = conf.getInt(AGENT_GLOBAL_COS_SOURCE_PERMIT, 128000000);
            MemoryManager.getInstance().addSemaphore(AGENT_GLOBAL_COS_SOURCE_PERMIT, permit);
            this.fileName = profile.getInstanceId();
            this.bucketName = profile.get("task.cosTask.bucketName");
            this.secretId = profile.get("task.cosTask.secretId");
            this.secretKey = profile.get("task.cosTask.secretKey");
            this.strRegion = profile.get("task.cosTask.region");
            this.cosClient = COSUtils.createCli(this.secretId, this.secretKey, this.strRegion);
            this.metadata = this.cosClient.getObjectMetadata(this.bucketName, this.fileName);
            this.queue = new LinkedBlockingQueue<AbstractSource.SourceData>(this.CACHE_QUEUE_SIZE);
            this.bufferToReadFile = new byte[this.SIZE_OF_BUFFER_TO_READ_FILE.intValue()];
            this.lastInodeUpdateTime = AgentUtils.getCurrentTime();
            this.initOffset(this.taskId);
            EXECUTOR_SERVICE.execute(this.run());
        }
        catch (Exception ex) {
            this.stopRunning();
            throw new FileException("error init stream for " + this.fileName, (Throwable)ex);
        }
    }

    @Override
    protected boolean doPrepareToRead() {
        if (AgentUtils.getCurrentTime() - this.lastInodeUpdateTime > this.META_UPDATE_INTERVAL_MS) {
            this.metadata = this.cosClient.getObjectMetadata(this.bucketName, this.fileName);
            this.lastInodeUpdateTime = AgentUtils.getCurrentTime();
        }
        if (this.metadata.getContentLength() < this.bytePosition) {
            this.fileExist = false;
            LOGGER.info("file rotate, instance will restart and offset will be clean, file {}", (Object)this.fileName);
            return false;
        }
        return true;
    }

    @Override
    protected List<AbstractSource.SourceData> readFromSource() {
        int len;
        if (this.queue.isEmpty()) {
            return null;
        }
        int count = 0;
        ArrayList<AbstractSource.SourceData> lines = new ArrayList<AbstractSource.SourceData>();
        for (len = 0; !this.queue.isEmpty() && count < this.BATCH_READ_LINE_COUNT && len < this.BATCH_READ_LINE_TOTAL_LEN && len + ((AbstractSource.SourceData)this.queue.peek()).getData().length <= this.BATCH_READ_LINE_TOTAL_LEN; len += ((AbstractSource.SourceData)this.queue.peek()).getData().length, ++count) {
            lines.add((AbstractSource.SourceData)this.queue.poll());
        }
        MemoryManager.getInstance().release(AGENT_GLOBAL_COS_SOURCE_PERMIT, len);
        return lines;
    }

    @Override
    protected void printCurrentState() {
        LOGGER.info("path is {}, linePosition {}, bytePosition is {} file len {}", new Object[]{this.fileName, this.linePosition, this.bytePosition, this.metadata.getContentLength()});
    }

    @Override
    protected String getThreadName() {
        return "cos-file-source-" + this.taskId + "-" + this.fileName;
    }

    private void initOffset(String taskId) {
        long byteOffset;
        long lineOffset;
        if (this.offsetProfile != null) {
            FileOffset fileOffset = this.parseFIleOffset(this.offsetProfile.getOffset());
            lineOffset = fileOffset.lineOffset;
            byteOffset = fileOffset.byteOffset;
            LOGGER.info("initOffset inode no change taskId {} restore lineOffset {} byteOffset {}, file {}", new Object[]{taskId, lineOffset, byteOffset, this.fileName});
        } else {
            lineOffset = 0L;
            byteOffset = 0L;
            LOGGER.info("initOffset taskId {} for new all read lineOffset {} byteOffset {} file {}", new Object[]{taskId, lineOffset, byteOffset, this.fileName});
        }
        this.linePosition = lineOffset;
        this.bytePosition = byteOffset;
    }

    private Runnable run() {
        return () -> {
            AgentThreadFactory.nameThread((String)this.getThreadName());
            this.running = true;
            try {
                this.doRun();
            }
            catch (Throwable e) {
                LOGGER.error("do run error maybe file deleted: ", e);
                ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)e);
            }
            this.running = false;
        };
    }

    protected void doRun() throws IOException {
        int num;
        GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucketName, this.fileName);
        getObjectRequest.setRange(this.bytePosition, this.metadata.getContentLength());
        COSObject cosObject = this.cosClient.getObject(getObjectRequest);
        COSObjectInputStream inputStream = cosObject.getObjectContent();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean overLen = false;
        while ((num = inputStream.read(this.bufferToReadFile)) != -1) {
            LOGGER.debug("read size {}", (Object)num);
            block5: for (int i = 0; i < num; ++i) {
                byte ch = this.bufferToReadFile[i];
                ++this.bytePosition;
                switch (ch) {
                    case 10: {
                        AbstractSource.SourceData sourceData;
                        boolean suc4Queue;
                        ++this.linePosition;
                        boolean suc = false;
                        while (this.isRunnable() && !suc && (suc4Queue = this.waitForPermit(AGENT_GLOBAL_COS_SOURCE_PERMIT, (sourceData = new AbstractSource.SourceData(this, baos.toByteArray(), this.getOffsetString(this.linePosition, this.bytePosition))).getData().length))) {
                            suc = this.queue.offer(sourceData);
                            if (suc) continue;
                            MemoryManager.getInstance().release(AGENT_GLOBAL_COS_SOURCE_PERMIT, sourceData.getData().length);
                            AgentUtils.silenceSleepInMs((long)this.WAIT_TIMEOUT_MS.intValue());
                        }
                        if (overLen) {
                            LOGGER.warn("readLines over len finally string len {}", (Object)new String(baos.toByteArray()).length());
                            long auditTime = 0L;
                            auditTime = this.profile.getSinkDataTime();
                            AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_READ_FAILED, (String)this.inlongGroupId, (String)this.inlongStreamId, (long)auditTime, (int)1, (long)this.maxPackSize, (long)this.auditVersion);
                            AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_READ_FAILED_REAL_TIME, (String)this.inlongGroupId, (String)this.inlongStreamId, (long)AgentUtils.getCurrentTime(), (int)1, (long)this.maxPackSize, (long)this.auditVersion);
                        }
                        baos.reset();
                        overLen = false;
                        continue block5;
                    }
                    case 13: {
                        continue block5;
                    }
                    default: {
                        if (baos.size() < this.maxPackSize) {
                            baos.write(ch);
                            continue block5;
                        }
                        overLen = true;
                    }
                }
            }
        }
        baos.close();
        inputStream.close();
        cosObject.close();
    }

    private String getOffsetString(Long lineOffset, Long byteOffset) {
        return lineOffset + OFFSET_SEP + byteOffset;
    }

    private FileOffset parseFIleOffset(String offset) {
        String[] offsetArray = offset.split(OFFSET_SEP);
        if (offsetArray.length == 2) {
            return new FileOffset(Long.parseLong(offsetArray[0]), Long.parseLong(offsetArray[1]), true);
        }
        return new FileOffset(Long.parseLong(offsetArray[0]), null, false);
    }

    @Override
    protected boolean isRunnable() {
        return this.runnable && this.fileExist;
    }

    public boolean sourceExist() {
        return this.fileExist;
    }

    @Override
    protected void releaseSource() {
        while (this.running) {
            AgentUtils.silenceSleepInMs((long)1L);
        }
        if (this.cosClient != null) {
            FileStaticManager.FileStatic data = new FileStaticManager.FileStatic();
            data.setTaskId(this.taskId);
            data.setRetry(String.valueOf(this.profile.isRetry()));
            data.setContentType(this.profile.get("task.cosTask.contentStyle"));
            data.setGroupId(this.profile.getInlongGroupId());
            data.setStreamId(this.profile.getInlongStreamId());
            data.setDataTime(this.format.format(this.profile.getSinkDataTime()));
            data.setFileName(this.profile.getInstanceId());
            data.setFileLen(String.valueOf(this.metadata.getContentLength()));
            data.setReadBytes(String.valueOf(this.bytePosition));
            data.setReadLines(String.valueOf(this.linePosition));
            OffsetProfile offsetProfile = OffsetManager.getInstance().getOffset(this.taskId, this.instanceId);
            if (offsetProfile != null) {
                data.setSendLines(offsetProfile.getOffset());
            }
            FileStaticManager.putStaticMsg((FileStaticManager.FileStatic)data);
            this.cosClient.shutdown();
        }
        while (!this.queue.isEmpty()) {
            MemoryManager.getInstance().release(AGENT_GLOBAL_COS_SOURCE_PERMIT, ((AbstractSource.SourceData)this.queue.poll()).getData().length);
        }
    }

    private boolean waitForPermit(String permitName, int permitLen) {
        boolean suc = false;
        while (!suc) {
            suc = MemoryManager.getInstance().tryAcquire(permitName, permitLen);
            if (suc) continue;
            MemoryManager.getInstance().printDetail(permitName, "cos_source");
            if (!this.isRunnable()) {
                return false;
            }
            AgentUtils.silenceSleepInMs((long)this.WAIT_TIMEOUT_MS.intValue());
        }
        return true;
    }

    protected class FileOffset {
        private Long lineOffset;
        private Long byteOffset;
        private boolean hasByteOffset;

        public Long getLineOffset() {
            return this.lineOffset;
        }

        public Long getByteOffset() {
            return this.byteOffset;
        }

        public boolean isHasByteOffset() {
            return this.hasByteOffset;
        }

        public void setLineOffset(Long lineOffset) {
            this.lineOffset = lineOffset;
        }

        public void setByteOffset(Long byteOffset) {
            this.byteOffset = byteOffset;
        }

        public void setHasByteOffset(boolean hasByteOffset) {
            this.hasByteOffset = hasByteOffset;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileOffset)) {
                return false;
            }
            FileOffset other = (FileOffset)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isHasByteOffset() != other.isHasByteOffset()) {
                return false;
            }
            Long this$lineOffset = this.getLineOffset();
            Long other$lineOffset = other.getLineOffset();
            if (this$lineOffset == null ? other$lineOffset != null : !((Object)this$lineOffset).equals(other$lineOffset)) {
                return false;
            }
            Long this$byteOffset = this.getByteOffset();
            Long other$byteOffset = other.getByteOffset();
            return !(this$byteOffset == null ? other$byteOffset != null : !((Object)this$byteOffset).equals(other$byteOffset));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileOffset;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isHasByteOffset() ? 79 : 97);
            Long $lineOffset = this.getLineOffset();
            result = result * 59 + ($lineOffset == null ? 43 : ((Object)$lineOffset).hashCode());
            Long $byteOffset = this.getByteOffset();
            result = result * 59 + ($byteOffset == null ? 43 : ((Object)$byteOffset).hashCode());
            return result;
        }

        public String toString() {
            return "COSSource.FileOffset(lineOffset=" + this.getLineOffset() + ", byteOffset=" + this.getByteOffset() + ", hasByteOffset=" + this.isHasByteOffset() + ")";
        }

        public FileOffset(Long lineOffset, Long byteOffset, boolean hasByteOffset) {
            this.lineOffset = lineOffset;
            this.byteOffset = byteOffset;
            this.hasByteOffset = hasByteOffset;
        }

        public FileOffset() {
        }
    }
}

