/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.CopyOnWriteHashMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.TypeParsers;

public class ObjectMapper
extends Mapper
implements Cloneable {
    public static final String CONTENT_TYPE = "object";
    public static final String NESTED_CONTENT_TYPE = "nested";
    private final String fullPath;
    private final boolean enabled;
    private final Nested nested;
    private final String nestedTypePathAsString;
    private final BytesRef nestedTypePathAsBytes;
    private final Query nestedTypeFilter;
    private volatile Dynamic dynamic;
    private Boolean includeInAll;
    private volatile CopyOnWriteHashMap<String, Mapper> mappers;

    ObjectMapper(String name, String fullPath, boolean enabled, Nested nested, Dynamic dynamic, Boolean includeInAll, Map<String, Mapper> mappers, Settings settings) {
        super(name);
        assert (settings != null);
        Version indexCreatedVersion = Version.indexCreated(settings);
        if (indexCreatedVersion.onOrAfter(Version.V_5_0_0_beta1) && name.isEmpty()) {
            throw new IllegalArgumentException("name cannot be empty string");
        }
        this.fullPath = fullPath;
        this.enabled = enabled;
        this.nested = nested;
        this.dynamic = dynamic;
        this.includeInAll = includeInAll;
        this.mappers = mappers == null ? new CopyOnWriteHashMap() : CopyOnWriteHashMap.copyOf(mappers);
        this.nestedTypePathAsString = "__" + fullPath;
        this.nestedTypePathAsBytes = new BytesRef((CharSequence)this.nestedTypePathAsString);
        this.nestedTypeFilter = new TermQuery(new Term("_type", this.nestedTypePathAsBytes));
    }

    protected ObjectMapper clone() {
        ObjectMapper clone;
        try {
            clone = (ObjectMapper)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    public ObjectMapper mappingUpdate(Mapper mapper) {
        ObjectMapper mappingUpdate = this.clone();
        mappingUpdate.mappers = new CopyOnWriteHashMap();
        mappingUpdate.putMapper(mapper);
        return mappingUpdate;
    }

    @Override
    public String name() {
        return this.fullPath;
    }

    @Override
    public String typeName() {
        return CONTENT_TYPE;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Mapper getMapper(String field) {
        return this.mappers.get(field);
    }

    public Nested nested() {
        return this.nested;
    }

    public Boolean includeInAll() {
        return this.includeInAll;
    }

    public Query nestedTypeFilter() {
        return this.nestedTypeFilter;
    }

    protected void putMapper(Mapper mapper) {
        this.mappers = this.mappers.copyAndPut(mapper.simpleName(), mapper);
    }

    @Override
    public Iterator<Mapper> iterator() {
        return this.mappers.values().iterator();
    }

    public String fullPath() {
        return this.fullPath;
    }

    public String nestedTypePathAsString() {
        return this.nestedTypePathAsString;
    }

    public final Dynamic dynamic() {
        return this.dynamic;
    }

    public ObjectMapper getParentObjectMapper(MapperService mapperService) {
        int indexOfLastDot = this.fullPath().lastIndexOf(46);
        if (indexOfLastDot != -1) {
            String parentNestObjectPath = this.fullPath().substring(0, indexOfLastDot);
            return mapperService.getObjectMapper(parentNestObjectPath);
        }
        return null;
    }

    public boolean parentObjectMapperAreNested(MapperService mapperService) {
        for (ObjectMapper parent = this.getParentObjectMapper(mapperService); parent != null; parent = parent.getParentObjectMapper(mapperService)) {
            if (parent.nested().isNested()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ObjectMapper merge(Mapper mergeWith, boolean updateAllTypes) {
        if (!(mergeWith instanceof ObjectMapper)) {
            throw new IllegalArgumentException("Can't merge a non object mapping [" + mergeWith.name() + "] with an object mapping [" + this.name() + "]");
        }
        ObjectMapper mergeWithObject = (ObjectMapper)mergeWith;
        ObjectMapper merged = this.clone();
        merged.doMerge(mergeWithObject, updateAllTypes);
        return merged;
    }

    protected void doMerge(ObjectMapper mergeWith, boolean updateAllTypes) {
        if (this.nested().isNested()) {
            if (!mergeWith.nested().isNested()) {
                throw new IllegalArgumentException("object mapping [" + this.name() + "] can't be changed from nested to non-nested");
            }
        } else if (mergeWith.nested().isNested()) {
            throw new IllegalArgumentException("object mapping [" + this.name() + "] can't be changed from non-nested to nested");
        }
        this.includeInAll = mergeWith.includeInAll;
        if (mergeWith.dynamic != null) {
            this.dynamic = mergeWith.dynamic;
        }
        for (Mapper mergeWithMapper : mergeWith) {
            Mapper mergeIntoMapper = this.mappers.get(mergeWithMapper.simpleName());
            ObjectMapper.checkEnabledFieldChange(mergeWith, mergeWithMapper, mergeIntoMapper);
            Mapper merged = mergeIntoMapper == null ? mergeWithMapper : mergeIntoMapper.merge(mergeWithMapper, updateAllTypes);
            this.putMapper(merged);
        }
    }

    private static void checkEnabledFieldChange(ObjectMapper mergeWith, Mapper mergeWithMapper, Mapper mergeIntoMapper) {
        if (mergeIntoMapper instanceof ObjectMapper && mergeWithMapper instanceof ObjectMapper) {
            ObjectMapper mergeIntoObjectMapper = (ObjectMapper)mergeIntoMapper;
            ObjectMapper mergeWithObjectMapper = (ObjectMapper)mergeWithMapper;
            if (mergeIntoObjectMapper.isEnabled() != mergeWithObjectMapper.isEnabled()) {
                String path = mergeWith.fullPath() + "." + mergeWithObjectMapper.simpleName() + ".enabled";
                throw new MapperException("Can't update attribute for type [" + path + "] in index mapping");
            }
        }
    }

    @Override
    public ObjectMapper updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
        ArrayList<Mapper> updatedMappers = null;
        for (Mapper mapper : this) {
            Mapper updated;
            if (mapper == (updated = mapper.updateFieldType(fullNameToFieldType))) continue;
            if (updatedMappers == null) {
                updatedMappers = new ArrayList<Mapper>();
            }
            updatedMappers.add(updated);
        }
        if (updatedMappers == null) {
            return this;
        }
        ObjectMapper updated = this.clone();
        for (Mapper updatedMapper : updatedMappers) {
            updated.putMapper(updatedMapper);
        }
        return updated;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.toXContent(builder, params, null);
        return builder;
    }

    public void toXContent(XContentBuilder builder, ToXContent.Params params, ToXContent custom) throws IOException {
        builder.startObject(this.simpleName());
        if (this.nested.isNested()) {
            builder.field("type", NESTED_CONTENT_TYPE);
            if (this.nested.isIncludeInParent()) {
                builder.field("include_in_parent", true);
            }
            if (this.nested.isIncludeInRoot()) {
                builder.field("include_in_root", true);
            }
        } else if (this.mappers.isEmpty() && custom == null) {
            builder.field("type", CONTENT_TYPE);
        }
        if (this.dynamic != null) {
            builder.field("dynamic", this.dynamic.name().toLowerCase(Locale.ROOT));
        }
        if (!this.enabled) {
            builder.field("enabled", this.enabled);
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", this.includeInAll);
        }
        if (custom != null) {
            custom.toXContent(builder, params);
        }
        this.doXContent(builder, params);
        Mapper[] sortedMappers = (Mapper[])this.mappers.values().stream().toArray(Mapper[]::new);
        Arrays.sort(sortedMappers, new Comparator<Mapper>(){

            @Override
            public int compare(Mapper o1, Mapper o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        int count = 0;
        for (Mapper mapper : sortedMappers) {
            if (mapper instanceof MetadataFieldMapper) continue;
            if (count++ == 0) {
                builder.startObject("properties");
            }
            mapper.toXContent(builder, params);
        }
        if (count > 0) {
            builder.endObject();
        }
        builder.endObject();
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            TypeParser.parseNested(name, node, builder, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Object fieldNode;
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                if (!TypeParser.parseObjectOrDocumentTypeProperties(fieldName, fieldNode = entry.getValue(), parserContext, builder)) continue;
                iterator.remove();
            }
            return builder;
        }

        protected static boolean parseObjectOrDocumentTypeProperties(String fieldName, Object fieldNode, Mapper.TypeParser.ParserContext parserContext, Builder builder) {
            if (fieldName.equals("dynamic")) {
                String value = fieldNode.toString();
                if (value.equalsIgnoreCase("strict")) {
                    builder.dynamic(Dynamic.STRICT);
                } else {
                    boolean dynamic = TypeParsers.nodeBooleanValue(fieldName, "dynamic", fieldNode, parserContext);
                    builder.dynamic(dynamic ? Dynamic.TRUE : Dynamic.FALSE);
                }
                return true;
            }
            if (fieldName.equals("enabled")) {
                builder.enabled(TypeParsers.nodeBooleanValue(fieldName, "enabled", fieldNode, parserContext));
                return true;
            }
            if (fieldName.equals("properties")) {
                if (!(fieldNode instanceof Collection) || !((Collection)fieldNode).isEmpty()) {
                    if (!(fieldNode instanceof Map)) {
                        throw new ElasticsearchParseException("properties must be a map type", new Object[0]);
                    }
                    TypeParser.parseProperties(builder, (Map)fieldNode, parserContext);
                }
                return true;
            }
            if (fieldName.equals("include_in_all")) {
                builder.includeInAll(TypeParsers.nodeBooleanValue(fieldName, "include_in_all", fieldNode, parserContext));
                return true;
            }
            return false;
        }

        protected static void parseNested(String name, Map<String, Object> node, Builder builder, Mapper.TypeParser.ParserContext parserContext) {
            boolean nested = false;
            boolean nestedIncludeInParent = false;
            boolean nestedIncludeInRoot = false;
            Object fieldNode = node.get("type");
            if (fieldNode != null) {
                String type = fieldNode.toString();
                if (type.equals(ObjectMapper.CONTENT_TYPE)) {
                    builder.nested = Nested.NO;
                } else if (type.equals(ObjectMapper.NESTED_CONTENT_TYPE)) {
                    nested = true;
                } else {
                    throw new MapperParsingException("Trying to parse an object but has a different type [" + type + "] for [" + name + "]");
                }
            }
            if ((fieldNode = node.get("include_in_parent")) != null) {
                nestedIncludeInParent = TypeParsers.nodeBooleanValue(name, "include_in_parent", fieldNode, parserContext);
                node.remove("include_in_parent");
            }
            if ((fieldNode = node.get("include_in_root")) != null) {
                nestedIncludeInRoot = TypeParsers.nodeBooleanValue(name, "include_in_root", fieldNode, parserContext);
                node.remove("include_in_root");
            }
            if (nested) {
                builder.nested = Nested.newNested(nestedIncludeInParent, nestedIncludeInRoot);
            }
        }

        protected static void parseProperties(Builder objBuilder, Map<String, Object> propsNode, Mapper.TypeParser.ParserContext parserContext) {
            Iterator<Map.Entry<String, Object>> iterator = propsNode.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean isEmptyList;
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                boolean bl = isEmptyList = entry.getValue() instanceof List && ((List)entry.getValue()).isEmpty();
                if (entry.getValue() instanceof Map) {
                    String type;
                    Map propNode = (Map)entry.getValue();
                    Object typeNode = propNode.get("type");
                    if (typeNode != null) {
                        type = typeNode.toString();
                    } else if (propNode.get("properties") != null) {
                        type = ObjectMapper.CONTENT_TYPE;
                    } else if (propNode.size() == 1 && propNode.get("enabled") != null) {
                        type = ObjectMapper.CONTENT_TYPE;
                    } else {
                        throw new MapperParsingException("No type specified for field [" + fieldName + "]");
                    }
                    Mapper.TypeParser typeParser = parserContext.typeParser(type);
                    if (typeParser == null) {
                        throw new MapperParsingException("No handler for type [" + type + "] declared on field [" + fieldName + "]");
                    }
                    String[] fieldNameParts = fieldName.split("\\.");
                    String realFieldName = fieldNameParts[fieldNameParts.length - 1];
                    Mapper.Builder<?, ?> fieldBuilder = typeParser.parse(realFieldName, propNode, parserContext);
                    for (int i = fieldNameParts.length - 2; i >= 0; --i) {
                        Builder intermediate = new Builder(fieldNameParts[i]);
                        intermediate.add(fieldBuilder);
                        fieldBuilder = intermediate;
                    }
                    objBuilder.add(fieldBuilder);
                    propNode.remove("type");
                    DocumentMapperParser.checkNoRemainingFields(fieldName, propNode, parserContext.indexVersionCreated());
                    iterator.remove();
                    continue;
                }
                if (isEmptyList) {
                    iterator.remove();
                    continue;
                }
                throw new MapperParsingException("Expected map for property [fields] on field [" + fieldName + "] but got a " + fieldName.getClass());
            }
            DocumentMapperParser.checkNoRemainingFields(propsNode, parserContext.indexVersionCreated(), "DocType mapping definition has unsupported parameters: ");
        }
    }

    public static class Builder<T extends Builder, Y extends ObjectMapper>
    extends Mapper.Builder<T, Y> {
        protected boolean enabled = true;
        protected Nested nested = Defaults.NESTED;
        protected Dynamic dynamic = Defaults.DYNAMIC;
        protected Boolean includeInAll;
        protected final List<Mapper.Builder> mappersBuilders = new ArrayList<Mapper.Builder>();

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        public T enabled(boolean enabled) {
            this.enabled = enabled;
            return (T)((Builder)this.builder);
        }

        public T dynamic(Dynamic dynamic) {
            this.dynamic = dynamic;
            return (T)((Builder)this.builder);
        }

        public T nested(Nested nested) {
            this.nested = nested;
            return (T)((Builder)this.builder);
        }

        public T includeInAll(boolean includeInAll) {
            this.includeInAll = includeInAll;
            return (T)((Builder)this.builder);
        }

        public T add(Mapper.Builder builder) {
            this.mappersBuilders.add(builder);
            return (T)((Builder)this.builder);
        }

        @Override
        public Y build(Mapper.BuilderContext context) {
            context.path().add(this.name);
            HashMap<String, Mapper> mappers = new HashMap<String, Mapper>();
            for (Mapper.Builder builder : this.mappersBuilders) {
                Object mapper = builder.build(context);
                Mapper existing = (Mapper)mappers.get(((Mapper)mapper).simpleName());
                if (existing != null) {
                    mapper = existing.merge((Mapper)mapper, false);
                }
                mappers.put(((Mapper)mapper).simpleName(), (Mapper)mapper);
            }
            context.path().remove();
            ObjectMapper objectMapper = this.createMapper(this.name, context.path().pathAsText(this.name), this.enabled, this.nested, this.dynamic, this.includeInAll, mappers, context.indexSettings());
            return (Y)objectMapper;
        }

        protected ObjectMapper createMapper(String name, String fullPath, boolean enabled, Nested nested, Dynamic dynamic, Boolean includeInAll, Map<String, Mapper> mappers, @Nullable Settings settings) {
            return new ObjectMapper(name, fullPath, enabled, nested, dynamic, includeInAll, mappers, settings);
        }
    }

    public static class Nested {
        public static final Nested NO = new Nested(false, false, false);
        private final boolean nested;
        private final boolean includeInParent;
        private final boolean includeInRoot;

        public static Nested newNested(boolean includeInParent, boolean includeInRoot) {
            return new Nested(true, includeInParent, includeInRoot);
        }

        private Nested(boolean nested, boolean includeInParent, boolean includeInRoot) {
            this.nested = nested;
            this.includeInParent = includeInParent;
            this.includeInRoot = includeInRoot;
        }

        public boolean isNested() {
            return this.nested;
        }

        public boolean isIncludeInParent() {
            return this.includeInParent;
        }

        public boolean isIncludeInRoot() {
            return this.includeInRoot;
        }
    }

    public static enum Dynamic {
        TRUE,
        FALSE,
        STRICT;

    }

    public static class Defaults {
        public static final boolean ENABLED = true;
        public static final Nested NESTED = Nested.NO;
        public static final Dynamic DYNAMIC = null;
    }
}

