/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import org.apache.inlong.manager.common.enums.SourceStatus;

public enum SimpleSourceStatus {
    INIT,
    NORMAL,
    FREEZING,
    FROZEN,
    FAILED,
    DELETING,
    DELETE;


    public static SimpleSourceStatus parseByStatus(int status) {
        SourceStatus sourceStatus = SourceStatus.forCode(status);
        switch (sourceStatus) {
            case SOURCE_NEW: 
            case TO_BE_ISSUED_ADD: 
            case BEEN_ISSUED_ADD: 
            case TO_BE_ISSUED_ACTIVE: 
            case BEEN_ISSUED_ACTIVE: {
                return INIT;
            }
            case SOURCE_NORMAL: {
                return NORMAL;
            }
            case TO_BE_ISSUED_STOP: 
            case BEEN_ISSUED_STOP: {
                return FREEZING;
            }
            case SOURCE_STOP: {
                return FROZEN;
            }
            case SOURCE_FAILED: 
            case HEARTBEAT_TIMEOUT: {
                return FAILED;
            }
            case TO_BE_ISSUED_DELETE: 
            case BEEN_ISSUED_DELETE: {
                return DELETING;
            }
            case SOURCE_DISABLE: {
                return DELETE;
            }
        }
        throw new IllegalStateException(String.format("Unsupported source status [%s]", new Object[]{sourceStatus}));
    }
}

