/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Utils {
    private static final int BUF_SIZE = 4096;
    private static final Map<Class<?>, Class<?>> classToPrimitive;

    public static <T> Class<T> unwrap(Class<T> type) {
        Class<?> unwrapped = classToPrimitive.get(Objects.requireNonNull(type));
        return unwrapped == null ? type : unwrapped;
    }

    public static Map<Object, Object> mapOf(Object ... kvps) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        int len = kvps.length;
        for (int i = 0; i < len; i += 2) {
            map.put(kvps[i], kvps[i + 1]);
        }
        return Collections.unmodifiableMap(map);
    }

    public static List<Object> listOf(Object ... values) {
        LinkedList<Object> list = new LinkedList<Object>();
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            list.add(values[i]);
        }
        return Collections.unmodifiableList(list);
    }

    public static String toString(InputStream in) throws IOException {
        return new String(Utils.toByteArray(in), StandardCharsets.UTF_8);
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Utils.copy(in, out);
        return out.toByteArray();
    }

    public static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[4096];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public static boolean isNullOrEmptyString(String str) {
        return str == null || str.isEmpty();
    }

    public static void checkArgument(byte[] value, int length) {
        if (value.length > length) {
            throw new IllegalArgumentException("Given byte array should NOT greater than " + length);
        }
    }

    public static void checkArgument(int value, int minValue) {
        if (value < minValue) {
            throw new IllegalArgumentException("Given value(" + value + ") should NOT less than " + minValue);
        }
    }

    public static void checkArgument(long value, long minValue) {
        if (value < minValue) {
            throw new IllegalArgumentException("Given value(" + value + ") should NOT less than " + minValue);
        }
    }

    public static void checkArgument(int value, int minValue, int maxValue) {
        if (value < minValue || value > maxValue) {
            throw new IllegalArgumentException("Given value(" + value + ") should between " + minValue + " and " + maxValue);
        }
    }

    public static void checkArgument(long value, long minValue, long maxValue) {
        if (value < minValue || value > maxValue) {
            throw new IllegalArgumentException("Given value(" + value + ") should between " + minValue + " and " + maxValue);
        }
    }

    public static void checkArgument(BigInteger value, BigInteger minValue) {
        if (value.compareTo(minValue) < 0) {
            throw new IllegalArgumentException("Given value(" + value + ") should greater than " + minValue);
        }
    }

    public static void checkArgument(BigInteger value, BigInteger minValue, BigInteger maxValue) {
        if (value.compareTo(minValue) < 0 || value.compareTo(maxValue) > 0) {
            throw new IllegalArgumentException("Given value(" + value + ") should between " + minValue + " and " + maxValue);
        }
    }

    public static void readFully(DataInputStream in, byte[] b) throws IOException {
        Utils.readFully(in, b, 0, b.length);
    }

    public static void readFully(DataInputStream in, byte[] b, int off, int len) throws IOException {
        int total;
        int result;
        Objects.requireNonNull(in);
        Objects.requireNonNull(b);
        if (len < 0 || off < 0) {
            throw new IndexOutOfBoundsException(String.format("length (%s) and offset (%s) cannot be negative", len, off));
        }
        int end = off + len;
        if (end < off || end > b.length) {
            throw new IndexOutOfBoundsException(String.format("offset (%s) should less than length (%s) and buffer length (%s)", off, len, b.length));
        }
        for (total = 0; total < len && (result = in.read(b, off + total, len - total)) != -1; total += result) {
        }
        if (total != len) {
            throw new EOFException("reached end of stream after reading " + total + " bytes; " + len + " bytes expected");
        }
    }

    public static int readUnsignedShort(DataInputStream inputStream) throws IOException {
        byte b1 = (byte)inputStream.readUnsignedByte();
        byte b2 = (byte)inputStream.readUnsignedByte();
        return (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    public static int readInt(DataInputStream inputStream) throws IOException {
        byte b1 = (byte)inputStream.readUnsignedByte();
        byte b2 = (byte)inputStream.readUnsignedByte();
        byte b3 = (byte)inputStream.readUnsignedByte();
        byte b4 = (byte)inputStream.readUnsignedByte();
        return b4 << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    public static long readLong(DataInputStream inputStream) throws IOException {
        byte b1 = (byte)inputStream.readUnsignedByte();
        byte b2 = (byte)inputStream.readUnsignedByte();
        byte b3 = (byte)inputStream.readUnsignedByte();
        byte b4 = (byte)inputStream.readUnsignedByte();
        byte b5 = (byte)inputStream.readUnsignedByte();
        byte b6 = (byte)inputStream.readUnsignedByte();
        byte b7 = (byte)inputStream.readUnsignedByte();
        byte b8 = (byte)inputStream.readUnsignedByte();
        return ((long)b8 & 0xFFL) << 56 | ((long)b7 & 0xFFL) << 48 | ((long)b6 & 0xFFL) << 40 | ((long)b5 & 0xFFL) << 32 | ((long)b4 & 0xFFL) << 24 | ((long)b3 & 0xFFL) << 16 | ((long)b2 & 0xFFL) << 8 | (long)b1 & 0xFFL;
    }

    public static BigInteger readLongAsBigInteger(DataInputStream inputStream) throws IOException {
        byte b1 = (byte)inputStream.readUnsignedByte();
        byte b2 = (byte)inputStream.readUnsignedByte();
        byte b3 = (byte)inputStream.readUnsignedByte();
        byte b4 = (byte)inputStream.readUnsignedByte();
        byte b5 = (byte)inputStream.readUnsignedByte();
        byte b6 = (byte)inputStream.readUnsignedByte();
        byte b7 = (byte)inputStream.readUnsignedByte();
        byte b8 = (byte)inputStream.readUnsignedByte();
        return new BigInteger(new byte[]{0, b8, b7, b6, b5, b4, b3, b2, b1});
    }

    public static int readUnsignedLeb128(DataInputStream inputStream) throws IOException {
        int read;
        int value = 0;
        int count = 0;
        do {
            read = inputStream.readUnsignedByte() & 0xFF;
            value |= (read & 0x7F) << count * 7;
        } while ((read & 0x80) == 128 && ++count < 5);
        if ((read & 0x80) == 128) {
            throw new IOException("invalid LEB128 sequence");
        }
        return value;
    }

    public static BigInteger readBigInteger(DataInputStream inputStream, int byteLength) throws IOException {
        byte[] r = new byte[byteLength];
        for (int i = r.length; i > 0; --i) {
            r[i - 1] = inputStream.readByte();
        }
        return new BigInteger(r);
    }

    public static void writeShort(DataOutputStream outputStream, int value) throws IOException {
        outputStream.write(0xFF & value);
        outputStream.write(0xFF & value >> 8);
    }

    public static void writeInt(DataOutputStream outputStream, int value) throws IOException {
        outputStream.write(0xFF & value);
        outputStream.write(0xFF & value >> 8);
        outputStream.write(0xFF & value >> 16);
        outputStream.write(0xFF & value >> 24);
    }

    public static void writeLong(DataOutputStream outputStream, long value) throws IOException {
        outputStream.write((int)(0xFFL & value));
        outputStream.write((int)(0xFFL & value >> 8));
        outputStream.write((int)(0xFFL & value >> 16));
        outputStream.write((int)(0xFFL & value >> 24));
        outputStream.write((int)(0xFFL & value >> 32));
        outputStream.write((int)(0xFFL & value >> 40));
        outputStream.write((int)(0xFFL & value >> 48));
        outputStream.write((int)(0xFFL & value >> 56));
    }

    public static void writeBigInteger(DataOutputStream outputStream, BigInteger value, int byteLength) throws IOException {
        int i;
        int empty = value.signum() == -1 ? -1 : 0;
        byte[] bytes = value.toByteArray();
        for (i = bytes.length - 1; i >= 0; --i) {
            outputStream.writeByte(bytes[i]);
        }
        for (i = byteLength - bytes.length; i > 0; --i) {
            outputStream.writeByte(empty);
        }
    }

    public static int getVarIntSize(int value) {
        int result = 0;
        do {
            ++result;
        } while ((value >>>= 7) != 0);
        return result;
    }

    public static int getVarLongSize(long value) {
        int result = 0;
        do {
            ++result;
        } while ((value >>>= 7) != 0L);
        return result;
    }

    public static void writeVarInt(int value, ByteBuffer buffer) {
        while ((long)(value & 0xFFFFFF80) != 0L) {
            buffer.put((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
        buffer.put((byte)(value & 0x7F));
    }

    public static int readVarInt(DataInput in) throws IOException {
        int b;
        int result = 0;
        int shift = 0;
        do {
            if (shift >= 32) {
                throw new IndexOutOfBoundsException("varint too long");
            }
            b = in.readUnsignedByte();
            result |= (b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return result;
    }

    public static int readVarInt(ByteBuffer buffer) {
        byte b;
        int result = 0;
        int shift = 0;
        do {
            if (shift >= 32) {
                throw new IndexOutOfBoundsException("varint too long");
            }
            b = buffer.get();
            result |= (b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return result;
    }

    public static BigInteger toBigInteger(BigDecimal num, int scale) {
        BigDecimal ten = BigDecimal.valueOf(10L);
        BigDecimal s = ten.pow(scale);
        return num.multiply(s).toBigInteger();
    }

    public static boolean startsWithIgnoreCase(String haystack, String pattern) {
        return haystack.substring(0, pattern.length()).equalsIgnoreCase(pattern);
    }

    public static String retainUnquoted(String haystack, char quoteChar) {
        StringBuilder sb = new StringBuilder();
        String[] split = Utils.splitWithoutEscaped(haystack, quoteChar, true);
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            if ((i & 1) != 0) continue;
            sb.append(s);
        }
        return sb.toString();
    }

    private static String[] splitWithoutEscaped(String str, char separatorChar, boolean retainEmpty) {
        int len = str.length();
        if (len == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < len) {
            if (str.charAt(i) == '\\') {
                match = true;
                i += 2;
                continue;
            }
            if (str.charAt(i) == separatorChar) {
                if (retainEmpty || match) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (retainEmpty || match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[0]);
    }

    static {
        HashMap<Class<Void>, Class<Object>> map = new HashMap<Class<Void>, Class<Object>>();
        map.put(Boolean.class, Boolean.TYPE);
        map.put(Byte.class, Byte.TYPE);
        map.put(Character.class, Character.TYPE);
        map.put(Double.class, Double.TYPE);
        map.put(Float.class, Float.TYPE);
        map.put(Integer.class, Integer.TYPE);
        map.put(Long.class, Long.TYPE);
        map.put(Short.class, Short.TYPE);
        map.put(Void.class, Void.TYPE);
        classToPrimitive = Collections.unmodifiableMap(map);
    }
}

