/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements. See the NOTICE file distributed with this
work for additional information regarding copyright ownership. The ASF
licenses this file to You under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations
under the License.
*/
// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             v3.21.1
// source: pdpb.proto

package hugegraph_pd_grpc

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// PDClient is the client API for PD service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PDClient interface {
	// 注册store，首次注册会生成新的store_id， store_id是store唯一标识
	RegisterStore(ctx context.Context, in *RegisterStoreRequest, opts ...grpc.CallOption) (*RegisterStoreResponse, error)
	GetStore(ctx context.Context, in *GetStoreRequest, opts ...grpc.CallOption) (*GetStoreResponse, error)
	// 修改Store状态等信息.
	SetStore(ctx context.Context, in *SetStoreRequest, opts ...grpc.CallOption) (*SetStoreResponse, error)
	// 根据可以查找所属分区
	DelStore(ctx context.Context, in *DetStoreRequest, opts ...grpc.CallOption) (*DetStoreResponse, error)
	GetAllStores(ctx context.Context, in *GetAllStoresRequest, opts ...grpc.CallOption) (*GetAllStoresResponse, error)
	StoreHeartbeat(ctx context.Context, in *StoreHeartbeatRequest, opts ...grpc.CallOption) (*StoreHeartbeatResponse, error)
	// 根据可以查找所属分区
	GetPartition(ctx context.Context, in *GetPartitionRequest, opts ...grpc.CallOption) (*GetPartitionResponse, error)
	// 根据HashCode查找所属分区
	GetPartitionByCode(ctx context.Context, in *GetPartitionByCodeRequest, opts ...grpc.CallOption) (*GetPartitionResponse, error)
	// 根据PartitionID返回分区
	GetPartitionByID(ctx context.Context, in *GetPartitionByIDRequest, opts ...grpc.CallOption) (*GetPartitionResponse, error)
	ScanPartitions(ctx context.Context, in *ScanPartitionsRequest, opts ...grpc.CallOption) (*ScanPartitionsResponse, error)
	// 更新分区信息，主要用来更新分区key范围，调用此接口需谨慎，否则会造成数据丢失。
	UpdatePartition(ctx context.Context, in *UpdatePartitionRequest, opts ...grpc.CallOption) (*UpdatePartitionResponse, error)
	// 根据可以查找所属分区
	DelPartition(ctx context.Context, in *DelPartitionRequest, opts ...grpc.CallOption) (*DelPartitionResponse, error)
	// 根据条件查询分区信息, 包括Store、Graph等条件
	QueryPartitions(ctx context.Context, in *QueryPartitionsRequest, opts ...grpc.CallOption) (*QueryPartitionsResponse, error)
	// 读取图信息
	GetGraph(ctx context.Context, in *GetGraphRequest, opts ...grpc.CallOption) (*GetGraphResponse, error)
	// 修改图信息
	SetGraph(ctx context.Context, in *SetGraphRequest, opts ...grpc.CallOption) (*SetGraphResponse, error)
	DelGraph(ctx context.Context, in *DelGraphRequest, opts ...grpc.CallOption) (*DelGraphResponse, error)
	// 全局唯一自增ID
	GetId(ctx context.Context, in *GetIdRequest, opts ...grpc.CallOption) (*GetIdResponse, error)
	ResetId(ctx context.Context, in *ResetIdRequest, opts ...grpc.CallOption) (*ResetIdResponse, error)
	// PD的集群列表
	GetMembers(ctx context.Context, in *GetMembersRequest, opts ...grpc.CallOption) (*GetMembersResponse, error)
	GetStoreStatus(ctx context.Context, in *GetAllStoresRequest, opts ...grpc.CallOption) (*GetAllStoresResponse, error)
	GetPDConfig(ctx context.Context, in *GetPDConfigRequest, opts ...grpc.CallOption) (*GetPDConfigResponse, error)
	SetPDConfig(ctx context.Context, in *SetPDConfigRequest, opts ...grpc.CallOption) (*SetPDConfigResponse, error)
	GetGraphSpace(ctx context.Context, in *GetGraphSpaceRequest, opts ...grpc.CallOption) (*GetGraphSpaceResponse, error)
	SetGraphSpace(ctx context.Context, in *SetGraphSpaceRequest, opts ...grpc.CallOption) (*SetGraphSpaceResponse, error)
	// 获取集群健康状态
	GetClusterStats(ctx context.Context, in *GetClusterStatsRequest, opts ...grpc.CallOption) (*GetClusterStatsResponse, error)
	// 替换PD的集群节点
	ChangePeerList(ctx context.Context, in *ChangePeerListRequest, opts ...grpc.CallOption) (*GetChangePeerListResponse, error)
	// 数据分裂
	SplitData(ctx context.Context, in *SplitDataRequest, opts ...grpc.CallOption) (*SplitDataResponse, error)
	SplitGraphData(ctx context.Context, in *SplitGraphDataRequest, opts ...grpc.CallOption) (*SplitDataResponse, error)
	// 数据迁移
	MovePartition(ctx context.Context, in *MovePartitionRequest, opts ...grpc.CallOption) (*MovePartitionResponse, error)
	// 汇报分区分裂等任务执行结果
	ReportTask(ctx context.Context, in *ReportTaskRequest, opts ...grpc.CallOption) (*ReportTaskResponse, error)
	GetPartitionStats(ctx context.Context, in *GetPartitionStatsRequest, opts ...grpc.CallOption) (*GetPartitionStatsResponse, error)
	//平衡store中分区leader的数量
	BalanceLeaders(ctx context.Context, in *BalanceLeadersRequest, opts ...grpc.CallOption) (*BalanceLeadersResponse, error)
	// 替换license文件
	PutLicense(ctx context.Context, in *PutLicenseRequest, opts ...grpc.CallOption) (*PutLicenseResponse, error)
	// 通知rocksdb进行compaction
	DbCompaction(ctx context.Context, in *DbCompactionRequest, opts ...grpc.CallOption) (*DbCompactionResponse, error)
	// 合并分区
	CombineCluster(ctx context.Context, in *CombineClusterRequest, opts ...grpc.CallOption) (*CombineClusterResponse, error)
	// 单个图缩容
	CombineGraph(ctx context.Context, in *CombineGraphRequest, opts ...grpc.CallOption) (*CombineGraphResponse, error)
	// shard group
	GetShardGroup(ctx context.Context, in *GetShardGroupRequest, opts ...grpc.CallOption) (*GetShardGroupResponse, error)
	UpdateShardGroup(ctx context.Context, in *UpdateShardGroupRequest, opts ...grpc.CallOption) (*UpdateShardGroupResponse, error)
	// 删除掉shard group
	DeleteShardGroup(ctx context.Context, in *DeleteShardGroupRequest, opts ...grpc.CallOption) (*DeleteShardGroupResponse, error)
	// shard group 运维相关的处理
	UpdateShardGroupOp(ctx context.Context, in *ChangeShardRequest, opts ...grpc.CallOption) (*ChangeShardResponse, error)
	// change shard
	ChangeShard(ctx context.Context, in *ChangeShardRequest, opts ...grpc.CallOption) (*ChangeShardResponse, error)
}

type pDClient struct {
	cc grpc.ClientConnInterface
}

func NewPDClient(cc grpc.ClientConnInterface) PDClient {
	return &pDClient{cc}
}

func (c *pDClient) RegisterStore(ctx context.Context, in *RegisterStoreRequest, opts ...grpc.CallOption) (*RegisterStoreResponse, error) {
	out := new(RegisterStoreResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/RegisterStore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) GetStore(ctx context.Context, in *GetStoreRequest, opts ...grpc.CallOption) (*GetStoreResponse, error) {
	out := new(GetStoreResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/GetStore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) SetStore(ctx context.Context, in *SetStoreRequest, opts ...grpc.CallOption) (*SetStoreResponse, error) {
	out := new(SetStoreResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/SetStore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) DelStore(ctx context.Context, in *DetStoreRequest, opts ...grpc.CallOption) (*DetStoreResponse, error) {
	out := new(DetStoreResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/DelStore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) GetAllStores(ctx context.Context, in *GetAllStoresRequest, opts ...grpc.CallOption) (*GetAllStoresResponse, error) {
	out := new(GetAllStoresResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/GetAllStores", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) StoreHeartbeat(ctx context.Context, in *StoreHeartbeatRequest, opts ...grpc.CallOption) (*StoreHeartbeatResponse, error) {
	out := new(StoreHeartbeatResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/StoreHeartbeat", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) GetPartition(ctx context.Context, in *GetPartitionRequest, opts ...grpc.CallOption) (*GetPartitionResponse, error) {
	out := new(GetPartitionResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/GetPartition", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) GetPartitionByCode(ctx context.Context, in *GetPartitionByCodeRequest, opts ...grpc.CallOption) (*GetPartitionResponse, error) {
	out := new(GetPartitionResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/GetPartitionByCode", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) GetPartitionByID(ctx context.Context, in *GetPartitionByIDRequest, opts ...grpc.CallOption) (*GetPartitionResponse, error) {
	out := new(GetPartitionResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/GetPartitionByID", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) ScanPartitions(ctx context.Context, in *ScanPartitionsRequest, opts ...grpc.CallOption) (*ScanPartitionsResponse, error) {
	out := new(ScanPartitionsResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/ScanPartitions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) UpdatePartition(ctx context.Context, in *UpdatePartitionRequest, opts ...grpc.CallOption) (*UpdatePartitionResponse, error) {
	out := new(UpdatePartitionResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/UpdatePartition", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) DelPartition(ctx context.Context, in *DelPartitionRequest, opts ...grpc.CallOption) (*DelPartitionResponse, error) {
	out := new(DelPartitionResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/DelPartition", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) QueryPartitions(ctx context.Context, in *QueryPartitionsRequest, opts ...grpc.CallOption) (*QueryPartitionsResponse, error) {
	out := new(QueryPartitionsResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/QueryPartitions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) GetGraph(ctx context.Context, in *GetGraphRequest, opts ...grpc.CallOption) (*GetGraphResponse, error) {
	out := new(GetGraphResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/GetGraph", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) SetGraph(ctx context.Context, in *SetGraphRequest, opts ...grpc.CallOption) (*SetGraphResponse, error) {
	out := new(SetGraphResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/SetGraph", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) DelGraph(ctx context.Context, in *DelGraphRequest, opts ...grpc.CallOption) (*DelGraphResponse, error) {
	out := new(DelGraphResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/DelGraph", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) GetId(ctx context.Context, in *GetIdRequest, opts ...grpc.CallOption) (*GetIdResponse, error) {
	out := new(GetIdResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/GetId", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) ResetId(ctx context.Context, in *ResetIdRequest, opts ...grpc.CallOption) (*ResetIdResponse, error) {
	out := new(ResetIdResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/ResetId", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) GetMembers(ctx context.Context, in *GetMembersRequest, opts ...grpc.CallOption) (*GetMembersResponse, error) {
	out := new(GetMembersResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/GetMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) GetStoreStatus(ctx context.Context, in *GetAllStoresRequest, opts ...grpc.CallOption) (*GetAllStoresResponse, error) {
	out := new(GetAllStoresResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/GetStoreStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) GetPDConfig(ctx context.Context, in *GetPDConfigRequest, opts ...grpc.CallOption) (*GetPDConfigResponse, error) {
	out := new(GetPDConfigResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/GetPDConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) SetPDConfig(ctx context.Context, in *SetPDConfigRequest, opts ...grpc.CallOption) (*SetPDConfigResponse, error) {
	out := new(SetPDConfigResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/SetPDConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) GetGraphSpace(ctx context.Context, in *GetGraphSpaceRequest, opts ...grpc.CallOption) (*GetGraphSpaceResponse, error) {
	out := new(GetGraphSpaceResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/GetGraphSpace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) SetGraphSpace(ctx context.Context, in *SetGraphSpaceRequest, opts ...grpc.CallOption) (*SetGraphSpaceResponse, error) {
	out := new(SetGraphSpaceResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/SetGraphSpace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) GetClusterStats(ctx context.Context, in *GetClusterStatsRequest, opts ...grpc.CallOption) (*GetClusterStatsResponse, error) {
	out := new(GetClusterStatsResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/GetClusterStats", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) ChangePeerList(ctx context.Context, in *ChangePeerListRequest, opts ...grpc.CallOption) (*GetChangePeerListResponse, error) {
	out := new(GetChangePeerListResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/ChangePeerList", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) SplitData(ctx context.Context, in *SplitDataRequest, opts ...grpc.CallOption) (*SplitDataResponse, error) {
	out := new(SplitDataResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/SplitData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) SplitGraphData(ctx context.Context, in *SplitGraphDataRequest, opts ...grpc.CallOption) (*SplitDataResponse, error) {
	out := new(SplitDataResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/SplitGraphData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) MovePartition(ctx context.Context, in *MovePartitionRequest, opts ...grpc.CallOption) (*MovePartitionResponse, error) {
	out := new(MovePartitionResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/MovePartition", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) ReportTask(ctx context.Context, in *ReportTaskRequest, opts ...grpc.CallOption) (*ReportTaskResponse, error) {
	out := new(ReportTaskResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/ReportTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) GetPartitionStats(ctx context.Context, in *GetPartitionStatsRequest, opts ...grpc.CallOption) (*GetPartitionStatsResponse, error) {
	out := new(GetPartitionStatsResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/GetPartitionStats", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) BalanceLeaders(ctx context.Context, in *BalanceLeadersRequest, opts ...grpc.CallOption) (*BalanceLeadersResponse, error) {
	out := new(BalanceLeadersResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/BalanceLeaders", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) PutLicense(ctx context.Context, in *PutLicenseRequest, opts ...grpc.CallOption) (*PutLicenseResponse, error) {
	out := new(PutLicenseResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/PutLicense", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) DbCompaction(ctx context.Context, in *DbCompactionRequest, opts ...grpc.CallOption) (*DbCompactionResponse, error) {
	out := new(DbCompactionResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/DbCompaction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) CombineCluster(ctx context.Context, in *CombineClusterRequest, opts ...grpc.CallOption) (*CombineClusterResponse, error) {
	out := new(CombineClusterResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/CombineCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) CombineGraph(ctx context.Context, in *CombineGraphRequest, opts ...grpc.CallOption) (*CombineGraphResponse, error) {
	out := new(CombineGraphResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/CombineGraph", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) GetShardGroup(ctx context.Context, in *GetShardGroupRequest, opts ...grpc.CallOption) (*GetShardGroupResponse, error) {
	out := new(GetShardGroupResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/GetShardGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) UpdateShardGroup(ctx context.Context, in *UpdateShardGroupRequest, opts ...grpc.CallOption) (*UpdateShardGroupResponse, error) {
	out := new(UpdateShardGroupResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/UpdateShardGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) DeleteShardGroup(ctx context.Context, in *DeleteShardGroupRequest, opts ...grpc.CallOption) (*DeleteShardGroupResponse, error) {
	out := new(DeleteShardGroupResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/DeleteShardGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) UpdateShardGroupOp(ctx context.Context, in *ChangeShardRequest, opts ...grpc.CallOption) (*ChangeShardResponse, error) {
	out := new(ChangeShardResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/UpdateShardGroupOp", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pDClient) ChangeShard(ctx context.Context, in *ChangeShardRequest, opts ...grpc.CallOption) (*ChangeShardResponse, error) {
	out := new(ChangeShardResponse)
	err := c.cc.Invoke(ctx, "/pdpb.PD/ChangeShard", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PDServer is the server API for PD service.
// All implementations must embed UnimplementedPDServer
// for forward compatibility
type PDServer interface {
	// 注册store，首次注册会生成新的store_id， store_id是store唯一标识
	RegisterStore(context.Context, *RegisterStoreRequest) (*RegisterStoreResponse, error)
	GetStore(context.Context, *GetStoreRequest) (*GetStoreResponse, error)
	// 修改Store状态等信息.
	SetStore(context.Context, *SetStoreRequest) (*SetStoreResponse, error)
	// 根据可以查找所属分区
	DelStore(context.Context, *DetStoreRequest) (*DetStoreResponse, error)
	GetAllStores(context.Context, *GetAllStoresRequest) (*GetAllStoresResponse, error)
	StoreHeartbeat(context.Context, *StoreHeartbeatRequest) (*StoreHeartbeatResponse, error)
	// 根据可以查找所属分区
	GetPartition(context.Context, *GetPartitionRequest) (*GetPartitionResponse, error)
	// 根据HashCode查找所属分区
	GetPartitionByCode(context.Context, *GetPartitionByCodeRequest) (*GetPartitionResponse, error)
	// 根据PartitionID返回分区
	GetPartitionByID(context.Context, *GetPartitionByIDRequest) (*GetPartitionResponse, error)
	ScanPartitions(context.Context, *ScanPartitionsRequest) (*ScanPartitionsResponse, error)
	// 更新分区信息，主要用来更新分区key范围，调用此接口需谨慎，否则会造成数据丢失。
	UpdatePartition(context.Context, *UpdatePartitionRequest) (*UpdatePartitionResponse, error)
	// 根据可以查找所属分区
	DelPartition(context.Context, *DelPartitionRequest) (*DelPartitionResponse, error)
	// 根据条件查询分区信息, 包括Store、Graph等条件
	QueryPartitions(context.Context, *QueryPartitionsRequest) (*QueryPartitionsResponse, error)
	// 读取图信息
	GetGraph(context.Context, *GetGraphRequest) (*GetGraphResponse, error)
	// 修改图信息
	SetGraph(context.Context, *SetGraphRequest) (*SetGraphResponse, error)
	DelGraph(context.Context, *DelGraphRequest) (*DelGraphResponse, error)
	// 全局唯一自增ID
	GetId(context.Context, *GetIdRequest) (*GetIdResponse, error)
	ResetId(context.Context, *ResetIdRequest) (*ResetIdResponse, error)
	// PD的集群列表
	GetMembers(context.Context, *GetMembersRequest) (*GetMembersResponse, error)
	GetStoreStatus(context.Context, *GetAllStoresRequest) (*GetAllStoresResponse, error)
	GetPDConfig(context.Context, *GetPDConfigRequest) (*GetPDConfigResponse, error)
	SetPDConfig(context.Context, *SetPDConfigRequest) (*SetPDConfigResponse, error)
	GetGraphSpace(context.Context, *GetGraphSpaceRequest) (*GetGraphSpaceResponse, error)
	SetGraphSpace(context.Context, *SetGraphSpaceRequest) (*SetGraphSpaceResponse, error)
	// 获取集群健康状态
	GetClusterStats(context.Context, *GetClusterStatsRequest) (*GetClusterStatsResponse, error)
	// 替换PD的集群节点
	ChangePeerList(context.Context, *ChangePeerListRequest) (*GetChangePeerListResponse, error)
	// 数据分裂
	SplitData(context.Context, *SplitDataRequest) (*SplitDataResponse, error)
	SplitGraphData(context.Context, *SplitGraphDataRequest) (*SplitDataResponse, error)
	// 数据迁移
	MovePartition(context.Context, *MovePartitionRequest) (*MovePartitionResponse, error)
	// 汇报分区分裂等任务执行结果
	ReportTask(context.Context, *ReportTaskRequest) (*ReportTaskResponse, error)
	GetPartitionStats(context.Context, *GetPartitionStatsRequest) (*GetPartitionStatsResponse, error)
	//平衡store中分区leader的数量
	BalanceLeaders(context.Context, *BalanceLeadersRequest) (*BalanceLeadersResponse, error)
	// 替换license文件
	PutLicense(context.Context, *PutLicenseRequest) (*PutLicenseResponse, error)
	// 通知rocksdb进行compaction
	DbCompaction(context.Context, *DbCompactionRequest) (*DbCompactionResponse, error)
	// 合并分区
	CombineCluster(context.Context, *CombineClusterRequest) (*CombineClusterResponse, error)
	// 单个图缩容
	CombineGraph(context.Context, *CombineGraphRequest) (*CombineGraphResponse, error)
	// shard group
	GetShardGroup(context.Context, *GetShardGroupRequest) (*GetShardGroupResponse, error)
	UpdateShardGroup(context.Context, *UpdateShardGroupRequest) (*UpdateShardGroupResponse, error)
	// 删除掉shard group
	DeleteShardGroup(context.Context, *DeleteShardGroupRequest) (*DeleteShardGroupResponse, error)
	// shard group 运维相关的处理
	UpdateShardGroupOp(context.Context, *ChangeShardRequest) (*ChangeShardResponse, error)
	// change shard
	ChangeShard(context.Context, *ChangeShardRequest) (*ChangeShardResponse, error)
	mustEmbedUnimplementedPDServer()
}

// UnimplementedPDServer must be embedded to have forward compatible implementations.
type UnimplementedPDServer struct {
}

func (UnimplementedPDServer) RegisterStore(context.Context, *RegisterStoreRequest) (*RegisterStoreResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RegisterStore not implemented")
}
func (UnimplementedPDServer) GetStore(context.Context, *GetStoreRequest) (*GetStoreResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStore not implemented")
}
func (UnimplementedPDServer) SetStore(context.Context, *SetStoreRequest) (*SetStoreResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetStore not implemented")
}
func (UnimplementedPDServer) DelStore(context.Context, *DetStoreRequest) (*DetStoreResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DelStore not implemented")
}
func (UnimplementedPDServer) GetAllStores(context.Context, *GetAllStoresRequest) (*GetAllStoresResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAllStores not implemented")
}
func (UnimplementedPDServer) StoreHeartbeat(context.Context, *StoreHeartbeatRequest) (*StoreHeartbeatResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StoreHeartbeat not implemented")
}
func (UnimplementedPDServer) GetPartition(context.Context, *GetPartitionRequest) (*GetPartitionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPartition not implemented")
}
func (UnimplementedPDServer) GetPartitionByCode(context.Context, *GetPartitionByCodeRequest) (*GetPartitionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPartitionByCode not implemented")
}
func (UnimplementedPDServer) GetPartitionByID(context.Context, *GetPartitionByIDRequest) (*GetPartitionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPartitionByID not implemented")
}
func (UnimplementedPDServer) ScanPartitions(context.Context, *ScanPartitionsRequest) (*ScanPartitionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ScanPartitions not implemented")
}
func (UnimplementedPDServer) UpdatePartition(context.Context, *UpdatePartitionRequest) (*UpdatePartitionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePartition not implemented")
}
func (UnimplementedPDServer) DelPartition(context.Context, *DelPartitionRequest) (*DelPartitionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DelPartition not implemented")
}
func (UnimplementedPDServer) QueryPartitions(context.Context, *QueryPartitionsRequest) (*QueryPartitionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryPartitions not implemented")
}
func (UnimplementedPDServer) GetGraph(context.Context, *GetGraphRequest) (*GetGraphResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGraph not implemented")
}
func (UnimplementedPDServer) SetGraph(context.Context, *SetGraphRequest) (*SetGraphResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetGraph not implemented")
}
func (UnimplementedPDServer) DelGraph(context.Context, *DelGraphRequest) (*DelGraphResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DelGraph not implemented")
}
func (UnimplementedPDServer) GetId(context.Context, *GetIdRequest) (*GetIdResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetId not implemented")
}
func (UnimplementedPDServer) ResetId(context.Context, *ResetIdRequest) (*ResetIdResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetId not implemented")
}
func (UnimplementedPDServer) GetMembers(context.Context, *GetMembersRequest) (*GetMembersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMembers not implemented")
}
func (UnimplementedPDServer) GetStoreStatus(context.Context, *GetAllStoresRequest) (*GetAllStoresResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStoreStatus not implemented")
}
func (UnimplementedPDServer) GetPDConfig(context.Context, *GetPDConfigRequest) (*GetPDConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPDConfig not implemented")
}
func (UnimplementedPDServer) SetPDConfig(context.Context, *SetPDConfigRequest) (*SetPDConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetPDConfig not implemented")
}
func (UnimplementedPDServer) GetGraphSpace(context.Context, *GetGraphSpaceRequest) (*GetGraphSpaceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGraphSpace not implemented")
}
func (UnimplementedPDServer) SetGraphSpace(context.Context, *SetGraphSpaceRequest) (*SetGraphSpaceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetGraphSpace not implemented")
}
func (UnimplementedPDServer) GetClusterStats(context.Context, *GetClusterStatsRequest) (*GetClusterStatsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetClusterStats not implemented")
}
func (UnimplementedPDServer) ChangePeerList(context.Context, *ChangePeerListRequest) (*GetChangePeerListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ChangePeerList not implemented")
}
func (UnimplementedPDServer) SplitData(context.Context, *SplitDataRequest) (*SplitDataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SplitData not implemented")
}
func (UnimplementedPDServer) SplitGraphData(context.Context, *SplitGraphDataRequest) (*SplitDataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SplitGraphData not implemented")
}
func (UnimplementedPDServer) MovePartition(context.Context, *MovePartitionRequest) (*MovePartitionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MovePartition not implemented")
}
func (UnimplementedPDServer) ReportTask(context.Context, *ReportTaskRequest) (*ReportTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportTask not implemented")
}
func (UnimplementedPDServer) GetPartitionStats(context.Context, *GetPartitionStatsRequest) (*GetPartitionStatsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPartitionStats not implemented")
}
func (UnimplementedPDServer) BalanceLeaders(context.Context, *BalanceLeadersRequest) (*BalanceLeadersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BalanceLeaders not implemented")
}
func (UnimplementedPDServer) PutLicense(context.Context, *PutLicenseRequest) (*PutLicenseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PutLicense not implemented")
}
func (UnimplementedPDServer) DbCompaction(context.Context, *DbCompactionRequest) (*DbCompactionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DbCompaction not implemented")
}
func (UnimplementedPDServer) CombineCluster(context.Context, *CombineClusterRequest) (*CombineClusterResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CombineCluster not implemented")
}
func (UnimplementedPDServer) CombineGraph(context.Context, *CombineGraphRequest) (*CombineGraphResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CombineGraph not implemented")
}
func (UnimplementedPDServer) GetShardGroup(context.Context, *GetShardGroupRequest) (*GetShardGroupResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetShardGroup not implemented")
}
func (UnimplementedPDServer) UpdateShardGroup(context.Context, *UpdateShardGroupRequest) (*UpdateShardGroupResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateShardGroup not implemented")
}
func (UnimplementedPDServer) DeleteShardGroup(context.Context, *DeleteShardGroupRequest) (*DeleteShardGroupResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteShardGroup not implemented")
}
func (UnimplementedPDServer) UpdateShardGroupOp(context.Context, *ChangeShardRequest) (*ChangeShardResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateShardGroupOp not implemented")
}
func (UnimplementedPDServer) ChangeShard(context.Context, *ChangeShardRequest) (*ChangeShardResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ChangeShard not implemented")
}
func (UnimplementedPDServer) mustEmbedUnimplementedPDServer() {}

// UnsafePDServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PDServer will
// result in compilation errors.
type UnsafePDServer interface {
	mustEmbedUnimplementedPDServer()
}

func RegisterPDServer(s grpc.ServiceRegistrar, srv PDServer) {
	s.RegisterService(&PD_ServiceDesc, srv)
}

func _PD_RegisterStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegisterStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).RegisterStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/RegisterStore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).RegisterStore(ctx, req.(*RegisterStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_GetStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).GetStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/GetStore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).GetStore(ctx, req.(*GetStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_SetStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).SetStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/SetStore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).SetStore(ctx, req.(*SetStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_DelStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).DelStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/DelStore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).DelStore(ctx, req.(*DetStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_GetAllStores_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAllStoresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).GetAllStores(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/GetAllStores",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).GetAllStores(ctx, req.(*GetAllStoresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_StoreHeartbeat_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StoreHeartbeatRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).StoreHeartbeat(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/StoreHeartbeat",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).StoreHeartbeat(ctx, req.(*StoreHeartbeatRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_GetPartition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPartitionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).GetPartition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/GetPartition",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).GetPartition(ctx, req.(*GetPartitionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_GetPartitionByCode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPartitionByCodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).GetPartitionByCode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/GetPartitionByCode",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).GetPartitionByCode(ctx, req.(*GetPartitionByCodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_GetPartitionByID_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPartitionByIDRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).GetPartitionByID(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/GetPartitionByID",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).GetPartitionByID(ctx, req.(*GetPartitionByIDRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_ScanPartitions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ScanPartitionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).ScanPartitions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/ScanPartitions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).ScanPartitions(ctx, req.(*ScanPartitionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_UpdatePartition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePartitionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).UpdatePartition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/UpdatePartition",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).UpdatePartition(ctx, req.(*UpdatePartitionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_DelPartition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DelPartitionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).DelPartition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/DelPartition",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).DelPartition(ctx, req.(*DelPartitionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_QueryPartitions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryPartitionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).QueryPartitions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/QueryPartitions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).QueryPartitions(ctx, req.(*QueryPartitionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_GetGraph_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGraphRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).GetGraph(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/GetGraph",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).GetGraph(ctx, req.(*GetGraphRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_SetGraph_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetGraphRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).SetGraph(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/SetGraph",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).SetGraph(ctx, req.(*SetGraphRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_DelGraph_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DelGraphRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).DelGraph(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/DelGraph",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).DelGraph(ctx, req.(*DelGraphRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_GetId_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIdRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).GetId(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/GetId",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).GetId(ctx, req.(*GetIdRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_ResetId_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetIdRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).ResetId(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/ResetId",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).ResetId(ctx, req.(*ResetIdRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_GetMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMembersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).GetMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/GetMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).GetMembers(ctx, req.(*GetMembersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_GetStoreStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAllStoresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).GetStoreStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/GetStoreStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).GetStoreStatus(ctx, req.(*GetAllStoresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_GetPDConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPDConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).GetPDConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/GetPDConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).GetPDConfig(ctx, req.(*GetPDConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_SetPDConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetPDConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).SetPDConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/SetPDConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).SetPDConfig(ctx, req.(*SetPDConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_GetGraphSpace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGraphSpaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).GetGraphSpace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/GetGraphSpace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).GetGraphSpace(ctx, req.(*GetGraphSpaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_SetGraphSpace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetGraphSpaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).SetGraphSpace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/SetGraphSpace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).SetGraphSpace(ctx, req.(*SetGraphSpaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_GetClusterStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).GetClusterStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/GetClusterStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).GetClusterStats(ctx, req.(*GetClusterStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_ChangePeerList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChangePeerListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).ChangePeerList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/ChangePeerList",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).ChangePeerList(ctx, req.(*ChangePeerListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_SplitData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SplitDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).SplitData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/SplitData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).SplitData(ctx, req.(*SplitDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_SplitGraphData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SplitGraphDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).SplitGraphData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/SplitGraphData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).SplitGraphData(ctx, req.(*SplitGraphDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_MovePartition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MovePartitionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).MovePartition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/MovePartition",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).MovePartition(ctx, req.(*MovePartitionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_ReportTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).ReportTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/ReportTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).ReportTask(ctx, req.(*ReportTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_GetPartitionStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPartitionStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).GetPartitionStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/GetPartitionStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).GetPartitionStats(ctx, req.(*GetPartitionStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_BalanceLeaders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BalanceLeadersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).BalanceLeaders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/BalanceLeaders",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).BalanceLeaders(ctx, req.(*BalanceLeadersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_PutLicense_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PutLicenseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).PutLicense(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/PutLicense",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).PutLicense(ctx, req.(*PutLicenseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_DbCompaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DbCompactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).DbCompaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/DbCompaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).DbCompaction(ctx, req.(*DbCompactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_CombineCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CombineClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).CombineCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/CombineCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).CombineCluster(ctx, req.(*CombineClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_CombineGraph_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CombineGraphRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).CombineGraph(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/CombineGraph",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).CombineGraph(ctx, req.(*CombineGraphRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_GetShardGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetShardGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).GetShardGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/GetShardGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).GetShardGroup(ctx, req.(*GetShardGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_UpdateShardGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateShardGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).UpdateShardGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/UpdateShardGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).UpdateShardGroup(ctx, req.(*UpdateShardGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_DeleteShardGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteShardGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).DeleteShardGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/DeleteShardGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).DeleteShardGroup(ctx, req.(*DeleteShardGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_UpdateShardGroupOp_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChangeShardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).UpdateShardGroupOp(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/UpdateShardGroupOp",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).UpdateShardGroupOp(ctx, req.(*ChangeShardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PD_ChangeShard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChangeShardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PDServer).ChangeShard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pdpb.PD/ChangeShard",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PDServer).ChangeShard(ctx, req.(*ChangeShardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// PD_ServiceDesc is the grpc.ServiceDesc for PD service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var PD_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "pdpb.PD",
	HandlerType: (*PDServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RegisterStore",
			Handler:    _PD_RegisterStore_Handler,
		},
		{
			MethodName: "GetStore",
			Handler:    _PD_GetStore_Handler,
		},
		{
			MethodName: "SetStore",
			Handler:    _PD_SetStore_Handler,
		},
		{
			MethodName: "DelStore",
			Handler:    _PD_DelStore_Handler,
		},
		{
			MethodName: "GetAllStores",
			Handler:    _PD_GetAllStores_Handler,
		},
		{
			MethodName: "StoreHeartbeat",
			Handler:    _PD_StoreHeartbeat_Handler,
		},
		{
			MethodName: "GetPartition",
			Handler:    _PD_GetPartition_Handler,
		},
		{
			MethodName: "GetPartitionByCode",
			Handler:    _PD_GetPartitionByCode_Handler,
		},
		{
			MethodName: "GetPartitionByID",
			Handler:    _PD_GetPartitionByID_Handler,
		},
		{
			MethodName: "ScanPartitions",
			Handler:    _PD_ScanPartitions_Handler,
		},
		{
			MethodName: "UpdatePartition",
			Handler:    _PD_UpdatePartition_Handler,
		},
		{
			MethodName: "DelPartition",
			Handler:    _PD_DelPartition_Handler,
		},
		{
			MethodName: "QueryPartitions",
			Handler:    _PD_QueryPartitions_Handler,
		},
		{
			MethodName: "GetGraph",
			Handler:    _PD_GetGraph_Handler,
		},
		{
			MethodName: "SetGraph",
			Handler:    _PD_SetGraph_Handler,
		},
		{
			MethodName: "DelGraph",
			Handler:    _PD_DelGraph_Handler,
		},
		{
			MethodName: "GetId",
			Handler:    _PD_GetId_Handler,
		},
		{
			MethodName: "ResetId",
			Handler:    _PD_ResetId_Handler,
		},
		{
			MethodName: "GetMembers",
			Handler:    _PD_GetMembers_Handler,
		},
		{
			MethodName: "GetStoreStatus",
			Handler:    _PD_GetStoreStatus_Handler,
		},
		{
			MethodName: "GetPDConfig",
			Handler:    _PD_GetPDConfig_Handler,
		},
		{
			MethodName: "SetPDConfig",
			Handler:    _PD_SetPDConfig_Handler,
		},
		{
			MethodName: "GetGraphSpace",
			Handler:    _PD_GetGraphSpace_Handler,
		},
		{
			MethodName: "SetGraphSpace",
			Handler:    _PD_SetGraphSpace_Handler,
		},
		{
			MethodName: "GetClusterStats",
			Handler:    _PD_GetClusterStats_Handler,
		},
		{
			MethodName: "ChangePeerList",
			Handler:    _PD_ChangePeerList_Handler,
		},
		{
			MethodName: "SplitData",
			Handler:    _PD_SplitData_Handler,
		},
		{
			MethodName: "SplitGraphData",
			Handler:    _PD_SplitGraphData_Handler,
		},
		{
			MethodName: "MovePartition",
			Handler:    _PD_MovePartition_Handler,
		},
		{
			MethodName: "ReportTask",
			Handler:    _PD_ReportTask_Handler,
		},
		{
			MethodName: "GetPartitionStats",
			Handler:    _PD_GetPartitionStats_Handler,
		},
		{
			MethodName: "BalanceLeaders",
			Handler:    _PD_BalanceLeaders_Handler,
		},
		{
			MethodName: "PutLicense",
			Handler:    _PD_PutLicense_Handler,
		},
		{
			MethodName: "DbCompaction",
			Handler:    _PD_DbCompaction_Handler,
		},
		{
			MethodName: "CombineCluster",
			Handler:    _PD_CombineCluster_Handler,
		},
		{
			MethodName: "CombineGraph",
			Handler:    _PD_CombineGraph_Handler,
		},
		{
			MethodName: "GetShardGroup",
			Handler:    _PD_GetShardGroup_Handler,
		},
		{
			MethodName: "UpdateShardGroup",
			Handler:    _PD_UpdateShardGroup_Handler,
		},
		{
			MethodName: "DeleteShardGroup",
			Handler:    _PD_DeleteShardGroup_Handler,
		},
		{
			MethodName: "UpdateShardGroupOp",
			Handler:    _PD_UpdateShardGroupOp_Handler,
		},
		{
			MethodName: "ChangeShard",
			Handler:    _PD_ChangeShard_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "pdpb.proto",
}
