/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.dgiwg;

import java.io.File;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageManager;
import mil.nga.geopackage.dgiwg.DGIWGGeoPackage;
import mil.nga.geopackage.dgiwg.DGIWGValidationErrors;
import mil.nga.geopackage.dgiwg.GeoPackageFile;
import mil.nga.geopackage.dgiwg.GeoPackageFileName;
import mil.nga.geopackage.extension.CrsWktExtension;
import mil.nga.geopackage.extension.CrsWktExtensionVersion;

public class DGIWGGeoPackageManager {
    public static GeoPackageFile create(File file, String metadata) {
        return DGIWGGeoPackageManager.create(file, "https://dgiwg.org/std/dmf/2.0", metadata);
    }

    public static GeoPackageFile create(File file, String uri, String metadata) {
        return DGIWGGeoPackageManager.create(file, uri, metadata, true);
    }

    public static GeoPackageFile create(File file, String metadata, boolean validate) {
        return DGIWGGeoPackageManager.create(file, "https://dgiwg.org/std/dmf/2.0", metadata, validate);
    }

    public static GeoPackageFile create(File file, String uri, String metadata, boolean validate) {
        GeoPackageFileName fileName = new GeoPackageFileName(file);
        return DGIWGGeoPackageManager.createFile(file, fileName, uri, metadata, validate);
    }

    public static GeoPackageFile create(String name, File directory, String metadata) {
        return DGIWGGeoPackageManager.create(name, directory, "https://dgiwg.org/std/dmf/2.0", metadata);
    }

    public static GeoPackageFile create(String name, File directory, String uri, String metadata) {
        return DGIWGGeoPackageManager.create(name, directory, uri, metadata, true);
    }

    public static GeoPackageFile create(String name, File directory, String metadata, boolean validate) {
        return DGIWGGeoPackageManager.create(name, directory, "https://dgiwg.org/std/dmf/2.0", metadata, validate);
    }

    public static GeoPackageFile create(String name, File directory, String uri, String metadata, boolean validate) {
        return DGIWGGeoPackageManager.create(new File(directory, name), uri, metadata, validate);
    }

    public static GeoPackageFile create(File directory, GeoPackageFileName fileName, String metadata) {
        return DGIWGGeoPackageManager.create(directory, fileName, "https://dgiwg.org/std/dmf/2.0", metadata);
    }

    public static GeoPackageFile create(File directory, GeoPackageFileName fileName, String uri, String metadata) {
        return DGIWGGeoPackageManager.create(directory, fileName, uri, metadata, true);
    }

    public static GeoPackageFile create(File directory, GeoPackageFileName fileName, String metadata, boolean validate) {
        return DGIWGGeoPackageManager.create(directory, fileName, "https://dgiwg.org/std/dmf/2.0", metadata, validate);
    }

    public static GeoPackageFile create(File directory, GeoPackageFileName fileName, String uri, String metadata, boolean validate) {
        File file = new File(directory, fileName.getNameWithExtension());
        return DGIWGGeoPackageManager.createFile(file, fileName, uri, metadata, validate);
    }

    public static GeoPackageFile create(GeoPackageFileName fileName, String metadata) {
        return DGIWGGeoPackageManager.create(fileName, "https://dgiwg.org/std/dmf/2.0", metadata);
    }

    public static GeoPackageFile create(GeoPackageFileName fileName, String uri, String metadata) {
        return DGIWGGeoPackageManager.create(fileName, uri, metadata, true);
    }

    public static GeoPackageFile create(GeoPackageFileName fileName, String metadata, boolean validate) {
        return DGIWGGeoPackageManager.create(fileName, "https://dgiwg.org/std/dmf/2.0", metadata, validate);
    }

    public static GeoPackageFile create(GeoPackageFileName fileName, String uri, String metadata, boolean validate) {
        return DGIWGGeoPackageManager.createFile(fileName.getFile(), fileName, uri, metadata, validate);
    }

    private static GeoPackageFile createFile(File file, GeoPackageFileName fileName, String uri, String metadata, boolean validate) {
        GeoPackageFile geoPackageFile = null;
        file = GeoPackageManager.create(file, validate);
        try (DGIWGGeoPackage geoPackage = DGIWGGeoPackageManager.open(file, false);){
            if (geoPackage != null) {
                CrsWktExtension wktExtension = new CrsWktExtension((GeoPackageCore)geoPackage);
                wktExtension.getOrCreate(CrsWktExtensionVersion.V_1);
                geoPackage.createGeoPackageDatasetMetadata(uri, metadata);
                geoPackageFile = new GeoPackageFile(file, fileName);
            }
        }
        return geoPackageFile;
    }

    public static DGIWGGeoPackage open(GeoPackageFile file) {
        return DGIWGGeoPackageManager.open(file, true);
    }

    public static DGIWGGeoPackage open(GeoPackageFile file, boolean validate) {
        return DGIWGGeoPackageManager.open(file.getFile(), validate);
    }

    public static DGIWGGeoPackage open(String name, GeoPackageFile file) {
        return DGIWGGeoPackageManager.open(name, file, true);
    }

    public static DGIWGGeoPackage open(String name, GeoPackageFile file, boolean validate) {
        return DGIWGGeoPackageManager.open(name, file.getFile(), validate);
    }

    public static DGIWGGeoPackage open(File file) {
        return DGIWGGeoPackageManager.open(file, true);
    }

    public static DGIWGGeoPackage open(File file, boolean validate) {
        return DGIWGGeoPackageManager.open(file.getName(), file, validate);
    }

    public static DGIWGGeoPackage open(String name, File file) {
        return DGIWGGeoPackageManager.open(name, file, true);
    }

    public static DGIWGGeoPackage open(String name, File file, boolean validate) {
        DGIWGGeoPackage geoPackage = null;
        GeoPackageFileName fileName = new GeoPackageFileName(file);
        GeoPackage gp = GeoPackageManager.open(name, file, validate);
        if (gp != null) {
            geoPackage = new DGIWGGeoPackage(fileName, gp);
            if (validate) {
                DGIWGGeoPackageManager.validate(geoPackage);
            }
        }
        return geoPackage;
    }

    public static boolean isValid(DGIWGGeoPackage geoPackage) {
        return geoPackage.isValid();
    }

    public static DGIWGValidationErrors validate(DGIWGGeoPackage geoPackage) {
        return geoPackage.validate();
    }
}

