/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension;

import java.util.Arrays;
import java.util.List;

public enum CrsWktExtensionVersion {
    V_1("1.0"),
    V_1_1("1.1");

    public static final CrsWktExtensionVersion FIRST;
    public static final CrsWktExtensionVersion LATEST;
    private final String version;
    private final String suffix;

    private CrsWktExtensionVersion(String version) {
        this.version = version;
        this.suffix = version.equals("1.0") ? "" : "_" + version.replaceAll("\\.", "_");
    }

    public String getVersion() {
        return this.version;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean isMinimum(CrsWktExtensionVersion version) {
        return this.compareTo(version) >= 0;
    }

    public List<CrsWktExtensionVersion> atMinimum() {
        List<CrsWktExtensionVersion> list = Arrays.asList(CrsWktExtensionVersion.values());
        return list.subList(this.ordinal(), list.size());
    }

    static {
        FIRST = V_1;
        LATEST = V_1_1;
    }
}

