/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.AlterTable;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.extension.BaseExtension;
import mil.nga.geopackage.extension.CrsWktExtensionVersion;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.geopackage.property.PropertyConstants;

public class CrsWktExtension
extends BaseExtension {
    public static final String NAME = "crs_wkt";
    public static final String EXTENSION_NAME = "gpkg_crs_wkt";
    public static final String DEFINITION_V_1 = GeoPackageProperties.getProperty(PropertyConstants.EXTENSIONS, "crs_wkt");
    public static final String DEFINITION_V_1_1 = GeoPackageProperties.getProperty(PropertyConstants.EXTENSIONS, "crs_wkt" + CrsWktExtensionVersion.V_1_1.getSuffix());
    public static final String DEFINITION_COLUMN_NAME = GeoPackageProperties.getProperty(PropertyConstants.EXTENSIONS, "crs_wkt", "definition", "column_name");
    public static final String DEFINITION_COLUMN_DEF = GeoPackageProperties.getProperty(PropertyConstants.EXTENSIONS, "crs_wkt", "definition", "column_def");
    public static final String EPOCH_COLUMN_NAME = GeoPackageProperties.getProperty(PropertyConstants.EXTENSIONS, "crs_wkt", "epoch", "column_name");
    public static final String EPOCH_COLUMN_DEF = GeoPackageProperties.getProperty(PropertyConstants.EXTENSIONS, "crs_wkt", "epoch", "column_def");
    private GeoPackageCoreConnection connection = null;

    public CrsWktExtension(GeoPackageCore geoPackage) {
        super(geoPackage);
        this.connection = geoPackage.getDatabase();
    }

    public List<Extensions> getOrCreate() {
        return this.getOrCreate(CrsWktExtensionVersion.LATEST);
    }

    public List<Extensions> getOrCreate(CrsWktExtensionVersion version) {
        ArrayList<Extensions> extensions = new ArrayList<Extensions>();
        extensions.add(this.getOrCreate(EXTENSION_NAME, "gpkg_spatial_ref_sys", DEFINITION_COLUMN_NAME, DEFINITION_V_1, ExtensionScopeType.READ_WRITE));
        if (!this.hasDefinitionColumn()) {
            this.createDefinitionColumn();
        }
        if (version.isMinimum(CrsWktExtensionVersion.V_1_1)) {
            String name = this.getExtensionName(version);
            extensions.add(this.getOrCreate(name, "gpkg_spatial_ref_sys", DEFINITION_COLUMN_NAME, DEFINITION_V_1_1, ExtensionScopeType.READ_WRITE));
            extensions.add(this.getOrCreate(name, "gpkg_spatial_ref_sys", EPOCH_COLUMN_NAME, DEFINITION_V_1_1, ExtensionScopeType.READ_WRITE));
            if (!this.hasEpochColumn()) {
                this.createEpochColumn();
            }
        }
        return extensions;
    }

    public boolean has() {
        CrsWktExtensionVersion version;
        boolean has = false;
        CrsWktExtensionVersion[] crsWktExtensionVersionArray = CrsWktExtensionVersion.values();
        int n = crsWktExtensionVersionArray.length;
        for (int i = 0; i < n && !(has = this.has(version = crsWktExtensionVersionArray[i])); ++i) {
        }
        return has;
    }

    public boolean hasMinimum(CrsWktExtensionVersion version) {
        CrsWktExtensionVersion ver;
        boolean has = false;
        Iterator<CrsWktExtensionVersion> iterator = version.atMinimum().iterator();
        while (iterator.hasNext() && !(has = this.has(ver = iterator.next()))) {
        }
        return has;
    }

    public boolean has(CrsWktExtensionVersion version) {
        String name = this.getExtensionName(version);
        boolean exists = this.has(name, "gpkg_spatial_ref_sys", DEFINITION_COLUMN_NAME);
        if (!exists && version == CrsWktExtensionVersion.FIRST) {
            exists = this.has(name);
        }
        if (exists && (exists = this.hasDefinitionColumn()) && version.isMinimum(CrsWktExtensionVersion.V_1_1) && (exists = this.has(name, "gpkg_spatial_ref_sys", EPOCH_COLUMN_NAME))) {
            exists = this.hasEpochColumn();
        }
        return exists;
    }

    public String getExtensionName(CrsWktExtensionVersion version) {
        return EXTENSION_NAME + version.getSuffix();
    }

    public void updateDefinition(long srsId, String definition) {
        this.connection.execSQL("UPDATE gpkg_spatial_ref_sys SET " + DEFINITION_COLUMN_NAME + " = '" + definition + "' WHERE srs_id = " + srsId);
    }

    public String getDefinition(long srsId) {
        String definition = (String)this.connection.querySingleTypedResult("SELECT " + DEFINITION_COLUMN_NAME + " FROM gpkg_spatial_ref_sys WHERE srs_id = ?", new String[]{String.valueOf(srsId)});
        return definition;
    }

    public void updateEpoch(long srsId, Double epoch) {
        this.connection.execSQL("UPDATE gpkg_spatial_ref_sys SET " + EPOCH_COLUMN_NAME + " = " + epoch + " WHERE srs_id = " + srsId);
    }

    public Double getEpoch(long srsId) {
        Double epoch = (Double)this.connection.querySingleTypedResult("SELECT " + EPOCH_COLUMN_NAME + " FROM gpkg_spatial_ref_sys WHERE srs_id = ?", new String[]{String.valueOf(srsId)});
        return epoch;
    }

    private void createDefinitionColumn() {
        AlterTable.addColumn(this.connection, "gpkg_spatial_ref_sys", DEFINITION_COLUMN_NAME, DEFINITION_COLUMN_DEF);
        this.updateDefinition(GeoPackageProperties.getIntegerProperty(PropertyConstants.WGS_84, "srs_id"), GeoPackageProperties.getProperty(PropertyConstants.WGS_84, "definition_12_063"));
        this.updateDefinition(GeoPackageProperties.getIntegerProperty(PropertyConstants.UNDEFINED_CARTESIAN, "srs_id"), GeoPackageProperties.getProperty(PropertyConstants.UNDEFINED_CARTESIAN, "definition_12_063"));
        this.updateDefinition(GeoPackageProperties.getIntegerProperty(PropertyConstants.UNDEFINED_GEOGRAPHIC, "srs_id"), GeoPackageProperties.getProperty(PropertyConstants.UNDEFINED_GEOGRAPHIC, "definition_12_063"));
        this.updateDefinition(GeoPackageProperties.getIntegerProperty(PropertyConstants.WEB_MERCATOR, "srs_id"), GeoPackageProperties.getProperty(PropertyConstants.WEB_MERCATOR, "definition_12_063"));
    }

    private void createEpochColumn() {
        AlterTable.addColumn(this.connection, "gpkg_spatial_ref_sys", EPOCH_COLUMN_NAME, EPOCH_COLUMN_DEF);
    }

    public boolean hasDefinitionColumn() {
        return this.connection.columnExists("gpkg_spatial_ref_sys", DEFINITION_COLUMN_NAME);
    }

    public boolean hasEpochColumn() {
        return this.connection.columnExists("gpkg_spatial_ref_sys", EPOCH_COLUMN_NAME);
    }

    public void removeExtension() {
        for (CrsWktExtensionVersion version : CrsWktExtensionVersion.values()) {
            this.removeExtension(version);
        }
    }

    public void removeExtension(CrsWktExtensionVersion version) {
        try {
            if (this.extensionsDao.isTableExists()) {
                String name = this.getExtensionName(version);
                this.extensionsDao.deleteByExtension(name);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete CRS WKT extension version " + version.getVersion() + ". GeoPackage: " + this.geoPackage.getName(), e);
        }
    }
}

