/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.postgis;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.metadata.sql.util.Dialect;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.sql.feature.BinaryEncoding;
import org.apache.sis.storage.sql.feature.Column;
import org.apache.sis.storage.sql.feature.Database;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.feature.Resources;
import org.apache.sis.storage.sql.feature.SelectionClauseWriter;
import org.apache.sis.storage.sql.feature.TableReference;
import org.apache.sis.storage.sql.feature.ValueGetter;
import org.apache.sis.storage.sql.postgis.ExtendedClauseWriter;
import org.apache.sis.storage.sql.postgis.ExtendedInfo;
import org.apache.sis.storage.sql.postgis.ExtentEstimator;
import org.apache.sis.storage.sql.postgis.ObjectGetter;
import org.apache.sis.storage.sql.postgis.RasterGetter;
import org.apache.sis.util.Version;
import org.opengis.geometry.Envelope;

public final class Postgres<G>
extends Database<G> {
    private final Version postgisVersion;

    public Postgres(DataSource source, Connection connection, DatabaseMetaData metadata, Dialect dialect, Geometries<G> geomLibrary, StoreListeners listeners) throws SQLException {
        super(source, metadata, dialect, geomLibrary, listeners);
        Version version = null;
        try (Statement st = connection.createStatement();
             ResultSet result = st.executeQuery("SELECT public.PostGIS_version();");){
            while (result.next() && (version = Postgres.parseVersion(result.getString(1))) == null) {
            }
        }
        catch (SQLException e) {
            this.log(Resources.forLocale(null).getLogRecord(Level.CONFIG, (short)12, "PostGIS"));
        }
        this.postgisVersion = version;
    }

    static Version parseVersion(String version) {
        if (version != null) {
            int s = version.indexOf(32);
            if (s >= 0) {
                version = version.substring(0, s);
            }
            if (!version.isEmpty()) {
                return new Version(version);
            }
        }
        return null;
    }

    @Override
    public ValueGetter<?> getMapping(Column columnDefinition) {
        if ("geography".equalsIgnoreCase(columnDefinition.typeName)) {
            return this.forGeometry(columnDefinition);
        }
        if ("raster".equalsIgnoreCase(columnDefinition.typeName)) {
            return new RasterGetter(columnDefinition.getDefaultCRS().orElse(null), this.getBinaryEncoding(columnDefinition));
        }
        return super.getMapping(columnDefinition);
    }

    @Override
    protected int getArrayComponentType(Column columnDefinition) {
        String typeName = columnDefinition.typeName;
        if (typeName.equalsIgnoreCase("_text")) {
            return 12;
        }
        if (typeName.length() >= 2 && typeName.charAt(0) == '_') {
            try {
                return JDBCType.valueOf(typeName.substring(1).toUpperCase(Locale.US)).getVendorTypeNumber();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return super.getArrayComponentType(columnDefinition);
    }

    @Override
    protected ValueGetter<Object> getDefaultMapping() {
        return ObjectGetter.INSTANCE;
    }

    @Override
    protected BinaryEncoding getBinaryEncoding(Column columnDefinition) {
        if (columnDefinition.type == 2004) {
            return super.getBinaryEncoding(columnDefinition);
        }
        return BinaryEncoding.HEXADECIMAL;
    }

    @Override
    protected InfoStatements createInfoStatements(Connection connection) {
        return new ExtendedInfo(this, connection);
    }

    @Override
    protected void addIgnoredTables(Map<String, Boolean> ignoredTables) {
        ignoredTables.put("geography_columns", Boolean.TRUE);
        ignoredTables.put("raster_columns", Boolean.TRUE);
        ignoredTables.put("raster_overviews", Boolean.FALSE);
    }

    @Override
    protected SelectionClauseWriter getFilterToSQL() {
        return ExtendedClauseWriter.INSTANCE;
    }

    @Override
    protected Envelope getEstimatedExtent(TableReference table, Column[] columns, boolean recall) throws SQLException {
        ExtentEstimator ex = new ExtentEstimator(this, table, columns);
        try (Connection c = this.source.getConnection();){
            GeneralEnvelope generalEnvelope;
            block12: {
                Statement statement = c.createStatement();
                try {
                    generalEnvelope = ex.estimate(statement, recall);
                    if (statement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return generalEnvelope;
        }
    }
}

