/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.transfer.s3.internal.serialization.ResumableFileUploadSerializer;
import software.amazon.awssdk.transfer.s3.model.ResumableTransfer;
import software.amazon.awssdk.transfer.s3.model.UploadFileRequest;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class ResumableFileUpload
implements ResumableTransfer,
ToCopyableBuilder<Builder, ResumableFileUpload> {
    private final UploadFileRequest uploadFileRequest;
    private final Instant fileLastModified;
    private final String multipartUploadId;
    private final Long partSizeInBytes;
    private final Long totalParts;
    private final long fileLength;
    private final Long transferredParts;

    private ResumableFileUpload(DefaultBuilder builder) {
        this.uploadFileRequest = (UploadFileRequest)Validate.paramNotNull((Object)builder.uploadFileRequest, (String)"uploadFileRequest");
        this.fileLastModified = (Instant)Validate.paramNotNull((Object)builder.fileLastModified, (String)"fileLastModified");
        this.fileLength = (Long)Validate.paramNotNull((Object)builder.fileLength, (String)"fileLength");
        this.multipartUploadId = builder.multipartUploadId;
        this.totalParts = builder.totalParts;
        this.partSizeInBytes = builder.partSizeInBytes;
        this.transferredParts = builder.transferredParts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResumableFileUpload that = (ResumableFileUpload)o;
        if (this.fileLength != that.fileLength) {
            return false;
        }
        if (!this.uploadFileRequest.equals(that.uploadFileRequest)) {
            return false;
        }
        if (!this.fileLastModified.equals(that.fileLastModified)) {
            return false;
        }
        if (!Objects.equals(this.multipartUploadId, that.multipartUploadId)) {
            return false;
        }
        if (!Objects.equals(this.partSizeInBytes, that.partSizeInBytes)) {
            return false;
        }
        if (!Objects.equals(this.transferredParts, that.transferredParts)) {
            return false;
        }
        return Objects.equals(this.totalParts, that.totalParts);
    }

    public int hashCode() {
        int result = this.uploadFileRequest.hashCode();
        result = 31 * result + this.fileLastModified.hashCode();
        result = 31 * result + (this.multipartUploadId != null ? this.multipartUploadId.hashCode() : 0);
        result = 31 * result + (this.partSizeInBytes != null ? this.partSizeInBytes.hashCode() : 0);
        result = 31 * result + (this.totalParts != null ? this.totalParts.hashCode() : 0);
        result = 31 * result + (this.transferredParts != null ? this.transferredParts.hashCode() : 0);
        result = 31 * result + (int)(this.fileLength ^ this.fileLength >>> 32);
        return result;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public UploadFileRequest uploadFileRequest() {
        return this.uploadFileRequest;
    }

    public Instant fileLastModified() {
        return this.fileLastModified;
    }

    public long fileLength() {
        return this.fileLength;
    }

    public OptionalLong partSizeInBytes() {
        return this.partSizeInBytes == null ? OptionalLong.empty() : OptionalLong.of(this.partSizeInBytes);
    }

    public OptionalLong totalParts() {
        return this.totalParts == null ? OptionalLong.empty() : OptionalLong.of(this.totalParts);
    }

    public Optional<String> multipartUploadId() {
        return Optional.ofNullable(this.multipartUploadId);
    }

    public OptionalLong transferredParts() {
        return this.transferredParts == null ? OptionalLong.empty() : OptionalLong.of(this.transferredParts);
    }

    @Override
    public void serializeToFile(Path path) {
        try {
            Files.write(path, ResumableFileUploadSerializer.toJson(this), new OpenOption[0]);
        }
        catch (IOException e) {
            throw SdkClientException.create((String)("Failed to write to " + path), (Throwable)e);
        }
    }

    @Override
    public void serializeToOutputStream(OutputStream outputStream) {
        byte[] bytes = ResumableFileUploadSerializer.toJson(this);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            IoUtils.copy((InputStream)byteArrayInputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw SdkClientException.create((String)"Failed to write this download object to the given OutputStream", (Throwable)e);
        }
    }

    @Override
    public String serializeToString() {
        return new String(ResumableFileUploadSerializer.toJson(this), StandardCharsets.UTF_8);
    }

    @Override
    public SdkBytes serializeToBytes() {
        return SdkBytes.fromByteArrayUnsafe((byte[])ResumableFileUploadSerializer.toJson(this));
    }

    @Override
    public InputStream serializeToInputStream() {
        return new ByteArrayInputStream(ResumableFileUploadSerializer.toJson(this));
    }

    public static ResumableFileUpload fromFile(Path path) {
        ResumableFileUpload resumableFileUpload;
        block8: {
            InputStream stream = Files.newInputStream(path, new OpenOption[0]);
            try {
                resumableFileUpload = ResumableFileUploadSerializer.fromJson(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw SdkClientException.create((String)("Failed to create a ResumableFileUpload from " + path), (Throwable)e);
                }
            }
            stream.close();
        }
        return resumableFileUpload;
    }

    public static ResumableFileUpload fromBytes(SdkBytes bytes) {
        return ResumableFileUploadSerializer.fromJson(bytes.asByteArrayUnsafe());
    }

    public static ResumableFileUpload fromString(String contents) {
        return ResumableFileUploadSerializer.fromJson(contents);
    }

    public String toString() {
        return ToString.builder((String)"ResumableFileUpload").add("fileLastModified", (Object)this.fileLastModified).add("multipartUploadId", (Object)this.multipartUploadId).add("uploadFileRequest", (Object)this.uploadFileRequest).add("fileLength", (Object)this.fileLength).add("totalParts", (Object)this.totalParts).add("partSizeInBytes", (Object)this.partSizeInBytes).add("transferredParts", (Object)this.transferredParts).build();
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    private static final class DefaultBuilder
    implements Builder {
        private String multipartUploadId;
        private UploadFileRequest uploadFileRequest;
        private Long partSizeInBytes;
        private Long totalParts;
        private Instant fileLastModified;
        private Long fileLength;
        private Long transferredParts;

        private DefaultBuilder() {
        }

        private DefaultBuilder(ResumableFileUpload persistableFileUpload) {
            this.multipartUploadId = persistableFileUpload.multipartUploadId;
            this.uploadFileRequest = persistableFileUpload.uploadFileRequest;
            this.partSizeInBytes = persistableFileUpload.partSizeInBytes;
            this.fileLastModified = persistableFileUpload.fileLastModified;
            this.totalParts = persistableFileUpload.totalParts;
            this.fileLength = persistableFileUpload.fileLength;
            this.transferredParts = persistableFileUpload.transferredParts;
        }

        @Override
        public Builder uploadFileRequest(UploadFileRequest uploadFileRequest) {
            this.uploadFileRequest = uploadFileRequest;
            return this;
        }

        @Override
        public Builder multipartUploadId(String mutipartUploadId) {
            this.multipartUploadId = mutipartUploadId;
            return this;
        }

        @Override
        public Builder fileLastModified(Instant fileLastModified) {
            this.fileLastModified = fileLastModified;
            return this;
        }

        @Override
        public Builder fileLength(Long fileLength) {
            this.fileLength = fileLength;
            return this;
        }

        @Override
        public Builder totalParts(Long totalParts) {
            this.totalParts = totalParts;
            return this;
        }

        @Override
        public Builder transferredParts(Long transferredParts) {
            this.transferredParts = transferredParts;
            return this;
        }

        @Override
        public Builder partSizeInBytes(Long partSizeInBytes) {
            this.partSizeInBytes = partSizeInBytes;
            return this;
        }

        public ResumableFileUpload build() {
            return new ResumableFileUpload(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResumableFileUpload> {
        public Builder uploadFileRequest(UploadFileRequest var1);

        default public Builder uploadFileRequest(Consumer<UploadFileRequest.Builder> uploadFileRequestBuilder) {
            UploadFileRequest request = (UploadFileRequest)((UploadFileRequest.Builder)UploadFileRequest.builder().applyMutation(uploadFileRequestBuilder)).build();
            this.uploadFileRequest(request);
            return this;
        }

        public Builder multipartUploadId(String var1);

        public Builder fileLastModified(Instant var1);

        public Builder fileLength(Long var1);

        public Builder totalParts(Long var1);

        public Builder transferredParts(Long var1);

        public Builder partSizeInBytes(Long var1);
    }
}

