/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.measure.Quantity;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.provider.DatumShiftGridFile;
import org.apache.sis.referencing.util.j2d.AffineTransform2D;
import org.apache.sis.referencing.util.j2d.IntervalRectangle;
import org.apache.sis.referencing.util.j2d.Tile;
import org.apache.sis.referencing.util.j2d.TileOrganizer;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.CollectionsExt;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

final class DatumShiftGridGroup<C extends Quantity<C>, T extends Quantity<T>>
extends DatumShiftGridFile<C, T> {
    private static final long serialVersionUID = -1602724619897451422L;
    private final Region[] regions;

    private DatumShiftGridGroup(Tile[] tiles, Map<Tile, DatumShiftGridFile<C, T>> grids, AffineTransform2D gridToCRS, Dimension gridSize) throws IOException, NoninvertibleTransformException {
        super(grids.get(tiles[0]), gridToCRS, gridSize.width, gridSize.height);
        int n = grids.size();
        this.regions = new Region[n];
        this.subgrids = new DatumShiftGridFile[n];
        for (int i = 0; i < n; ++i) {
            Tile tile = tiles[i];
            DatumShiftGridFile<C, T> grid = grids.get(tile);
            this.regions[i] = new Region(tile);
            this.subgrids[i] = grid;
            if (!(grid.accuracy > this.accuracy)) continue;
            this.accuracy = grid.accuracy;
        }
    }

    static <C extends Quantity<C>, T extends Quantity<T>> DatumShiftGridGroup<C, T> create(URI file, List<DatumShiftGridFile<C, T>> subgrids) throws IOException, FactoryException, NoninvertibleTransformException {
        TileOrganizer mosaic = new TileOrganizer(null);
        LinkedHashMap<Tile, DatumShiftGridFile<C, T>> grids = new LinkedHashMap<Tile, DatumShiftGridFile<C, T>>(Containers.hashMapCapacity((int)subgrids.size()));
        for (DatumShiftGridFile<C, T> grid : subgrids) {
            int[] size = grid.getGridSize();
            Tile tile = new Tile(new Rectangle(size[0], size[1]), (AffineTransform)((Object)grid.getCoordinateToGrid().inverse()));
            if (!mosaic.add(tile) || grids.put(tile, grid) != null) {
                throw new AssertionError(tile);
            }
        }
        Map.Entry result = (Map.Entry)CollectionsExt.singletonOrNull(mosaic.tiles().entrySet());
        if (result == null) {
            throw new FactoryException(Resources.format((short)94, file));
        }
        Tile global = (Tile)result.getKey();
        return new DatumShiftGridGroup<C, T>((Tile[])result.getValue(), grids, global.getGridToCRS(), global.getSize());
    }

    private DatumShiftGridGroup(DatumShiftGridGroup<C, T> other, DatumShiftGridFile<C, T>[] data) {
        super(other);
        this.subgrids = data;
        this.regions = other.regions;
    }

    @Override
    protected final DatumShiftGridFile<C, T> setData(Object[] other) {
        return new DatumShiftGridGroup<C, T>(this, (DatumShiftGridFile[])other);
    }

    @Override
    protected Object[] getData() {
        return this.subgrids;
    }

    @Override
    public int getTranslationDimensions() {
        return this.subgrids[0].getTranslationDimensions();
    }

    @Override
    public double getCellValue(int dim, int gridX, int gridY) {
        for (int i = 0; i < this.regions.length; ++i) {
            Region r = this.regions[i];
            if (!r.containsInclusive(gridX, gridY)) continue;
            double shift = this.subgrids[i].getCellValue(dim, Math.toIntExact(Math.round(r.x(gridX))), Math.toIntExact(Math.round(r.y(gridY))));
            if (this.isCellValueRatio()) {
                shift *= r.relativeCellSize(dim);
            }
            return shift;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void interpolateInCell(double gridX, double gridY, double[] vector) {
        int ni = 0;
        Region nearest = this.regions[ni];
        double dmin = nearest.distanceSquared(gridX, gridY);
        for (int i = 1; i < this.regions.length; ++i) {
            Region r = this.regions[i];
            double d = r.distanceSquared(gridX, gridY);
            if (!(d < dmin)) continue;
            dmin = d;
            nearest = r;
            ni = i;
            if (d == 0.0) break;
        }
        this.subgrids[ni].interpolateInCell(nearest.x(gridX), nearest.y(gridY), vector);
        if (this.isCellValueRatio()) {
            for (int dim = 0; dim < 2; ++dim) {
                int n = dim;
                vector[n] = vector[n] * nearest.relativeCellSize(dim);
            }
        }
    }

    private static final class Region
    extends IntervalRectangle {
        private static final long serialVersionUID = -2925837396412170681L;
        private final double sx;
        private final double sy;

        Region(Tile tile) throws IOException {
            Rectangle r = tile.getRegionOnFinestLevel();
            Dimension s = tile.getSubsampling();
            this.xmin = r.getMinX();
            this.xmax = r.getMaxX();
            this.ymin = r.getMinY();
            this.ymax = r.getMaxY();
            this.sx = s.width;
            this.sy = s.height;
        }

        final double x(double p) {
            return (p - this.xmin) / this.sx;
        }

        final double y(double p) {
            return (p - this.ymin) / this.sy;
        }

        final double relativeCellSize(int dim) {
            switch (dim) {
                case 0: {
                    return this.sx;
                }
                case 1: {
                    return this.sy;
                }
            }
            throw new IndexOutOfBoundsException();
        }
    }
}

