/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.internal.DoubleDouble;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public abstract class DatumShiftGrid<C extends Quantity<C>, T extends Quantity<T>>
implements Serializable {
    private static final long serialVersionUID = 8405276545243175808L;
    protected static final int INTERPOLATED_DIMENSIONS = 2;
    private final Unit<C> coordinateUnit;
    private final LinearTransform coordinateToGrid;
    private final Unit<T> translationUnit;
    private final boolean isCellValueRatio;
    private final int[] gridSize;

    protected DatumShiftGrid(Unit<C> coordinateUnit, LinearTransform coordinateToGrid, int[] gridSize, boolean isCellValueRatio, Unit<T> translationUnit) {
        ArgumentChecks.ensureNonNull((String)"coordinateUnit", coordinateUnit);
        ArgumentChecks.ensureNonNull((String)"coordinateToGrid", (Object)coordinateToGrid);
        ArgumentChecks.ensureNonNull((String)"gridSize", (Object)gridSize);
        ArgumentChecks.ensureNonNull((String)"translationUnit", translationUnit);
        int n = coordinateToGrid.getTargetDimensions();
        ArgumentChecks.ensureDimensionMatches((String)"gridSize", (int)n, (int[])gridSize);
        this.coordinateUnit = coordinateUnit;
        this.coordinateToGrid = coordinateToGrid;
        this.isCellValueRatio = isCellValueRatio;
        this.translationUnit = translationUnit;
        gridSize = (int[])gridSize.clone();
        this.gridSize = gridSize;
        for (int i = 0; i < gridSize.length; ++i) {
            n = gridSize[i];
            if (n >= 2) continue;
            throw new IllegalArgumentException(Errors.format((short)(n <= 0 ? (short)165 : 45), (Object)Strings.toIndexed((String)"gridSize", (int)i), (Object)n));
        }
    }

    protected DatumShiftGrid(DatumShiftGrid<C, T> other) {
        ArgumentChecks.ensureNonNull((String)"other", other);
        this.coordinateUnit = other.coordinateUnit;
        this.coordinateToGrid = other.coordinateToGrid;
        this.isCellValueRatio = other.isCellValueRatio;
        this.translationUnit = other.translationUnit;
        this.gridSize = other.gridSize;
    }

    public int[] getGridSize() {
        return (int[])this.gridSize.clone();
    }

    public int getGridSize(int dimension) {
        return this.gridSize[dimension];
    }

    public Envelope getDomainOfValidity() throws TransformException {
        GeneralEnvelope env = new GeneralEnvelope(this.gridSize.length);
        for (int i = 0; i < this.gridSize.length; ++i) {
            env.setRange(i, 0.0, this.gridSize[i] - 1);
        }
        return Envelopes.transform(this.getCoordinateToGrid().inverse(), (Envelope)env);
    }

    public Envelope getDomainOfValidity(Unit<C> unit) throws TransformException {
        UnitConverter uc = this.getCoordinateUnit().getConverterTo(unit);
        if (uc.isIdentity()) {
            return this.getDomainOfValidity();
        }
        GeneralEnvelope domain = GeneralEnvelope.castOrCopy(this.getDomainOfValidity());
        int i = domain.getDimension();
        while (--i >= 0) {
            domain.setRange(i, uc.convert(domain.getLower(i)), uc.convert(domain.getUpper(i)));
        }
        return domain;
    }

    public Unit<C> getCoordinateUnit() {
        return this.coordinateUnit;
    }

    public LinearTransform getCoordinateToGrid() {
        return this.coordinateToGrid;
    }

    public abstract int getTranslationDimensions();

    public Unit<T> getTranslationUnit() {
        return this.translationUnit;
    }

    public double[] interpolateAt(double ... coordinates) throws TransformException {
        LinearTransform c = this.getCoordinateToGrid();
        ArgumentChecks.ensureDimensionMatches((String)"coordinates", (int)c.getSourceDimensions(), (double[])coordinates);
        int dim = this.getTranslationDimensions();
        double[] vector = new double[Math.max(dim, c.getTargetDimensions())];
        c.transform(coordinates, 0, vector, 0, 1);
        this.interpolateInCell(vector[0], vector[1], vector);
        if (this.isCellValueRatio()) {
            c.inverse().deltaTransform(vector, 0, vector, 0, 1);
        }
        if (vector.length != dim) {
            vector = Arrays.copyOf(vector, dim);
        }
        return vector;
    }

    public void interpolateInCell(double gridX, double gridY, double[] vector) {
        int n;
        boolean skipY;
        boolean skipX;
        int xmax = this.gridSize[0] - 2;
        int ymax = this.gridSize[1] - 2;
        int ix = (int)gridX;
        int iy = (int)gridY;
        if (ix < 0 || ix > xmax || iy < 0 || iy > ymax) {
            double[] gridCoordinates = new double[]{gridX, gridY};
            this.replaceOutsideGridCoordinates(gridCoordinates);
            gridX = gridCoordinates[0];
            gridY = gridCoordinates[1];
            ix = Math.max(0, Math.min(xmax, (int)gridX));
            iy = Math.max(0, Math.min(ymax, (int)gridY));
        }
        gridY -= (double)iy;
        boolean bl = skipX = (gridX -= (double)ix) < 0.0;
        if (skipX) {
            gridX = 0.0;
        }
        boolean bl2 = skipY = gridY < 0.0;
        if (skipY) {
            gridY = 0.0;
        }
        if (gridX > 1.0) {
            gridX = 1.0;
            skipX = true;
        }
        if (gridY > 1.0) {
            gridY = 1.0;
            skipY = true;
        }
        boolean derivative = vector.length >= (n = this.getTranslationDimensions()) + 4;
        for (int dim = 0; dim < n; ++dim) {
            double r00 = this.getCellValue(dim, ix, iy);
            double r01 = this.getCellValue(dim, ix + 1, iy);
            double r10 = this.getCellValue(dim, ix, iy + 1);
            double r11 = this.getCellValue(dim, ix + 1, iy + 1);
            double dx = r01 - r00;
            double r0x = Math.fma(gridX, dx, r00);
            double dy = r11 - r10;
            double r1x = Math.fma(gridX, dy, r10);
            vector[dim] = gridY * (r1x - r0x) + r0x;
            if (!derivative) continue;
            dx = skipX ? 0.0 : (dx += (dy - dx) * gridX);
            if (skipY) {
                dy = 0.0;
            } else {
                dy = r10 - r00;
                dy += (r11 - r01 - dy) * gridY;
            }
            int i = n;
            if (dim == 0) {
                dx += 1.0;
            } else {
                dy += 1.0;
                i += 2;
                derivative = false;
            }
            vector[i] = dx;
            vector[i + 1] = dy;
        }
    }

    public Matrix derivativeInCell(double gridX, double gridY) {
        int xmax = this.gridSize[0] - 2;
        int ymax = this.gridSize[1] - 2;
        int ix = (int)gridX;
        int iy = (int)gridY;
        if (ix < 0 || ix > xmax || iy < 0 || iy > ymax) {
            double[] gridCoordinates = new double[]{gridX, gridY};
            this.replaceOutsideGridCoordinates(gridCoordinates);
            gridX = gridCoordinates[0];
            gridY = gridCoordinates[1];
            ix = Math.max(0, Math.min(xmax, (int)gridX));
            iy = Math.max(0, Math.min(ymax, (int)gridY));
        }
        boolean skipX = (gridX -= (double)ix) < 0.0 || gridX > 1.0;
        boolean skipY = (gridY -= (double)iy) < 0.0 || gridY > 1.0;
        MatrixSIS derivative = Matrices.createDiagonal(this.getTranslationDimensions(), this.gridSize.length);
        int j = derivative.getNumRow();
        while (--j >= 0) {
            double r00 = this.getCellValue(j, ix, iy);
            double r01 = this.getCellValue(j, ix + 1, iy);
            double r10 = this.getCellValue(j, ix, iy + 1);
            double r11 = this.getCellValue(j, ix + 1, iy + 1);
            if (!skipX) {
                double dx = r01 - r00;
                dx += (r11 - r10 - dx) * gridX;
                derivative.setElement(j, 0, derivative.getElement(j, 0) + dx);
            }
            if (skipY) continue;
            double dy = r10 - r00;
            dy += (r11 - r01 - dy) * gridY;
            derivative.setElement(j, 1, derivative.getElement(j, 1) + dy);
        }
        return derivative;
    }

    public abstract double getCellValue(int var1, int var2, int var3);

    public double getCellMean(int dim) {
        DoubleDouble sum = DoubleDouble.ZERO;
        int nx = this.gridSize[0];
        int ny = this.gridSize[1];
        for (int gridY = 0; gridY < ny; ++gridY) {
            for (int gridX = 0; gridX < nx; ++gridX) {
                sum = sum.add(this.getCellValue(dim, gridX, gridY), false);
            }
        }
        return sum.doubleValue() / (double)(nx * ny);
    }

    public abstract double getCellPrecision();

    public boolean isCellValueRatio() {
        return this.isCellValueRatio;
    }

    public boolean isCellInGrid(double gridX, double gridY) {
        double xmax = this.gridSize[0] - 1;
        double ymax = this.gridSize[1] - 1;
        if (gridX >= 0.0 && gridX <= xmax && gridY >= 0.0 && gridY <= ymax) {
            return true;
        }
        double[] gridCoordinates = new double[]{gridX, gridY};
        this.replaceOutsideGridCoordinates(gridCoordinates);
        gridX = gridCoordinates[0];
        gridY = gridCoordinates[1];
        return gridX >= 0.0 && gridX <= xmax && gridY >= 0.0 && gridY <= ymax;
    }

    protected void replaceOutsideGridCoordinates(double[] gridCoordinates) {
    }

    public abstract ParameterDescriptorGroup getParameterDescriptors();

    public abstract void getParameterValues(Parameters var1);

    public String toString() {
        String t;
        StringBuffer buffer = new StringBuffer("DatumShift[");
        for (int i = 0; i < this.gridSize.length; ++i) {
            if (i != 0) {
                buffer.append(" \u00d7 ");
            }
            buffer.append(this.gridSize[i]);
        }
        String s = String.valueOf(this.coordinateUnit);
        if (s.isEmpty()) {
            s = "1";
        }
        if ((t = String.valueOf(this.translationUnit)).isEmpty()) {
            t = "1";
        }
        buffer.append(" cells; units = ").append(s).append(" \u2192 ").append(t);
        if (this.isCellValueRatio) {
            buffer.append("\u2215cellSize");
        }
        return buffer.append(']').toString();
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == this.getClass()) {
            DatumShiftGrid that = (DatumShiftGrid)other;
            return Arrays.equals(this.gridSize, that.gridSize) && Objects.equals(this.coordinateToGrid, that.coordinateToGrid) && Objects.equals(this.coordinateUnit, that.coordinateUnit) && Objects.equals(this.translationUnit, that.translationUnit) && this.isCellValueRatio == that.isCellValueRatio;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.coordinateToGrid) + 37 * Arrays.hashCode(this.gridSize);
    }
}

