/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.ReusableLogEvent;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.impl.LogEventFactory;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.core.time.Clock;
import org.apache.logging.log4j.core.time.NanoClock;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.spi.recycler.Recycler;
import org.apache.logging.log4j.spi.recycler.RecyclerFactory;

public class ReusableLogEventFactory
implements LogEventFactory {
    private final ContextDataInjector injector;
    private final Clock clock;
    private final NanoClock nanoClock;
    private final Recycler<MutableLogEvent> recycler;

    @Inject
    public ReusableLogEventFactory(ContextDataInjector injector, Clock clock, NanoClock nanoClock, RecyclerFactory recyclerFactory) {
        this.injector = injector;
        this.clock = clock;
        this.nanoClock = nanoClock;
        this.recycler = recyclerFactory.create(() -> {
            MutableLogEvent event = new MutableLogEvent();
            Thread currentThread = Thread.currentThread();
            event.setThreadId(currentThread.getId());
            event.setThreadName(currentThread.getName());
            event.setThreadPriority(currentThread.getPriority());
            return event;
        });
    }

    @Override
    public LogEvent createEvent(String loggerName, Marker marker, String fqcn, Level level, Message message, List<Property> properties, Throwable t) {
        return this.createEvent(loggerName, marker, fqcn, null, level, message, properties, t);
    }

    @Override
    public LogEvent createEvent(String loggerName, Marker marker, String fqcn, StackTraceElement location, Level level, Message message, List<Property> properties, Throwable t) {
        MutableLogEvent result = (MutableLogEvent)this.recycler.acquire();
        result.setLoggerName(loggerName);
        result.setMarker(marker);
        result.setLoggerFqcn(fqcn);
        result.setLevel(level == null ? Level.OFF : level);
        result.setMessage(message);
        result.initTime(this.clock, this.nanoClock);
        result.setThrown(t);
        result.setSource(location);
        result.setContextData(this.injector.injectContextData(properties, result.getContextData()));
        result.setContextStack((ThreadContext.ContextStack)(ThreadContext.getDepth() == 0 ? ThreadContext.EMPTY_STACK : ThreadContext.cloneStack()));
        result.setThreadName(Thread.currentThread().getName());
        result.setThreadPriority(Thread.currentThread().getPriority());
        return result;
    }

    @Override
    public void recycle(LogEvent event) {
        if (event instanceof ReusableLogEvent) {
            ((ReusableLogEvent)event).clear();
            if (event instanceof MutableLogEvent) {
                this.recycler.release((Object)((MutableLogEvent)event));
            }
        }
    }

    @Deprecated(since="3.0.0")
    public static void release(LogEvent logEvent) {
        if (logEvent instanceof ReusableLogEvent) {
            ((ReusableLogEvent)logEvent).clear();
        }
    }
}

