/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Static;

public final class Logging
extends Static {
    private static final int LEVEL_THRESHOLD_FOR_STACKTRACE = 600;

    private Logging() {
    }

    public static Logger getLogger(Class<?> source) {
        ArgumentChecks.ensureNonNull("source", source);
        Object name = source.getPackageName();
        if (((String)name).startsWith("org.apache.sis.internal.")) {
            name = "org.apache.sis." + ((String)name).substring("org.apache.sis.internal.".length());
        }
        return Logger.getLogger((String)name);
    }

    @Deprecated(since="1.4", forRemoval=true)
    public static void log(Class<?> classe, String method, LogRecord record) {
        Logging.completeAndLog(null, classe, method, record);
    }

    public static void completeAndLog(Logger logger, Class<?> classe, String method, LogRecord record) {
        ArgumentChecks.ensureNonNull("record", record);
        if (logger != null) {
            record.setLoggerName(logger.getName());
        } else {
            String loggerName = record.getLoggerName();
            if (loggerName == null) {
                logger = Logging.getLogger(classe);
                record.setLoggerName(logger.getName());
            } else {
                logger = Logger.getLogger(loggerName);
            }
        }
        if (classe != null && method != null) {
            record.setSourceClassName(classe.getCanonicalName());
            record.setSourceMethodName(method);
        } else {
            Logger fl = logger;
            logger = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(stream -> Logging.inferCaller(fl, classe != null ? classe.getCanonicalName() : null, method, stream.filter(frame -> Modifier.isPublic(frame.getDeclaringClass().getModifiers())).map(StackWalker.StackFrame::toStackTraceElement), record));
        }
        logger.log(record);
    }

    private static Logger inferCaller(Logger logger, String classe, String method, Stream<StackTraceElement> trace, LogRecord record) {
        StackTraceElement first = trace.filter(element -> (classe != null ? classe.equals(element.getClassName()) : Logging.isPublic(element)) && (method == null || method.equals(element.getMethodName()))).findFirst().orElse(null);
        if (logger == null) {
            String name = "global";
            if (first != null) {
                String classname = first.getClassName();
                int separator = classname.lastIndexOf(46);
                name = separator >= 1 ? classname.substring(0, separator - 1) : "";
            }
            logger = Logger.getLogger(name);
        }
        if (classe != null || first != null) {
            record.setSourceClassName(first == null ? classe : first.getClassName());
        }
        if (method != null || first != null) {
            record.setSourceMethodName(first == null ? method : first.getMethodName());
        }
        return logger;
    }

    private static boolean isPublic(StackTraceElement e) {
        String classname = e.getClassName();
        if (classname.startsWith("java") || classname.startsWith("org.apache.sis.internal.") || classname.indexOf(36) >= 0 || e.getMethodName().indexOf(36) >= 0) {
            return false;
        }
        if (classname.startsWith("org.apache.sis.util.logging.")) {
            return classname.endsWith("Test");
        }
        return true;
    }

    public static boolean unexpectedException(Logger logger, Class<?> classe, String method, Throwable error) {
        String classname = classe != null ? classe.getName() : null;
        return Logging.unexpectedException(logger, classname, method, error, Level.WARNING);
    }

    private static boolean unexpectedException(Logger logger, String classe, String method, Throwable error, Level level) {
        if (error == null) {
            return false;
        }
        if (logger == null && classe != null) {
            int separator = classe.lastIndexOf(46);
            String paquet = separator >= 1 ? classe.substring(0, separator - 1) : "";
            logger = Logger.getLogger(paquet);
        }
        if (logger != null && !logger.isLoggable(level)) {
            return false;
        }
        StringBuilder buffer = new StringBuilder(256).append(Classes.getShortClassName(error));
        String message = error.getMessage();
        if (message != null) {
            buffer.append(": ").append(message);
        }
        message = buffer.toString();
        message = Exceptions.formatChainedMessages(null, message, error);
        LogRecord record = new LogRecord(level, message);
        if (level.intValue() >= 600) {
            record.setThrown(error);
        }
        if (logger == null || classe == null || method == null) {
            logger = Logging.inferCaller(logger, classe, method, Arrays.stream(error.getStackTrace()), record);
        } else {
            record.setSourceClassName(classe);
            record.setSourceMethodName(method);
        }
        record.setLoggerName(logger.getName());
        logger.log(record);
        return true;
    }

    static boolean configurationException(Logger logger, Class<?> classe, String method, Throwable error) {
        String classname = classe != null ? classe.getName() : null;
        return Logging.unexpectedException(logger, classname, method, error, Level.CONFIG);
    }

    public static boolean recoverableException(Logger logger, Class<?> classe, String method, Throwable error) {
        String classname = classe != null ? classe.getName() : null;
        return Logging.unexpectedException(logger, classname, method, error, Level.FINE);
    }

    public static boolean ignorableException(Logger logger, Class<?> classe, String method, Throwable error) {
        String classname = classe != null ? classe.getName() : null;
        return Logging.unexpectedException(logger, classname, method, error, Level.FINER);
    }

    public static boolean severeException(Logger logger, Class<?> classe, String method, Throwable error) {
        String classname = classe != null ? classe.getName() : null;
        return Logging.unexpectedException(logger, classname, method, error, Level.SEVERE);
    }
}

