/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.type;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.baremaps.data.type.DataType;
import org.apache.baremaps.data.type.PolygonDataType;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class MultiPolygonDataType
implements DataType<MultiPolygon> {
    private final GeometryFactory geometryFactory;
    private final PolygonDataType polygonDataType;

    public MultiPolygonDataType() {
        this(new GeometryFactory());
    }

    public MultiPolygonDataType(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
        this.polygonDataType = new PolygonDataType(geometryFactory);
    }

    @Override
    public int size(MultiPolygon value) {
        int size = 4;
        for (int i = 0; i < value.getNumGeometries(); ++i) {
            size += this.polygonDataType.size((Polygon)value.getGeometryN(i));
        }
        return size;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, MultiPolygon value) {
        buffer.putInt(position, this.size(value));
        int p = position + 4;
        for (int i = 0; i < value.getNumGeometries(); ++i) {
            this.polygonDataType.write(buffer, p, (Polygon)value.getGeometryN(i));
            p += buffer.getInt(p);
        }
    }

    @Override
    public MultiPolygon read(ByteBuffer buffer, int position) {
        int size = this.size(buffer, position);
        int limit = position + size;
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int p = position + 4; p < limit; p += this.polygonDataType.size(buffer, p)) {
            Polygon polygon = this.polygonDataType.read(buffer, p);
            polygons.add(polygon);
        }
        return this.geometryFactory.createMultiPolygon((Polygon[])polygons.toArray(Polygon[]::new));
    }
}

