/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.collection;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.baremaps.data.collection.DataCollection;
import org.apache.baremaps.data.collection.DataList;
import org.apache.baremaps.data.collection.DataMap;

public class DataConversions {
    private DataConversions() {
    }

    public static <E> Collection<E> asCollection(DataCollection<E> dataCollection) {
        if (dataCollection instanceof DataCollectionAdapter) {
            DataCollectionAdapter adapter = (DataCollectionAdapter)dataCollection;
            return adapter.collection;
        }
        return new CollectionAdapter<E>(dataCollection);
    }

    public static <E> DataCollection<E> asDataCollection(Collection<E> collection) {
        if (collection instanceof CollectionAdapter) {
            CollectionAdapter adapter = (CollectionAdapter)collection;
            return adapter.collection;
        }
        return new DataCollectionAdapter<E>(collection);
    }

    public static <E> List<E> asList(DataList<E> dataList) {
        if (dataList instanceof DataListAdapter) {
            DataListAdapter adapter = (DataListAdapter)dataList;
            return adapter.list;
        }
        return new ListAdapter<E>(dataList);
    }

    public static <E> DataList<E> asDataList(List<E> list) {
        if (list instanceof ListAdapter) {
            ListAdapter adapter = (ListAdapter)list;
            return adapter.list;
        }
        return new DataListAdapter<E>(list);
    }

    public static <K, V> Map<K, V> asMap(DataMap<K, V> dataMap) {
        if (dataMap instanceof DataMapAdapter) {
            DataMapAdapter adapter = (DataMapAdapter)dataMap;
            return adapter.map;
        }
        return new MapAdapter<K, V>(dataMap);
    }

    public static <K, V> DataMap<K, V> asDataMap(Map<K, V> map) {
        if (map instanceof MapAdapter) {
            MapAdapter adapter = (MapAdapter)map;
            return adapter.map;
        }
        return new DataMapAdapter<K, V>(map);
    }

    private static class DataCollectionAdapter<E>
    implements DataCollection<E> {
        private final Collection<E> collection;

        public DataCollectionAdapter(Collection<E> collection) {
            this.collection = collection;
        }

        @Override
        public long size() {
            return this.collection.size();
        }

        @Override
        public boolean add(E value) {
            return this.collection.add(value);
        }

        @Override
        public void clear() {
            this.collection.clear();
        }

        @Override
        public Iterator<E> iterator() {
            return this.collection.iterator();
        }
    }

    private static class CollectionAdapter<E>
    extends AbstractCollection<E> {
        private final DataCollection<E> collection;
        private final int size;

        public CollectionAdapter(DataCollection<E> dataCollection) {
            this.collection = dataCollection;
            this.size = (int)dataCollection.size();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator<E> iterator() {
            return this.collection.iterator();
        }
    }

    private static class DataListAdapter<E>
    implements DataList<E> {
        private final List<E> list;

        public DataListAdapter(List<E> list) {
            this.list = list;
        }

        @Override
        public long size() {
            return this.list.size();
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public long addIndexed(E value) {
            this.list.add(value);
            return (long)this.list.size() - 1L;
        }

        @Override
        public void set(long index, E value) {
            this.list.set((int)index, value);
        }

        @Override
        public E get(long index) {
            return this.list.get((int)index);
        }

        public boolean equals(Object object) {
            return this.list.equals(object);
        }

        public int hashCode() {
            return this.list.hashCode();
        }
    }

    private static class ListAdapter<E>
    extends AbstractList<E> {
        private final DataList<E> list;
        private final int size;

        public ListAdapter(DataList<E> dataList) {
            this.list = dataList;
            this.size = (int)dataList.size();
        }

        @Override
        public boolean add(E value) {
            return this.list.add(value);
        }

        @Override
        public E set(int index, E value) {
            E oldValue = this.list.get(index);
            this.list.set(index, value);
            return oldValue;
        }

        @Override
        public E get(int index) {
            return this.list.get(index);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean equals(Object object) {
            return this.list.equals(object);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }
    }

    private static class DataMapAdapter<K, V>
    implements DataMap<K, V> {
        private final Map<K, V> map;

        public DataMapAdapter(Map<K, V> map) {
            this.map = map;
        }

        @Override
        public long size() {
            return this.map.size();
        }

        @Override
        public V get(Object key) {
            return this.map.get(key);
        }

        @Override
        public V put(K key, V value) {
            return this.map.put(key, value);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(V value) {
            return this.map.containsValue(value);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<K> keyIterator() {
            return this.map.keySet().iterator();
        }

        @Override
        public Iterator<V> valueIterator() {
            return this.map.values().iterator();
        }

        @Override
        public Iterator<Map.Entry<K, V>> entryIterator() {
            return this.map.entrySet().iterator();
        }

        public boolean equals(Object object) {
            return this.map.equals(object);
        }

        public int hashCode() {
            return this.map.hashCode();
        }
    }

    private static class MapAdapter<K, V>
    extends AbstractMap<K, V> {
        private final DataMap<K, V> map;
        private final int size;

        public MapAdapter(DataMap<K, V> dataMap) {
            this.map = dataMap;
            this.size = (int)dataMap.size();
        }

        @Override
        public V put(K key, V value) {
            return this.map.put(key, value);
        }

        @Override
        public V get(Object key) {
            return this.map.get(key);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return map.entryIterator();
                }

                @Override
                public int size() {
                    return size;
                }
            };
        }

        @Override
        public boolean equals(Object object) {
            return this.map.equals(object);
        }

        @Override
        public int hashCode() {
            return this.map.hashCode();
        }
    }
}

