/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.common;

import java.util.logging.Logger;
import mil.nga.crs.common.Unit;
import mil.nga.crs.wkt.CRSWriter;

public class VerticalExtent {
    private static final Logger logger = Logger.getLogger(VerticalExtent.class.getName());
    private double minimumHeight;
    private String minimumHeightText;
    private double maximumHeight;
    private String maximumHeightText;
    private Unit unit = null;

    public VerticalExtent() {
    }

    public VerticalExtent(double minimumHeight, double maximumHeight) {
        this(minimumHeight, maximumHeight, null);
    }

    public VerticalExtent(String minimumHeight, String maximumHeight) {
        this(minimumHeight, maximumHeight, null);
    }

    public VerticalExtent(double minimumHeight, double maximumHeight, Unit unit) {
        this.setMinimumHeight(minimumHeight);
        this.setMaximumHeight(maximumHeight);
        this.setUnit(unit);
    }

    public VerticalExtent(String minimumHeight, String maximumHeight, Unit unit) {
        this.setMinimumHeight(minimumHeight);
        this.setMaximumHeight(maximumHeight);
        this.setUnit(unit);
    }

    public double getMinimumHeight() {
        return this.minimumHeight;
    }

    public String getMinimumHeightText() {
        return this.minimumHeightText;
    }

    public void setMinimumHeight(double minimumHeight) {
        this.minimumHeight = minimumHeight;
        this.minimumHeightText = String.valueOf(minimumHeight);
    }

    public void setMinimumHeight(String minimumHeight) {
        this.minimumHeightText = minimumHeight;
        this.minimumHeight = Double.parseDouble(minimumHeight);
    }

    public double getMaximumHeight() {
        return this.maximumHeight;
    }

    public String getMaximumHeightText() {
        return this.maximumHeightText;
    }

    public void setMaximumHeight(double maximumHeight) {
        this.maximumHeight = maximumHeight;
        this.maximumHeightText = String.valueOf(maximumHeight);
    }

    public void setMaximumHeight(String maximumHeight) {
        this.maximumHeightText = maximumHeight;
        this.maximumHeight = Double.parseDouble(maximumHeight);
    }

    public Unit getUnit() {
        return this.unit;
    }

    public boolean hasUnit() {
        return this.getUnit() != null;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        long temp = Double.doubleToLongBits(this.maximumHeight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minimumHeight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VerticalExtent other = (VerticalExtent)obj;
        if (this.unit == null ? other.unit != null : !this.unit.equals(other.unit)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maximumHeight) != Double.doubleToLongBits(other.maximumHeight)) {
            return false;
        }
        return Double.doubleToLongBits(this.minimumHeight) == Double.doubleToLongBits(other.minimumHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String value = null;
        try (CRSWriter writer = new CRSWriter();){
            writer.write(this);
            value = writer.toString();
        }
        return value;
    }
}

