/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels.store.op;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.nodelabels.store.op.FSNodeStoreLogOp;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.ReplaceLabelsOnNodeRequestPBImpl;

public class NodeToLabelOp
extends FSNodeStoreLogOp<CommonNodeLabelsManager> {
    private Map<NodeId, Set<String>> nodeToLabels;
    public static final int OPCODE = 1;

    @Override
    public void write(OutputStream os, CommonNodeLabelsManager mgr) throws IOException {
        ((ReplaceLabelsOnNodeRequestPBImpl)ReplaceLabelsOnNodeRequest.newInstance(this.nodeToLabels)).getProto().writeDelimitedTo(os);
    }

    @Override
    public void recover(InputStream is, CommonNodeLabelsManager mgr) throws IOException {
        this.nodeToLabels = new ReplaceLabelsOnNodeRequestPBImpl(YarnServerResourceManagerServiceProtos.ReplaceLabelsOnNodeRequestProto.parseDelimitedFrom((InputStream)is)).getNodeToLabels();
        if (mgr.isCentralizedConfiguration()) {
            mgr.replaceLabelsOnNode(this.nodeToLabels);
        }
    }

    public NodeToLabelOp setNodeToLabels(Map<NodeId, Set<String>> nodeToLabelsList) {
        this.nodeToLabels = nodeToLabelsList;
        return this;
    }

    public Map<NodeId, Set<String>> getNodeToLabels() {
        return this.nodeToLabels;
    }

    @Override
    public int getOpCode() {
        return 1;
    }
}

