/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client;

import com.linecorp.armeria.common.FilteredHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.annotation.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class TruncatingHttpResponse
extends FilteredHttpResponse {
    private final int maxContentLength;
    private int contentLength;
    private boolean overflow;
    @Nullable
    private Subscriber<? super HttpObject> subscriber;

    public TruncatingHttpResponse(HttpResponse delegate, int maxContentLength) {
        super(delegate);
        this.maxContentLength = maxContentLength;
    }

    @Override
    protected void beforeSubscribe(Subscriber<? super HttpObject> subscriber, Subscription subscription) {
        this.subscriber = subscriber;
    }

    @Override
    protected HttpObject filter(HttpObject obj) {
        if (!this.overflow && obj instanceof HttpData) {
            int dataLength = ((HttpData)obj).length();
            this.contentLength += dataLength;
            if (this.contentLength > this.maxContentLength) {
                this.overflow = true;
                assert (this.subscriber != null);
                this.subscriber.onComplete();
            }
        }
        return obj;
    }
}

