// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
#ifndef KUDU_UTIL_CRC_H_
#define KUDU_UTIL_CRC_H_

#include <cstdint>
#include <cstdlib>

#include <crcutil/interface.h>

namespace kudu {
namespace crc {

typedef crcutil_interface::CRC Crc;

// Returns pointer to singleton instance of CRC32C implementation.
Crc* GetCrc32cInstance();

// Helper function to simply calculate a CRC32C of the given data.
uint32_t Crc32c(const void* data, size_t length);

// Given CRC value of previous chunk of data,
// extends it to new chunk and returns the result.
uint32_t Crc32c(const void* data, size_t length, uint32_t prev_crc32);

} // namespace crc
} // namespace kudu

#endif // KUDU_UTIL_CRC_H_
