/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.cache.VisorCache;
import org.apache.ignite.internal.visor.cache.VisorMemoryMetrics;
import org.apache.ignite.internal.visor.event.VisorGridEvent;
import org.apache.ignite.internal.visor.igfs.VisorIgfs;
import org.apache.ignite.internal.visor.igfs.VisorIgfsEndpoint;
import org.apache.ignite.internal.visor.node.VisorAffinityTopologyVersion;
import org.apache.ignite.internal.visor.node.VisorPersistenceMetrics;
import org.apache.ignite.internal.visor.util.VisorExceptionWrapper;

public class VisorNodeDataCollectorTaskResult
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private boolean active;
    private Map<UUID, VisorExceptionWrapper> unhandledEx = new HashMap<UUID, VisorExceptionWrapper>();
    private Map<UUID, String> gridNames = new HashMap<UUID, String>();
    private Map<UUID, Long> topVersions = new HashMap<UUID, Long>();
    private Map<UUID, Boolean> taskMonitoringEnabled = new HashMap<UUID, Boolean>();
    private Map<UUID, Long> errCnts = new HashMap<UUID, Long>();
    private List<VisorGridEvent> evts = new ArrayList<VisorGridEvent>();
    private Map<UUID, VisorExceptionWrapper> evtsEx = new HashMap<UUID, VisorExceptionWrapper>();
    private Map<UUID, Collection<VisorMemoryMetrics>> memoryMetrics = new HashMap<UUID, Collection<VisorMemoryMetrics>>();
    private Map<UUID, VisorExceptionWrapper> memoryMetricsEx = new HashMap<UUID, VisorExceptionWrapper>();
    private Map<UUID, Collection<VisorCache>> caches = new HashMap<UUID, Collection<VisorCache>>();
    private Map<UUID, VisorExceptionWrapper> cachesEx = new HashMap<UUID, VisorExceptionWrapper>();
    private Map<UUID, Collection<VisorIgfs>> igfss = new HashMap<UUID, Collection<VisorIgfs>>();
    private Map<UUID, Collection<VisorIgfsEndpoint>> igfsEndpoints = new HashMap<UUID, Collection<VisorIgfsEndpoint>>();
    private Map<UUID, VisorExceptionWrapper> igfssEx = new HashMap<UUID, VisorExceptionWrapper>();
    private Map<UUID, VisorAffinityTopologyVersion> readyTopVers = new HashMap<UUID, VisorAffinityTopologyVersion>();
    private Map<UUID, Boolean> pendingExchanges = new HashMap<UUID, Boolean>();
    private Map<UUID, VisorPersistenceMetrics> persistenceMetrics = new HashMap<UUID, VisorPersistenceMetrics>();
    private Map<UUID, VisorExceptionWrapper> persistenceMetricsEx = new HashMap<UUID, VisorExceptionWrapper>();
    private Map<UUID, Double> rebalance = new HashMap<UUID, Double>();

    public boolean isEmpty() {
        return this.gridNames.isEmpty() && this.topVersions.isEmpty() && this.unhandledEx.isEmpty() && this.taskMonitoringEnabled.isEmpty() && this.evts.isEmpty() && this.evtsEx.isEmpty() && this.memoryMetrics.isEmpty() && this.memoryMetricsEx.isEmpty() && this.caches.isEmpty() && this.cachesEx.isEmpty() && this.igfss.isEmpty() && this.igfsEndpoints.isEmpty() && this.igfssEx.isEmpty() && this.readyTopVers.isEmpty() && this.pendingExchanges.isEmpty() && this.persistenceMetrics.isEmpty() && this.persistenceMetricsEx.isEmpty() && this.rebalance.isEmpty();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Map<UUID, VisorExceptionWrapper> getUnhandledEx() {
        return this.unhandledEx;
    }

    public Map<UUID, String> getGridNames() {
        return this.gridNames;
    }

    public Map<UUID, Long> getTopologyVersions() {
        return this.topVersions;
    }

    public Map<UUID, Boolean> getTaskMonitoringEnabled() {
        return this.taskMonitoringEnabled;
    }

    public List<VisorGridEvent> getEvents() {
        return this.evts;
    }

    public Map<UUID, VisorExceptionWrapper> getEventsEx() {
        return this.evtsEx;
    }

    public Map<UUID, Collection<VisorMemoryMetrics>> getMemoryMetrics() {
        return this.memoryMetrics;
    }

    public Map<UUID, VisorExceptionWrapper> getMemoryMetricsEx() {
        return this.memoryMetricsEx;
    }

    public Map<UUID, Collection<VisorCache>> getCaches() {
        return this.caches;
    }

    public Map<UUID, VisorExceptionWrapper> getCachesEx() {
        return this.cachesEx;
    }

    public Map<UUID, Collection<VisorIgfs>> getIgfss() {
        return this.igfss;
    }

    public Map<UUID, Collection<VisorIgfsEndpoint>> getIgfsEndpoints() {
        return this.igfsEndpoints;
    }

    public Map<UUID, VisorExceptionWrapper> getIgfssEx() {
        return this.igfssEx;
    }

    public Map<UUID, Long> getErrorCounts() {
        return this.errCnts;
    }

    public Map<UUID, VisorAffinityTopologyVersion> getReadyAffinityVersions() {
        return this.readyTopVers;
    }

    public Map<UUID, Boolean> getPendingExchanges() {
        return this.pendingExchanges;
    }

    public Map<UUID, VisorPersistenceMetrics> getPersistenceMetrics() {
        return this.persistenceMetrics;
    }

    public Map<UUID, VisorExceptionWrapper> getPersistenceMetricsEx() {
        return this.persistenceMetricsEx;
    }

    public Map<UUID, Double> getRebalance() {
        return this.rebalance;
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    public void add(VisorNodeDataCollectorTaskResult res) {
        assert (res != null);
        this.active = this.active || res.isActive();
        this.unhandledEx.putAll(res.getUnhandledEx());
        this.gridNames.putAll(res.getGridNames());
        this.topVersions.putAll(res.getTopologyVersions());
        this.taskMonitoringEnabled.putAll(res.getTaskMonitoringEnabled());
        this.errCnts.putAll(res.getErrorCounts());
        this.evts.addAll(res.getEvents());
        this.evtsEx.putAll(res.getEventsEx());
        this.memoryMetrics.putAll(res.getMemoryMetrics());
        this.memoryMetricsEx.putAll(res.getMemoryMetricsEx());
        this.caches.putAll(res.getCaches());
        this.cachesEx.putAll(res.getCachesEx());
        this.igfss.putAll(res.getIgfss());
        this.igfsEndpoints.putAll(res.getIgfsEndpoints());
        this.igfssEx.putAll(res.getIgfssEx());
        this.readyTopVers.putAll(res.getReadyAffinityVersions());
        this.pendingExchanges.putAll(res.getPendingExchanges());
        this.persistenceMetrics.putAll(res.getPersistenceMetrics());
        this.persistenceMetricsEx.putAll(res.getPersistenceMetricsEx());
        this.rebalance.putAll(res.getRebalance());
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeBoolean(this.active);
        U.writeMap(out, this.unhandledEx);
        U.writeMap(out, this.gridNames);
        U.writeMap(out, this.topVersions);
        U.writeMap(out, this.taskMonitoringEnabled);
        U.writeMap(out, this.errCnts);
        U.writeCollection(out, this.evts);
        U.writeMap(out, this.evtsEx);
        U.writeMap(out, this.memoryMetrics);
        U.writeMap(out, this.memoryMetricsEx);
        U.writeMap(out, this.caches);
        U.writeMap(out, this.cachesEx);
        U.writeMap(out, this.igfss);
        U.writeMap(out, this.igfsEndpoints);
        U.writeMap(out, this.igfssEx);
        U.writeMap(out, this.readyTopVers);
        U.writeMap(out, this.pendingExchanges);
        U.writeMap(out, this.persistenceMetrics);
        U.writeMap(out, this.persistenceMetricsEx);
        U.writeMap(out, this.rebalance);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.active = in.readBoolean();
        this.unhandledEx = U.readMap(in);
        this.gridNames = U.readMap(in);
        this.topVersions = U.readMap(in);
        this.taskMonitoringEnabled = U.readMap(in);
        this.errCnts = U.readMap(in);
        this.evts = U.readList(in);
        this.evtsEx = U.readMap(in);
        this.memoryMetrics = U.readMap(in);
        this.memoryMetricsEx = U.readMap(in);
        this.caches = U.readMap(in);
        this.cachesEx = U.readMap(in);
        this.igfss = U.readMap(in);
        this.igfsEndpoints = U.readMap(in);
        this.igfssEx = U.readMap(in);
        this.readyTopVers = U.readMap(in);
        this.pendingExchanges = U.readMap(in);
        this.persistenceMetrics = U.readMap(in);
        this.persistenceMetricsEx = U.readMap(in);
        if (protoVer > 1) {
            this.rebalance = U.readMap(in);
        }
    }

    public String toString() {
        return S.toString(VisorNodeDataCollectorTaskResult.class, this);
    }
}

