/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.discovery;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.ShutdownPolicy;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.CommunicationFailureResolver;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.DefaultCommunicationFailureResolver;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.failure.RestartProcessFailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.NodeOrderComparator;
import org.apache.ignite.internal.events.DiscoveryCustomEvent;
import org.apache.ignite.internal.managers.GridManagerAdapter;
import org.apache.ignite.internal.managers.discovery.ClusterMetricsImpl;
import org.apache.ignite.internal.managers.discovery.CustomEventListener;
import org.apache.ignite.internal.managers.discovery.CustomMessageWrapper;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.DiscoveryLocalJoinData;
import org.apache.ignite.internal.managers.discovery.IgniteClusterNode;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpi;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.managers.systemview.walker.ClusterNodeViewWalker;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.ClientCacheChangeDummyDiscoveryMessage;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeRequest;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateFinishMessage;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateMessage;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.cluster.GridClusterStateProcessor;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.processors.tracing.messages.SpanContainer;
import org.apache.ignite.internal.util.GridAtomicLong;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.segmentation.SegmentationPolicy;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.spi.discovery.DiscoveryMetricsProvider;
import org.apache.ignite.spi.discovery.DiscoveryNotification;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.DiscoverySpiDataExchange;
import org.apache.ignite.spi.discovery.DiscoverySpiHistorySupport;
import org.apache.ignite.spi.discovery.DiscoverySpiListener;
import org.apache.ignite.spi.discovery.DiscoverySpiMutableCustomMessageSupport;
import org.apache.ignite.spi.discovery.DiscoverySpiNodeAuthenticator;
import org.apache.ignite.spi.discovery.DiscoverySpiOrderSupport;
import org.apache.ignite.spi.discovery.IgniteDiscoveryThread;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.spi.systemview.view.ClusterNodeView;
import org.apache.ignite.thread.IgniteThread;
import org.apache.ignite.thread.OomExceptionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDiscoveryManager
extends GridManagerAdapter<DiscoverySpi> {
    private static final String PREFIX = "Topology snapshot";
    public static final String NODES_SYS_VIEW = "nodes";
    public static final String NODES_SYS_VIEW_DESC = "Cluster nodes";
    public static final int DFLT_DISCOVERY_HISTORY_SIZE = 500;
    public static final String DISCO_METRICS = MetricUtils.metricName("io", "discovery");
    private static final IgnitePredicate<ClusterNode> FILTER_NOT_DAEMON = new P1<ClusterNode>(){

        @Override
        public boolean apply(ClusterNode n) {
            return !n.isDaemon();
        }
    };
    private static final IgnitePredicate<ClusterNode> FILTER_CLI = new P1<ClusterNode>(){

        @Override
        public boolean apply(ClusterNode n) {
            return n.isClient();
        }
    };
    private final int DISCOVERY_HISTORY_SIZE = IgniteSystemProperties.getInteger("IGNITE_DISCOVERY_HISTORY_SIZE", 500);
    private final Object discoEvtMux = new Object();
    private final DiscoveryWorker discoWrk = new DiscoveryWorker();
    private final DiscoveryMessageNotifierWorker discoNtfWrk = new DiscoveryMessageNotifierWorker();
    private SegmentCheckWorker segChkWrk;
    private IgniteThread segChkThread;
    private final GridAtomicLong lastLoggedTop = new GridAtomicLong();
    private ClusterNode locNode;
    private boolean isLocDaemon;
    private boolean hasRslvrs;
    private final AtomicBoolean lastSegChkRes = new AtomicBoolean(true);
    private final GridBoundedConcurrentLinkedHashMap<AffinityTopologyVersion, DiscoCache> discoCacheHist = new GridBoundedConcurrentLinkedHashMap(this.DISCOVERY_HISTORY_SIZE);
    private volatile Map<Long, Collection<ClusterNode>> topHist = new HashMap<Long, Collection<ClusterNode>>();
    private final AtomicReference<Snapshot> topSnap = new AtomicReference<Snapshot>(new Snapshot(AffinityTopologyVersion.ZERO, null));
    private int minorTopVer;
    private boolean discoOrdered;
    private boolean histSupported;
    private long segChkFreq;
    private GridFutureAdapter<DiscoveryLocalJoinData> locJoin = new GridFutureAdapter();
    private ConcurrentMap<Class<?>, List<CustomEventListener<DiscoveryCustomMessage>>> customEvtLsnrs = new ConcurrentHashMap();
    private final Collection<IgniteInClosure<ClusterNode>> locNodeInitLsnrs = new ArrayList<IgniteInClosure<ClusterNode>>();
    private ConcurrentMap<String, CachePredicate> registeredCaches = new ConcurrentHashMap<String, CachePredicate>();
    private Map<Integer, CacheGroupAffinity> registeredCacheGrps = new HashMap<Integer, CacheGroupAffinity>();
    private final GridSpinBusyLock busyLock = new GridSpinBusyLock();
    private final ArrayDeque<IgniteUuid> rcvdCustomMsgs = new ArrayDeque();
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private boolean registeredDiscoSpi;
    private Serializable consistentId;

    public GridDiscoveryManager(GridKernalContext ctx) {
        super(ctx, (IgniteSpi[])new DiscoverySpi[]{ctx.config().getDiscoverySpi()});
        if (ctx.systemView().view(NODES_SYS_VIEW) == null) {
            ctx.systemView().registerView(NODES_SYS_VIEW, NODES_SYS_VIEW_DESC, new ClusterNodeViewWalker(), () -> F.concat(false, this.allNodes(), this.daemonNodes()), ClusterNodeView::new);
        }
    }

    @Override
    public void onBeforeSpiStart() {
        DiscoverySpi spi = (DiscoverySpi)this.getSpi();
        spi.setNodeAttributes(this.ctx.nodeAttributes(), IgniteVersionUtils.VER);
    }

    public void cleanCachesAndGroups() {
        this.registeredCacheGrps.clear();
        this.registeredCaches.clear();
    }

    public void addCacheGroup(CacheGroupDescriptor grpDesc, IgnitePredicate<ClusterNode> filter, CacheMode cacheMode) {
        CacheGroupAffinity old = this.registeredCacheGrps.put(grpDesc.groupId(), new CacheGroupAffinity(grpDesc.cacheOrGroupName(), filter, cacheMode, grpDesc.persistenceEnabled()));
        assert (old == null) : old;
    }

    public void removeCacheGroup(CacheGroupDescriptor grpDesc) {
        CacheGroupAffinity rmvd = this.registeredCacheGrps.remove(grpDesc.groupId());
        assert (rmvd != null) : grpDesc.cacheOrGroupName();
    }

    public void setCacheFilter(int cacheId, int grpId, String cacheName, boolean nearEnabled) {
        if (!this.registeredCaches.containsKey(cacheName)) {
            CacheGroupAffinity grp = this.registeredCacheGrps.get(grpId);
            assert (grp != null) : "Failed to find cache group [grpId=" + grpId + ", cache=" + cacheName + ']';
            if (grp.cacheMode == CacheMode.REPLICATED) {
                nearEnabled = false;
            }
            this.registeredCaches.put(cacheName, new CachePredicate(cacheId, grp, nearEnabled));
        }
    }

    public void removeCacheFilter(String cacheName) {
        CachePredicate p = (CachePredicate)this.registeredCaches.remove(cacheName);
        assert (p != null) : cacheName;
    }

    public boolean addClientNode(String cacheName, UUID clientNodeId, boolean nearEnabled) {
        CachePredicate p = (CachePredicate)this.registeredCaches.get(cacheName);
        assert (p != null) : cacheName;
        return p.addClientNode(clientNodeId, nearEnabled);
    }

    public boolean onClientCacheClose(String cacheName, UUID clientNodeId) {
        CachePredicate p = (CachePredicate)this.registeredCaches.get(cacheName);
        assert (p != null) : cacheName;
        return p.onNodeLeft(clientNodeId);
    }

    public Map<String, Map<UUID, Boolean>> clientNodesMap() {
        HashMap res = null;
        for (Map.Entry entry : this.registeredCaches.entrySet()) {
            CachePredicate pred = (CachePredicate)entry.getValue();
            if (F.isEmpty(pred.clientNodes)) continue;
            if (res == null) {
                res = U.newHashMap(this.registeredCaches.size());
            }
            res.put(entry.getKey(), new HashMap(pred.clientNodes));
        }
        return res == null ? Collections.emptyMap() : res;
    }

    private void updateClientNodes(UUID leftNodeId) {
        for (Map.Entry entry : this.registeredCaches.entrySet()) {
            CachePredicate pred = (CachePredicate)entry.getValue();
            pred.onNodeLeft(leftNodeId);
        }
    }

    @Override
    protected void onKernalStart0() throws IgniteCheckedException {
        if (this.getSpi() instanceof TcpDiscoverySpi && Boolean.TRUE.equals(this.ctx.config().isClientMode()) && !((DiscoverySpi)this.getSpi()).isClientMode()) {
            this.ctx.performance().add("Enable client mode for TcpDiscoverySpi (set TcpDiscoverySpi.forceServerMode to false)");
        }
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.ctx.addNodeAttribute("org.apache.ignite.offheap.size", this.requiredOffheap());
        this.ctx.addNodeAttribute("org.apache.ignite.data.regions.offheap.size", this.configuredOffheap());
        DiscoverySpi spi = (DiscoverySpi)this.getSpi();
        this.discoOrdered = this.discoOrdered();
        this.histSupported = this.historySupported();
        this.isLocDaemon = this.ctx.isDaemon();
        this.hasRslvrs = this.ctx.config().isClientMode() == false && !F.isEmpty(this.ctx.config().getSegmentationResolvers());
        this.segChkFreq = this.ctx.config().getSegmentCheckFrequency();
        if (this.hasRslvrs) {
            int segResAttemp;
            if (this.segChkFreq < 0L) {
                throw new IgniteCheckedException("Segment check frequency cannot be negative: " + this.segChkFreq);
            }
            if (this.segChkFreq > 0L && this.segChkFreq < 2000L) {
                U.warn(this.log, "Configuration parameter 'segmentCheckFrequency' is too low (at least 2000 ms recommended): " + this.segChkFreq);
            }
            if ((segResAttemp = this.ctx.config().getSegmentationResolveAttempts()) < 1) {
                throw new IgniteCheckedException("Segment resolve attempts cannot be negative or zero: " + segResAttemp);
            }
            this.checkSegmentOnStart();
        }
        spi.setMetricsProvider(this.createMetricsProvider());
        if (this.ctx.security().enabled()) {
            if (SecurityUtils.isSecurityCompatibilityMode()) {
                this.ctx.addNodeAttribute("org.apache.ignite.security.compatibility.enabled", true);
            }
            spi.setAuthenticator(new DiscoverySpiNodeAuthenticator(){

                @Override
                public SecurityContext authenticateNode(ClusterNode node, SecurityCredentials cred) {
                    try {
                        return GridDiscoveryManager.this.ctx.security().authenticateNode(node, cred);
                    }
                    catch (IgniteCheckedException e) {
                        throw U.convertException(e);
                    }
                }

                @Override
                public boolean isGlobalNodeAuthentication() {
                    return GridDiscoveryManager.this.ctx.security().isGlobalNodeAuthentication();
                }
            });
        }
        if (this.ctx.config().getCommunicationFailureResolver() != null) {
            this.ctx.resource().injectGeneric(this.ctx.config().getCommunicationFailureResolver());
        }
        final AtomicReference lastStateChangeEvtLsnrFutRef = new AtomicReference();
        spi.setListener(new DiscoverySpiListener(){
            private long gridStartTime;

            @Override
            public void onLocalNodeInitialized(ClusterNode locNode) {
                for (IgniteInClosure lsnr : GridDiscoveryManager.this.locNodeInitLsnrs) {
                    lsnr.apply(locNode);
                }
                if (locNode instanceof IgniteClusterNode) {
                    IgniteClusterNode node = (IgniteClusterNode)locNode;
                    if (GridDiscoveryManager.this.consistentId != null) {
                        node.setConsistentId(GridDiscoveryManager.this.consistentId);
                    }
                }
            }

            @Override
            public IgniteFuture<?> onDiscovery(DiscoveryNotification notification) {
                GridFutureAdapter notificationFut = new GridFutureAdapter();
                GridDiscoveryManager.this.discoNtfWrk.submit(notificationFut, () -> {
                    Object object = GridDiscoveryManager.this.discoEvtMux;
                    synchronized (object) {
                        this.onDiscovery0(notification);
                    }
                });
                IgniteFutureImpl fut = new IgniteFutureImpl(notificationFut);
                switch (notification.type()) {
                    case 10: 
                    case 11: 
                    case 12: {
                        if (CU.isPersistenceEnabled(GridDiscoveryManager.this.ctx.config())) break;
                        lastStateChangeEvtLsnrFutRef.set(fut);
                        break;
                    }
                    case 18: {
                        lastStateChangeEvtLsnrFutRef.set(fut);
                    }
                }
                return fut;
            }

            private void onDiscovery0(final DiscoveryNotification notification) {
                boolean discoCacheRecalculationRequired;
                DiscoCache discoCache;
                AffinityTopologyVersion nextTopVer;
                Snapshot snapshot;
                boolean verChanged;
                DiscoveryCustomMessage customMsg;
                int type = notification.type();
                final ClusterNode node = notification.getNode();
                long topVer = notification.getTopVer();
                DiscoveryCustomMessage discoveryCustomMessage = customMsg = notification.getCustomMsgData() == null ? null : ((CustomMessageWrapper)notification.getCustomMsgData()).delegate();
                if (GridDiscoveryManager.this.skipMessage(notification.type(), customMsg)) {
                    return;
                }
                ClusterNode locNode = GridDiscoveryManager.this.localNode();
                if (notification.getTopHist() != null) {
                    GridDiscoveryManager.this.topHist = notification.getTopHist();
                }
                if (type == 13) {
                    verChanged = false;
                } else if (type != 14 && type != 16 && type != 17 && type != 18) {
                    GridDiscoveryManager.this.minorTopVer = 0;
                    verChanged = true;
                } else {
                    verChanged = false;
                }
                if (type == 12 || type == 11) {
                    for (DiscoCache c : GridDiscoveryManager.this.discoCacheHist.values()) {
                        c.updateAlives(node);
                    }
                    GridDiscoveryManager.this.updateClientNodes(node.id());
                }
                boolean locJoinEvt = type == 10 && node.id().equals(locNode.id());
                ChangeGlobalStateFinishMessage stateFinishMsg = null;
                if (type == 12 || type == 11) {
                    stateFinishMsg = GridDiscoveryManager.this.ctx.state().onNodeLeft(node);
                }
                if (type == 18) {
                    boolean incMinorTopVer;
                    assert (customMsg != null);
                    if (customMsg instanceof ChangeGlobalStateMessage) {
                        incMinorTopVer = GridDiscoveryManager.this.ctx.state().onStateChangeMessage(new AffinityTopologyVersion(topVer, GridDiscoveryManager.this.minorTopVer), (ChangeGlobalStateMessage)customMsg, GridDiscoveryManager.this.discoCache());
                    } else if (customMsg instanceof ChangeGlobalStateFinishMessage) {
                        GridDiscoveryManager.this.ctx.state().onStateFinishMessage((ChangeGlobalStateFinishMessage)customMsg);
                        snapshot = (Snapshot)GridDiscoveryManager.this.topSnap.get();
                        DiscoCache discoCache2 = snapshot.discoCache.copy(snapshot.topVer, GridDiscoveryManager.this.ctx.state().clusterState());
                        GridDiscoveryManager.this.topSnap.set(new Snapshot(snapshot.topVer, discoCache2));
                        incMinorTopVer = false;
                    } else {
                        incMinorTopVer = GridDiscoveryManager.this.ctx.cache().onCustomEvent(customMsg, new AffinityTopologyVersion(topVer, GridDiscoveryManager.this.minorTopVer), node);
                    }
                    if (incMinorTopVer) {
                        GridDiscoveryManager.this.minorTopVer++;
                        verChanged = true;
                    }
                    nextTopVer = new AffinityTopologyVersion(topVer, GridDiscoveryManager.this.minorTopVer);
                    if (incMinorTopVer) {
                        GridDiscoveryManager.this.ctx.cache().onDiscoveryEvent(type, customMsg, node, nextTopVer, GridDiscoveryManager.this.ctx.state().clusterState());
                    }
                } else {
                    nextTopVer = new AffinityTopologyVersion(topVer, GridDiscoveryManager.this.minorTopVer);
                    GridDiscoveryManager.this.ctx.cache().onDiscoveryEvent(type, customMsg, node, nextTopVer, GridDiscoveryManager.this.ctx.state().clusterState());
                }
                if (verChanged) {
                    snapshot = (Snapshot)GridDiscoveryManager.this.topSnap.get();
                    discoCache = customMsg == null ? GridDiscoveryManager.this.createDiscoCache(nextTopVer, GridDiscoveryManager.this.ctx.state().clusterState(), locNode, notification.getTopSnapshot()) : (customMsg instanceof ChangeGlobalStateMessage ? GridDiscoveryManager.this.createDiscoCache(nextTopVer, GridDiscoveryManager.this.ctx.state().pendingState((ChangeGlobalStateMessage)customMsg), locNode, notification.getTopSnapshot()) : customMsg.createDiscoCache(GridDiscoveryManager.this, nextTopVer, snapshot.discoCache));
                    GridDiscoveryManager.this.discoCacheHist.put(nextTopVer, discoCache);
                    assert (snapshot.topVer.compareTo(nextTopVer) < 0) : "Topology version out of order [this.topVer=" + GridDiscoveryManager.access$1900(GridDiscoveryManager.this) + ", topVer=" + topVer + ", node=" + node + ", nextTopVer=" + nextTopVer + ", evt=" + U.gridEventName(type) + ']';
                    GridDiscoveryManager.this.topSnap.set(new Snapshot(nextTopVer, discoCache));
                } else {
                    discoCache = GridDiscoveryManager.this.discoCache();
                }
                if ((locJoinEvt || !node.isClient() && !node.isDaemon()) && (type == 11 || type == 12 || type == 10) && (discoCacheRecalculationRequired = GridDiscoveryManager.this.ctx.state().autoAdjustInMemoryClusterState(node.id(), notification.getTopSnapshot(), discoCache, topVer, GridDiscoveryManager.this.minorTopVer))) {
                    discoCache = GridDiscoveryManager.this.createDiscoCache(nextTopVer, GridDiscoveryManager.this.ctx.state().clusterState(), locNode, notification.getTopSnapshot());
                    GridDiscoveryManager.this.discoCacheHist.put(nextTopVer, discoCache);
                    GridDiscoveryManager.this.topSnap.set(new Snapshot(nextTopVer, discoCache));
                }
                if (type == 18) {
                    for (Class<?> cls = customMsg.getClass(); cls != null; cls = cls.getSuperclass()) {
                        List list = (List)GridDiscoveryManager.this.customEvtLsnrs.get(cls);
                        if (list == null) continue;
                        for (CustomEventListener lsnr : list) {
                            try {
                                lsnr.onCustomEvent(nextTopVer, node, customMsg);
                            }
                            catch (Exception e) {
                                U.error(GridDiscoveryManager.this.log, "Failed to notify direct custom event listener: " + customMsg, e);
                            }
                        }
                    }
                }
                if (locJoinEvt) {
                    if (this.gridStartTime == 0L) {
                        this.gridStartTime = ((DiscoverySpi)GridDiscoveryManager.this.getSpi()).getGridStartTime();
                    }
                    GridDiscoveryManager.this.topSnap.set(new Snapshot(nextTopVer, discoCache));
                    GridDiscoveryManager.this.startLatch.countDown();
                    DiscoveryEvent discoEvt = new DiscoveryEvent();
                    discoEvt.node(GridDiscoveryManager.this.ctx.discovery().localNode());
                    discoEvt.eventNode(node);
                    discoEvt.type(10);
                    discoEvt.topologySnapshot(topVer, new ArrayList<ClusterNode>(F.view(notification.getTopSnapshot(), FILTER_NOT_DAEMON)));
                    if (notification.getSpanContainer() != null) {
                        discoEvt.span(notification.getSpanContainer().span());
                    }
                    GridDiscoveryManager.this.discoWrk.discoCache = discoCache;
                    if (!GridDiscoveryManager.this.isLocDaemon && !GridDiscoveryManager.this.ctx.clientDisconnected()) {
                        GridDiscoveryManager.this.ctx.cache().context().versions().onLocalJoin(topVer);
                        GridDiscoveryManager.this.ctx.cache().context().coordinators().onLocalJoin(discoEvt, discoCache);
                        GridDiscoveryManager.this.ctx.cache().context().exchange().onLocalJoin(discoEvt, discoCache);
                        GridDiscoveryManager.this.ctx.service().onLocalJoin(discoEvt, discoCache);
                        GridDiscoveryManager.this.ctx.authentication().onLocalJoin();
                        GridDiscoveryManager.this.ctx.encryption().onLocalJoin();
                        GridDiscoveryManager.this.ctx.cluster().onLocalJoin();
                    }
                    IgniteInternalFuture<Boolean> transitionWaitFut = GridDiscoveryManager.this.ctx.state().onLocalJoin(discoCache);
                    GridDiscoveryManager.this.locJoin.onDone(new DiscoveryLocalJoinData(discoEvt, discoCache, transitionWaitFut, GridDiscoveryManager.this.ctx.state().clusterState().active()));
                    return;
                }
                if (type == 16) {
                    assert (locNode.isClient()) : locNode;
                    assert (node.isClient()) : node;
                    ((IgniteKernal)GridDiscoveryManager.this.ctx.grid()).onDisconnected();
                    if (!GridDiscoveryManager.this.locJoin.isDone()) {
                        GridDiscoveryManager.this.locJoin.onDone(new IgniteCheckedException("Node disconnected"));
                    }
                    GridDiscoveryManager.this.locJoin = new GridFutureAdapter();
                    GridDiscoveryManager.this.registeredCaches.clear();
                    GridDiscoveryManager.this.registeredCacheGrps.clear();
                    for (AffinityTopologyVersion histVer : GridDiscoveryManager.this.discoCacheHist.keySet()) {
                        Object rmvd = GridDiscoveryManager.this.discoCacheHist.remove(histVer);
                        assert (rmvd != null) : histVer;
                    }
                    GridDiscoveryManager.this.topHist.clear();
                    GridDiscoveryManager.this.topSnap.set(new Snapshot(AffinityTopologyVersion.ZERO, GridDiscoveryManager.this.createDiscoCache(AffinityTopologyVersion.ZERO, GridDiscoveryManager.this.ctx.state().clusterState(), locNode, Collections.singleton(locNode))));
                } else if (type == 17) {
                    assert (locNode.isClient()) : locNode;
                    assert (node.isClient()) : node;
                    boolean clusterRestarted = this.gridStartTime != ((DiscoverySpi)GridDiscoveryManager.this.getSpi()).getGridStartTime();
                    this.gridStartTime = ((DiscoverySpi)GridDiscoveryManager.this.getSpi()).getGridStartTime();
                    ((IgniteKernal)GridDiscoveryManager.this.ctx.grid()).onReconnected(clusterRestarted);
                    GridDiscoveryManager.this.ctx.cache().context().coordinators().onLocalJoin(GridDiscoveryManager.this.localJoinEvent(), discoCache);
                    GridDiscoveryManager.this.ctx.cache().context().exchange().onLocalJoin(GridDiscoveryManager.this.localJoinEvent(), discoCache);
                    GridDiscoveryManager.this.ctx.service().onLocalJoin(GridDiscoveryManager.this.localJoinEvent(), discoCache);
                    final DiscoCache discoCache0 = discoCache;
                    GridDiscoveryManager.this.ctx.cluster().clientReconnectFuture().listen(new CI1<IgniteFuture<?>>(){

                        @Override
                        public void apply(IgniteFuture<?> fut) {
                            try {
                                fut.get();
                                GridDiscoveryManager.this.discoWrk.addEvent(new NotificationEvent(17, nextTopVer, node, discoCache0, notification.getTopSnapshot(), null, notification.getSpanContainer()));
                            }
                            catch (IgniteException igniteException) {
                                // empty catch block
                            }
                        }
                    });
                    return;
                }
                if (type == 16 || type == 14 || !GridDiscoveryManager.this.ctx.clientDisconnected()) {
                    GridDiscoveryManager.this.discoWrk.addEvent(new NotificationEvent(type, nextTopVer, node, discoCache, notification.getTopSnapshot(), customMsg, notification.getSpanContainer()));
                }
                if (stateFinishMsg != null) {
                    GridDiscoveryManager.this.discoWrk.addEvent(new NotificationEvent(18, nextTopVer, node, discoCache, notification.getTopSnapshot(), stateFinishMsg, notification.getSpanContainer()));
                }
                if (type == 16) {
                    GridDiscoveryManager.this.discoWrk.awaitDisconnectEvent();
                }
            }
        });
        spi.setDataExchange(new DiscoverySpiDataExchange(){

            @Override
            public DiscoveryDataBag collect(DiscoveryDataBag dataBag) {
                assert (dataBag != null);
                assert (dataBag.joiningNodeId() != null);
                if (GridDiscoveryManager.this.ctx.localNodeId().equals(dataBag.joiningNodeId())) {
                    for (GridComponent c : GridDiscoveryManager.this.ctx.components()) {
                        c.collectJoiningNodeData(dataBag);
                    }
                } else {
                    this.waitForLastStateChangeEventFuture();
                    for (GridComponent c : GridDiscoveryManager.this.ctx.components()) {
                        c.collectGridNodeData(dataBag);
                    }
                }
                return dataBag;
            }

            @Override
            public void onExchange(DiscoveryDataBag dataBag) {
                assert (dataBag != null);
                assert (dataBag.joiningNodeId() != null);
                if (GridDiscoveryManager.this.ctx.localNodeId().equals(dataBag.joiningNodeId())) {
                    GridClusterStateProcessor stateProc = GridDiscoveryManager.this.ctx.state();
                    stateProc.onGridDataReceived(dataBag.gridDiscoveryData(stateProc.discoveryDataType().ordinal()));
                    for (GridComponent c : GridDiscoveryManager.this.ctx.components()) {
                        if (c.discoveryDataType() == null || c == stateProc) continue;
                        c.onGridDataReceived(dataBag.gridDiscoveryData(c.discoveryDataType().ordinal()));
                    }
                } else {
                    GridClusterStateProcessor stateProc = GridDiscoveryManager.this.ctx.state();
                    DiscoveryDataBag.JoiningNodeDiscoveryData data0 = dataBag.newJoinerDiscoveryData(stateProc.discoveryDataType().ordinal());
                    assert (data0 != null);
                    stateProc.onJoiningNodeDataReceived(data0);
                    for (GridComponent c : GridDiscoveryManager.this.ctx.components()) {
                        DiscoveryDataBag.JoiningNodeDiscoveryData data;
                        if (c.discoveryDataType() == null || c == stateProc || (data = dataBag.newJoinerDiscoveryData(c.discoveryDataType().ordinal())) == null) continue;
                        c.onJoiningNodeDataReceived(data);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void waitForLastStateChangeEventFuture() {
                IgniteFuture lastStateChangeEvtLsnrFut = (IgniteFuture)lastStateChangeEvtLsnrFutRef.get();
                if (lastStateChangeEvtLsnrFut != null) {
                    GridWorker worker;
                    Thread currThread = Thread.currentThread();
                    GridWorker gridWorker = worker = currThread instanceof IgniteDiscoveryThread ? ((IgniteDiscoveryThread)((Object)currThread)).worker() : null;
                    if (worker != null) {
                        worker.blockingSectionBegin();
                    }
                    try {
                        lastStateChangeEvtLsnrFut.get();
                    }
                    finally {
                        lastStateChangeEvtLsnrFutRef.set(null);
                        if (worker != null) {
                            worker.blockingSectionEnd();
                        }
                    }
                }
            }
        });
        new DiscoveryMessageNotifierThread(this.discoNtfWrk).start();
        this.startSpi();
        this.registeredDiscoSpi = true;
        try {
            U.await(this.startLatch);
        }
        catch (IgniteInterruptedException e) {
            throw new IgniteCheckedException("Failed to start discovery manager (thread has been interrupted).", e);
        }
        if (this.hasRslvrs && this.segChkFreq > 0L) {
            this.segChkWrk = new SegmentCheckWorker();
            this.segChkThread = new IgniteThread(this.segChkWrk);
            this.segChkThread.setUncaughtExceptionHandler(new OomExceptionHandler(this.ctx));
            this.segChkThread.start();
        }
        this.locNode = spi.getLocalNode();
        this.checkAttributes(this.discoCache().remoteNodes());
        new IgniteThread(this.discoWrk).start();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    private boolean skipMessage(int type, @Nullable DiscoveryCustomMessage customMsg) {
        if (type == 18) {
            assert (customMsg != null && customMsg.id() != null) : customMsg;
            if (this.rcvdCustomMsgs.contains(customMsg.id())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received duplicated custom message, will ignore [msg=" + customMsg + "]");
                }
                return true;
            }
            this.rcvdCustomMsgs.addLast(customMsg.id());
            while (this.rcvdCustomMsgs.size() > this.DISCOVERY_HISTORY_SIZE) {
                this.rcvdCustomMsgs.pollFirst();
            }
        }
        return false;
    }

    public <T extends DiscoveryCustomMessage> void setCustomEventListener(Class<T> msgCls, CustomEventListener<T> lsnr) {
        List list = (List)this.customEvtLsnrs.get(msgCls);
        if (list == null) {
            list = F.addIfAbsent(this.customEvtLsnrs, msgCls, new CopyOnWriteArrayList());
        }
        list.add(lsnr);
    }

    public void addLocalNodeInitializedEventListener(IgniteInClosure<ClusterNode> lsnr) {
        this.locNodeInitLsnrs.add(lsnr);
    }

    public DiscoveryMetricsProvider createMetricsProvider() {
        return new DiscoveryMetricsProvider(){
            private final boolean disableCacheMetricsUpdate = IgniteSystemProperties.getBoolean("IGNITE_DISCOVERY_DISABLE_CACHE_METRICS_UPDATE");
            private final long startTime = U.currentTimeMillis();

            @Override
            public ClusterMetrics metrics() {
                return new ClusterMetricsImpl(GridDiscoveryManager.this.ctx, this.startTime);
            }

            @Override
            public Map<Integer, CacheMetrics> cacheMetrics() {
                try {
                    if (this.disableCacheMetricsUpdate) {
                        return Collections.emptyMap();
                    }
                    if (GridDiscoveryManager.this.ctx.state().clusterState().transition()) {
                        return Collections.emptyMap();
                    }
                    Collection<GridCacheAdapter<?, ?>> caches = GridDiscoveryManager.this.ctx.cache().internalCaches();
                    if (!F.isEmpty(caches)) {
                        HashMap<Integer, CacheMetrics> metrics = U.newHashMap(caches.size());
                        for (GridCacheAdapter<?, ?> cache : caches) {
                            if (!cache.context().statisticsEnabled() || !cache.context().started() || cache.context().affinity().affinityTopologyVersion().topologyVersion() <= 0L) continue;
                            metrics.put(cache.context().cacheId(), cache.localMetrics());
                        }
                        return metrics;
                    }
                }
                catch (Exception e) {
                    U.warn(GridDiscoveryManager.this.log, "Failed to compute cache metrics", e);
                }
                return Collections.emptyMap();
            }
        };
    }

    private boolean discoOrdered() {
        DiscoverySpiOrderSupport ann = U.getAnnotation(this.ctx.config().getDiscoverySpi().getClass(), DiscoverySpiOrderSupport.class);
        return ann != null && ann.value();
    }

    private boolean historySupported() {
        DiscoverySpiHistorySupport ann = U.getAnnotation(this.ctx.config().getDiscoverySpi().getClass(), DiscoverySpiHistorySupport.class);
        return ann != null && ann.value();
    }

    private void checkSegmentOnStart() throws IgniteCheckedException {
        assert (this.hasRslvrs);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting network segment check.");
        }
        while (!this.ctx.segmentation().isValidSegment()) {
            if (this.ctx.config().isWaitForSegmentOnStart()) {
                LT.warn(this.log, "Failed to check network segment (retrying every 2000 ms).");
                U.sleep(2000L);
                continue;
            }
            throw new IgniteCheckedException("Failed to check network segment.");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Finished network segment check successfully.");
        }
    }

    private void checkAttributes(Iterable<ClusterNode> nodes) throws IgniteCheckedException {
        ClusterNode locNode = ((DiscoverySpi)this.getSpi()).getLocalNode();
        assert (locNode != null);
        String locPreferIpV4 = (String)locNode.attribute("java.net.preferIPv4Stack");
        Object locMode = locNode.attribute("org.apache.ignite.ignite.dep.mode");
        int locJvmMajVer = this.nodeJavaMajorVersion(locNode);
        boolean locP2pEnabled = (Boolean)locNode.attribute("org.apache.ignite.peer.classloading.enabled");
        ShutdownPolicy locShutdownPolicy = ShutdownPolicy.fromOrdinal((Integer)locNode.attribute("org.apache.ignite.shutdown.policy"));
        boolean ipV4Warned = false;
        boolean jvmMajVerWarned = false;
        Boolean locMarshUseDfltSuid = (Boolean)locNode.attribute("org.apache.ignite.marshaller.useDefaultSUID");
        boolean locMarshUseDfltSuidBool = locMarshUseDfltSuid == null ? true : locMarshUseDfltSuid;
        Boolean locMarshStrSerVer2 = (Boolean)locNode.attribute("org.apache.ignite.marshaller.utf8SerializationVer2");
        boolean locMarshStrSerVer2Bool = locMarshStrSerVer2 == null ? false : locMarshStrSerVer2;
        boolean locDelayAssign = (Boolean)locNode.attribute("org.apache.ignite.cache.lateAffinity");
        Boolean locSrvcProcMode = (Boolean)locNode.attribute("org.apache.ignite.event.driven.service.processor.enabled");
        Boolean locSecurityCompatibilityEnabled = (Boolean)locNode.attribute("org.apache.ignite.security.compatibility.enabled");
        for (ClusterNode n : nodes) {
            Boolean rmtSecurityCompatibilityEnabled;
            ShutdownPolicy rmtShutdownPolicy;
            boolean rmtSrvcProcMode;
            boolean rmtMarshStrSerVer2Bool;
            Boolean rmtMarshUseDfltSuid;
            boolean rmtMarshUseDfltSuidBool;
            String rmtPreferIpV4;
            int rmtJvmMajVer = this.nodeJavaMajorVersion(n);
            if (locJvmMajVer != rmtJvmMajVer && !jvmMajVerWarned) {
                U.warn(this.log, "Local java version is different from remote [loc=" + locJvmMajVer + ", rmt=" + rmtJvmMajVer + "]");
                jvmMajVerWarned = true;
            }
            if (!F.eq(rmtPreferIpV4 = (String)n.attribute("java.net.preferIPv4Stack"), locPreferIpV4)) {
                if (!ipV4Warned) {
                    U.warn(this.log, "Local node's value of 'java.net.preferIPv4Stack' system property differs from remote node's (all nodes in topology should have identical value) [locPreferIpV4=" + locPreferIpV4 + ", rmtPreferIpV4=" + rmtPreferIpV4 + ", locId8=" + U.id8(locNode.id()) + ", rmtId8=" + U.id8(n.id()) + ", rmtAddrs=" + U.addressesAsString(n) + ", rmtNode=" + U.toShortString(n) + "]");
                }
                ipV4Warned = true;
            }
            if (!this.isLocDaemon && !n.isDaemon()) {
                Object rmtMode = n.attribute("org.apache.ignite.ignite.dep.mode");
                if (!locMode.equals(rmtMode)) {
                    throw new IgniteCheckedException("Remote node has deployment mode different from local [locId8=" + U.id8(locNode.id()) + ", locMode=" + locMode + ", rmtId8=" + U.id8(n.id()) + ", rmtMode=" + rmtMode + ", rmtAddrs=" + U.addressesAsString(n) + ", rmtNode=" + U.toShortString(n) + "]");
                }
                boolean rmtP2pEnabled = (Boolean)n.attribute("org.apache.ignite.peer.classloading.enabled");
                if (locP2pEnabled != rmtP2pEnabled) {
                    throw new IgniteCheckedException("Remote node has peer class loading enabled flag different from local [locId8=" + U.id8(locNode.id()) + ", locPeerClassLoading=" + locP2pEnabled + ", rmtId8=" + U.id8(n.id()) + ", rmtPeerClassLoading=" + rmtP2pEnabled + ", rmtAddrs=" + U.addressesAsString(n) + ", rmtNode=" + U.toShortString(n) + "]");
                }
            }
            boolean bl = rmtMarshUseDfltSuidBool = (rmtMarshUseDfltSuid = (Boolean)n.attribute("org.apache.ignite.marshaller.useDefaultSUID")) == null ? true : rmtMarshUseDfltSuid;
            if (locMarshUseDfltSuidBool != rmtMarshUseDfltSuidBool) {
                throw new IgniteCheckedException("Local node's IGNITE_OPTIMIZED_MARSHALLER_USE_DEFAULT_SUID property value differs from remote node's value (to make sure all nodes in topology have identical marshaller settings, configure system property explicitly) [locMarshUseDfltSuid=" + locMarshUseDfltSuid + ", rmtMarshUseDfltSuid=" + rmtMarshUseDfltSuid + ", locNodeAddrs=" + U.addressesAsString(locNode) + ", rmtNodeAddrs=" + U.addressesAsString(n) + ", locNodeId=" + locNode.id() + ", rmtNodeId=" + n.id() + ", rmtNode=" + U.toShortString(n) + "]");
            }
            Boolean rmtMarshStrSerVer2 = (Boolean)n.attribute("org.apache.ignite.marshaller.utf8SerializationVer2");
            boolean bl2 = rmtMarshStrSerVer2Bool = rmtMarshStrSerVer2 == null ? false : rmtMarshStrSerVer2;
            if (locMarshStrSerVer2Bool != rmtMarshStrSerVer2Bool) {
                throw new IgniteCheckedException("Local node's IGNITE_BINARY_MARSHALLER_USE_STRING_SERIALIZATION_VER_2 property value differs from remote node's value (to make sure all nodes in topology have identical marshaller settings, configure system property explicitly) [locMarshStrSerVer2=" + locMarshStrSerVer2 + ", rmtMarshStrSerVer2=" + rmtMarshStrSerVer2 + ", locNodeAddrs=" + U.addressesAsString(locNode) + ", rmtNodeAddrs=" + U.addressesAsString(n) + ", locNodeId=" + locNode.id() + ", rmtNodeId=" + n.id() + ", rmtNode=" + U.toShortString(n) + "]");
            }
            boolean rmtLateAssign = (Boolean)n.attribute("org.apache.ignite.cache.lateAffinity");
            if (locDelayAssign != rmtLateAssign) {
                throw new IgniteCheckedException("Remote node has cache affinity assignment mode different from local [locId8=" + U.id8(locNode.id()) + ", locDelayAssign=" + locDelayAssign + ", rmtId8=" + U.id8(n.id()) + ", rmtLateAssign=" + rmtLateAssign + ", rmtAddrs=" + U.addressesAsString(n) + ", rmtNode=" + U.toShortString(n) + "]");
            }
            Boolean rmtSrvcProcModeAttr = (Boolean)n.attribute("org.apache.ignite.event.driven.service.processor.enabled");
            boolean bl3 = rmtSrvcProcMode = rmtSrvcProcModeAttr != null ? rmtSrvcProcModeAttr : false;
            if (!F.eq(locSrvcProcMode, rmtSrvcProcMode)) {
                throw new IgniteCheckedException("Local node's IGNITE_EVENT_DRIVEN_SERVICE_PROCESSOR_ENABLED property value differs from remote node's value (to make sure all nodes in topology have identical service processor mode, configure system property explicitly) [locSrvcProcMode=" + locSrvcProcMode + ", rmtSrvcProcMode=" + rmtSrvcProcMode + ", locNodeAddrs=" + U.addressesAsString(locNode) + ", rmtNodeAddrs=" + U.addressesAsString(n) + ", locNodeId=" + locNode.id() + ", rmtNode=" + U.toShortString(n) + "]");
            }
            ShutdownPolicy shutdownPolicy = rmtShutdownPolicy = n.attribute("org.apache.ignite.shutdown.policy") == null ? null : ShutdownPolicy.fromOrdinal((Integer)n.attribute("org.apache.ignite.shutdown.policy"));
            if (rmtShutdownPolicy != null && !F.eq((Object)locShutdownPolicy, (Object)rmtShutdownPolicy)) {
                throw new IgniteCheckedException("Remote node has shutdoun policy different from local local [locId8=" + U.id8(locNode.id()) + ", locShutdownPolicy=" + (Object)((Object)locShutdownPolicy) + ", rmtId8=" + U.id8(n.id()) + ", rmtShutdownPolicy=" + (Object)((Object)rmtShutdownPolicy) + ", rmtAddrs=" + U.addressesAsString(n) + ", rmtNode=" + U.toShortString(n) + "]");
            }
            if (!this.ctx.security().enabled() || F.eq(locSecurityCompatibilityEnabled, rmtSecurityCompatibilityEnabled = (Boolean)n.attribute("org.apache.ignite.security.compatibility.enabled"))) continue;
            throw new IgniteCheckedException("Local node's IGNITE_SECURITY_COMPATIBILITY_MODE property value differs from remote node's value (to make sure all nodes in topology have identical Ignite security compatibility mode enabled, configure system property explicitly) [locSecurityCompatibilityEnabled=" + locSecurityCompatibilityEnabled + ", rmtSecurityCompatibilityEnabled=" + rmtSecurityCompatibilityEnabled + ", locNodeAddrs=" + U.addressesAsString(locNode) + ", rmtNodeAddrs=" + U.addressesAsString(n) + ", locNodeId=" + locNode.id() + ", rmtNode=" + U.toShortString(n) + "]");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Finished node attributes consistency check.");
        }
    }

    private int nodeJavaMajorVersion(ClusterNode node) throws IgniteCheckedException {
        String verStr = (String)node.attribute("java.version");
        int res = U.majorJavaVersion(verStr);
        if (res == 0) {
            U.error(this.log, "Failed to get java major version (unknown 'java.version' format) [ver=" + (String)node.attribute("java.version") + "]");
        }
        return res;
    }

    private static int cpus(Collection<ClusterNode> nodes) {
        HashSet<String> macSet = new HashSet<String>(nodes.size(), 1.0f);
        int cpus = 0;
        for (ClusterNode n : nodes) {
            String macs = (String)n.attribute("org.apache.ignite.macs");
            if (!macSet.add(macs)) continue;
            cpus += n.metrics().getTotalCpus();
        }
        return cpus;
    }

    public void ackTopology(long topVer, int evtType, ClusterNode evtNode) {
        this.ackTopology(topVer, evtType, evtNode, false);
    }

    private void ackTopology(long topVer, int evtType, ClusterNode evtNode, boolean throttle) {
        assert (!this.isLocDaemon);
        DiscoCache discoCache = (DiscoCache)this.discoCacheHist.get(new AffinityTopologyVersion(topVer));
        if (discoCache == null) {
            String msg = "Failed to resolve nodes topology [topVer=" + topVer + ", hist=" + this.discoCacheHist.keySet() + ']';
            if (this.log.isQuiet()) {
                U.quiet(false, msg);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug(msg);
            } else if (this.log.isInfoEnabled()) {
                this.log.info(msg);
            }
            return;
        }
        List<ClusterNode> rmtNodes = discoCache.remoteNodes();
        Collection<ClusterNode> srvNodes = F.view(discoCache.allNodes(), F.not(FILTER_CLI));
        Collection<ClusterNode> clientNodes = F.view(discoCache.allNodes(), FILTER_CLI);
        ClusterNode locNode = discoCache.localNode();
        List<ClusterNode> allNodes = discoCache.allNodes();
        if (throttle && !this.lastLoggedTop.setIfGreater(topVer)) {
            return;
        }
        int totalCpus = GridDiscoveryManager.cpus(allNodes);
        double heap = U.heapSize(allNodes, 2);
        double offheap = U.offheapSize(allNodes, 2);
        if (this.log.isQuiet()) {
            this.topologySnapshotMessage(new IgniteClosure<String, Void>(){

                @Override
                public Void apply(String msg) {
                    U.quiet(false, msg);
                    return null;
                }
            }, topVer, discoCache, evtType, evtNode, srvNodes.size(), clientNodes.size(), totalCpus, heap, offheap);
        }
        if (this.log.isDebugEnabled()) {
            String dbg = "";
            dbg = dbg + U.nl() + U.nl() + ">>> +----------------+" + U.nl() + ">>> " + PREFIX + "." + U.nl() + ">>> +----------------+" + U.nl() + ">>> Ignite instance name: " + (this.ctx.igniteInstanceName() == null ? "default" : this.ctx.igniteInstanceName()) + U.nl() + ">>> Number of server nodes: " + srvNodes.size() + U.nl() + ">>> Number of client nodes: " + clientNodes.size() + U.nl() + (this.discoOrdered ? ">>> Topology version: " + topVer + U.nl() : "");
            dbg = dbg + ">>> Local: " + locNode.id().toString().toUpperCase() + ", " + U.addressesAsString(locNode) + ", " + locNode.order() + ", " + locNode.attribute("os.name") + ' ' + locNode.attribute("os.arch") + ' ' + locNode.attribute("os.version") + ", " + System.getProperty("user.name") + ", " + locNode.attribute("java.runtime.name") + ' ' + locNode.attribute("java.runtime.version") + U.nl();
            for (ClusterNode node : rmtNodes) {
                dbg = dbg + ">>> Remote: " + node.id().toString().toUpperCase() + ", " + U.addressesAsString(node) + ", " + node.order() + ", " + node.attribute("os.name") + ' ' + node.attribute("os.arch") + ' ' + node.attribute("os.version") + ", " + node.attribute("org.apache.ignite.user.name") + ", " + node.attribute("java.runtime.name") + ' ' + node.attribute("java.runtime.version") + U.nl();
            }
            dbg = dbg + ">>> Total number of CPUs: " + totalCpus + U.nl();
            dbg = dbg + ">>> Total heap size: " + heap + "GB" + U.nl();
            dbg = dbg + ">>> Total offheap size: " + offheap + "GB" + U.nl();
            this.log.debug(dbg);
        } else if (this.log.isInfoEnabled()) {
            this.topologySnapshotMessage(new IgniteClosure<String, Void>(){

                @Override
                public Void apply(String msg) {
                    GridDiscoveryManager.this.log.info(msg);
                    return null;
                }
            }, topVer, discoCache, evtType, evtNode, srvNodes.size(), clientNodes.size(), totalCpus, heap, offheap);
        }
    }

    private long requiredOffheap() {
        if (this.ctx.config().isClientMode().booleanValue()) {
            return 0L;
        }
        DataStorageConfiguration memCfg = this.ctx.config().getDataStorageConfiguration();
        assert (memCfg != null);
        long res = memCfg.getSystemRegionMaxSize();
        DataRegionConfiguration[] dataRegions = memCfg.getDataRegionConfigurations();
        if (dataRegions != null) {
            for (DataRegionConfiguration dataReg : dataRegions) {
                res += dataReg.getMaxSize();
                res += U.checkpointBufferSize(dataReg);
            }
        }
        res += memCfg.getDefaultDataRegionConfiguration().getMaxSize();
        return res += U.checkpointBufferSize(memCfg.getDefaultDataRegionConfiguration());
    }

    private long configuredOffheap() {
        DataStorageConfiguration memCfg = this.ctx.config().getDataStorageConfiguration();
        if (memCfg == null) {
            return 0L;
        }
        long res = memCfg.getDefaultDataRegionConfiguration().getMaxSize();
        DataRegionConfiguration[] dataRegions = memCfg.getDataRegionConfigurations();
        if (dataRegions != null) {
            for (DataRegionConfiguration dataReg : dataRegions) {
                res += dataReg.getMaxSize();
            }
        }
        return res;
    }

    private void topologySnapshotMessage(IgniteClosure<String, Void> clo, long topVer, DiscoCache discoCache, int evtType, ClusterNode evtNode, int srvNodesNum, int clientNodesNum, int totalCpus, double heap, double offheap) {
        BaselineTopology blt;
        DiscoveryDataClusterState state = discoCache.state();
        String summary = "Topology snapshot [" + (this.discoOrdered ? "ver=" + topVer + ", " : "") + "locNode=" + U.id8(discoCache.localNode().id()) + ", servers=" + srvNodesNum + ", clients=" + clientNodesNum + ", state=" + (state.active() ? "ACTIVE" : "INACTIVE") + ", CPUs=" + totalCpus + ", offheap=" + offheap + "GB, heap=" + heap + "GB]";
        clo.apply(summary);
        ClusterNode currCrd = discoCache.oldestServerNode();
        if (!(evtType != 12 && evtType != 11 || currCrd == null || currCrd.order() <= evtNode.order() || evtNode.isClient() || evtNode.isDaemon())) {
            clo.apply("Coordinator changed [prev=" + evtNode + ", cur=" + currCrd + "]");
        }
        if ((blt = state.baselineTopology()) != null && discoCache.baselineNodes() != null) {
            int bltSize = discoCache.baselineNodes().size();
            int bltOnline = discoCache.aliveBaselineNodes().size();
            int bltOffline = bltSize - bltOnline;
            clo.apply("  ^-- Baseline [id=" + blt.id() + ", size=" + bltSize + ", online=" + bltOnline + ", offline=" + bltOffline + ']');
            ClusterState targetState = this.ctx.config().getClusterStateOnStart();
            if (targetState == null) {
                ClusterState clusterState = targetState = this.ctx.config().isAutoActivationEnabled() ? ClusterState.ACTIVE : ClusterState.INACTIVE;
            }
            if (!state.state().active() && targetState.active()) {
                String offlineConsistentIds = "";
                if (bltOffline > 0 && bltOffline <= 5) {
                    HashSet<? extends BaselineNode> offlineNodes = new HashSet<BaselineNode>(discoCache.baselineNodes());
                    offlineNodes.removeAll(discoCache.aliveBaselineNodes());
                    offlineConsistentIds = ' ' + F.nodeConsistentIds(offlineNodes).toString();
                }
                if (bltOffline == 0) {
                    if (evtType == 10 && discoCache.baselineNode(evtNode)) {
                        clo.apply("  ^-- All baseline nodes are online, will start auto-activation");
                    }
                } else {
                    clo.apply("  ^-- " + bltOffline + " nodes left for auto-activation" + offlineConsistentIds);
                }
            }
        }
    }

    @Override
    public void onKernalStop0(boolean cancel) {
        this.startLatch.countDown();
        if (this.segChkWrk != null) {
            this.segChkWrk.cancel();
            U.join(this.segChkThread, this.log);
        }
        if (!this.locJoin.isDone()) {
            this.locJoin.onDone(new NodeStoppingException("Failed to wait for local node joined event (grid is stopping)."));
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.busyLock.block();
        ((DiscoverySpi)this.getSpi()).setListener(null);
        U.cancel(this.discoWrk);
        U.join(this.discoWrk, this.log);
        U.cancel(this.discoNtfWrk);
        U.join(this.discoNtfWrk, this.log);
        this.stopSpi();
        if (!this.registeredDiscoSpi) {
            ((DiscoverySpi)this.getSpi()).spiStop();
        }
        this.registeredDiscoSpi = false;
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    public boolean aliveAll(@Nullable Collection<UUID> nodeIds) {
        if (nodeIds == null || nodeIds.isEmpty()) {
            return false;
        }
        for (UUID id : nodeIds) {
            if (this.alive(id)) continue;
            return false;
        }
        return true;
    }

    public boolean alive(UUID nodeId) {
        return this.getAlive(nodeId) != null;
    }

    @Nullable
    public ClusterNode getAlive(UUID nodeId) {
        assert (nodeId != null);
        return ((DiscoverySpi)this.getSpi()).getNode(nodeId);
    }

    public boolean alive(ClusterNode node) {
        assert (node != null);
        return this.alive(node.id());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pingNode(UUID nodeId) throws IgniteClientDisconnectedCheckedException {
        assert (nodeId != null);
        if (!this.busyLock.enterBusy()) {
            return false;
        }
        try {
            boolean bl = ((DiscoverySpi)this.getSpi()).pingNode(nodeId);
            return bl;
        }
        catch (IgniteException e) {
            if (e.hasCause(IgniteClientDisconnectedCheckedException.class, IgniteClientDisconnectedException.class)) {
                IgniteFuture<?> reconnectFut = this.ctx.cluster().clientReconnectFuture();
                throw new IgniteClientDisconnectedCheckedException(reconnectFut, e.getMessage());
            }
            LT.warn(this.log, "Ping failed with error [node=" + nodeId + ", err=" + e + ']');
            boolean bl = true;
            return bl;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pingNodeNoError(UUID nodeId) {
        assert (nodeId != null);
        if (!this.busyLock.enterBusy()) {
            return false;
        }
        try {
            boolean bl = ((DiscoverySpi)this.getSpi()).pingNode(nodeId);
            return bl;
        }
        catch (IgniteException ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Nullable
    public ClusterNode node(UUID nodeId) {
        assert (nodeId != null);
        return this.discoCache().node(nodeId);
    }

    public Collection<ClusterNode> nodes(@Nullable Collection<UUID> ids, IgnitePredicate<UUID> ... p) {
        return F.isEmpty(ids) ? Collections.emptyList() : F.view(F.viewReadOnly(ids, U.id2Node(this.ctx), p), F.notNull());
    }

    public IgniteInternalFuture<Long> topologyFuture(long awaitVer) {
        long topVer = this.topologyVersion();
        if (topVer >= awaitVer) {
            return new GridFinishedFuture<Long>(topVer);
        }
        DiscoTopologyFuture fut = new DiscoTopologyFuture(this.ctx, awaitVer);
        fut.init();
        return fut;
    }

    public DiscoCache discoCache() {
        Snapshot cur = this.topSnap.get();
        assert (cur != null);
        return cur.discoCache;
    }

    public DiscoCache discoCache(AffinityTopologyVersion topVer) {
        return (DiscoCache)this.discoCacheHist.get(topVer);
    }

    public Collection<ClusterNode> remoteNodes() {
        return this.discoCache().remoteNodes();
    }

    public Collection<ClusterNode> allNodes() {
        return this.discoCache().allNodes();
    }

    public Collection<ClusterNode> aliveServerNodes() {
        return this.discoCache().aliveServerNodes();
    }

    public int size() {
        return this.discoCache().allNodes().size();
    }

    public Collection<ClusterNode> nodes(long topVer) {
        return this.nodes(new AffinityTopologyVersion(topVer));
    }

    public Collection<ClusterNode> nodes(AffinityTopologyVersion topVer) {
        return this.resolveDiscoCache(CU.cacheId(null), topVer).allNodes();
    }

    public List<ClusterNode> serverNodes(AffinityTopologyVersion topVer) {
        return this.resolveDiscoCache(CU.cacheId(null), topVer).serverNodes();
    }

    @Nullable
    public List<? extends BaselineNode> baselineNodes(AffinityTopologyVersion topVer) {
        return this.resolveDiscoCache(CU.cacheId(null), topVer).baselineNodes();
    }

    public ClusterNode node(AffinityTopologyVersion topVer, UUID id) {
        return this.resolveDiscoCache(CU.cacheId(null), topVer).node(id);
    }

    public Map<UUID, Short> consistentId(AffinityTopologyVersion topVer) {
        return this.resolveDiscoCache(CU.cacheId(null), topVer).consistentIdMap();
    }

    public Map<Short, UUID> nodeIdMap(AffinityTopologyVersion topVer) {
        return this.resolveDiscoCache(CU.cacheId(null), topVer).nodeIdMap();
    }

    public List<ClusterNode> cacheNodes(@Nullable String cacheName, AffinityTopologyVersion topVer) {
        return this.resolveDiscoCache(CU.cacheId(cacheName), topVer).cacheNodes(cacheName);
    }

    public Collection<ClusterNode> remoteAliveNodesWithCaches(AffinityTopologyVersion topVer) {
        return this.resolveDiscoCache(CU.cacheId(null), topVer).remoteAliveNodesWithCaches();
    }

    @Nullable
    public ClusterNode oldestAliveServerNode(AffinityTopologyVersion topVer) {
        return this.resolveDiscoCache(CU.cacheId(null), topVer).oldestAliveServerNode();
    }

    public Collection<ClusterNode> cacheGroupAffinityNodes(int grpId, AffinityTopologyVersion topVer) {
        return this.resolveDiscoCache(grpId, topVer).cacheGroupAffinityNodes(grpId);
    }

    public boolean cacheAffinityNode(ClusterNode node, String cacheName) {
        CachePredicate pred = (CachePredicate)this.registeredCaches.get(cacheName);
        return pred != null && pred.dataNode(node);
    }

    public boolean cacheGroupAffinityNode(ClusterNode node, int grpId) {
        CacheGroupAffinity aff = this.registeredCacheGrps.get(grpId);
        if (aff == null) {
            this.log.warning("Registered cache group not found for groupId=" + grpId + ". Group was destroyed.");
            return false;
        }
        return CU.affinityNode(node, aff.cacheFilter);
    }

    public boolean cacheNearNode(ClusterNode node, String cacheName) {
        CachePredicate pred = (CachePredicate)this.registeredCaches.get(cacheName);
        return pred != null && pred.nearNode(node);
    }

    public boolean cacheClientNode(ClusterNode node, String cacheName) {
        CachePredicate pred = (CachePredicate)this.registeredCaches.get(cacheName);
        return pred != null && pred.clientNode(node);
    }

    public boolean cacheNode(ClusterNode node, String cacheName) {
        CachePredicate pred = (CachePredicate)this.registeredCaches.get(cacheName);
        return pred != null && pred.cacheNode(node);
    }

    public Map<String, CacheConfiguration> nodePublicCaches(ClusterNode node) {
        HashMap<String, CacheConfiguration> caches = U.newHashMap(this.registeredCaches.size());
        for (DynamicCacheDescriptor cacheDesc : this.ctx.cache().cacheDescriptors().values()) {
            CachePredicate p;
            if (!cacheDesc.cacheType().userCache() || (p = (CachePredicate)this.registeredCaches.get(cacheDesc.cacheName())) == null || !p.cacheNode(node)) continue;
            caches.put(cacheDesc.cacheName(), cacheDesc.cacheConfiguration());
        }
        return caches;
    }

    private DiscoCache resolveDiscoCache(int grpId, AffinityTopologyVersion topVer) {
        DiscoCache cache;
        Snapshot snap = this.topSnap.get();
        DiscoCache discoCache = cache = AffinityTopologyVersion.NONE.equals(topVer) || topVer.equals(snap.topVer) ? snap.discoCache : (DiscoCache)this.discoCacheHist.get(topVer);
        if (cache == null) {
            AffinityTopologyVersion lastAffChangedTopVer = this.ctx.cache().context().exchange().lastAffinityChangedTopologyVersion(topVer);
            if (!lastAffChangedTopVer.equals(topVer)) {
                assert (lastAffChangedTopVer.compareTo(topVer) < 0);
                for (Map.Entry e : this.discoCacheHist.descendingEntrySet()) {
                    if (((AffinityTopologyVersion)e.getKey()).isBetween(lastAffChangedTopVer, topVer)) {
                        return (DiscoCache)e.getValue();
                    }
                    if (((AffinityTopologyVersion)e.getKey()).compareTo(lastAffChangedTopVer) >= 0) continue;
                    break;
                }
            }
            CacheGroupDescriptor desc = this.ctx.cache().cacheGroupDescriptors().get(grpId);
            throw new IgniteException("Failed to resolve nodes topology [cacheGrp=" + (desc != null ? desc.cacheOrGroupName() : "N/A") + ", topVer=" + topVer + ", history=" + this.discoCacheHist.keySet() + ", snap=" + snap + ", locNode=" + this.ctx.discovery().localNode() + ']');
        }
        return cache;
    }

    @Nullable
    public Collection<ClusterNode> topology(long topVer) {
        DiscoCache cache;
        if (!this.histSupported) {
            throw new UnsupportedOperationException("Current discovery SPI does not support topology snapshots history (consider using TCP discovery SPI).");
        }
        Map<Long, Collection<ClusterNode>> snapshots = this.topHist;
        Collection<ClusterNode> nodes = snapshots.get(topVer);
        if (nodes == null && (cache = (DiscoCache)this.discoCacheHist.get(new AffinityTopologyVersion(topVer, 0))) != null) {
            nodes = cache.allNodes();
        }
        return nodes;
    }

    public Collection<ClusterNode> serverTopologyNodes(long topVer) {
        return F.view(this.topology(topVer), F.not(FILTER_CLI), FILTER_NOT_DAEMON);
    }

    public Collection<ClusterNode> daemonNodes() {
        return this.discoCache().daemonNodes();
    }

    public ClusterNode localNode() {
        return this.locNode == null ? ((DiscoverySpi)this.getSpi()).getLocalNode() : this.locNode;
    }

    @Deprecated
    public Serializable consistentId() {
        if (this.consistentId == null) {
            this.consistentId = this.getInjectedDiscoverySpi().consistentId();
        }
        return this.consistentId;
    }

    public DiscoverySpi getInjectedDiscoverySpi() {
        try {
            this.inject();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to init consistent ID.", e);
        }
        return (DiscoverySpi)this.getSpi();
    }

    public void consistentId(Serializable consistentId) {
        this.consistentId = consistentId;
    }

    public long topologyVersion() {
        return this.topSnap.get().topVer.topologyVersion();
    }

    public AffinityTopologyVersion topologyVersionEx() {
        return this.topSnap.get().topVer;
    }

    public DiscoveryEvent localJoinEvent() {
        try {
            return this.locJoin.get().event();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    public DiscoveryLocalJoinData localJoin() {
        try {
            return this.locJoin.get();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    public GridFutureAdapter<DiscoveryLocalJoinData> localJoinFuture() {
        return this.locJoin;
    }

    public void sendCustomEvent(DiscoveryCustomMessage msg) throws IgniteCheckedException {
        try {
            ((DiscoverySpi)this.getSpi()).sendCustomEvent(new CustomMessageWrapper(msg));
        }
        catch (IgniteClientDisconnectedException e) {
            IgniteFuture<?> reconnectFut = this.ctx.cluster().clientReconnectFuture();
            throw new IgniteClientDisconnectedCheckedException(reconnectFut, e.getMessage());
        }
        catch (IgniteException e) {
            throw new IgniteCheckedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientCacheStartEvent(UUID reqId, @Nullable Map<String, DynamicCacheChangeRequest> startReqs, @Nullable Set<String> cachesToClose) {
        Object object = this.discoEvtMux;
        synchronized (object) {
            this.discoWrk.addEvent(new NotificationEvent(18, AffinityTopologyVersion.NONE, this.localNode(), null, Collections.emptyList(), new ClientCacheChangeDummyDiscoveryMessage(reqId, startReqs, cachesToClose), null));
        }
    }

    public void metricsUpdateEvent(DiscoCache discoCache, ClusterNode node) {
        this.discoWrk.addEvent(new NotificationEvent(13, discoCache.version(), node, discoCache, discoCache.nodeMap.values(), null, null));
    }

    public long gridStartTime() {
        return ((DiscoverySpi)this.getSpi()).getGridStartTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryFailNode(UUID nodeId, @Nullable String warning) {
        if (!this.busyLock.enterBusy()) {
            return false;
        }
        try {
            if (!((DiscoverySpi)this.getSpi()).pingNode(nodeId)) {
                ((DiscoverySpi)this.getSpi()).failNode(nodeId, warning);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public void failNode(UUID nodeId, @Nullable String warning) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            ((DiscoverySpi)this.getSpi()).failNode(nodeId, warning);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public boolean reconnectSupported() {
        DiscoverySpi spi = (DiscoverySpi)this.getSpi();
        ClusterNode clusterNode = this.ctx.discovery().localNode();
        boolean client = clusterNode instanceof TcpDiscoveryNode ? ((TcpDiscoveryNode)clusterNode).clientRouterNodeId() != null : clusterNode.isClient();
        return client && spi instanceof IgniteDiscoverySpi && ((IgniteDiscoverySpi)spi).clientReconnectSupported();
    }

    public void reconnect() {
        assert (this.reconnectSupported());
        DiscoverySpi discoverySpi = (DiscoverySpi)this.getSpi();
        ((IgniteDiscoverySpi)discoverySpi).clientReconnect();
    }

    @NotNull
    private DiscoCache createDiscoCache(AffinityTopologyVersion topVer, DiscoveryDataClusterState state, ClusterNode loc, Collection<ClusterNode> topSnapshot) {
        ArrayList<ClusterNode> baselineNodes;
        HashMap<Short, UUID> consIdxToNodeId;
        HashMap<UUID, Short> nodeIdToConsIdx;
        assert (topSnapshot.contains(loc));
        HashSet<UUID> alives = U.newHashSet(topSnapshot.size());
        HashMap<UUID, ClusterNode> nodeMap = U.newHashMap(topSnapshot.size());
        ArrayList<ClusterNode> daemonNodes = new ArrayList<ClusterNode>(topSnapshot.size());
        ArrayList<ClusterNode> srvNodes = new ArrayList<ClusterNode>(topSnapshot.size());
        ArrayList<ClusterNode> rmtNodes = new ArrayList<ClusterNode>(topSnapshot.size());
        ArrayList<ClusterNode> allNodes = new ArrayList<ClusterNode>(topSnapshot.size());
        IgniteProductVersion minVer = null;
        IgniteProductVersion minSrvVer = null;
        for (ClusterNode node : topSnapshot) {
            if (this.alive(node)) {
                alives.add(node.id());
            }
            if (node.isDaemon()) {
                daemonNodes.add(node);
            } else {
                allNodes.add(node);
                if (!node.isLocal()) {
                    rmtNodes.add(node);
                }
                if (!node.isClient()) {
                    srvNodes.add(node);
                    if (minSrvVer == null) {
                        minSrvVer = node.version();
                    } else if (node.version().compareTo(minSrvVer) < 0) {
                        minSrvVer = node.version();
                    }
                }
            }
            nodeMap.put(node.id(), node);
            if (minVer == null) {
                minVer = node.version();
                continue;
            }
            if (node.version().compareTo(minVer) >= 0) continue;
            minVer = node.version();
        }
        assert (!rmtNodes.contains(loc)) : "Remote nodes collection shouldn't contain local node [rmtNodes=" + rmtNodes + ", loc=" + loc + ']';
        BaselineTopology blt = state.baselineTopology();
        if (blt != null) {
            nodeIdToConsIdx = U.newHashMap(srvNodes.size());
            consIdxToNodeId = U.newHashMap(srvNodes.size());
            Map<Object, Short> m = blt.consistentIdMapping();
            HashMap<Object, ClusterNode> aliveNodesByConsId = U.newHashMap(srvNodes.size());
            for (ClusterNode node : srvNodes) {
                Short compactedId = m.get(node.consistentId());
                if (compactedId != null) {
                    nodeIdToConsIdx.put(node.id(), compactedId);
                    consIdxToNodeId.put(compactedId, node.id());
                }
                aliveNodesByConsId.put(node.consistentId(), node);
            }
            ArrayList<ClusterNode> baselineNodes0 = new ArrayList<ClusterNode>(blt.size());
            for (Object consId : blt.consistentIds()) {
                ClusterNode srvNode = (ClusterNode)aliveNodesByConsId.get(consId);
                if (srvNode != null) {
                    baselineNodes0.add(srvNode);
                    continue;
                }
                baselineNodes0.add(blt.baselineNode(consId));
            }
            baselineNodes = baselineNodes0;
        } else {
            nodeIdToConsIdx = null;
            consIdxToNodeId = null;
            baselineNodes = null;
        }
        HashMap<Integer, List<ClusterNode>> allCacheNodes = U.newHashMap(allNodes.size());
        HashMap<Integer, List<ClusterNode>> cacheGrpAffNodes = U.newHashMap(allNodes.size());
        TreeSet<ClusterNode> rmtNodesWithCaches = new TreeSet<ClusterNode>(NodeOrderComparator.getInstance());
        this.fillAffinityNodeCaches(allNodes, allCacheNodes, cacheGrpAffNodes, rmtNodesWithCaches, nodeIdToConsIdx == null ? null : nodeIdToConsIdx.keySet());
        return new DiscoCache(topVer, state, loc, Collections.unmodifiableList(rmtNodes), Collections.unmodifiableList(allNodes), Collections.unmodifiableList(srvNodes), Collections.unmodifiableList(daemonNodes), U.sealList(rmtNodesWithCaches), baselineNodes == null ? null : Collections.unmodifiableList(baselineNodes), Collections.unmodifiableMap(allCacheNodes), Collections.unmodifiableMap(cacheGrpAffNodes), Collections.unmodifiableMap(nodeMap), alives, nodeIdToConsIdx == null ? null : Collections.unmodifiableMap(nodeIdToConsIdx), consIdxToNodeId == null ? null : Collections.unmodifiableMap(consIdxToNodeId), minVer, minSrvVer);
    }

    private void addToMap(Map<Integer, List<ClusterNode>> cacheMap, String cacheName, ClusterNode node) {
        List<ClusterNode> cacheNodes = cacheMap.get(CU.cacheId(cacheName));
        if (cacheNodes == null) {
            cacheNodes = new ArrayList<ClusterNode>();
            cacheMap.put(CU.cacheId(cacheName), cacheNodes);
        }
        cacheNodes.add(node);
    }

    public static void initCommunicationErrorResolveConfiguration(IgniteConfiguration cfg) throws IgniteCheckedException {
        CommunicationFailureResolver rslvr = cfg.getCommunicationFailureResolver();
        CommunicationSpi commSpi = cfg.getCommunicationSpi();
        DiscoverySpi discoverySpi = cfg.getDiscoverySpi();
        if (rslvr != null) {
            if (!GridDiscoveryManager.supportsCommunicationErrorResolve(commSpi)) {
                throw new IgniteCheckedException("CommunicationFailureResolver is configured, but CommunicationSpi does not support communicationproblem resolve: " + commSpi.getClass().getName());
            }
            if (!GridDiscoveryManager.supportsCommunicationErrorResolve(discoverySpi)) {
                throw new IgniteCheckedException("CommunicationFailureResolver is configured, but DiscoverySpi does not support communicationproblem resolve: " + discoverySpi.getClass().getName());
            }
        } else if (GridDiscoveryManager.supportsCommunicationErrorResolve(commSpi) && GridDiscoveryManager.supportsCommunicationErrorResolve(discoverySpi)) {
            cfg.setCommunicationFailureResolver(new DefaultCommunicationFailureResolver());
        }
    }

    private static boolean supportsCommunicationErrorResolve(DiscoverySpi spi) {
        return spi instanceof IgniteDiscoverySpi && ((IgniteDiscoverySpi)spi).supportsCommunicationFailureResolve();
    }

    private static boolean supportsCommunicationErrorResolve(CommunicationSpi spi) {
        return spi instanceof TcpCommunicationSpi;
    }

    public boolean communicationErrorResolveSupported() {
        return this.ctx.config().getCommunicationFailureResolver() != null;
    }

    public boolean mutableCustomMessages() {
        DiscoverySpiMutableCustomMessageSupport ann = U.getAnnotation(this.ctx.config().getDiscoverySpi().getClass(), DiscoverySpiMutableCustomMessageSupport.class);
        return ann != null && ann.value();
    }

    public void resolveCommunicationError(ClusterNode node, Exception err) {
        DiscoverySpi spi = (DiscoverySpi)this.getSpi();
        if (!GridDiscoveryManager.supportsCommunicationErrorResolve(spi) || !GridDiscoveryManager.supportsCommunicationErrorResolve(this.ctx.config().getCommunicationSpi())) {
            throw new UnsupportedOperationException();
        }
        ((IgniteDiscoverySpi)spi).resolveCommunicationFailure(node, err);
    }

    public ClusterNode historicalNode(UUID nodeId) {
        for (DiscoCache discoCache : this.discoCacheHist.descendingValues()) {
            ClusterNode node = discoCache.node(nodeId);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private void fillAffinityNodeCaches(List<ClusterNode> allNodes, Map<Integer, List<ClusterNode>> allCacheNodes, Map<Integer, List<ClusterNode>> cacheGrpAffNodes, Set<ClusterNode> rmtNodesWithCaches, Set<UUID> bltNodes) {
        for (ClusterNode node : allNodes) {
            assert (node.order() != 0L) : "Invalid node order [locNode=" + this.localNode() + ", node=" + node + ']';
            assert (!node.isDaemon());
            for (Map.Entry<Integer, CacheGroupAffinity> entry : this.registeredCacheGrps.entrySet()) {
                CacheGroupAffinity grpAff = entry.getValue();
                Integer grpId = entry.getKey();
                if (!CU.affinityNode(node, grpAff.cacheFilter) || grpAff.persistentCacheGrp && bltNodes != null && !bltNodes.contains(node.id())) continue;
                List<ClusterNode> nodes = cacheGrpAffNodes.get(grpId);
                if (nodes == null) {
                    nodes = new ArrayList<ClusterNode>();
                    cacheGrpAffNodes.put(grpId, nodes);
                }
                nodes.add(node);
            }
            for (Map.Entry<Integer, CacheGroupAffinity> entry : this.registeredCaches.entrySet()) {
                String cacheName = (String)((Object)entry.getKey());
                CachePredicate filter = (CachePredicate)((Object)entry.getValue());
                if (!filter.cacheNode(node)) continue;
                if (!node.isLocal()) {
                    rmtNodesWithCaches.add(node);
                }
                this.addToMap(allCacheNodes, cacheName, node);
            }
        }
    }

    public DiscoCache createDiscoCacheOnCacheChange(AffinityTopologyVersion topVer, DiscoCache discoCache) {
        List<ClusterNode> allNodes = discoCache.allNodes();
        HashMap<Integer, List<ClusterNode>> allCacheNodes = U.newHashMap(allNodes.size());
        HashMap<Integer, List<ClusterNode>> cacheGrpAffNodes = U.newHashMap(allNodes.size());
        TreeSet<ClusterNode> rmtNodesWithCaches = new TreeSet<ClusterNode>(NodeOrderComparator.getInstance());
        Map<UUID, Short> nodeIdToConsIdx = discoCache.nodeIdToConsIdx;
        this.fillAffinityNodeCaches(allNodes, allCacheNodes, cacheGrpAffNodes, rmtNodesWithCaches, nodeIdToConsIdx == null ? null : nodeIdToConsIdx.keySet());
        return new DiscoCache(topVer, discoCache.state(), discoCache.localNode(), discoCache.remoteNodes(), allNodes, discoCache.serverNodes(), discoCache.daemonNodes(), U.sealList(rmtNodesWithCaches), discoCache.baselineNodes(), allCacheNodes, cacheGrpAffNodes, discoCache.nodeMap, discoCache.alives, nodeIdToConsIdx, discoCache.consIdxToNodeId, discoCache.minimumNodeVersion(), discoCache.minimumServerNodeVersion());
    }

    private class CachePredicate {
        private final int cacheId;
        private final CacheGroupAffinity aff;
        private final boolean nearEnabled;
        private final ConcurrentHashMap<UUID, Boolean> clientNodes;

        private CachePredicate(int cacheId, CacheGroupAffinity aff, boolean nearEnabled) {
            assert (aff != null);
            this.cacheId = cacheId;
            this.aff = aff;
            this.nearEnabled = nearEnabled;
            this.clientNodes = new ConcurrentHashMap();
        }

        boolean addClientNode(UUID nodeId, boolean nearEnabled) {
            assert (nodeId != null);
            Boolean old = this.clientNodes.putIfAbsent(nodeId, nearEnabled);
            return old == null;
        }

        public boolean onNodeLeft(UUID leftNodeId) {
            assert (leftNodeId != null);
            Boolean old = this.clientNodes.remove(leftNodeId);
            return old != null;
        }

        public boolean dataNode(ClusterNode node) {
            return CU.affinityNode(node, this.aff.cacheFilter);
        }

        boolean cacheNode(ClusterNode node) {
            return !node.isDaemon() && (CU.affinityNode(node, this.aff.cacheFilter) || this.cacheClientNode(node) != null);
        }

        boolean nearNode(ClusterNode node) {
            if (CU.affinityNode(node, this.aff.cacheFilter)) {
                return this.nearEnabled;
            }
            Boolean near = this.cacheClientNode(node);
            return near != null && near != false;
        }

        public boolean clientNode(ClusterNode node) {
            if (node.isDaemon()) {
                return false;
            }
            Boolean near = this.cacheClientNode(node);
            return near != null && near == false;
        }

        private Boolean cacheClientNode(ClusterNode node) {
            if (GridDiscoveryManager.this.ctx.localNodeId().equals(node.id())) {
                GridCacheContext cctx = GridDiscoveryManager.this.ctx.cache().context().cacheContext(this.cacheId);
                return cctx != null ? Boolean.valueOf(CU.isNearEnabled(cctx)) : null;
            }
            return this.clientNodes.get(node.id());
        }
    }

    private static class CacheGroupAffinity {
        private final String name;
        private final IgnitePredicate<ClusterNode> cacheFilter;
        private final CacheMode cacheMode;
        private final boolean persistentCacheGrp;

        CacheGroupAffinity(String name, IgnitePredicate<ClusterNode> cacheFilter, CacheMode cacheMode, boolean persistentCacheGrp) {
            this.name = name;
            this.cacheFilter = cacheFilter;
            this.cacheMode = cacheMode;
            this.persistentCacheGrp = persistentCacheGrp;
        }

        public String toString() {
            return S.toString(CacheGroupAffinity.class, this);
        }
    }

    private static class Snapshot {
        private final AffinityTopologyVersion topVer;
        @GridToStringExclude
        private final DiscoCache discoCache;

        private Snapshot(AffinityTopologyVersion topVer, DiscoCache discoCache) {
            this.topVer = topVer;
            this.discoCache = discoCache;
        }

        public String toString() {
            return S.toString(Snapshot.class, this);
        }
    }

    private static class DiscoTopologyFuture
    extends GridFutureAdapter<Long>
    implements GridLocalEventListener {
        private GridKernalContext ctx;
        private long awaitVer;

        private DiscoTopologyFuture(GridKernalContext ctx, long awaitVer) {
            this.ctx = ctx;
            this.awaitVer = awaitVer;
        }

        private void init() {
            this.ctx.event().addLocalEventListener(this, 10, 11, 12);
            long topVer = this.ctx.discovery().topologyVersion();
            if (topVer >= this.awaitVer) {
                this.onDone(topVer);
            }
        }

        @Override
        public boolean onDone(@Nullable Long res, @Nullable Throwable err) {
            if (super.onDone(res, err)) {
                this.ctx.event().removeLocalEventListener(this, 10, 11, 12);
                return true;
            }
            return false;
        }

        @Override
        public void onEvent(Event evt) {
            assert (evt.type() == 10 || evt.type() == 11 || evt.type() == 12);
            DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
            if (discoEvt.topologyVersion() >= this.awaitVer) {
                this.onDone(discoEvt.topologyVersion());
            }
        }
    }

    private class DiscoveryWorker
    extends GridWorker {
        private DiscoCache discoCache;
        private final BlockingQueue<NotificationEvent> evts;
        private final RestartProcessFailureHandler restartProcHnd;
        private final StopNodeFailureHandler stopNodeHnd;
        private boolean nodeSegFired;
        private volatile GridFutureAdapter disconnectEvtFut;

        private DiscoveryWorker() {
            super(GridDiscoveryManager.this.ctx.igniteInstanceName(), "disco-event-worker", GridDiscoveryManager.this.log, GridDiscoveryManager.this.ctx.workersRegistry());
            this.evts = new LinkedBlockingQueue<NotificationEvent>();
            this.restartProcHnd = new RestartProcessFailureHandler();
            this.stopNodeHnd = new StopNodeFailureHandler();
        }

        private void recordEvent(int type, long topVer, ClusterNode node, DiscoCache discoCache, Collection<ClusterNode> topSnapshot, @Nullable SpanContainer spanContainer) {
            assert (node != null);
            if (GridDiscoveryManager.this.ctx.event().isRecordable(type)) {
                DiscoveryEvent evt = new DiscoveryEvent();
                evt.node(GridDiscoveryManager.this.ctx.discovery().localNode());
                evt.eventNode(node);
                evt.type(type);
                evt.topologySnapshot(topVer, U.arrayList(topSnapshot, FILTER_NOT_DAEMON));
                evt.span(spanContainer != null ? spanContainer.span() : null);
                if (type == 13) {
                    evt.message("Metrics were updated");
                } else if (type == 10) {
                    evt.message("Node joined");
                } else if (type == 11) {
                    evt.message("Node left");
                } else if (type == 12) {
                    evt.message("Node failed");
                } else if (type == 14) {
                    evt.message("Node segmented");
                } else if (type == 16) {
                    evt.message("Client node disconnected");
                } else if (type == 17) {
                    evt.message("Client node reconnected");
                } else assert (false) : "Unexpected discovery message type: " + type;
                GridDiscoveryManager.this.ctx.event().record(evt, discoCache);
            }
        }

        void addEvent(NotificationEvent notificationEvt) {
            assert (notificationEvt.node != null) : notificationEvt.data;
            if (notificationEvt.type == 16) {
                ((GridDiscoveryManager)GridDiscoveryManager.this).discoWrk.disconnectEvtFut = new GridFutureAdapter();
            }
            this.evts.add(notificationEvt);
        }

        @Override
        protected void body() throws InterruptedException {
            while (!this.isCancelled()) {
                try {
                    this.body0();
                    this.onIdle();
                }
                catch (InterruptedException e) {
                    if (!this.isCancelled) {
                        GridDiscoveryManager.this.ctx.failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, e));
                    }
                    throw e;
                }
                catch (Throwable t) {
                    U.error(this.log, "Exception in discovery event worker thread.", t);
                    FailureType type = t instanceof OutOfMemoryError ? FailureType.CRITICAL_ERROR : FailureType.SYSTEM_WORKER_TERMINATION;
                    GridDiscoveryManager.this.ctx.failure().process(new FailureContext(type, t));
                    throw t;
                }
            }
        }

        private void body0() throws InterruptedException {
            NotificationEvent evt;
            this.blockingSectionBegin();
            try {
                evt = this.evts.take();
            }
            finally {
                this.blockingSectionEnd();
            }
            int type = evt.type;
            AffinityTopologyVersion topVer = evt.topVer;
            if (type == 13 && (this.discoCache == null || topVer.compareTo(this.discoCache.version()) < 0)) {
                return;
            }
            ClusterNode node = evt.node;
            boolean isDaemon = node.isDaemon();
            boolean segmented = false;
            if (evt.discoCache != null) {
                this.discoCache = evt.discoCache;
            }
            switch (type) {
                case 10: {
                    assert (!GridDiscoveryManager.this.discoOrdered || topVer.topologyVersion() == node.order()) : "Invalid topology version [topVer=" + topVer + ", node=" + node + ']';
                    try {
                        GridDiscoveryManager.this.checkAttributes(F.asList(node));
                    }
                    catch (IgniteCheckedException e) {
                        U.warn(this.log, e.getMessage());
                    }
                    if (!isDaemon) {
                        if (!GridDiscoveryManager.this.isLocDaemon) {
                            if (this.log.isInfoEnabled()) {
                                this.log.info("Added new node to topology: " + node);
                            }
                            GridDiscoveryManager.this.ackTopology(topVer.topologyVersion(), type, node, true);
                            break;
                        }
                        if (!this.log.isDebugEnabled()) break;
                        this.log.debug("Added new node to topology: " + node);
                        break;
                    }
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Added new daemon node to topology: " + node);
                    break;
                }
                case 11: {
                    if (GridDiscoveryManager.this.hasRslvrs) {
                        GridDiscoveryManager.this.segChkWrk.scheduleSegmentCheck();
                    }
                    if (!isDaemon) {
                        if (!GridDiscoveryManager.this.isLocDaemon) {
                            if (this.log.isInfoEnabled()) {
                                this.log.info("Node left topology: " + node);
                            }
                            GridDiscoveryManager.this.ackTopology(topVer.topologyVersion(), type, node, true);
                            break;
                        }
                        if (!this.log.isDebugEnabled()) break;
                        this.log.debug("Node left topology: " + node);
                        break;
                    }
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Daemon node left topology: " + node);
                    break;
                }
                case 16: {
                    this.disconnectEvtFut.onDone();
                    break;
                }
                case 17: {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Client node reconnected to topology: " + node);
                    }
                    if (GridDiscoveryManager.this.isLocDaemon) break;
                    GridDiscoveryManager.this.ackTopology(topVer.topologyVersion(), type, node, true);
                    break;
                }
                case 12: {
                    if (GridDiscoveryManager.this.hasRslvrs) {
                        GridDiscoveryManager.this.segChkWrk.scheduleSegmentCheck();
                    }
                    if (!isDaemon) {
                        if (!GridDiscoveryManager.this.isLocDaemon) {
                            U.warn(this.log, "Node FAILED: " + node);
                            GridDiscoveryManager.this.ackTopology(topVer.topologyVersion(), type, node, true);
                            break;
                        }
                        if (!this.log.isDebugEnabled()) break;
                        this.log.debug("Node FAILED: " + node);
                        break;
                    }
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Daemon node FAILED: " + node);
                    break;
                }
                case 14: {
                    assert (F.eqNodes(GridDiscoveryManager.this.localNode(), node));
                    if (this.nodeSegFired) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Ignored node segmented event [type=EVT_NODE_SEGMENTED, node=" + node + ']');
                        }
                        return;
                    }
                    this.nodeSegFired = true;
                    GridDiscoveryManager.this.lastLoggedTop.set(0L);
                    segmented = true;
                    if (!GridDiscoveryManager.this.isLocDaemon) {
                        U.warn(this.log, "Local node SEGMENTED: " + node);
                        break;
                    }
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Local node SEGMENTED: " + node);
                    break;
                }
                case 18: {
                    if (GridDiscoveryManager.this.ctx.event().isRecordable(18)) {
                        DiscoveryCustomEvent customEvt = new DiscoveryCustomEvent();
                        customEvt.node(GridDiscoveryManager.this.ctx.discovery().localNode());
                        customEvt.eventNode(node);
                        customEvt.type(type);
                        customEvt.topologySnapshot(topVer.topologyVersion(), evt.topSnapshot);
                        customEvt.affinityTopologyVersion(topVer);
                        customEvt.customMessage(evt.data);
                        customEvt.span(evt.spanContainer != null ? evt.spanContainer.span() : null);
                        if (evt.discoCache == null) {
                            assert (this.discoCache != null) : evt.data;
                            evt.discoCache = this.discoCache;
                        }
                        GridDiscoveryManager.this.ctx.event().record(customEvt, evt.discoCache);
                    }
                    return;
                }
                case 13: {
                    break;
                }
                default: {
                    assert (false) : "Invalid discovery event: " + type;
                    break;
                }
            }
            this.recordEvent(type, topVer.topologyVersion(), node, evt.discoCache, evt.topSnapshot, evt.spanContainer);
            if (segmented) {
                this.onSegmentation();
            }
        }

        private void onSegmentation() {
            SegmentationPolicy segPlc = GridDiscoveryManager.this.ctx.config().getSegmentationPolicy();
            try {
                ((DiscoverySpi)GridDiscoveryManager.this.getSpi()).disconnect();
            }
            catch (IgniteSpiException e) {
                U.error(this.log, "Failed to disconnect discovery SPI.", e);
            }
            switch (segPlc) {
                case RESTART_JVM: {
                    GridDiscoveryManager.this.ctx.failure().process(new FailureContext(FailureType.SEGMENTATION, null), this.restartProcHnd);
                    break;
                }
                case STOP: {
                    GridDiscoveryManager.this.ctx.failure().process(new FailureContext(FailureType.SEGMENTATION, null), this.stopNodeHnd);
                    break;
                }
                default: {
                    assert (segPlc == SegmentationPolicy.NOOP) : "Unsupported segmentation policy value: " + (Object)((Object)segPlc);
                    break;
                }
            }
        }

        private void awaitDisconnectEvent() {
            try {
                this.disconnectEvtFut.get();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to wait for handling disconnect event.", e);
            }
        }

        @Override
        public String toString() {
            return S.toString(DiscoveryWorker.class, this);
        }
    }

    private static class NotificationEvent {
        int type;
        AffinityTopologyVersion topVer;
        ClusterNode node;
        DiscoCache discoCache;
        Collection<ClusterNode> topSnapshot;
        @Nullable
        DiscoveryCustomMessage data;
        SpanContainer spanContainer;

        public NotificationEvent(int type, AffinityTopologyVersion topVer, ClusterNode node, DiscoCache discoCache, Collection<ClusterNode> topSnapshot, @Nullable DiscoveryCustomMessage data, SpanContainer spanContainer) {
            this.type = type;
            this.topVer = topVer;
            this.node = node;
            this.discoCache = discoCache;
            this.topSnapshot = topSnapshot;
            this.data = data;
            this.spanContainer = spanContainer;
        }
    }

    private class DiscoveryMessageNotifierWorker
    extends GridWorker {
        private final BlockingQueue<T2<GridFutureAdapter, Runnable>> queue;

        protected DiscoveryMessageNotifierWorker() {
            super(GridDiscoveryManager.this.ctx.igniteInstanceName(), "disco-notifier-worker", GridDiscoveryManager.this.log, GridDiscoveryManager.this.ctx.workersRegistry());
            this.queue = new LinkedBlockingQueue<T2<GridFutureAdapter, Runnable>>();
        }

        private void body0() throws InterruptedException {
            T2<GridFutureAdapter, Runnable> notification;
            this.blockingSectionBegin();
            try {
                notification = this.queue.take();
            }
            finally {
                this.blockingSectionEnd();
            }
            try {
                ((Runnable)notification.get2()).run();
            }
            finally {
                ((GridFutureAdapter)notification.get1()).onDone();
            }
        }

        public synchronized void submit(GridFutureAdapter notificationFut, Runnable cmd) {
            if (this.isCancelled()) {
                notificationFut.onDone();
                return;
            }
            this.queue.add(new T2<GridFutureAdapter, Runnable>(notificationFut, cmd));
        }

        @Override
        public synchronized void cancel() {
            super.cancel();
            while (!this.queue.isEmpty()) {
                T2 notification = (T2)this.queue.poll();
                if (notification == null) continue;
                ((GridFutureAdapter)notification.get1()).onDone();
            }
        }

        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            while (!this.isCancelled()) {
                try {
                    this.body0();
                }
                catch (Throwable t) {
                    boolean isInterruptedException;
                    boolean bl = isInterruptedException = X.hasCause(t, InterruptedException.class) || X.hasCause(t, IgniteInterruptedException.class) || X.hasCause(t, IgniteInterruptedCheckedException.class);
                    if (!isInterruptedException) {
                        U.error(this.log, "Exception in discovery notifier worker thread.", t);
                    }
                    if (!isInterruptedException || !this.isCancelled) {
                        FailureType type = t instanceof OutOfMemoryError ? FailureType.CRITICAL_ERROR : FailureType.SYSTEM_WORKER_TERMINATION;
                        GridDiscoveryManager.this.ctx.failure().process(new FailureContext(type, t));
                    }
                    throw t;
                }
            }
        }
    }

    private class DiscoveryMessageNotifierThread
    extends IgniteThread
    implements IgniteDiscoveryThread {
        private final GridWorker worker;

        public DiscoveryMessageNotifierThread(GridWorker worker) {
            super(worker);
            this.worker = worker;
        }

        @Override
        public GridWorker worker() {
            return this.worker;
        }
    }

    private class SegmentCheckWorker
    extends GridWorker {
        private final BlockingQueue<Object> queue;

        private SegmentCheckWorker() {
            super(GridDiscoveryManager.this.ctx.igniteInstanceName(), "disco-net-seg-chk-worker", GridDiscoveryManager.this.log);
            this.queue = new LinkedBlockingQueue<Object>();
            assert (GridDiscoveryManager.this.hasRslvrs);
            assert (GridDiscoveryManager.this.segChkFreq > 0L);
        }

        public void scheduleSegmentCheck() {
            this.queue.add(new Object());
        }

        @Override
        protected void body() throws InterruptedException {
            long lastChkNanos = 0L;
            while (!this.isCancelled()) {
                Object req = this.queue.poll(2000L, TimeUnit.MILLISECONDS);
                long nowNanos = System.nanoTime();
                if (req == null && (GridDiscoveryManager.this.segChkFreq == 0L || U.nanosToMillis(nowNanos - lastChkNanos) <= GridDiscoveryManager.this.segChkFreq)) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Skipping segment check as it has not been requested and it is not time to check.");
                    continue;
                }
                assert (req != null || U.nanosToMillis(nowNanos - lastChkNanos) > GridDiscoveryManager.this.segChkFreq);
                while (this.queue.poll() != null) {
                }
                if (!GridDiscoveryManager.this.lastSegChkRes.get()) continue;
                boolean segValid = GridDiscoveryManager.this.ctx.segmentation().isValidSegment();
                lastChkNanos = nowNanos;
                if (!segValid) {
                    ClusterNode node = ((DiscoverySpi)GridDiscoveryManager.this.getSpi()).getLocalNode();
                    Set<ClusterNode> locNodeOnlyTop = Collections.singleton(node);
                    GridDiscoveryManager.this.discoWrk.addEvent(new NotificationEvent(14, AffinityTopologyVersion.NONE, node, GridDiscoveryManager.this.createDiscoCache(AffinityTopologyVersion.NONE, GridDiscoveryManager.this.ctx.state().clusterState(), node, locNodeOnlyTop), locNodeOnlyTop, null, null));
                    GridDiscoveryManager.this.lastSegChkRes.set(false);
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Segment has been checked [requested=" + (req != null) + ", valid=" + segValid + ']');
            }
        }

        @Override
        public String toString() {
            return S.toString(SegmentCheckWorker.class, this);
        }
    }
}

