/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.exception.handler.replacement;

import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.URISyntaxHandler;
import jakarta.inject.Singleton;
import java.net.URISyntaxException;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.constants.HttpCode;
import org.apache.ignite.internal.rest.problem.HttpProblemResponse;

@Singleton
@Replaces(value=URISyntaxHandler.class)
@Requires(classes={URISyntaxException.class, ExceptionHandler.class})
public class UriSyntaxHandlerReplacement
implements ExceptionHandler<URISyntaxException, HttpResponse<? extends Problem>> {
    public HttpResponse<? extends Problem> handle(HttpRequest request, URISyntaxException exception) {
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.BAD_REQUEST).title("Malformed URI").detail(exception.getMessage()));
    }
}

