/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.sse;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.sse.DefaultEvent;
import java.time.Duration;

public interface Event<T> {
    public static final String ID = "id";
    public static final String EVENT = "event";
    public static final String DATA = "data";
    public static final String RETRY = "retry";

    public T getData();

    public String getId();

    public String getName();

    public String getComment();

    public Duration getRetry();

    public Event<T> retry(@Nullable Duration var1);

    public Event<T> id(@Nullable String var1);

    public Event<T> name(@Nullable String var1);

    public Event<T> comment(@Nullable String var1);

    public static <ET> Event<ET> of(ET data) {
        ArgumentUtils.check((String)DATA, data).notNull();
        return new DefaultEvent<ET>(data);
    }

    public static <ET> Event<ET> of(Event event, ET data) {
        ArgumentUtils.check((String)DATA, data).notNull();
        return new DefaultEvent<ET>(data).id(event.getId()).comment(event.getComment()).name(event.getName()).retry(event.getRetry());
    }
}

