/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.meta;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.meta.MetaRemoveCommandArg;
import org.apache.ignite.internal.management.meta.MetadataMarshalled;
import org.apache.ignite.internal.management.meta.MetadataRemoveTask;
import org.apache.ignite.lang.IgniteExperimental;

@IgniteExperimental
public class MetaRemoveCommand
implements ComputeCommand<MetaRemoveCommandArg, MetadataMarshalled> {
    @Override
    public String description() {
        return "Remove the metadata of the specified type (the type must be specified by type name or by type identifier) from cluster and saves the removed metadata to the specified file.\nIf the file name isn't specified the output file name is: '<typeId>.bin'";
    }

    @Override
    public Class<MetaRemoveCommandArg> argClass() {
        return MetaRemoveCommandArg.class;
    }

    @Override
    public Class<MetadataRemoveTask> taskClass() {
        return MetadataRemoveTask.class;
    }

    @Override
    public void printResult(MetaRemoveCommandArg arg, MetadataMarshalled res, Consumer<String> printer) {
        if (res.metadata() == null) {
            throw new IllegalArgumentException("Failed to remove binary type, type not found: " + arg);
        }
        BinaryMetadata m = res.metadata();
        Path outFile = FileSystems.getDefault().getPath(arg.out() != null ? arg.out() : BinaryUtils.binaryMetaFileName(m.typeId()), new String[0]);
        try (OutputStream os = Files.newOutputStream(outFile, new OpenOption[0]);){
            os.write(res.metadataMarshalled());
        }
        catch (IOException e) {
            printer.accept("Cannot store removed type '" + m.typeName() + "' to: " + outFile);
            printer.accept(e.getMessage());
            return;
        }
        printer.accept("Type '" + m.typeName() + "' is removed. Metadata is stored at: " + outFile);
    }

    @Override
    public String confirmationPrompt(MetaRemoveCommandArg arg) {
        return "Warning: the command will remove the binary metadata for a type \"" + (Serializable)(arg.typeId() != 0 ? Integer.valueOf(arg.typeId()) : arg.typeName()) + "\" from cluster. Please drop client connections after the operation to clear their local metadata cache if needed.";
    }
}

