/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryEnumObjectImpl;
import org.apache.ignite.internal.binary.BinaryFieldImpl;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class BinaryTypeImpl
implements BinaryType {
    @GridToStringExclude
    private final BinaryContext ctx;
    private final BinaryMetadata meta;

    public BinaryTypeImpl(BinaryContext ctx, BinaryMetadata meta) {
        this.ctx = ctx;
        this.meta = meta;
    }

    @Override
    public String typeName() {
        return this.meta.typeName();
    }

    @Override
    public int typeId() {
        return this.meta.typeId();
    }

    @Override
    public Collection<String> fieldNames() {
        return this.meta.fields();
    }

    @Override
    public String fieldTypeName(String fieldName) {
        return this.meta.fieldTypeName(fieldName);
    }

    @Override
    public BinaryFieldImpl field(String fieldName) {
        return this.ctx.createField(this.meta.typeId(), fieldName);
    }

    @Override
    public String affinityKeyFieldName() {
        return this.meta.affinityKeyFieldName();
    }

    @Override
    public boolean isEnum() {
        return this.meta.isEnum();
    }

    @Override
    public Collection<BinaryObject> enumValues() {
        Collection<Integer> ordinals = this.meta.enumMap().values();
        ArrayList<BinaryObject> enumValues = new ArrayList<BinaryObject>(ordinals.size());
        for (Integer ord : ordinals) {
            enumValues.add(new BinaryEnumObjectImpl(this.ctx, this.typeId(), this.typeName(), ord));
        }
        return enumValues;
    }

    public BinaryContext context() {
        return this.ctx;
    }

    public BinaryMetadata metadata() {
        return this.meta;
    }

    public String toString() {
        return S.toString(BinaryTypeImpl.class, this);
    }
}

