/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteAbstractSqlAlterTable;

public class IgniteSqlAlterTableDropColumn
extends IgniteAbstractSqlAlterTable {
    private final boolean ifExistsColumn;
    private final SqlNodeList columns;

    public IgniteSqlAlterTableDropColumn(SqlParserPos pos, boolean ifExists, SqlIdentifier tblName, boolean ifExistsColumn, SqlNodeList columns) {
        super(pos, ifExists, tblName);
        this.ifExistsColumn = ifExistsColumn;
        this.columns = Objects.requireNonNull(columns, "columns list");
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)this.columns);
    }

    @Override
    protected void unparseAlterTableOperation(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP");
        writer.keyword("COLUMN");
        if (this.ifExistsColumn) {
            writer.keyword("IF EXISTS");
        }
        this.columns.unparse(writer, leftPrec, rightPrec);
    }

    public boolean ifExistsColumn() {
        return this.ifExistsColumn;
    }

    public SqlNodeList columns() {
        return this.columns;
    }
}

