/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.message;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.query.calcite.message.MarshalableMessage;
import org.apache.ignite.internal.processors.query.calcite.message.MessageType;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class QueryStartResponse
implements MarshalableMessage {
    private UUID queryId;
    private long fragmentId;
    @GridDirectTransient
    private Throwable error;
    private byte[] errBytes;

    public QueryStartResponse() {
    }

    public QueryStartResponse(UUID queryId, long fragmentId) {
        this(queryId, fragmentId, null);
    }

    public QueryStartResponse(UUID queryId, long fragmentId, Throwable error) {
        this.queryId = queryId;
        this.fragmentId = fragmentId;
        this.error = error;
    }

    public UUID queryId() {
        return this.queryId;
    }

    public long fragmentId() {
        return this.fragmentId;
    }

    public Throwable error() {
        return this.error;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext<?, ?> ctx) throws IgniteCheckedException {
        if (this.error != null) {
            this.errBytes = U.marshal(ctx, (Object)this.error);
        }
    }

    @Override
    public void prepareUnmarshal(GridCacheSharedContext<?, ?> ctx) throws IgniteCheckedException {
        if (this.errBytes != null) {
            this.error = (Throwable)U.unmarshal(ctx, (byte[])this.errBytes, (ClassLoader)U.resolveClassLoader((IgniteConfiguration)ctx.gridConfig()));
        }
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("errBytes", this.errBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("fragmentId", this.fragmentId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeUuid("queryId", this.queryId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.errBytes = reader.readByteArray("errBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.fragmentId = reader.readLong("fragmentId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.queryId = reader.readUuid("queryId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(QueryStartResponse.class);
    }

    @Override
    public MessageType type() {
        return MessageType.QUERY_START_RESPONSE;
    }

    public byte fieldsCount() {
        return 3;
    }
}

