/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.compress;

import java.nio.file.Path;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import org.apache.ignite.internal.processors.compress.NativeFileSystem;

public class NativeFileSystemPosix
implements NativeFileSystem {
    private static POSIX posix = POSIXFactory.getPOSIX();

    public int getFileSystemBlockSize(Path path) {
        FileStat stat = posix.stat(path.toString());
        return Math.toIntExact(stat.blockSize());
    }

    public int getFileSystemBlockSize(int fd) {
        FileStat stat = posix.fstat(fd);
        return Math.toIntExact(stat.blockSize());
    }

    public long getSparseFileSize(int fd) {
        FileStat stat = posix.fstat(fd);
        return stat.blocks() * 512L;
    }

    public void punchHole(int fd, long off, long len) {
        throw new UnsupportedOperationException();
    }
}

