/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.compress;

import com.github.luben.zstd.Zstd;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.DiskPageCompression;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.ThreadLocalDirectByteBuffer;
import org.apache.ignite.internal.processors.cache.persistence.file.RandomAccessFileIO;
import org.apache.ignite.internal.processors.compress.CompressionProcessor;
import org.apache.ignite.internal.processors.compress.FileSystemUtils;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.xerial.snappy.Snappy;

public class CompressionProcessorImpl
extends CompressionProcessor {
    private final ThreadLocalDirectByteBuffer compressBuf = new ThreadLocalDirectByteBuffer(CompressionProcessorImpl.maxCompressedBufferSize(16384), GridUnsafe.NATIVE_BYTE_ORDER);

    public CompressionProcessorImpl(GridKernalContext ctx) {
        super(ctx);
    }

    public void checkPageCompressionSupported() throws IgniteCheckedException {
    }

    public void checkPageCompressionSupported(Path storagePath, int pageSize) throws IgniteCheckedException {
        if (!U.isLinux()) {
            throw new IgniteCheckedException("Currently page compression is supported only for Linux.");
        }
        FileSystemUtils.checkSupported();
        int fsBlockSize = FileSystemUtils.getFileSystemBlockSize((Path)storagePath);
        if (fsBlockSize <= 0) {
            throw new IgniteCheckedException("Failed to get file system block size: " + storagePath);
        }
        if (!U.isPow2((int)fsBlockSize)) {
            throw new IgniteCheckedException("Storage block size must be power of 2: " + fsBlockSize);
        }
        if (pageSize < fsBlockSize * 2) {
            throw new IgniteCheckedException("Page size (now configured to " + pageSize + " bytes) must be at least 2 times larger than the underlying storage block size (detected to be " + fsBlockSize + " bytes at '" + storagePath + "') for page compression.");
        }
        this.checkPunchHole(storagePath, fsBlockSize);
    }

    private void checkPunchHole(Path storagePath, int fsBlockSz) throws IgniteException {
        File testFile;
        block13: {
            ByteBuffer buf = null;
            testFile = null;
            try {
                testFile = File.createTempFile("punch_hole_", null, storagePath.toFile());
                buf = GridUnsafe.allocateBuffer((int)(fsBlockSz * 2));
                GridUnsafe.zeroMemory((long)GridUnsafe.bufferAddress((ByteBuffer)buf), (long)buf.capacity());
                try (RandomAccessFileIO testFileIO = new RandomAccessFileIO(testFile, new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE});){
                    testFileIO.writeFully(buf);
                    testFileIO.punchHole((long)fsBlockSz, fsBlockSz);
                }
                if (buf == null) break block13;
            }
            catch (Exception e) {
                try {
                    throw new IgniteException("File system does not support punching holes on path " + storagePath, (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (buf != null) {
                        GridUnsafe.freeBuffer(buf);
                    }
                    if (testFile != null) {
                        testFile.delete();
                    }
                    throw throwable;
                }
            }
            GridUnsafe.freeBuffer((ByteBuffer)buf);
        }
        if (testFile != null) {
            testFile.delete();
        }
    }

    protected ByteBuffer doCompressPage(DiskPageCompression compression, ByteBuffer compactPage, int compactSize, int compressLevel) {
        switch (compression) {
            case ZSTD: {
                return this.compressPageZstd(compactPage, compactSize, compressLevel);
            }
            case LZ4: {
                return this.compressPageLz4(compactPage, compactSize, compressLevel);
            }
            case SNAPPY: {
                return this.compressPageSnappy(compactPage, compactSize);
            }
        }
        throw new IllegalStateException("Unsupported compression: " + compression);
    }

    private ByteBuffer compressPageLz4(ByteBuffer compactPage, int compactSize, int compressLevel) {
        LZ4Compressor compressor = Lz4.getCompressor(compressLevel);
        ByteBuffer compressedPage = this.compressBuf.get();
        CompressionProcessorImpl.copyPageHeader(compactPage, compressedPage, compactSize);
        compressor.compress(compactPage, compressedPage);
        compactPage.flip();
        compressedPage.flip();
        return compressedPage;
    }

    private ByteBuffer compressPageZstd(ByteBuffer compactPage, int compactSize, int compressLevel) {
        ByteBuffer compressedPage = this.compressBuf.get();
        CompressionProcessorImpl.copyPageHeader(compactPage, compressedPage, compactSize);
        Zstd.compress((ByteBuffer)compressedPage, (ByteBuffer)compactPage, (int)compressLevel);
        compactPage.flip();
        compressedPage.flip();
        return compressedPage;
    }

    private ByteBuffer compressPageSnappy(ByteBuffer compactPage, int compactSize) {
        ByteBuffer compressedPage = this.compressBuf.get();
        CompressionProcessorImpl.copyPageHeader(compactPage, compressedPage, compactSize);
        try {
            int compressedSize = Snappy.compress((ByteBuffer)compactPage, (ByteBuffer)compressedPage);
            assert (compressedPage.limit() == 40 + compressedSize);
        }
        catch (IOException e) {
            throw new IgniteException("Failed to compress page with Snappy.", (Throwable)e);
        }
        compactPage.position(0);
        compressedPage.position(0);
        return compressedPage;
    }

    private static void copyPageHeader(ByteBuffer compactPage, ByteBuffer compressedPage, int compactSize) {
        compactPage.limit(40);
        compressedPage.put(compactPage);
        compactPage.limit(compactSize);
    }

    protected void doDecompressPage(int compressType, ByteBuffer page, int compressedSize, int compactSize) {
        ByteBuffer dst = this.compressBuf.get();
        page.limit(compressedSize).position(40);
        dst.limit(compactSize - 40);
        switch (compressType) {
            case 2: {
                Zstd.decompress((ByteBuffer)dst, (ByteBuffer)page);
                dst.flip();
                break;
            }
            case 3: {
                Lz4.decompress(page, dst);
                dst.flip();
                break;
            }
            case 4: {
                try {
                    Snappy.uncompress((ByteBuffer)page, (ByteBuffer)dst);
                    break;
                }
                catch (IOException e) {
                    throw new IgniteException((Throwable)e);
                }
            }
            default: {
                throw new IgniteException("Unknown compression: " + compressType);
            }
        }
        page.position(40).limit(compactSize);
        page.put(dst).flip();
        assert (page.limit() == compactSize);
    }

    private static int maxCompressedBufferSize(int baseSz) {
        int lz4Sz = Lz4.fastCompressor.maxCompressedLength(baseSz);
        int zstdSz = (int)Zstd.compressBound((long)baseSz);
        int snappySz = Snappy.maxCompressedLength((int)baseSz);
        return Math.max(Math.max(lz4Sz, zstdSz), snappySz);
    }

    static class Lz4 {
        static final LZ4Factory factory = LZ4Factory.fastestInstance();
        static final LZ4FastDecompressor decompressor = factory.fastDecompressor();
        static final LZ4Compressor fastCompressor = factory.fastCompressor();

        Lz4() {
        }

        static LZ4Compressor getCompressor(int level) {
            assert (level >= 0 && level <= 17) : level;
            return level == 0 ? fastCompressor : factory.highCompressor(level);
        }

        static void decompress(ByteBuffer page, ByteBuffer dst) {
            decompressor.decompress(page, dst);
        }
    }
}

