/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.aws.sns;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.aws.sns.SnsNotify;
import org.apache.hop.pipeline.transforms.aws.sns.SnsNotifyData;

@Transform(id="SnsNotify", image="aws-sns.svg", name="i18n::SNSNotify.Name", description="i18n::SNSNotify.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", keywords={""}, documentationUrl="/pipeline/transforms/aws-sns-notify.html")
public class SnsNotifyMeta
extends BaseTransformMeta<SnsNotify, SnsNotifyData> {
    private static final Class<?> PKG = SnsNotifyMeta.class;
    @HopMetadataProperty(key="AwsCredChain", injectionKey="AWS_CRED_CHAIN")
    private String awsCredChain;
    @HopMetadataProperty(key="aws_key", injectionKey="AWS_KEY")
    private String awsKey;
    @HopMetadataProperty(key="aws_key_secret", injectionKey="AWS_KEY_SECRET")
    private String awsKeySecret;
    @HopMetadataProperty(key="aws_region", injectionKey="AWS_REGION")
    private String awsRegion;
    @HopMetadataProperty(key="notify_point", injectionKey="NOTIFY_POINT")
    private String notifyPoint;
    @HopMetadataProperty(key="chooser_topic_arn", injectionKey="CHOOSER_TOPIC_ARN")
    private String cInputtopicArn;
    @HopMetadataProperty(key="chooser_subject", injectionKey="CHOOSER_SUBJECT")
    private String cInputSubject;
    @HopMetadataProperty(key="chooser_message", injectionKey="CHOOSER_MESSAGE")
    private String cInputMessage;
    @HopMetadataProperty(key="field_topic_arn", injectionKey="FIELD_TOPIC_ARN")
    private String tFldtopicARN;
    @HopMetadataProperty(key="field_subject", injectionKey="FIELD_SUBJECT")
    private String tFldSubject;
    @HopMetadataProperty(key="field_message", injectionKey="FIELD_MESSAGE")
    private String tFldMessage;
    @HopMetadataProperty(key="value_topic_arn", injectionKey="VALUE_TOPIC_ARN")
    private String tValuetopicARN;
    @HopMetadataProperty(key="value_subject", injectionKey="VALUE_SUBJECT")
    private String tValueSubject;
    @HopMetadataProperty(key="value_message", injectionKey="VALUE_MESSAGE")
    private String tValueMessage;
    @HopMetadataProperty(key="field_message_id", injectionKey="FIELD_MESSAGE_ID")
    private String tFldMessageID;

    public String getAwsCredChain() {
        return this.awsCredChain == null ? "N" : this.awsCredChain;
    }

    public void setAwsCredChain(String awsCredChain) {
        this.awsCredChain = awsCredChain;
    }

    public String getAwsKey() {
        return this.awsKey == null ? "" : this.awsKey;
    }

    public void setAwsKey(String awsKey) {
        this.awsKey = awsKey;
    }

    public String getAwsKeySecret() {
        return this.awsKeySecret == null ? "" : this.awsKeySecret;
    }

    public void setAwsKeySecret(String awsKeySecret) {
        this.awsKeySecret = awsKeySecret;
    }

    public String getAwsRegion() {
        return this.awsRegion == null ? "" : this.awsRegion;
    }

    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    public String getNotifyPoint() {
        return this.notifyPoint == null ? "Send once with first row" : this.notifyPoint;
    }

    public String[] getNotifyPointValues() {
        return new String[]{"Send once with first row", "Send for each row (be careful!)"};
    }

    public String getNotifyPointShort() {
        if (this.notifyPoint.contains("last")) {
            return "last";
        }
        if (this.notifyPoint.contains("each")) {
            return "each";
        }
        return "first";
    }

    public void setNotifyPoint(String notifyPoint) {
        this.notifyPoint = notifyPoint;
    }

    public String getCInputtopicArn() {
        return this.cInputtopicArn == null ? "N" : this.cInputtopicArn;
    }

    public void setCInputtopicArn(String cInputtopicArn) {
        this.cInputtopicArn = cInputtopicArn;
    }

    public String getTFldtopicARN() {
        return this.tFldtopicARN == null ? "" : this.tFldtopicARN;
    }

    public void setTFldtopicARN(String tFldtopicARN) {
        this.tFldtopicARN = tFldtopicARN;
    }

    public String getTValuetopicARN() {
        return this.tValuetopicARN == null ? "" : this.tValuetopicARN;
    }

    public void setTValuetopicARN(String tValuetopicARN) {
        this.tValuetopicARN = tValuetopicARN;
    }

    public String getCInputSubject() {
        return this.cInputSubject == null ? "N" : this.cInputSubject;
    }

    public void setCInputSubject(String cInputSubject) {
        this.cInputSubject = cInputSubject;
    }

    public String getTFldSubject() {
        return this.tFldSubject == null ? "" : this.tFldSubject;
    }

    public void setTFldSubject(String tFldSubject) {
        this.tFldSubject = tFldSubject;
    }

    public String getTValueSubject() {
        return this.tValueSubject == null ? "" : this.tValueSubject;
    }

    public void setTValueSubject(String tValueSubject) {
        this.tValueSubject = tValueSubject;
    }

    public String getCInputMessage() {
        return this.cInputMessage == null ? "N" : this.cInputMessage;
    }

    public void setCInputMessage(String cInputMessage) {
        this.cInputMessage = cInputMessage;
    }

    public String getTFldMessage() {
        return this.tFldMessage == null ? "N" : this.tFldMessage;
    }

    public void setTFldMessage(String tFldMessage) {
        this.tFldMessage = tFldMessage;
    }

    public String getTValueMessage() {
        return this.tValueMessage == null ? "" : this.tValueMessage;
    }

    public void setTValueMessage(String tValueMessage) {
        this.tValueMessage = tValueMessage;
    }

    public String getTFldMessageID() {
        return this.tFldMessageID == null ? "" : this.tFldMessageID;
    }

    public void setTFldMessageID(String tFldMessageID) {
        this.tFldMessageID = tFldMessageID;
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables space, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            if (this.tFldMessageID != null && !this.tFldMessageID.equals("")) {
                IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)this.tFldMessageID, (int)2);
                valueMeta.setName(this.tFldMessageID.toUpperCase());
                valueMeta.setTrimType(3);
                valueMeta.setOrigin(name);
                inputRowMeta.addValueMeta(valueMeta);
            }
        }
        catch (HopPluginException e) {
            this.logBasic(e.getMessage());
            throw new HopTransformException((Throwable)e);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta transMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables space, IHopMetadataProvider metaStore) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SNSNotify.CheckResult.ReceivingRows.OK", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SNSNotify.CheckResult.ReceivingRows.ERROR", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.getAwsCredChain() == "N" && (this.getAwsKey().isEmpty() || this.getAwsKeySecret().isEmpty() || this.getAwsRegion().isEmpty())) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SNSNotify.CheckResult.AWSCredentials.ERROR", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SNSNotify.CheckResult.AWSCredentials.OK", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.getNotifyPoint().isEmpty()) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SNSNotify.CheckResult.NotifyPoint.ERROR", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SNSNotify.CheckResult.NotifyPoint.OK", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        boolean notifyPropsError = false;
        if (this.getCInputtopicArn().equals("Y") && this.getTFldtopicARN().isEmpty() || this.getCInputtopicArn().equals("N") && this.getTValuetopicARN().isEmpty()) {
            notifyPropsError = true;
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SNSNotify.CheckResult.NotifyProps.topicARN.ERROR", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.getCInputSubject().equals("Y") && this.getTFldSubject().isEmpty() || this.getCInputSubject().equals("N") && this.getTValueSubject().isEmpty()) {
            notifyPropsError = true;
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SNSNotify.CheckResult.NotifyProps.Subject.ERROR", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.getCInputMessage().equals("Y") && this.getTFldMessage().isEmpty() || this.getCInputMessage().equals("N") && this.getTValueMessage().isEmpty()) {
            notifyPropsError = true;
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SNSNotify.CheckResult.NotifyProps.Message.ERROR", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (!notifyPropsError) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SNSNotify.CheckResult.NotifyProps.OK", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

