/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.reflection.probe.xp;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.RowProducer;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.RowAdapter;
import org.apache.hop.pipeline.transform.TransformMetaDataCombi;
import org.apache.hop.reflection.probe.meta.DataProbeLocation;
import org.apache.hop.reflection.probe.meta.PipelineProbe;
import org.apache.hop.reflection.probe.transform.PipelineDataProbe;

@ExtensionPoint(id="PipelineDataProbeXp", extensionPointId="PipelineStartThreads", description="Before the start of a pipeline, after init, attach the data probes needed")
public class PipelineDataProbeXp
implements IExtensionPoint<Pipeline> {
    public static final String PIPELINE_DATA_PROBE_FLAG = "PipelineDataProbeActive";

    public void callExtensionPoint(ILogChannel log, IVariables variables, Pipeline pipeline) throws HopException {
        if (pipeline.getExtensionDataMap().get(PIPELINE_DATA_PROBE_FLAG) != null) {
            return;
        }
        IHopMetadataProvider metadataProvider = pipeline.getMetadataProvider();
        IHopMetadataSerializer serializer = metadataProvider.getSerializer(PipelineProbe.class);
        List pipelineDataProbes = serializer.loadAll();
        for (PipelineProbe pipelineProbe : pipelineDataProbes) {
            this.handlePipelineProbe(log, pipelineProbe, (IPipelineEngine<PipelineMeta>)pipeline, variables);
        }
    }

    private void handlePipelineProbe(ILogChannel log, PipelineProbe pipelineProbe, IPipelineEngine<PipelineMeta> pipeline, IVariables variables) throws HopException {
        try {
            if (!pipelineProbe.isEnabled()) {
                return;
            }
            String probingPipelineFilename = variables.resolve(pipelineProbe.getPipelineFilename());
            FileObject probingFileObject = HopVfs.getFileObject((String)probingPipelineFilename);
            if (!probingFileObject.exists()) {
                log.logBasic("WARNING: The Pipeline Probe pipeline file '" + probingPipelineFilename + "' couldn't be found to execute.");
                return;
            }
            for (DataProbeLocation dataProbeLocation : pipelineProbe.getDataProbeLocations()) {
                if (!this.probeLocationExists(variables, dataProbeLocation, pipeline)) continue;
                this.executeProbingPipeline(pipelineProbe, dataProbeLocation, probingPipelineFilename, pipeline, variables);
            }
        }
        catch (Exception e) {
            pipeline.stopAll();
            throw new HopException("Error handling Pipeline Probe metadata object '" + pipelineProbe.getName() + "' at the start of pipeline: " + pipeline, (Throwable)e);
        }
    }

    private boolean probeLocationExists(IVariables variables, DataProbeLocation dataProbeLocation, IPipelineEngine<PipelineMeta> pipeline) throws HopException {
        FileObject locationFileObject;
        String locationFilename;
        if (StringUtils.isEmpty((String)pipeline.getFilename())) {
            return false;
        }
        FileObject parentFileObject = HopVfs.getFileObject((String)pipeline.getFilename());
        String parentFilename = parentFileObject.getName().getPath();
        if (!parentFilename.equals(locationFilename = (locationFileObject = HopVfs.getFileObject((String)variables.resolve(dataProbeLocation.getSourcePipelineFilename()))).getName().getPath())) {
            return false;
        }
        List componentCopies = pipeline.getComponentCopies(dataProbeLocation.getSourceTransformName());
        return componentCopies != null && !componentCopies.isEmpty();
    }

    private synchronized void executeProbingPipeline(PipelineProbe pipelineProbe, DataProbeLocation dataProbeLocation, String loggingPipelineFilename, IPipelineEngine<PipelineMeta> pipeline, IVariables variables) throws HopException {
        PipelineMeta probingPipelineMeta = new PipelineMeta(loggingPipelineFilename, pipeline.getMetadataProvider(), variables);
        LocalPipelineEngine probingPipeline = new LocalPipelineEngine(probingPipelineMeta, variables, pipeline);
        probingPipeline.getExtensionDataMap().put(PIPELINE_DATA_PROBE_FLAG, "Y");
        probingPipeline.getExtensionDataMap().put("PipelineLoggingActive", "Y");
        probingPipeline.setLogLevel(LogLevel.ERROR);
        probingPipeline.prepareExecution();
        List componentCopies = pipeline.getComponentCopies(dataProbeLocation.getSourceTransformName());
        for (IEngineComponent componentCopy : componentCopies) {
            for (TransformMetaDataCombi combi : probingPipeline.getTransforms()) {
                ITransform iTransform = combi.transform;
                if (!(iTransform instanceof PipelineDataProbe)) continue;
                PipelineDataProbe pipelineDataProbe = (PipelineDataProbe)iTransform;
                pipelineDataProbe.setSourcePipelineName(pipeline.getPipelineMeta().getName());
                pipelineDataProbe.setSourceTransformLogChannelId(pipeline.getLogChannelId());
                pipelineDataProbe.setSourceTransformName(componentCopy.getName());
                pipelineDataProbe.setSourceTransformCopy(componentCopy.getCopyNr());
                try {
                    final RowProducer rowProducer = probingPipeline.addRowProducer(combi.transformName, combi.copy);
                    componentCopy.addRowListener((IRowListener)new RowAdapter(){

                        public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                            rowProducer.putRow(rowMeta, row);
                        }
                    });
                    pipeline.addExecutionFinishedListener(pe -> rowProducer.finished());
                }
                catch (HopException e2) {
                    throw new HopTransformException("Error adding row producer to transform '" + combi.transformName + "'", (Throwable)e2);
                }
            }
        }
        probingPipeline.startThreads();
        pipeline.addExecutionStoppedListener(e -> probingPipeline.stopAll());
    }
}

