/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.serde2.thrift.Type;
import org.apache.hive.jdbc.JdbcColumnAttributes;

public class JdbcColumn {
    private final String columnName;
    private final String tableName;
    private final String tableCatalog;
    private final String type;
    private final String comment;
    private final int ordinalPos;

    JdbcColumn(String columnName, String tableName, String tableCatalog, String type, String comment, int ordinalPos) {
        this.columnName = columnName;
        this.tableName = tableName;
        this.tableCatalog = tableCatalog;
        this.type = type;
        this.comment = comment;
        this.ordinalPos = ordinalPos;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableCatalog() {
        return this.tableCatalog;
    }

    public String getType() {
        return this.type;
    }

    static String columnClassName(Type hiveType, JdbcColumnAttributes columnAttributes) throws SQLException {
        int columnType = JdbcColumn.hiveTypeToSqlType(hiveType);
        switch (columnType) {
            case 0: {
                return "null";
            }
            case 16: {
                return Boolean.class.getName();
            }
            case 1: 
            case 12: {
                return String.class.getName();
            }
            case -6: {
                return Byte.class.getName();
            }
            case 5: {
                return Short.class.getName();
            }
            case 4: {
                return Integer.class.getName();
            }
            case -5: {
                return Long.class.getName();
            }
            case 91: {
                return Date.class.getName();
            }
            case 6: {
                return Float.class.getName();
            }
            case 8: {
                return Double.class.getName();
            }
            case 93: {
                return Timestamp.class.getName();
            }
            case 2014: {
                return TimestampTZ.class.getName();
            }
            case 3: {
                return BigInteger.class.getName();
            }
            case -2: {
                return byte[].class.getName();
            }
            case 1111: 
            case 2000: {
                switch (hiveType) {
                    case INTERVAL_YEAR_MONTH_TYPE: {
                        return HiveIntervalYearMonth.class.getName();
                    }
                    case INTERVAL_DAY_TIME_TYPE: {
                        return HiveIntervalDayTime.class.getName();
                    }
                }
                return String.class.getName();
            }
            case 2002: 
            case 2003: {
                return String.class.getName();
            }
        }
        throw new SQLException("Invalid column type: " + columnType);
    }

    static Type typeStringToHiveType(String type) throws SQLException {
        String t;
        switch (t = type.toLowerCase()) {
            case "string": {
                return Type.STRING_TYPE;
            }
            case "varchar": {
                return Type.VARCHAR_TYPE;
            }
            case "char": {
                return Type.CHAR_TYPE;
            }
            case "float": {
                return Type.FLOAT_TYPE;
            }
            case "double": {
                return Type.DOUBLE_TYPE;
            }
            case "boolean": {
                return Type.BOOLEAN_TYPE;
            }
            case "tinyint": {
                return Type.TINYINT_TYPE;
            }
            case "smallint": {
                return Type.SMALLINT_TYPE;
            }
            case "int": {
                return Type.INT_TYPE;
            }
            case "bigint": {
                return Type.BIGINT_TYPE;
            }
            case "date": {
                return Type.DATE_TYPE;
            }
            case "timestamp": {
                return Type.TIMESTAMP_TYPE;
            }
            case "timestamp with local time zone": {
                return Type.TIMESTAMPLOCALTZ_TYPE;
            }
            case "interval_year_month": {
                return Type.INTERVAL_YEAR_MONTH_TYPE;
            }
            case "interval_day_time": {
                return Type.INTERVAL_DAY_TIME_TYPE;
            }
            case "decimal": {
                return Type.DECIMAL_TYPE;
            }
            case "binary": {
                return Type.BINARY_TYPE;
            }
            case "map": {
                return Type.MAP_TYPE;
            }
            case "array": {
                return Type.ARRAY_TYPE;
            }
            case "struct": {
                return Type.STRUCT_TYPE;
            }
            case "uniontype": {
                return Type.UNION_TYPE;
            }
            case "void": 
            case "null": {
                return Type.NULL_TYPE;
            }
        }
        throw new SQLException("Unrecognized column type: " + type);
    }

    public static int hiveTypeToSqlType(Type hiveType) throws SQLException {
        return hiveType.toJavaSQLType();
    }

    public static int hiveTypeToSqlType(String type) throws SQLException {
        return JdbcColumn.hiveTypeToSqlType(JdbcColumn.typeStringToHiveType(type));
    }

    static String getColumnTypeName(String type) throws SQLException {
        String t;
        switch (t = type.toLowerCase()) {
            case "string": {
                return "string";
            }
            case "varchar": {
                return "varchar";
            }
            case "char": {
                return "char";
            }
            case "float": {
                return "float";
            }
            case "double": {
                return "double";
            }
            case "boolean": {
                return "boolean";
            }
            case "tinyint": {
                return "tinyint";
            }
            case "smallint": {
                return "smallint";
            }
            case "int": {
                return "int";
            }
            case "bigint": {
                return "bigint";
            }
            case "timestamp": {
                return "timestamp";
            }
            case "timestamp with local time zone": {
                return "timestamp with local time zone";
            }
            case "date": {
                return "date";
            }
            case "interval_year_month": {
                return "interval_year_month";
            }
            case "interval_day_time": {
                return "interval_day_time";
            }
            case "decimal": {
                return "decimal";
            }
            case "binary": {
                return "binary";
            }
            case "void": 
            case "null": {
                return "void";
            }
            case "map": {
                return "map";
            }
            case "array": {
                return "array";
            }
            case "struct": {
                return "struct";
            }
        }
        throw new SQLException("Unrecognized column type: " + type);
    }

    static int columnDisplaySize(Type hiveType, JdbcColumnAttributes columnAttributes) throws SQLException {
        int columnType = JdbcColumn.hiveTypeToSqlType(hiveType);
        switch (columnType) {
            case 0: {
                return 4;
            }
            case 16: {
                return JdbcColumn.columnPrecision(hiveType, columnAttributes);
            }
            case 1: 
            case 12: {
                return JdbcColumn.columnPrecision(hiveType, columnAttributes);
            }
            case -2: {
                return Integer.MAX_VALUE;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return JdbcColumn.columnPrecision(hiveType, columnAttributes) + 1;
            }
            case 91: {
                return 10;
            }
            case 93: 
            case 2014: {
                return JdbcColumn.columnPrecision(hiveType, columnAttributes);
            }
            case 6: {
                return 24;
            }
            case 8: {
                return 25;
            }
            case 3: {
                return JdbcColumn.columnPrecision(hiveType, columnAttributes) + 2;
            }
            case 1111: 
            case 2000: {
                return JdbcColumn.columnPrecision(hiveType, columnAttributes);
            }
            case 2002: 
            case 2003: {
                return Integer.MAX_VALUE;
            }
        }
        throw new SQLException("Invalid column type: " + columnType);
    }

    static int columnPrecision(Type hiveType, JdbcColumnAttributes columnAttributes) throws SQLException {
        int columnType = JdbcColumn.hiveTypeToSqlType(hiveType);
        switch (columnType) {
            case 0: {
                return 0;
            }
            case 16: {
                return 1;
            }
            case 1: 
            case 12: {
                if (columnAttributes != null) {
                    return columnAttributes.precision;
                }
                return Integer.MAX_VALUE;
            }
            case -2: {
                return Integer.MAX_VALUE;
            }
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case -5: {
                return 19;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 91: {
                return 10;
            }
            case 93: {
                return 29;
            }
            case 2014: {
                return 31;
            }
            case 3: {
                return columnAttributes.precision;
            }
            case 1111: 
            case 2000: {
                switch (hiveType) {
                    case INTERVAL_YEAR_MONTH_TYPE: {
                        return 11;
                    }
                    case INTERVAL_DAY_TIME_TYPE: {
                        return 29;
                    }
                }
                return Integer.MAX_VALUE;
            }
            case 2002: 
            case 2003: {
                return Integer.MAX_VALUE;
            }
        }
        throw new SQLException("Invalid column type: " + columnType);
    }

    static int columnScale(Type hiveType, JdbcColumnAttributes columnAttributes) throws SQLException {
        int columnType = JdbcColumn.hiveTypeToSqlType(hiveType);
        switch (columnType) {
            case -6: 
            case -5: 
            case -2: 
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 12: 
            case 16: 
            case 91: {
                return 0;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 93: 
            case 2014: {
                return 9;
            }
            case 3: {
                return columnAttributes.scale;
            }
            case 1111: 
            case 2000: 
            case 2002: 
            case 2003: {
                return 0;
            }
        }
        throw new SQLException("Invalid column type: " + columnType);
    }

    public Integer getNumPrecRadix() {
        String t;
        switch (t = this.type.toLowerCase()) {
            case "tinyint": 
            case "smallint": 
            case "int": 
            case "bigint": 
            case "float": 
            case "double": 
            case "decimal": {
                return 10;
            }
        }
        return null;
    }

    public String getComment() {
        return this.comment;
    }

    public int getOrdinalPos() {
        return this.ordinalPos;
    }
}

