/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforce;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransform;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransformData;
import org.w3c.dom.Node;

public abstract class SalesforceTransformMeta<Main extends SalesforceTransform, Data extends SalesforceTransformData>
extends BaseTransformMeta<Main, Data> {
    private static final Class<?> PKG = SalesforceTransformMeta.class;
    @Injection(name="SALESFORCE_URL")
    private String targetUrl;
    @Injection(name="SALESFORCE_USERNAME")
    private String username;
    @Injection(name="SALESFORCE_PASSWORD")
    private String password;
    @Injection(name="TIME_OUT")
    private String timeout;
    @Injection(name="USE_COMPRESSION")
    private boolean compression;
    @Injection(name="MODULE")
    private String module;

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    ").append(XmlHandler.addTagValue((String)"targeturl", (String)this.getTargetUrl()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"username", (String)this.getUsername()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword())));
        retval.append("    ").append(XmlHandler.addTagValue((String)"timeout", (String)this.getTimeout()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"useCompression", (boolean)this.isCompression()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"module", (String)this.getModule()));
        return retval.toString();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.setTargetUrl(XmlHandler.getTagValue((Node)transformNode, (String)"targeturl"));
        this.setUsername(XmlHandler.getTagValue((Node)transformNode, (String)"username"));
        this.setPassword(Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)transformNode, (String)"password")));
        this.setTimeout(XmlHandler.getTagValue((Node)transformNode, (String)"timeout"));
        this.setCompression("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"useCompression")));
        this.setModule(XmlHandler.getTagValue((Node)transformNode, (String)"module"));
    }

    public Object clone() {
        SalesforceTransformMeta retval = (SalesforceTransformMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.setTargetUrl("https://login.salesforce.com/services/Soap/u/50.0");
        this.setUsername("");
        this.setPassword("");
        this.setTimeout("60000");
        this.setCompression(false);
        this.setModule("Account");
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = Utils.isEmpty((CharSequence)this.getTargetUrl()) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceTransformMeta.CheckResult.NoURL", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceTransformMeta.CheckResult.URLOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = Utils.isEmpty((CharSequence)this.getUsername()) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceTransformMeta.CheckResult.NoUsername", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceTransformMeta.CheckResult.UsernameOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = Utils.isEmpty((CharSequence)this.getModule()) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceTransformMeta.CheckResult.NoModule", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceTransformMeta.CheckResult.ModuleOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public boolean isCompression() {
        return this.compression;
    }

    public void setCompression(boolean compression) {
        this.compression = compression;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }
}

