/*
 * Decompiled with CFR 0.152.
 */
package com.knuddels.jtokkit;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

final class SpecialEncoder {
    private static final String SPECIAL_START = "<|";
    private static final String SPECIAL_END = "|>";
    private final Map<Integer, String> encodedToDecoded;

    SpecialEncoder(Map<String, Integer> encoder) {
        this.encodedToDecoded = new HashMap<Integer, String>(encoder.size());
        for (Map.Entry<String, Integer> entry : encoder.entrySet()) {
            String key = entry.getKey();
            Integer value = entry.getValue();
            assert (key.contains(SPECIAL_START) && key.contains(SPECIAL_END)) : "Special tokens must contain <| and |> (but was " + key + ")";
            this.encodedToDecoded.put(value, key);
        }
    }

    byte[] decodeIfPresent(Integer encodedToken) {
        String result = this.encodedToDecoded.get(encodedToken);
        return result != null ? result.getBytes(StandardCharsets.UTF_8) : null;
    }

    void checkForSpecialTokens(String text) {
        if (text.contains(SPECIAL_START) && text.contains(SPECIAL_END)) {
            for (String specialToken : this.encodedToDecoded.values()) {
                if (!text.contains(specialToken)) continue;
                throw new UnsupportedOperationException("Encoding special tokens is not supported.");
            }
        }
    }
}

