/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.owasp.encoder.Encode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@XmlRootElement
public class TransformStatus {
    public static final String XML_TAG = "transform_status";
    private static final String CONST_SAMPLES = "samples";
    private String transformName;
    private int copy;
    private long linesRead;
    private long linesWritten;
    private long linesInput;
    private long linesOutput;
    private long linesUpdated;
    private long linesRejected;
    private long inputBufferSize;
    private long outputBufferSize;
    private long errors;
    private String statusDescription;
    private double seconds;
    private String speed;
    private String priority;
    private boolean stopped;
    private boolean paused;
    private long accumulatedRuntime;
    private IRowMeta sampleRowMeta;
    private List<Object[]> sampleRows;
    private final DecimalFormat speedDf = new DecimalFormat("#,###,###,###,##0");

    public TransformStatus() {
        this.sampleRows = Collections.synchronizedList(new LinkedList());
    }

    public TransformStatus(IEngineComponent component) {
        this.updateAll(component);
    }

    public synchronized void updateAll(IEngineComponent component) {
        this.transformName = component.getName();
        this.copy = component.getCopyNr();
        this.linesRead += component.getLinesRead();
        this.linesWritten += component.getLinesWritten();
        this.linesInput += component.getLinesInput();
        this.linesOutput += component.getLinesOutput();
        this.linesUpdated += component.getLinesUpdated();
        this.linesRejected += component.getLinesRejected();
        this.errors += component.getErrors();
        this.accumulatedRuntime += component.getExecutionDuration();
        this.statusDescription = component.getStatusDescription();
        long inProc = Math.max(this.linesInput, this.linesRead);
        long outProc = Math.max(this.linesOutput + this.linesUpdated, this.linesWritten + this.linesRejected);
        float lapsed = (float)this.accumulatedRuntime / 1000.0f;
        double inSpeed = 0.0;
        double outSpeed = 0.0;
        if (lapsed != 0.0f) {
            inSpeed = Math.floor(10.0f * ((float)inProc / lapsed)) / 10.0;
            outSpeed = Math.floor(10.0f * ((float)outProc / lapsed)) / 10.0;
        }
        double speedNumber = inSpeed > outSpeed ? inSpeed : outSpeed;
        this.seconds = Math.floor((double)(lapsed * 10.0f) + 0.5) / 10.0;
        this.speed = lapsed == 0.0f ? "-" : " " + this.speedDf.format(speedNumber);
        this.priority = component.isRunning() ? "   " + component.getInputBufferSize() + "/" + component.getOutputBufferSize() : "-";
        this.stopped = component.isStopped();
        this.paused = component.isPaused();
        this.inputBufferSize += component.getInputBufferSize();
        this.outputBufferSize += component.getOutputBufferSize();
    }

    public String getHTMLTableRow(boolean urlInTransformName) {
        return "<tr> <th>" + (urlInTransformName ? this.transformName : Encode.forHtml((String)this.transformName)) + "</th> <th>" + this.copy + "</th> <th>" + this.linesRead + "</th> <th>" + this.linesWritten + "</th> <th>" + this.linesInput + "</th> <th>" + this.linesOutput + "</th> <th>" + this.linesUpdated + "</th> <th>" + this.linesRejected + "</th> <th>" + this.errors + "</th> <th>" + Encode.forHtml((String)this.statusDescription) + "</th> <th>" + this.seconds + "</th> <th>" + Encode.forHtml((String)this.speed) + "</th> <th>" + Encode.forHtml((String)this.priority) + "</th> </tr>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public String getXml() throws HopException {
        try {
            StringBuilder xml = new StringBuilder();
            xml.append(XmlHandler.openTag((String)XML_TAG));
            xml.append(XmlHandler.addTagValue((String)"transformName", (String)this.transformName, (boolean)false, (String[])new String[0]));
            xml.append(XmlHandler.addTagValue((String)"copy", (int)this.copy, (boolean)false));
            xml.append(XmlHandler.addTagValue((String)"linesRead", (long)this.linesRead, (boolean)false));
            xml.append(XmlHandler.addTagValue((String)"linesWritten", (long)this.linesWritten, (boolean)false));
            xml.append(XmlHandler.addTagValue((String)"linesInput", (long)this.linesInput, (boolean)false));
            xml.append(XmlHandler.addTagValue((String)"linesOutput", (long)this.linesOutput, (boolean)false));
            xml.append(XmlHandler.addTagValue((String)"linesUpdated", (long)this.linesUpdated, (boolean)false));
            xml.append(XmlHandler.addTagValue((String)"linesRejected", (long)this.linesRejected, (boolean)false));
            xml.append(XmlHandler.addTagValue((String)"errors", (long)this.errors, (boolean)false));
            xml.append(XmlHandler.addTagValue((String)"input_buffer_size", (long)this.inputBufferSize, (boolean)false));
            xml.append(XmlHandler.addTagValue((String)"output_buffer_size", (long)this.outputBufferSize, (boolean)false));
            xml.append(XmlHandler.addTagValue((String)"statusDescription", (String)this.statusDescription, (boolean)false, (String[])new String[0]));
            xml.append(XmlHandler.addTagValue((String)"seconds", (double)this.seconds, (boolean)false));
            xml.append(XmlHandler.addTagValue((String)"speed", (String)this.speed, (boolean)false, (String[])new String[0]));
            xml.append(XmlHandler.addTagValue((String)"priority", (String)this.priority, (boolean)false, (String[])new String[0]));
            xml.append(XmlHandler.addTagValue((String)"stopped", (boolean)this.stopped, (boolean)false));
            xml.append(XmlHandler.addTagValue((String)"paused", (boolean)this.paused, (boolean)false));
            if (this.sampleRowMeta != null) {
                xml.append(XmlHandler.openTag((String)CONST_SAMPLES));
                xml.append(this.sampleRowMeta.getMetaXml());
                xml.append(Const.CR);
                if (this.sampleRows != null) {
                    List<Object[]> list = this.sampleRows;
                    synchronized (list) {
                        for (Object[] sampleRow : this.sampleRows) {
                            xml.append(this.sampleRowMeta.getDataXml(sampleRow));
                            xml.append(Const.CR);
                        }
                    }
                }
                xml.append(XmlHandler.closeTag((String)CONST_SAMPLES));
            }
            xml.append(XmlHandler.closeTag((String)XML_TAG));
            return xml.toString();
        }
        catch (Exception e) {
            throw new HopException("Unable to serialize transform '" + this.transformName + "' status data to XML", (Throwable)e);
        }
    }

    public TransformStatus(Node node) throws HopException {
        Node rowMetaNode;
        this.transformName = XmlHandler.getTagValue((Node)node, (String)"transformName");
        this.copy = Integer.parseInt(XmlHandler.getTagValue((Node)node, (String)"copy"));
        this.linesRead = Long.parseLong(XmlHandler.getTagValue((Node)node, (String)"linesRead"));
        this.linesWritten = Long.parseLong(XmlHandler.getTagValue((Node)node, (String)"linesWritten"));
        this.linesInput = Long.parseLong(XmlHandler.getTagValue((Node)node, (String)"linesInput"));
        this.linesOutput = Long.parseLong(XmlHandler.getTagValue((Node)node, (String)"linesOutput"));
        this.linesUpdated = Long.parseLong(XmlHandler.getTagValue((Node)node, (String)"linesUpdated"));
        this.linesRejected = Long.parseLong(XmlHandler.getTagValue((Node)node, (String)"linesRejected"));
        this.errors = Long.parseLong(XmlHandler.getTagValue((Node)node, (String)"errors"));
        this.inputBufferSize = Long.parseLong(XmlHandler.getTagValue((Node)node, (String)"input_buffer_size"));
        this.outputBufferSize = Long.parseLong(XmlHandler.getTagValue((Node)node, (String)"output_buffer_size"));
        this.statusDescription = XmlHandler.getTagValue((Node)node, (String)"statusDescription");
        this.seconds = Double.parseDouble(XmlHandler.getTagValue((Node)node, (String)"seconds"));
        this.speed = XmlHandler.getTagValue((Node)node, (String)"speed");
        this.priority = XmlHandler.getTagValue((Node)node, (String)"priority");
        this.stopped = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)node, (String)"stopped"));
        this.paused = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)node, (String)"paused"));
        Node samplesNode = XmlHandler.getSubNode((Node)node, (String)CONST_SAMPLES);
        if (samplesNode != null && (rowMetaNode = XmlHandler.getSubNode((Node)samplesNode, (String)"row-meta")) != null) {
            this.sampleRowMeta = new RowMeta(rowMetaNode);
            this.sampleRows = new ArrayList<Object[]>();
            List dataNodes = XmlHandler.getNodes((Node)samplesNode, (String)"row-data");
            for (Node dataNode : dataNodes) {
                Object[] sampleRow = this.sampleRowMeta.getRow(dataNode);
                this.sampleRows.add(sampleRow);
            }
        }
    }

    public TransformStatus fromXml(String xml) throws HopException {
        Document document = XmlHandler.loadXmlString((String)xml);
        return new TransformStatus(XmlHandler.getSubNode((Node)document, (String)XML_TAG));
    }

    @JsonIgnore
    public String[] getPipelineLogFields() {
        return this.getPipelineLogFields(this.statusDescription);
    }

    public String[] getPipelineLogFields(String overrideDescription) {
        return new String[]{"", this.transformName, Integer.toString(this.copy), Long.toString(this.linesRead), Long.toString(this.linesWritten), Long.toString(this.linesInput), Long.toString(this.linesOutput), Long.toString(this.linesUpdated), Long.toString(this.linesRejected), Long.toString(this.errors), overrideDescription, this.convertSeconds(this.seconds), this.speed, this.priority};
    }

    private String convertSeconds(double seconds) {
        String retval = seconds + "s";
        if (seconds < 60.0) {
            return retval;
        }
        double donnee = seconds;
        int mn = (int)donnee / 60;
        int h = mn / 60;
        int s = (int)donnee % 60;
        retval = h > 0 ? h + "h " + mn + "mn " + s + "s" : (mn > 0 ? (mn %= 60) + "mn " + s + "s" : seconds + "s");
        return retval;
    }

    @JsonIgnore
    public String[] getPeekFields() {
        return new String[]{Integer.toString(this.copy), Long.toString(this.linesRead), Long.toString(this.linesWritten), Long.toString(this.linesInput), Long.toString(this.linesOutput), Long.toString(this.linesUpdated), Long.toString(this.linesRejected), Long.toString(this.errors), this.statusDescription, this.convertSeconds(this.seconds), this.speed, this.priority};
    }

    public int getCopy() {
        return this.copy;
    }

    public void setCopy(int copy) {
        this.copy = copy;
    }

    public long getErrors() {
        return this.errors;
    }

    public void setErrors(long errors) {
        this.errors = errors;
    }

    public long getLinesInput() {
        return this.linesInput;
    }

    public void setLinesInput(long linesInput) {
        this.linesInput = linesInput;
    }

    public long getLinesOutput() {
        return this.linesOutput;
    }

    public void setLinesOutput(long linesOutput) {
        this.linesOutput = linesOutput;
    }

    public long getLinesRead() {
        return this.linesRead;
    }

    public void setLinesRead(long linesRead) {
        this.linesRead = linesRead;
    }

    public long getLinesUpdated() {
        return this.linesUpdated;
    }

    public void setLinesUpdated(long linesUpdated) {
        this.linesUpdated = linesUpdated;
    }

    public long getLinesWritten() {
        return this.linesWritten;
    }

    public void setLinesWritten(long linesWritten) {
        this.linesWritten = linesWritten;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public double getSeconds() {
        return this.seconds;
    }

    public void setSeconds(double seconds) {
        this.seconds = seconds;
    }

    public String getSpeed() {
        return this.speed;
    }

    public void setSpeed(String speed) {
        this.speed = speed;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public String getTransformName() {
        return this.transformName;
    }

    public void setTransformName(String transformName) {
        this.transformName = transformName;
    }

    public long getLinesRejected() {
        return this.linesRejected;
    }

    public void setLinesRejected(long linesRejected) {
        this.linesRejected = linesRejected;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public IRowMeta getSampleRowMeta() {
        return this.sampleRowMeta;
    }

    public void setSampleRowMeta(IRowMeta sampleRowMeta) {
        this.sampleRowMeta = sampleRowMeta;
    }

    public List<Object[]> getSampleRows() {
        return this.sampleRows;
    }

    public void setSampleRows(List<Object[]> sampleRows) {
        this.sampleRows = sampleRows;
    }

    public long getInputBufferSize() {
        return this.inputBufferSize;
    }

    public void setInputBufferSize(long inputBufferSize) {
        this.inputBufferSize = inputBufferSize;
    }

    public long getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public void setOutputBufferSize(long outputBufferSize) {
        this.outputBufferSize = outputBufferSize;
    }
}

