/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.proton.transport.proxy.impl;

import com.microsoft.azure.proton.transport.proxy.ProxyChallengeProcessor;
import com.microsoft.azure.proton.transport.proxy.impl.Constants;
import com.microsoft.azure.proton.transport.proxy.impl.ProxyAuthenticator;
import java.net.PasswordAuthentication;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class BasicProxyChallengeProcessorImpl
implements ProxyChallengeProcessor {
    private final ProxyAuthenticator proxyAuthenticator;
    private final Map<String, String> headers;
    private String host;

    BasicProxyChallengeProcessorImpl(String host, ProxyAuthenticator proxyAuthenticator) {
        Objects.requireNonNull(host);
        Objects.requireNonNull(proxyAuthenticator);
        this.host = host;
        this.headers = new HashMap<String, String>();
        this.proxyAuthenticator = proxyAuthenticator;
    }

    @Override
    public Map<String, String> getHeader() {
        PasswordAuthentication passwordAuthentication = this.proxyAuthenticator.getPasswordAuthentication(Constants.BASIC_LOWERCASE, this.host);
        if (!ProxyAuthenticator.isPasswordAuthenticationHasValues(passwordAuthentication)) {
            return null;
        }
        String proxyUserName = passwordAuthentication.getUserName();
        String proxyPassword = new String(passwordAuthentication.getPassword());
        String usernamePasswordPair = String.join((CharSequence)":", proxyUserName, proxyPassword);
        this.headers.put("Proxy-Authorization", String.join((CharSequence)" ", "Basic", Base64.getEncoder().encodeToString(usernamePasswordPair.getBytes(StandardCharsets.UTF_8))));
        return this.headers;
    }
}

