/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.javafilter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transforms.javafilter.JavaFilterData;
import org.apache.hop.pipeline.transforms.javafilter.JavaFilterMeta;
import org.apache.hop.pipeline.transforms.util.JaninoCheckerUtil;
import org.codehaus.janino.ExpressionEvaluator;

public class JavaFilter
extends BaseTransform<JavaFilterMeta, JavaFilterData> {
    private static final Class<?> PKG = JavaFilterMeta.class;

    public JavaFilter(TransformMeta transformMeta, JavaFilterMeta meta, JavaFilterData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((JavaFilterData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((JavaFilterMeta)this.meta).getFields(((JavaFilterData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            if (((JavaFilterData)this.data).chosesTargetTransforms) {
                PipelineHopMeta hop;
                TransformMeta to;
                List targetStreams = ((JavaFilterMeta)this.meta).getTransformIOMeta().getTargetStreams();
                if (!Utils.isEmpty((CharSequence)((IStream)targetStreams.get(0)).getTransformName())) {
                    to = ((IStream)targetStreams.get(0)).getTransformMeta();
                    hop = this.getPipelineMeta().findPipelineHop(this.getTransformMeta(), to);
                    if (hop != null && hop.isEnabled()) {
                        ((JavaFilterData)this.data).trueRowSet = this.findOutputRowSet(this.getTransformName(), this.getCopy(), ((IStream)targetStreams.get(0)).getTransformName(), 0);
                        if (((JavaFilterData)this.data).trueRowSet == null) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"JavaFilter.Log.TargetTransformInvalid", (String[])new String[]{((IStream)targetStreams.get(0)).getTransformName()}));
                        }
                    }
                } else {
                    ((JavaFilterData)this.data).trueRowSet = null;
                }
                if (!Utils.isEmpty((CharSequence)((IStream)targetStreams.get(1)).getTransformName())) {
                    to = ((IStream)targetStreams.get(1)).getTransformMeta();
                    hop = this.getPipelineMeta().findPipelineHop(this.getTransformMeta(), to);
                    if (hop != null && hop.isEnabled()) {
                        ((JavaFilterData)this.data).falseRowSet = this.findOutputRowSet(this.getTransformName(), this.getCopy(), ((IStream)targetStreams.get(1)).getTransformName(), 0);
                        if (((JavaFilterData)this.data).falseRowSet == null) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"JavaFilter.Log.TargetTransformInvalid", (String[])new String[]{((IStream)targetStreams.get(1)).getTransformName()}));
                        }
                    }
                } else {
                    ((JavaFilterData)this.data).falseRowSet = null;
                }
            }
        }
        if (this.isRowLevel()) {
            this.logRowlevel("Read row #" + this.getLinesRead() + " : " + this.getInputRowMeta().getString(r));
        }
        boolean keep = this.calcFields(r);
        if (!((JavaFilterData)this.data).chosesTargetTransforms) {
            if (keep) {
                this.putRow(((JavaFilterData)this.data).outputRowMeta, r);
            }
        } else if (keep) {
            if (((JavaFilterData)this.data).trueRowSet != null) {
                if (this.isRowLevel()) {
                    this.logRowlevel("Sending row to true  :" + ((JavaFilterData)this.data).trueTransformName + " : " + this.getInputRowMeta().getString(r));
                }
                this.putRowTo(((JavaFilterData)this.data).outputRowMeta, r, ((JavaFilterData)this.data).trueRowSet);
            }
        } else if (((JavaFilterData)this.data).falseRowSet != null) {
            if (this.isRowLevel()) {
                this.logRowlevel("Sending row to false :" + ((JavaFilterData)this.data).falseTransformName + " : " + this.getInputRowMeta().getString(r));
            }
            this.putRowTo(((JavaFilterData)this.data).outputRowMeta, r, ((JavaFilterData)this.data).falseRowSet);
        }
        if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"JavaFilter.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    private boolean calcFields(Object[] r) throws HopValueException {
        try {
            if (((JavaFilterData)this.data).expressionEvaluator == null) {
                String realCondition = this.resolve(((JavaFilterMeta)this.meta).getCondition());
                ((JavaFilterData)this.data).argumentIndexes = new ArrayList<Integer>();
                ArrayList<String> parameterNames = new ArrayList<String>();
                ArrayList<Class<String>> parameterTypes = new ArrayList<Class<String>>();
                for (int i = 0; i < ((JavaFilterData)this.data).outputRowMeta.size(); ++i) {
                    IValueMeta valueMeta = ((JavaFilterData)this.data).outputRowMeta.getValueMeta(i);
                    if (!realCondition.contains(valueMeta.getName())) continue;
                    ((JavaFilterData)this.data).argumentIndexes.add(i);
                    parameterTypes.add(switch (valueMeta.getType()) {
                        case 2 -> String.class;
                        case 1 -> Double.class;
                        case 5 -> Long.class;
                        case 3 -> Date.class;
                        case 6 -> BigDecimal.class;
                        case 4 -> Boolean.class;
                        case 8 -> byte[].class;
                        default -> String.class;
                    });
                    parameterNames.add(valueMeta.getName());
                }
                ((JavaFilterData)this.data).expressionEvaluator = new ExpressionEvaluator();
                ((JavaFilterData)this.data).expressionEvaluator.setParameters(parameterNames.toArray(new String[parameterNames.size()]), parameterTypes.toArray(new Class[parameterTypes.size()]));
                ((JavaFilterData)this.data).expressionEvaluator.setReturnType(Object.class);
                ((JavaFilterData)this.data).expressionEvaluator.setThrownExceptions(new Class[]{Exception.class});
                JaninoCheckerUtil janinoCheckerUtil = new JaninoCheckerUtil();
                List<String> codeCheck = janinoCheckerUtil.checkCode(realCondition);
                if (!codeCheck.isEmpty()) {
                    throw new HopException("Script contains code that is not allowed : " + codeCheck);
                }
                ((JavaFilterData)this.data).expressionEvaluator.cook(realCondition);
                ((JavaFilterData)this.data).argumentData = new Object[((JavaFilterData)this.data).argumentIndexes.size()];
            }
            for (int x = 0; x < ((JavaFilterData)this.data).argumentIndexes.size(); ++x) {
                int index = ((JavaFilterData)this.data).argumentIndexes.get(x);
                IValueMeta outputValueMeta = ((JavaFilterData)this.data).outputRowMeta.getValueMeta(index);
                ((JavaFilterData)this.data).argumentData[x] = outputValueMeta.convertToNormalStorageType(r[index]);
            }
            Object formulaResult = ((JavaFilterData)this.data).expressionEvaluator.evaluate(((JavaFilterData)this.data).argumentData);
            if (formulaResult instanceof Boolean) {
                Boolean bool = (Boolean)formulaResult;
                return bool;
            }
            throw new HopException("The result of the filter expression must be a boolean and we got back : " + formulaResult.getClass().getName());
        }
        catch (Exception e) {
            throw new HopValueException((Throwable)e);
        }
    }

    public boolean init() {
        if (super.init()) {
            List targetStreams = ((JavaFilterMeta)this.meta).getTransformIOMeta().getTargetStreams();
            ((JavaFilterData)this.data).trueTransformName = ((IStream)targetStreams.get(0)).getTransformName();
            ((JavaFilterData)this.data).falseTransformName = ((IStream)targetStreams.get(1)).getTransformName();
            if (((IStream)targetStreams.get(0)).getTransformMeta() != null ^ ((IStream)targetStreams.get(1)).getTransformMeta() != null) {
                this.logError(BaseMessages.getString(PKG, (String)"JavaFilter.Log.BothTrueAndFalseNeeded", (String[])new String[0]));
            } else {
                ((JavaFilterData)this.data).chosesTargetTransforms = ((IStream)targetStreams.get(0)).getTransformMeta() != null && ((IStream)targetStreams.get(1)).getTransformMeta() != null;
                return true;
            }
        }
        return false;
    }
}

