/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import org.snmp4j.User;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class UsmUser
implements User,
Comparable,
Cloneable {
    private static final long serialVersionUID = -2258973598142206767L;
    private OctetString securityName;
    private OctetString authenticationPassphrase;
    private OctetString privacyPassphrase;
    private OID authenticationProtocol;
    private OID privacyProtocol;
    private OctetString localizationEngineID;

    public UsmUser(OctetString octetString, OID oID, OctetString octetString2, OID oID2, OctetString octetString3) {
        if (octetString == null) {
            throw new NullPointerException();
        }
        if (oID != null && octetString2 != null && octetString2.length() < 8) {
            throw new IllegalArgumentException("USM passphrases must be at least 8 bytes long (RFC3414 \u00a711.2)");
        }
        if (oID2 != null && octetString3 != null && octetString3.length() < 8) {
            throw new IllegalArgumentException("USM passphrases must be at least 8 bytes long (RFC3414 \u00a711.2)");
        }
        this.securityName = octetString;
        this.authenticationProtocol = oID;
        this.authenticationPassphrase = octetString2;
        this.privacyProtocol = oID2;
        this.privacyPassphrase = octetString3;
    }

    public UsmUser(OctetString octetString, OID oID, OctetString octetString2, OID oID2, OctetString octetString3, OctetString octetString4) {
        this(octetString, oID, octetString2, oID2, octetString3);
        this.localizationEngineID = octetString4;
    }

    public OctetString getSecurityName() {
        return (OctetString)this.securityName.clone();
    }

    public OID getAuthenticationProtocol() {
        if (this.authenticationProtocol == null) {
            return null;
        }
        return (OID)this.authenticationProtocol.clone();
    }

    public OID getPrivacyProtocol() {
        if (this.privacyProtocol == null) {
            return null;
        }
        return (OID)this.privacyProtocol.clone();
    }

    public OctetString getAuthenticationPassphrase() {
        if (this.authenticationPassphrase == null) {
            return null;
        }
        return (OctetString)this.authenticationPassphrase.clone();
    }

    public OctetString getPrivacyPassphrase() {
        if (this.privacyPassphrase == null) {
            return null;
        }
        return (OctetString)this.privacyPassphrase.clone();
    }

    public OctetString getLocalizationEngineID() {
        return this.localizationEngineID;
    }

    public boolean isLocalized() {
        return this.localizationEngineID != null;
    }

    public int getSecurityModel() {
        return 3;
    }

    public int compareTo(Object object) {
        UsmUser usmUser = (UsmUser)object;
        return this.securityName.compareTo(usmUser.securityName);
    }

    public Object clone() {
        UsmUser usmUser = new UsmUser(this.securityName, this.authenticationProtocol, this.authenticationPassphrase, this.privacyProtocol, this.privacyPassphrase, this.localizationEngineID);
        return usmUser;
    }

    public String toString() {
        return "UsmUser[secName=" + this.securityName + ",authProtocol=" + this.authenticationProtocol + ",authPassphrase=" + this.authenticationPassphrase + ",privProtocol=" + this.privacyProtocol + ",privPassphrase=" + this.privacyPassphrase + ",localizationEngineID=" + this.getLocalizationEngineID() + "]";
    }
}

