/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.row;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.commons.codec.language.DoubleMetaphone;
import org.apache.commons.codec.language.Metaphone;
import org.apache.commons.codec.language.RefinedSoundex;
import org.apache.commons.codec.language.Soundex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopFileNotFoundException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.fileinput.CharsetToolkit;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.HopJaroWinklerDistance;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlCheck;

public class ValueDataUtil {
    private static final Log log = LogFactory.getLog(ValueDataUtil.class);
    private static final String CONST_ROUND_ONLY_WORK_ON_NUMERIC = "The 'round' function only works on numeric data";
    private static final String SYS_PROPERTY_ROUND_2_MODE = "ROUND_2_MODE";
    private static final String SYS_PROPERTY_ROUND_2_MODE_DEFAULT_VALUE = "ROUND_HALF_CEILING";
    private static final int ROUND_2_MODE_DEFAULT_VALUE = -1;
    private static final String SYS_PROPERTY_ROUND_2_MODE_BACKWARD_COMPATIBILITY_VALUE = "ROUND_HALF_EVEN";
    private static final int ROUND_2_MODE_BACKWARD_COMPATIBILITY_VALUE = 6;
    private static final int ROUND_2_MODE = ValueDataUtil.readRound2Mode();

    private static int readRound2Mode() {
        int round2Mode = -1;
        String rpaValue = System.getProperty(SYS_PROPERTY_ROUND_2_MODE);
        if (Utils.isEmpty(rpaValue)) {
            log.debug((Object)"System property is omitted: ROUND_2_MODE. Default value used: ROUND_HALF_CEILING.");
        } else if (SYS_PROPERTY_ROUND_2_MODE_DEFAULT_VALUE.equals(rpaValue)) {
            log.debug((Object)"System property read: ROUND_2_MODE=-1 (default value)");
        } else if (SYS_PROPERTY_ROUND_2_MODE_BACKWARD_COMPATIBILITY_VALUE.equalsIgnoreCase(rpaValue)) {
            round2Mode = 6;
            log.debug((Object)"System property read: ROUND_2_MODE=ROUND_HALF_EVEN (backward compatibility value)");
        } else {
            log.warn((Object)("Incorrect value of system property read: ROUND_2_MODE=" + rpaValue + ". Set to ROUND_HALF_CEILING instead."));
        }
        return round2Mode;
    }

    private static void throwsErrorOnFileNotFound(FileObject file) throws HopFileNotFoundException, FileSystemException {
        if (file == null || !file.exists()) {
            throw new HopFileNotFoundException("File not found", file.getName().getPath());
        }
    }

    public static Long getLevenshtein_Distance(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) {
        if (dataA == null || dataB == null) {
            return null;
        }
        return StringUtils.getLevenshteinDistance((String)dataA.toString(), (String)dataB.toString());
    }

    public static Long getDamerauLevenshtein_Distance(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) {
        if (dataA == null || dataB == null) {
            return null;
        }
        return Utils.getDamerauLevenshteinDistance(dataA.toString(), dataB.toString());
    }

    public static Double getJaro_Similitude(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) {
        if (dataA == null || dataB == null) {
            return null;
        }
        HopJaroWinklerDistance pjwd = new HopJaroWinklerDistance();
        pjwd.apply(dataA.toString(), dataB.toString());
        return pjwd.getJaroDistance();
    }

    public static Double getJaroWinkler_Similitude(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) {
        if (dataA == null || dataB == null) {
            return null;
        }
        HopJaroWinklerDistance pjwd = new HopJaroWinklerDistance();
        pjwd.apply(dataA.toString(), dataB.toString());
        return pjwd.getJaroWinklerDistance();
    }

    public static String get_Metaphone(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return new Metaphone().metaphone(dataA.toString());
    }

    public static String get_Double_Metaphone(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return new DoubleMetaphone().doubleMetaphone(dataA.toString());
    }

    public static String get_SoundEx(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return new Soundex().encode(dataA.toString());
    }

    public static String get_RefinedSoundEx(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return new RefinedSoundex().encode(dataA.toString());
    }

    public static String initCap(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return WordUtils.capitalizeFully((String)dataA.toString(), (char[])new char[]{' ', '_', ',', ':', ';', '-'});
    }

    public static String upperCase(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return dataA.toString().toUpperCase();
    }

    public static String lowerCase(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return dataA.toString().toLowerCase();
    }

    public static String escapeXml(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.escapeXml(dataA.toString());
    }

    public static String unEscapeXml(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.unEscapeXml(dataA.toString());
    }

    public static String escapeHtml(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.escapeHtml(dataA.toString());
    }

    public static String unEscapeHtml(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.unEscapeHtml(dataA.toString());
    }

    public static String escapeSql(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.escapeSql(dataA.toString());
    }

    public static String useCDATA(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return "<![CDATA[" + dataA + "]]>";
    }

    public static String removeCR(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.removeCR(dataA.toString());
    }

    public static String removeLF(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.removeLF(dataA.toString());
    }

    public static String removeCRLF(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.removeCRLF(dataA.toString());
    }

    public static String removeTAB(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.removeTAB(dataA.toString());
    }

    public static String getDigits(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.getDigitsOnly(dataA.toString());
    }

    public static String removeDigits(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.removeDigits(dataA.toString());
    }

    public static long stringLen(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return 0L;
        }
        return dataA.toString().length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String createChecksum(IValueMeta metaA, Object dataA, String type, boolean failIfNoFile) throws HopFileNotFoundException {
        if (dataA == null) {
            return null;
        }
        String md5Hash = null;
        FileObject file = null;
        InputStream in = null;
        try {
            file = HopVfs.getFileObject(dataA.toString());
            ValueDataUtil.throwsErrorOnFileNotFound(file);
            in = HopVfs.getInputStream(file);
            int bytes = in.available();
            byte[] buffer = new byte[bytes];
            in.read(buffer);
            StringBuffer md5HashBuff = new StringBuffer(32);
            byte[] b = MessageDigest.getInstance(type).digest(buffer);
            int len = b.length;
            for (int x = 0; x < len; ++x) {
                md5HashBuff.append(String.format("%02x", b[x]));
            }
            md5Hash = md5HashBuff.toString();
        }
        catch (HopFileNotFoundException e) {
            if (failIfNoFile) {
                throw e;
            }
            log.debug((Object)e.getMessage());
            IOUtils.closeQuietly((Closeable)file);
            IOUtils.closeQuietly((InputStream)in);
        }
        catch (Exception e2) {
            log.debug((Object)e2.getMessage());
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((Closeable)file);
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)file);
            IOUtils.closeQuietly((InputStream)in);
        }
        IOUtils.closeQuietly((Closeable)file);
        IOUtils.closeQuietly((InputStream)in);
        return md5Hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Long checksumCRC32(IValueMeta metaA, Object dataA, boolean failIfNoFile) throws HopFileNotFoundException {
        long checksum;
        block10: {
            checksum = 0L;
            if (dataA == null) {
                return checksum;
            }
            FileObject file = null;
            CheckedInputStream cis = null;
            try {
                file = HopVfs.getFileObject(dataA.toString());
                ValueDataUtil.throwsErrorOnFileNotFound(file);
                cis = new CheckedInputStream(HopVfs.getInputStream(file), new CRC32());
                byte[] buf = new byte[128];
                int readSize = 0;
                while ((readSize = cis.read(buf)) >= 0) {
                }
                checksum = cis.getChecksum().getValue();
                IOUtils.closeQuietly((Closeable)file);
            }
            catch (HopFileNotFoundException e) {
                if (failIfNoFile) {
                    throw e;
                }
                log.debug((Object)e.getMessage());
                break block10;
            }
            catch (Exception e2) {
                log.debug((Object)e2.getMessage());
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)file);
                IOUtils.closeQuietly(cis);
            }
            IOUtils.closeQuietly((InputStream)cis);
        }
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Long checksumAdler32(IValueMeta metaA, Object dataA, boolean failIfNoFile) throws HopFileNotFoundException {
        long checksum;
        block10: {
            checksum = 0L;
            if (dataA == null) {
                return checksum;
            }
            FileObject file = null;
            CheckedInputStream cis = null;
            try {
                file = HopVfs.getFileObject(dataA.toString());
                ValueDataUtil.throwsErrorOnFileNotFound(file);
                cis = new CheckedInputStream(HopVfs.getInputStream(file), new Adler32());
                byte[] buf = new byte[128];
                int readSize = 0;
                while ((readSize = cis.read(buf)) >= 0) {
                }
                checksum = cis.getChecksum().getValue();
                IOUtils.closeQuietly((Closeable)file);
            }
            catch (HopFileNotFoundException e) {
                if (failIfNoFile) {
                    throw e;
                }
                log.debug((Object)e.getMessage());
                break block10;
            }
            catch (Exception e2) {
                log.debug((Object)e2.getMessage());
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)file);
                IOUtils.closeQuietly(cis);
            }
            IOUtils.closeQuietly((InputStream)cis);
        }
        return checksum;
    }

    public static Object plus(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) throws HopValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 2: {
                return metaA.getString(dataA) + metaB.getString(dataB);
            }
            case 1: {
                Double valueA = metaA.getNumber(dataA);
                Double valueB = metaB.getNumber(dataB);
                if (valueB == null) {
                    return valueA;
                }
                if (valueA == null) {
                    return valueB;
                }
                return valueA + valueB;
            }
            case 5: {
                Long valueA = metaA.getInteger(dataA);
                Long valueB = metaB.getInteger(dataB);
                if (valueB == null) {
                    return valueA;
                }
                if (valueA == null) {
                    return valueB;
                }
                return valueA + valueB;
            }
            case 4: {
                Boolean valueA = metaA.getBoolean(dataA);
                Boolean valueB = metaB.getBoolean(dataB);
                if (valueB == null) {
                    return valueA;
                }
                if (valueA == null) {
                    return valueB;
                }
                return valueA != false || valueB != false;
            }
            case 6: {
                BigDecimal valueA = metaA.getBigNumber(dataA);
                BigDecimal valueB = metaB.getBigNumber(dataB);
                if (valueB == null) {
                    return valueA;
                }
                if (valueA == null) {
                    return valueB;
                }
                return valueA.add(valueB);
            }
        }
        throw new HopValueException("The 'plus' function only works on numeric data and Strings.");
    }

    public static Object plus3(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB, IValueMeta metaC, Object dataC) throws HopValueException {
        if (dataA == null || dataB == null || dataC == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 2: {
                return metaA.getString(dataA) + metaB.getString(dataB) + metaC.getString(dataC);
            }
            case 1: {
                return metaA.getNumber(dataA) + metaB.getNumber(dataB) + metaC.getNumber(dataC);
            }
            case 5: {
                return metaA.getInteger(dataA) + metaB.getInteger(dataB) + metaC.getInteger(dataC);
            }
            case 4: {
                return metaA.getBoolean(dataA) != false || metaB.getBoolean(dataB) != false || metaB.getBoolean(dataC) != false;
            }
            case 6: {
                return metaA.getBigNumber(dataA).add(metaB.getBigNumber(dataB).add(metaC.getBigNumber(dataC)));
            }
        }
        throw new HopValueException("The 'plus' function only works on numeric data and Strings.");
    }

    public static Object sum(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) throws HopValueException {
        if (dataA == null && dataB == null) {
            return null;
        }
        if (dataA == null && dataB != null) {
            Object value = metaA.convertData(metaB, dataB);
            metaA.setStorageType(0);
            return value;
        }
        if (dataA != null && dataB == null) {
            return dataA;
        }
        return ValueDataUtil.plus(metaA, dataA, metaB, dataB);
    }

    /*
     * Loose catch block
     */
    public static byte[] loadFileContentInBinary(IValueMeta metaA, Object dataA, boolean failIfNoFile) throws HopValueException, HopFileNotFoundException {
        if (dataA == null) {
            return null;
        }
        byte[] content = null;
        FileObject file = null;
        InputStream is = null;
        try {
            file = HopVfs.getFileObject(dataA.toString());
            ValueDataUtil.throwsErrorOnFileNotFound(file);
            is = HopVfs.getInputStream(file);
            int fileSize = (int)file.getContent().getSize();
            content = new byte[fileSize];
            is.read(content, 0, fileSize);
        }
        catch (HopFileNotFoundException e) {
            if (failIfNoFile) {
                throw e;
            }
            log.debug((Object)e.getMessage());
            IOUtils.closeQuietly((Closeable)file);
            IOUtils.closeQuietly((InputStream)is);
        }
        catch (Exception e2) {
            throw new HopValueException(e2);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((Closeable)file);
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((Closeable)file);
        IOUtils.closeQuietly((InputStream)is);
        return content;
    }

    public static Object minus(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) throws HopValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return metaA.getNumber(dataA) - metaB.getNumber(dataB);
            }
            case 5: {
                return metaA.getInteger(dataA) - metaB.getInteger(dataB);
            }
            case 6: {
                return metaA.getBigNumber(dataA).subtract(metaB.getBigNumber(dataB));
            }
        }
        return metaA.getInteger(dataA) - metaB.getInteger(dataB);
    }

    public static Object multiply(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) throws HopValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        if (metaB.isString() && metaA.isNumeric() || metaB.isNumeric() && metaA.isString()) {
            return ValueDataUtil.multiplyString(metaA, dataA, metaB, dataB);
        }
        return ValueDataUtil.multiplyNumeric(metaA, dataA, metaB, dataB);
    }

    protected static Object multiplyNumeric(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) throws HopValueException {
        switch (metaA.getType()) {
            case 1: {
                return ValueDataUtil.multiplyDoubles(metaA.getNumber(dataA), metaB.getNumber(dataB));
            }
            case 5: {
                return ValueDataUtil.multiplyLongs(metaA.getInteger(dataA), metaB.getInteger(dataB));
            }
            case 6: {
                return ValueDataUtil.multiplyBigDecimals(metaA.getBigNumber(dataA), metaB.getBigNumber(dataB), null);
            }
        }
        throw new HopValueException("The 'multiply' function only works on numeric data optionally multiplying strings.");
    }

    public static Double multiplyDoubles(Double a, Double b) {
        return a * b;
    }

    public static Long multiplyLongs(Long a, Long b) {
        return a * b;
    }

    private static int getMaxPrecision(BigDecimal a, BigDecimal b) {
        return a.precision() >= b.precision() ? a.precision() : b.precision();
    }

    private static int getMaxScale(BigDecimal a, BigDecimal b) {
        return a.scale() >= b.scale() ? a.scale() : b.scale();
    }

    private static BigDecimal removeTrailingZeroFractionOrScale(BigDecimal a, int maxScale) {
        if (a.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0) {
            return a.setScale(0);
        }
        return a.setScale(maxScale, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal multiplyBigDecimals(BigDecimal a, BigDecimal b, MathContext mc) {
        if (mc == null) {
            mc = new MathContext(ValueDataUtil.getMaxPrecision(a, b), RoundingMode.HALF_EVEN);
        }
        return ValueDataUtil.removeTrailingZeroFractionOrScale(a.multiply(b, mc), ValueDataUtil.getMaxScale(a, b));
    }

    protected static Object multiplyString(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) throws HopValueException {
        int n;
        StringBuffer s;
        String append = "";
        if (metaB.isString()) {
            s = new StringBuffer(metaB.getString(dataB));
            append = metaB.getString(dataB);
            n = metaA.getInteger(dataA).intValue();
        } else {
            s = new StringBuffer(metaA.getString(dataA));
            append = metaA.getString(dataA);
            n = metaB.getInteger(dataB).intValue();
        }
        if (n == 0) {
            s.setLength(0);
        } else {
            for (int i = 1; i < n; ++i) {
                s.append(append);
            }
        }
        return s.toString();
    }

    public static Object divide(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) throws HopValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return ValueDataUtil.divideDoubles(metaA.getNumber(dataA), metaB.getNumber(dataB));
            }
            case 5: {
                return ValueDataUtil.divideLongs(metaA.getInteger(dataA), metaB.getInteger(dataB));
            }
            case 6: {
                return ValueDataUtil.divideBigDecimals(metaA.getBigNumber(dataA), metaB.getBigNumber(dataB), null);
            }
        }
        throw new HopValueException("The 'divide' function only works on numeric data.");
    }

    public static Double divideDoubles(Double a, Double b) {
        return a / b;
    }

    public static Long divideLongs(Long a, Long b) {
        return a / b;
    }

    public static BigDecimal divideBigDecimals(BigDecimal a, BigDecimal b, MathContext mc) {
        if (mc == null) {
            mc = new MathContext(ValueDataUtil.getMaxPrecision(a, b), RoundingMode.HALF_EVEN);
        }
        BigDecimal result = a.divide(b, mc);
        return ValueDataUtil.removeTrailingZeroFractionOrScale(result, result.scale());
    }

    public static Object sqrt(IValueMeta metaA, Object dataA) throws HopValueException {
        if (dataA == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return Math.sqrt(metaA.getNumber(dataA));
            }
            case 5: {
                return Math.round(Math.sqrt(metaA.getNumber(dataA)));
            }
            case 6: {
                return BigDecimal.valueOf(Math.sqrt(metaA.getNumber(dataA)));
            }
        }
        throw new HopValueException("The 'sqrt' function only works on numeric data.");
    }

    public static Object percent1(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) throws HopValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return ValueDataUtil.divideDoubles(ValueDataUtil.multiplyDoubles(100.0, metaA.getNumber(dataA)), metaB.getNumber(dataB));
            }
            case 5: {
                return ValueDataUtil.divideLongs(ValueDataUtil.multiplyLongs(100L, metaA.getInteger(dataA)), metaB.getInteger(dataB));
            }
            case 6: {
                return ValueDataUtil.divideBigDecimals(ValueDataUtil.multiplyBigDecimals(metaA.getBigNumber(dataA), new BigDecimal(100), null), metaB.getBigNumber(dataB), null);
            }
        }
        throw new HopValueException("The 'A/B in %' function only works on numeric data");
    }

    public static Object percent2(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) throws HopValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return metaA.getNumber(dataA) - ValueDataUtil.divideDoubles(ValueDataUtil.multiplyDoubles(metaA.getNumber(dataA), metaB.getNumber(dataB)), 100.0);
            }
            case 5: {
                return metaA.getInteger(dataA) - ValueDataUtil.divideLongs(ValueDataUtil.multiplyLongs(metaA.getInteger(dataA), metaB.getInteger(dataB)), 100L);
            }
            case 6: {
                return metaA.getBigNumber(dataA).subtract(ValueDataUtil.divideBigDecimals(ValueDataUtil.multiplyBigDecimals(metaB.getBigNumber(dataB), metaA.getBigNumber(dataA), null), new BigDecimal(100), null));
            }
        }
        throw new HopValueException("The 'A-B%' function only works on numeric data");
    }

    public static Object percent3(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) throws HopValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return metaA.getNumber(dataA) + ValueDataUtil.divideDoubles(ValueDataUtil.multiplyDoubles(metaA.getNumber(dataA), metaB.getNumber(dataB)), 100.0);
            }
            case 5: {
                return metaA.getInteger(dataA) + ValueDataUtil.divideLongs(ValueDataUtil.multiplyLongs(metaA.getInteger(dataA), metaB.getInteger(dataB)), 100L);
            }
            case 6: {
                return metaA.getBigNumber(dataA).add(ValueDataUtil.divideBigDecimals(ValueDataUtil.multiplyBigDecimals(metaB.getBigNumber(dataB), metaA.getBigNumber(dataA), null), new BigDecimal(100), null));
            }
        }
        throw new HopValueException("The 'A+B%' function only works on numeric data");
    }

    public static Object combination1(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB, IValueMeta metaC, Object dataC) throws HopValueException {
        if (dataA == null || dataB == null || dataC == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return metaA.getNumber(dataA) + metaB.getNumber(dataB) * metaC.getNumber(dataC);
            }
            case 5: {
                return metaA.getInteger(dataA) + metaB.getInteger(dataB) * metaC.getInteger(dataC);
            }
            case 6: {
                return metaA.getBigNumber(dataA).add(ValueDataUtil.multiplyBigDecimals(metaB.getBigNumber(dataB), metaC.getBigNumber(dataC), null));
            }
        }
        throw new HopValueException("The 'combination1' function only works on numeric data");
    }

    public static Object combination2(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) throws HopValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return Math.sqrt(metaA.getNumber(dataA) * metaA.getNumber(dataA) + metaB.getNumber(dataB) * metaB.getNumber(dataB));
            }
            case 5: {
                return Math.round(Math.sqrt(metaA.getInteger(dataA) * metaA.getInteger(dataA) + metaB.getInteger(dataB) / metaB.getInteger(dataB)));
            }
            case 6: {
                return BigDecimal.valueOf(Math.sqrt(metaA.getNumber(dataA) * metaA.getNumber(dataA) + metaB.getNumber(dataB) * metaB.getNumber(dataB)));
            }
        }
        throw new HopValueException("The 'combination2' function only works on numeric data");
    }

    public static Object round(IValueMeta metaA, Object dataA) throws HopValueException {
        if (dataA == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return (double)Math.round(metaA.getNumber(dataA));
            }
            case 5: {
                return metaA.getInteger(dataA);
            }
            case 6: {
                return new BigDecimal(Math.round(metaA.getNumber(dataA)));
            }
        }
        throw new HopValueException(CONST_ROUND_ONLY_WORK_ON_NUMERIC);
    }

    public static Object round(IValueMeta metaA, Object dataA, int roundingMode) throws HopValueException {
        if (dataA == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return Const.round((double)metaA.getNumber(dataA), 0, roundingMode);
            }
            case 5: {
                return Const.round((long)metaA.getInteger(dataA), 0, roundingMode);
            }
            case 6: {
                return Const.round(metaA.getBigNumber(dataA), 0, roundingMode);
            }
        }
        throw new HopValueException(CONST_ROUND_ONLY_WORK_ON_NUMERIC);
    }

    public static Object round(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) throws HopValueException {
        return ValueDataUtil.round(metaA, dataA, metaB, dataB, ROUND_2_MODE);
    }

    public static Object round(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB, int roundingMode) throws HopValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return Const.round((double)metaA.getNumber(dataA), metaB.getInteger(dataB).intValue(), roundingMode);
            }
            case 5: {
                return Const.round((long)metaA.getInteger(dataA), metaB.getInteger(dataB).intValue(), roundingMode);
            }
            case 6: {
                return Const.round(metaA.getBigNumber(dataA), metaB.getInteger(dataB).intValue(), roundingMode);
            }
        }
        throw new HopValueException(CONST_ROUND_ONLY_WORK_ON_NUMERIC);
    }

    public static Object round(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB, IValueMeta metaC, Object dataC) throws HopValueException {
        if (dataA == null || dataB == null || dataC == null) {
            return null;
        }
        Long valueC = metaC.getInteger(dataC);
        if (valueC == null || valueC < -1L || valueC > 6L) {
            throw new HopValueException("The 'round_custom' arg C has incorrect value: " + valueC);
        }
        int roundingMode = valueC.intValue();
        return ValueDataUtil.round(metaA, dataA, metaB, dataB, roundingMode);
    }

    public static Object ceil(IValueMeta metaA, Object dataA) throws HopValueException {
        if (dataA == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return Math.ceil(metaA.getNumber(dataA));
            }
            case 5: {
                return metaA.getInteger(dataA);
            }
            case 6: {
                return BigDecimal.valueOf(Math.ceil(metaA.getNumber(dataA)));
            }
        }
        throw new HopValueException("The 'ceil' function only works on numeric data");
    }

    public static Object floor(IValueMeta metaA, Object dataA) throws HopValueException {
        if (dataA == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return Math.floor(metaA.getNumber(dataA));
            }
            case 5: {
                return metaA.getInteger(dataA);
            }
            case 6: {
                return BigDecimal.valueOf(Math.floor(metaA.getNumber(dataA)));
            }
        }
        throw new HopValueException("The 'floor' function only works on numeric data");
    }

    public static Object abs(IValueMeta metaA, Object dataA) throws HopValueException {
        if (dataA == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return Math.abs(metaA.getNumber(dataA));
            }
            case 5: {
                return metaA.getInteger(Math.abs(metaA.getNumber(dataA).longValue()));
            }
            case 6: {
                return BigDecimal.valueOf(Math.abs(metaA.getNumber(dataA)));
            }
        }
        throw new HopValueException("The 'abs' function only works on numeric data");
    }

    public static Object remainder(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) throws HopValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return metaA.getNumber(dataA) % metaB.getNumber(dataB);
            }
            case 5: {
                return metaA.getInteger(dataA) % metaB.getInteger(dataB);
            }
            case 6: {
                BigDecimal aValue = metaA.getBigNumber(dataA);
                BigDecimal bValue = metaA.getBigNumber(dataB);
                BigDecimal result = aValue.remainder(bValue, new MathContext(ValueDataUtil.getMaxPrecision(aValue, bValue), RoundingMode.HALF_EVEN));
                return ValueDataUtil.removeTrailingZeroFractionOrScale(result, result.scale());
            }
        }
        throw new HopValueException("The 'remainder' function only works on numeric data");
    }

    public static Object nvl(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) throws HopValueException {
        switch (metaA.getType()) {
            case 2: {
                if (dataA == null) {
                    return metaB.getString(dataB);
                }
                return metaA.getString(dataA);
            }
            case 1: {
                if (dataA == null) {
                    return metaB.getNumber(dataB);
                }
                return metaA.getNumber(dataA);
            }
            case 5: {
                if (dataA == null) {
                    return metaB.getInteger(dataB);
                }
                return metaA.getInteger(dataA);
            }
            case 6: {
                if (dataA == null) {
                    return metaB.getBigNumber(dataB);
                }
                return metaA.getBigNumber(dataA);
            }
            case 3: {
                if (dataA == null) {
                    return metaB.getDate(dataB);
                }
                return metaA.getDate(dataA);
            }
            case 4: {
                if (dataA == null) {
                    return metaB.getBoolean(dataB);
                }
                return metaA.getBoolean(dataA);
            }
            case 8: {
                if (dataA == null) {
                    return metaB.getBinary(dataB);
                }
                return metaA.getBinary(dataA);
            }
        }
        if (dataA == null) {
            return metaB.getNativeDataType(dataB);
        }
        return metaA.getNativeDataType(dataA);
    }

    public static Object removeTimeFromDate(IValueMeta metaA, Object dataA) throws HopValueException {
        Calendar cal = Calendar.getInstance();
        Date date = metaA.getDate(dataA);
        if (date != null) {
            cal.setTime(date);
            return Const.removeTimeFromDate(date);
        }
        return null;
    }

    public static Object addTimeToDate(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB, IValueMeta metaC, Object dataC) throws HopValueException {
        if (dataA == null) {
            return null;
        }
        try {
            if (dataC == null) {
                return Const.addTimeToDate(metaA.getDate(dataA), metaB.getString(dataB), null);
            }
            return Const.addTimeToDate(metaA.getDate(dataA), metaB.getString(dataB), metaC.getString(dataC));
        }
        catch (Exception e) {
            throw new HopValueException(e);
        }
    }

    public static Object addDays(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) throws HopValueException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(metaA.getDate(dataA));
        cal.add(6, metaB.getInteger(dataB).intValue());
        return cal.getTime();
    }

    public static Object addHours(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) throws HopValueException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(metaA.getDate(dataA));
        cal.add(11, metaB.getInteger(dataB).intValue());
        return cal.getTime();
    }

    public static Object addMinutes(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) throws HopValueException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(metaA.getDate(dataA));
        cal.add(12, metaB.getInteger(dataB).intValue());
        return cal.getTime();
    }

    public static Object addSeconds(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) throws HopValueException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(metaA.getDate(dataA));
        cal.add(13, metaB.getInteger(dataB).intValue());
        return cal.getTime();
    }

    public static Object addMonths(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) throws HopValueException {
        if (dataA != null && dataB != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(metaA.getDate(dataA));
            int year = cal.get(1);
            int month = cal.get(2);
            int day = cal.get(5);
            int newyear = year + (month += metaB.getInteger(dataB).intValue()) / 12;
            int newmonth = month % 12;
            cal.set(newyear, newmonth, 1);
            int newday = cal.getActualMaximum(5);
            if (newday < day) {
                cal.set(5, newday);
            } else {
                cal.set(5, day);
            }
            return cal.getTime();
        }
        throw new HopValueException("Unable to add months with a null value");
    }

    public static Object DateDiff(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB, String resultType) throws HopValueException {
        if (dataA != null && dataB != null) {
            Date startDate = metaB.getDate(dataB);
            Date endDate = metaA.getDate(dataA);
            Calendar stDateCal = Calendar.getInstance();
            Calendar endDateCal = Calendar.getInstance();
            stDateCal.setTime(startDate);
            endDateCal.setTime(endDate);
            long endL = endDateCal.getTimeInMillis() + (long)endDateCal.getTimeZone().getOffset(endDateCal.getTimeInMillis());
            long startL = stDateCal.getTimeInMillis() + (long)stDateCal.getTimeZone().getOffset(stDateCal.getTimeInMillis());
            long diff = endL - startL;
            if (Utils.isEmpty(resultType)) {
                return diff / 86400000L;
            }
            if (resultType.equals("ms")) {
                return diff;
            }
            if (resultType.equals("s")) {
                return diff / 1000L;
            }
            if (resultType.equals("mn")) {
                return diff / 60000L;
            }
            if (resultType.equals("h")) {
                return diff / 3600000L;
            }
            if (resultType.equals("d")) {
                return diff / 86400000L;
            }
            throw new HopValueException("Unknown result type option '" + resultType + "'");
        }
        return null;
    }

    public static Object DateWorkingDiff(IValueMeta metaA, Object dataA, IValueMeta metaB, Object dataB) throws HopValueException {
        if (dataA != null && dataB != null) {
            Date fromDate = metaB.getDate(dataB);
            Date toDate = metaA.getDate(dataA);
            boolean singminus = false;
            if (fromDate.after(toDate)) {
                singminus = true;
                Date temp = fromDate;
                fromDate = toDate;
                toDate = temp;
            }
            Calendar calFrom = Calendar.getInstance();
            calFrom.setTime(fromDate);
            Calendar calTo = Calendar.getInstance();
            calTo.setTime(toDate);
            int iNoOfWorkingDays = 0;
            do {
                if (calFrom.get(7) != 7 && calFrom.get(7) != 1) {
                    ++iNoOfWorkingDays;
                }
                calFrom.add(5, 1);
            } while (calFrom.getTimeInMillis() <= calTo.getTimeInMillis());
            return singminus ? (long)(-iNoOfWorkingDays) : (long)iNoOfWorkingDays;
        }
        return null;
    }

    public static Object yearOfDate(IValueMeta metaA, Object dataA) throws HopValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(metaA.getDate(dataA));
        return (long)calendar.get(1);
    }

    public static Object monthOfDate(IValueMeta metaA, Object dataA) throws HopValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(metaA.getDate(dataA));
        return (long)(calendar.get(2) + 1);
    }

    public static Object quarterOfDate(IValueMeta metaA, Object dataA) throws HopValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(metaA.getDate(dataA));
        return (long)((calendar.get(2) + 3) / 3);
    }

    public static Object dayOfYear(IValueMeta metaA, Object dataA) throws HopValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(metaA.getDate(dataA));
        return (long)calendar.get(6);
    }

    public static Object dayOfMonth(IValueMeta metaA, Object dataA) throws HopValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(metaA.getDate(dataA));
        return (long)calendar.get(5);
    }

    public static Object hourOfDay(IValueMeta metaA, Object dataA) throws HopValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(metaA.getDate(dataA));
        calendar.setTimeZone(metaA.getDateFormatTimeZone());
        return (long)calendar.get(11);
    }

    public static Object minuteOfHour(IValueMeta metaA, Object dataA) throws HopValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(metaA.getDate(dataA));
        return (long)calendar.get(12);
    }

    public static Object secondOfMinute(IValueMeta metaA, Object dataA) throws HopValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(metaA.getDate(dataA));
        return (long)calendar.get(13);
    }

    public static Object dayOfWeek(IValueMeta metaA, Object dataA) throws HopValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(metaA.getDate(dataA));
        return (long)calendar.get(7);
    }

    public static Object weekOfYear(IValueMeta metaA, Object dataA) throws HopValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(metaA.getDate(dataA));
        return (long)calendar.get(3);
    }

    public static Object weekOfYearISO8601(IValueMeta metaA, Object dataA) throws HopValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
        calendar.setMinimalDaysInFirstWeek(4);
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(metaA.getDate(dataA));
        return (long)calendar.get(3);
    }

    public static Object yearOfDateISO8601(IValueMeta metaA, Object dataA) throws HopValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
        calendar.setMinimalDaysInFirstWeek(4);
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(metaA.getDate(dataA));
        int week = calendar.get(3);
        int month = calendar.get(2);
        int year = calendar.get(1);
        if (week >= 52 && month == 0) {
            --year;
        }
        if (week <= 2 && month == 11) {
            ++year;
        }
        return (long)year;
    }

    public static String hexToByteDecode(IValueMeta meta, Object data) throws HopValueException {
        if (meta.isNull(data)) {
            return null;
        }
        String hexString = meta.getString(data);
        int len = hexString.length();
        char[] chArray = new char[(len + 1) / 2];
        boolean evenByte = true;
        int nextByte = 0;
        if (len % 2 == 1) {
            evenByte = false;
        }
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int nibble;
            char c = hexString.charAt(i);
            if (c >= '0' && c <= '9') {
                nibble = c - 48;
            } else if (c >= 'A' && c <= 'F') {
                nibble = c - 65 + 10;
            } else if (c >= 'a' && c <= 'f') {
                nibble = c - 97 + 10;
            } else {
                throw new HopValueException("invalid hex digit '" + c + "'.");
            }
            if (evenByte) {
                nextByte = nibble << 4;
            } else {
                chArray[j] = (char)(nextByte += nibble);
                ++j;
            }
            evenByte = !evenByte;
        }
        return new String(chArray);
    }

    public static String byteToHexEncode(IValueMeta metaA, Object dataA) throws HopValueException {
        if (dataA == null) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        String hex = metaA.getString(dataA);
        char[] s = hex.toCharArray();
        StringBuffer hexString = new StringBuffer(2 * s.length);
        for (int i = 0; i < s.length; ++i) {
            hexString.append(hexDigits[(s[i] & 0xF0) >> 4]);
            hexString.append(hexDigits[s[i] & 0xF]);
        }
        return hexString.toString();
    }

    public static String charToHexEncode(IValueMeta meta, Object data) throws HopValueException {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        if (meta.isNull(data)) {
            return null;
        }
        String hex = meta.getString(data);
        char[] s = hex.toCharArray();
        StringBuffer hexString = new StringBuffer(2 * s.length);
        for (int i = 0; i < s.length; ++i) {
            hexString.append(hexDigits[(s[i] & 0xF000) >> 12]);
            hexString.append(hexDigits[(s[i] & 0xF00) >> 8]);
            hexString.append(hexDigits[(s[i] & 0xF0) >> 4]);
            hexString.append(hexDigits[s[i] & 0xF]);
        }
        return hexString.toString();
    }

    public static String hexToCharDecode(IValueMeta meta, Object data) throws HopValueException {
        if (meta.isNull(data)) {
            return null;
        }
        String hexString = meta.getString(data);
        int len = hexString.length();
        char[] chArray = new char[(len + 3) / 4];
        int nextChar = 0;
        int charNr = len % 4;
        if (charNr == 0) {
            charNr = 4;
        }
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int nibble;
            char c = hexString.charAt(i);
            if (c >= '0' && c <= '9') {
                nibble = c - 48;
            } else if (c >= 'A' && c <= 'F') {
                nibble = c - 65 + 10;
            } else if (c >= 'a' && c <= 'f') {
                nibble = c - 97 + 10;
            } else {
                throw new HopValueException("invalid hex digit '" + c + "'.");
            }
            if (charNr == 4) {
                nextChar = nibble << 12;
                --charNr;
                continue;
            }
            if (charNr == 3) {
                nextChar += nibble << 8;
                --charNr;
                continue;
            }
            if (charNr == 2) {
                nextChar += nibble << 4;
                --charNr;
                continue;
            }
            chArray[j] = (char)(nextChar += nibble);
            charNr = 4;
            ++j;
        }
        return new String(chArray);
    }

    public static String rightPad(String ret, int limit) {
        return Const.rightPad(ret, limit);
    }

    public static String rightPad(StringBuffer ret, int limit) {
        return Const.rightPad(ret, limit);
    }

    public static String replace(String string, String repl, String with) {
        StringBuffer str = new StringBuffer(string);
        for (int i = str.length() - 1; i >= 0; --i) {
            if (!str.substring(i).startsWith(repl)) continue;
            str.delete(i, i + repl.length());
            str.insert(i, with);
        }
        return str.toString();
    }

    public static void replaceBuffer(StringBuffer str, String code, String repl) {
        int clength = code.length();
        for (int i = str.length() - clength; i >= 0; --i) {
            String look = str.substring(i, i + clength);
            if (!look.equalsIgnoreCase(code)) continue;
            str.replace(i, i + clength, repl);
        }
    }

    public static int nrSpacesBefore(String field) {
        int nr;
        int len = field.length();
        for (nr = 0; nr < len && field.charAt(nr) == ' '; ++nr) {
        }
        return nr;
    }

    public static final int nrSpacesAfter(String field) {
        int nr;
        int len = field.length();
        for (nr = 0; nr < len && field.charAt(field.length() - 1 - nr) == ' '; ++nr) {
        }
        return nr;
    }

    public static boolean onlySpaces(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Const.isSpace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isXmlFileWellFormed(IValueMeta metaA, Object dataA, boolean failIfNoFile) throws HopFileNotFoundException {
        if (dataA == null) {
            return false;
        }
        String filename = dataA.toString();
        FileObject file = null;
        try {
            file = HopVfs.getFileObject(filename);
            ValueDataUtil.throwsErrorOnFileNotFound(file);
            boolean bl = XmlCheck.isXmlFileWellFormed(file);
            return bl;
        }
        catch (HopFileNotFoundException e) {
            if (failIfNoFile) {
                throw e;
            }
            log.debug((Object)e.getMessage());
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((Closeable)file);
        }
        return false;
    }

    public static boolean isXmlWellFormed(IValueMeta metaA, Object dataA) {
        if (dataA == null) {
            return false;
        }
        try {
            return XmlCheck.isXmlWellFormed(new ByteArrayInputStream(metaA.getBinary(dataA)));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage());
            return false;
        }
    }

    /*
     * Loose catch block
     */
    public static String getFileEncoding(IValueMeta metaA, Object dataA, boolean failIfNoFile) throws HopValueException, HopFileNotFoundException {
        if (dataA == null) {
            return null;
        }
        String encoding = null;
        FileObject file = null;
        try {
            file = HopVfs.getFileObject(metaA.getString(dataA));
            ValueDataUtil.throwsErrorOnFileNotFound(file);
            encoding = CharsetToolkit.guessEncodingName(file);
        }
        catch (HopFileNotFoundException e) {
            if (failIfNoFile) {
                throw e;
            }
            log.debug((Object)e.getMessage());
            IOUtils.closeQuietly((Closeable)file);
        }
        catch (Exception e2) {
            throw new HopValueException(e2);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(file);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((Closeable)file);
        return encoding;
    }

    public static Object getZeroForValueMetaType(IValueMeta type) throws HopValueException {
        if (type == null) {
            throw new HopValueException("API error. IValueMeta can't be null!");
        }
        switch (type.getType()) {
            case 5: {
                return 0L;
            }
            case 1: {
                return 0.0;
            }
            case 6: {
                return new BigDecimal(0);
            }
            case 2: {
                return "";
            }
        }
        throw new HopValueException("get zero function undefined for data type: " + type.getType());
    }
}

