/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.unzip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.actions.unzip.FileExistsEnum;
import org.apache.hop.workflow.engine.IWorkflowEngine;

@Action(id="UNZIP", name="i18n::ActionUnZip.Name", description="i18n::ActionUnZip.Description", image="UnZip.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionUnZip.keyword"}, documentationUrl="/workflow/actions/unzip.html")
public class ActionUnZip
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionUnZip.class;
    public static final String CONST_ACTION_UN_ZIP_ERROR_SUCCESS_CONDITIONBROKEN = "ActionUnZip.Error.SuccessConditionbroken";
    public static final String CONST_SPACES = "      ";
    @HopMetadataProperty(key="zipfilename")
    private String zipFilename = null;
    @HopMetadataProperty(key="afterunzip")
    public int afterUnzip = 0;
    @HopMetadataProperty(key="wildcard")
    private String wildcard = null;
    @HopMetadataProperty(key="wildcardexclude")
    private String wildcardExclude = null;
    @HopMetadataProperty(key="targetdirectory")
    private String sourceDirectory = null;
    @HopMetadataProperty(key="movetodirectory")
    private String moveToDirectory = null;
    @HopMetadataProperty(key="addfiletoresult")
    private boolean addFileToResult = false;
    @HopMetadataProperty(key="isfromprevious")
    private boolean fromPrevious = false;
    @HopMetadataProperty(key="adddate")
    private boolean addDate = false;
    @HopMetadataProperty(key="addtime")
    private boolean addTime = false;
    @HopMetadataProperty(key="SpecifyFormat")
    private boolean specifyFormat = false;
    @HopMetadataProperty(key="date_time_format")
    private String dateTimeFormat;
    @HopMetadataProperty(key="rootzip")
    private boolean rootZip = false;
    @HopMetadataProperty(key="createfolder")
    private boolean createFolder = false;
    @HopMetadataProperty(key="nr_limit")
    private String nrLimit = "10";
    @HopMetadataProperty(key="wildcardSource")
    private String wildcardSource = null;
    @HopMetadataProperty(key="iffileexists", storeWithCode=true)
    private FileExistsEnum ifFileExist = FileExistsEnum.SKIP;
    @HopMetadataProperty(key="create_move_to_directory")
    private boolean createMoveToDirectory = false;
    @HopMetadataProperty(key="addOriginalTimestamp")
    private boolean addOriginalTimestamp = false;
    @HopMetadataProperty(key="setOriginalModificationDate")
    private boolean setOriginalModificationDate = false;
    public static final String SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED = "success_when_at_least";
    public static final String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public static final String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    @HopMetadataProperty(key="success_condition")
    private String successCondition = "success_if_no_errors";
    public static final String[] typeIfFileExistsDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionUnZip.Skip.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionUnZip.Overwrite.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionUnZip.Give_Unique_Name.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionUnZip.Fail.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionUnZip.OverwriteIfSizeDifferent.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionUnZip.OverwriteIfSizeEquals.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionUnZip.OverwriteIfZipBigger.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionUnZip.OverwriteIfZipBiggerOrEqual.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionUnZip.OverwriteIfZipSmaller.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionUnZip.OverwriteIfZipSmallerOrEqual.Label", (String[])new String[0])};
    private int nrErrors = 0;
    private int nrSuccess = 0;
    boolean successConditionBroken = false;
    boolean successConditionBrokenExit = false;
    int limitFiles = 0;
    private static SimpleDateFormat daf;
    private boolean dateFormatSet = false;

    public ActionUnZip(String n) {
        super(n, "");
    }

    public ActionUnZip() {
        this("");
    }

    public Object clone() {
        ActionUnZip je = (ActionUnZip)super.clone();
        return je;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result execute(Result previousResult, int nr) {
        Result result;
        block90: {
            FileObject movetodir;
            FileObject fileObject;
            String realMovetodirectory;
            String realTargetdirectory;
            String realWildcardExclude;
            String realWildcard;
            String realWildcardSource;
            String realFilenameSource;
            RowMetaAndData resultRow;
            List rows;
            block91: {
                result = previousResult;
                result.setResult(false);
                result.setNrErrors(1L);
                rows = result.getRows();
                resultRow = null;
                realFilenameSource = this.resolve(this.zipFilename);
                realWildcardSource = this.resolve(this.wildcardSource);
                realWildcard = this.resolve(this.wildcard);
                realWildcardExclude = this.resolve(this.wildcardExclude);
                realTargetdirectory = this.resolve(this.sourceDirectory);
                realMovetodirectory = this.resolve(this.moveToDirectory);
                this.limitFiles = Const.toInt((String)this.resolve(this.getNrLimit()), (int)10);
                this.nrErrors = 0;
                this.nrSuccess = 0;
                this.successConditionBroken = false;
                this.successConditionBrokenExit = false;
                if (this.fromPrevious) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.ArgFromPrevious.Found", (String[])new String[]{"" + (rows != null ? rows.size() : 0)}));
                    }
                    if (rows.isEmpty()) {
                        return result;
                    }
                } else if (Utils.isEmpty((CharSequence)this.zipFilename)) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.No_ZipFile_Defined.Label", (String[])new String[0]));
                    return result;
                }
                fileObject = null;
                FileObject targetdir = null;
                movetodir = null;
                try {
                    boolean exitaction;
                    block93: {
                        block92: {
                            if (Utils.isEmpty((CharSequence)realTargetdirectory)) {
                                this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.Error.TargetFolderMissing", (String[])new String[0]));
                                Result result2 = result;
                                return result2;
                            }
                            exitaction = false;
                            targetdir = HopVfs.getFileObject((String)realTargetdirectory, (IVariables)this.getVariables());
                            if (targetdir.exists()) break block92;
                            if (this.createFolder) {
                                targetdir.createFolder();
                                if (this.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.TargetFolderCreated", (String[])new String[]{realTargetdirectory}));
                                }
                                break block93;
                            } else {
                                this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.TargetFolderNotFound.Label", (String[])new String[0]));
                                exitaction = true;
                            }
                            break block93;
                        }
                        if (targetdir.getType() != FileType.FOLDER) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.TargetFolderNotFolder.Label", (String[])new String[]{realTargetdirectory}));
                            exitaction = true;
                        } else if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.TargetFolderExists.Label", (String[])new String[]{realTargetdirectory}));
                        }
                    }
                    if (this.afterUnzip == 2) {
                        if (Utils.isEmpty((CharSequence)this.moveToDirectory)) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.MoveToDirectoryEmpty.Label", (String[])new String[0]));
                            exitaction = true;
                        } else {
                            movetodir = HopVfs.getFileObject((String)realMovetodirectory, (IVariables)this.getVariables());
                            if (!movetodir.exists() || movetodir.getType() != FileType.FOLDER) {
                                if (this.createMoveToDirectory) {
                                    movetodir.createFolder();
                                    if (this.isDetailed()) {
                                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.MoveToFolderCreated", (String[])new String[]{realMovetodirectory}));
                                    }
                                } else {
                                    this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.MoveToDirectoryNotExists.Label", (String[])new String[0]));
                                    exitaction = true;
                                }
                            }
                        }
                    }
                    if (exitaction) {
                        Result result3 = result;
                        return result3;
                    }
                    if (this.fromPrevious) {
                        if (rows == null) break block90;
                        break block91;
                    }
                    fileObject = HopVfs.getFileObject((String)realFilenameSource, (IVariables)this.getVariables());
                    if (!fileObject.exists()) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.ZipFile.NotExists.Label", (String[])new String[]{realFilenameSource}));
                        Result result4 = result;
                        return result4;
                    }
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.Zip_FileExists.Label", (String[])new String[]{realFilenameSource}));
                    }
                    if (Utils.isEmpty((CharSequence)this.sourceDirectory)) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.SourceFolderNotFound.Label", (String[])new String[0]));
                        Result result5 = result;
                        return result5;
                    }
                    this.processOneFile(result, (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, fileObject, realTargetdirectory, realWildcard, realWildcardExclude, movetodir, realMovetodirectory, realWildcardSource);
                    break block90;
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.ErrorUnzip.Label", (String[])new String[]{realFilenameSource, e.getMessage()}));
                    this.updateErrors();
                    break block90;
                }
                finally {
                    if (fileObject != null) {
                        try {
                            fileObject.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (targetdir != null) {
                        try {
                            targetdir.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (movetodir != null) {
                        try {
                            movetodir.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            for (int iteration = 0; iteration < rows.size() && !this.parentWorkflow.isStopped(); ++iteration) {
                if (this.successConditionBroken) {
                    if (!this.successConditionBrokenExit) {
                        this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_UN_ZIP_ERROR_SUCCESS_CONDITIONBROKEN, (String[])new String[]{"" + this.nrErrors}));
                        this.successConditionBrokenExit = true;
                    }
                    result.setNrErrors((long)this.nrErrors);
                    return result;
                }
                resultRow = (RowMetaAndData)rows.get(iteration);
                realFilenameSource = resultRow.getString(0, null);
                realWildcardSource = resultRow.getString(1, null);
                fileObject = HopVfs.getFileObject((String)realFilenameSource, (IVariables)this.getVariables());
                if (fileObject.exists()) {
                    this.processOneFile(result, (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, fileObject, realTargetdirectory, realWildcard, realWildcardExclude, movetodir, realMovetodirectory, realWildcardSource);
                    continue;
                }
                this.updateErrors();
                this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.Error.CanNotFindFile", (String[])new String[]{realFilenameSource}));
            }
        }
        result.setNrErrors((long)this.nrErrors);
        result.setNrLinesWritten((long)this.nrSuccess);
        if (this.getSuccessStatus()) {
            result.setResult(true);
        }
        this.displayResults();
        return result;
    }

    private void displayResults() {
        if (this.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.Info.FilesInError", (String[])new String[]{"" + this.nrErrors}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.Info.FilesInSuccess", (String[])new String[]{"" + this.nrSuccess}));
            this.logDetailed("=======================================");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processOneFile(Result result, IWorkflowEngine<WorkflowMeta> parentWorkflow, FileObject fileObject, String realTargetdirectory, String realWildcard, String realWildcardExclude, FileObject movetodir, String realMovetodirectory, String realWildcardSource) {
        boolean retval;
        block28: {
            retval = false;
            try {
                if (fileObject.getType().equals((Object)FileType.FILE)) {
                    if (!this.unzipFile(fileObject, realTargetdirectory, realWildcard, realWildcardExclude, result, parentWorkflow, movetodir, realMovetodirectory)) {
                        this.updateErrors();
                    } else {
                        this.updateSuccess();
                    }
                    break block28;
                }
                FileObject[] children = fileObject.getChildren();
                int i = 0;
                while (true) {
                    if (i < children.length && !parentWorkflow.isStopped()) {
                        if (this.successConditionBroken) {
                            if (!this.successConditionBrokenExit) {
                                this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_UN_ZIP_ERROR_SUCCESS_CONDITIONBROKEN, (String[])new String[]{"" + this.nrErrors}));
                                this.successConditionBrokenExit = true;
                            }
                            boolean bl = false;
                            return bl;
                        }
                        if (!children[i].getType().equals((Object)FileType.FOLDER)) {
                            boolean unzip = true;
                            String filename = children[i].getName().getPath();
                            Pattern patternSource = null;
                            if (!Utils.isEmpty((CharSequence)realWildcardSource)) {
                                patternSource = Pattern.compile(realWildcardSource);
                            }
                            if (patternSource != null) {
                                Matcher matcher = patternSource.matcher(filename);
                                unzip = matcher.matches();
                            }
                            if (unzip) {
                                if (!this.unzipFile(children[i], realTargetdirectory, realWildcard, realWildcardExclude, result, parentWorkflow, movetodir, realMovetodirectory)) {
                                    this.updateErrors();
                                } else {
                                    this.updateSuccess();
                                }
                            }
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.updateErrors();
                this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.Error.Label", (String[])new String[]{e.getMessage()}));
            }
            finally {
                if (fileObject != null) {
                    try {
                        fileObject.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unzipFile(FileObject sourceFileObject, String realTargetdirectory, String realWildcard, String realWildcardExclude, Result result, IWorkflowEngine<WorkflowMeta> parentWorkflow, FileObject movetodir, String realMovetodirectory) {
        boolean retval = false;
        Object unzipToFolder = realTargetdirectory;
        try {
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.ProcessingFile", (String[])new String[]{sourceFileObject.toString()}));
            }
            if (this.rootZip) {
                String folderName;
                FileObject rootfolder;
                String shortSourceFilename = sourceFileObject.getName().getBaseName();
                int lenstring = shortSourceFilename.length();
                int lastindexOfDot = shortSourceFilename.lastIndexOf(46);
                if (lastindexOfDot == -1) {
                    lastindexOfDot = lenstring;
                }
                if (!(rootfolder = HopVfs.getFileObject((String)(folderName = realTargetdirectory + "/" + shortSourceFilename.substring(0, lastindexOfDot)), (IVariables)this.getVariables())).exists()) {
                    try {
                        rootfolder.createFolder();
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.RootFolderCreated", (String[])new String[]{folderName}));
                        }
                    }
                    catch (Exception e) {
                        throw new Exception(BaseMessages.getString(PKG, (String)"ActionUnZip.Error.CanNotCreateRootFolder", (String[])new String[]{folderName}), e);
                    }
                }
                unzipToFolder = folderName;
            }
            String zipFilename = "zip:" + sourceFileObject.getName().getFriendlyURI();
            FileObject zipFile = HopVfs.getFileObject((String)zipFilename, (IVariables)this.getVariables());
            FileObject[] items = zipFile.findFiles((FileSelector)new AllFileSelector(){

                public boolean traverseDescendents(FileSelectInfo info) {
                    return true;
                }

                public boolean includeFile(FileSelectInfo info) {
                    if (info.getDepth() == 0) {
                        return false;
                    }
                    FileObject fileObject = info.getFile();
                    return fileObject != null;
                }
            });
            Pattern pattern = null;
            if (!Utils.isEmpty((CharSequence)realWildcard)) {
                pattern = Pattern.compile(realWildcard);
            }
            Pattern patternexclude = null;
            if (!Utils.isEmpty((CharSequence)realWildcardExclude)) {
                patternexclude = Pattern.compile(realWildcardExclude);
            }
            for (FileObject item : items) {
                if (this.successConditionBroken) {
                    if (!this.successConditionBrokenExit) {
                        this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_UN_ZIP_ERROR_SUCCESS_CONDITIONBROKEN, (String[])new String[]{"" + this.nrErrors}));
                        this.successConditionBrokenExit = true;
                    }
                    return false;
                }
                DefaultFileSystemManager defaultFileSystemManager = HopVfs.getFileSystemManager((IVariables)this.getVariables());
                synchronized (defaultFileSystemManager) {
                    block50: {
                        FileObject newFileObject = null;
                        try {
                            if (this.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.ProcessingZipEntry", (String[])new String[]{item.getName().getURI(), sourceFileObject.toString()}));
                            }
                            String newFileName = (String)unzipToFolder + Const.FILE_SEPARATOR + this.getTargetFilename(item);
                            newFileObject = HopVfs.getFileObject((String)newFileName, (IVariables)this.getVariables());
                            if (item.getType().equals((Object)FileType.FOLDER)) {
                                if (this.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.CreatingDirectory.Label", (String[])new String[]{newFileName}));
                                }
                                if (!newFileObject.exists()) {
                                    newFileObject.createFolder();
                                }
                                break block50;
                            }
                            boolean getIt = true;
                            boolean getItexclude = false;
                            if (pattern != null) {
                                Matcher matcher = pattern.matcher(item.getName().getURI());
                                getIt = matcher.matches();
                            }
                            if (patternexclude != null) {
                                Matcher matcherexclude = patternexclude.matcher(item.getName().getURI());
                                getItexclude = matcherexclude.matches();
                            }
                            boolean take = this.takeThisFile(item, newFileName);
                            if (!getIt || getItexclude || !take) break block50;
                            if (this.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.ExtractingEntry.Label", (String[])new String[]{item.getName().getURI(), newFileName}));
                            }
                            if (this.ifFileExist == FileExistsEnum.UNIQ) {
                                int lenstring = newFileName.length();
                                int lastindexOfDot = newFileName.lastIndexOf(46);
                                if (lastindexOfDot == -1) {
                                    lastindexOfDot = lenstring;
                                }
                                newFileName = newFileName.substring(0, lastindexOfDot) + StringUtil.getFormattedDateTimeNow((boolean)true) + newFileName.substring(lastindexOfDot, lenstring);
                                if (this.isDebug()) {
                                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.CreatingUniqFile", (String[])new String[]{newFileName}));
                                }
                            }
                            if (!newFileObject.getParent().exists()) {
                                newFileObject.getParent().createFolder();
                            }
                            InputStream is = null;
                            OutputStream os = null;
                            try {
                                is = HopVfs.getInputStream((FileObject)item);
                                os = HopVfs.getOutputStream((FileObject)newFileObject, (boolean)false);
                                if (is != null) {
                                    int len;
                                    byte[] buff = new byte[2048];
                                    while ((len = is.read(buff)) > 0) {
                                        os.write(buff, 0, len);
                                    }
                                    this.addFilenameToResultFilenames(result, parentWorkflow, newFileName);
                                }
                            }
                            finally {
                                if (is != null) {
                                    is.close();
                                }
                                if (os != null) {
                                    os.close();
                                }
                            }
                        }
                        catch (Exception e) {
                            this.updateErrors();
                            this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.Error.CanNotProcessZipEntry", (String[])new String[]{item.getName().getURI(), sourceFileObject.toString()}), e);
                        }
                        finally {
                            if (newFileObject != null) {
                                try {
                                    newFileObject.close();
                                    if (this.setOriginalModificationDate) {
                                        newFileObject.getContent().setLastModifiedTime(item.getContent().getLastModifiedTime());
                                    }
                                }
                                catch (Exception exception) {}
                            }
                            HopVfs.getFileSystemManager((IVariables)this.getVariables()).closeFileSystem(item.getFileSystem());
                            if (items != null) {
                                items = null;
                            }
                        }
                    }
                }
            }
            if (this.afterUnzip > 0) {
                this.doUnzipPostProcessing(sourceFileObject, movetodir, realMovetodirectory);
            }
            retval = true;
        }
        catch (Exception e) {
            this.updateErrors();
            this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.ErrorUnzip.Label", (String[])new String[]{sourceFileObject.toString(), e.getMessage()}), e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUnzipPostProcessing(FileObject sourceFileObject, FileObject movetodir, String realMovetodirectory) throws FileSystemException {
        if (this.afterUnzip == 1) {
            boolean deleted = sourceFileObject.delete();
            if (!deleted) {
                this.updateErrors();
                this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.Cant_Delete_File.Label", (String[])new String[]{sourceFileObject.toString()}));
            }
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.File_Deleted.Label", (String[])new String[]{sourceFileObject.toString()}));
            }
        } else if (this.afterUnzip == 2) {
            FileObject destFile = null;
            try {
                String destinationFilename = movetodir + Const.FILE_SEPARATOR + sourceFileObject.getName().getBaseName();
                destFile = HopVfs.getFileObject((String)destinationFilename, (IVariables)this.getVariables());
                sourceFileObject.moveTo(destFile);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileMovedTo", (String[])new String[]{sourceFileObject.toString(), realMovetodirectory}));
                }
            }
            catch (Exception e) {
                this.updateErrors();
                this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.Cant_Move_File.Label", (String[])new String[]{sourceFileObject.toString(), realMovetodirectory, e.getMessage()}));
            }
            finally {
                if (destFile != null) {
                    try {
                        destFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void addFilenameToResultFilenames(Result result, IWorkflowEngine<WorkflowMeta> parentWorkflow, String newfile) throws Exception {
        if (this.addFileToResult) {
            ResultFile resultFile = new ResultFile(0, HopVfs.getFileObject((String)newfile, (IVariables)this.getVariables()), parentWorkflow.getWorkflowName(), this.toString());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
        }
    }

    private void updateErrors() {
        ++this.nrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private void updateSuccess() {
        ++this.nrSuccess;
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.nrErrors > 0 && this.getSuccessCondition().equals(SUCCESS_IF_NO_ERRORS) || this.nrErrors >= this.limitFiles && this.getSuccessCondition().equals(SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.nrErrors == 0 && this.getSuccessCondition().equals(SUCCESS_IF_NO_ERRORS) || this.nrSuccess >= this.limitFiles && this.getSuccessCondition().equals(SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED) || this.nrErrors <= this.limitFiles && this.getSuccessCondition().equals(SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private boolean takeThisFile(FileObject sourceFile, String destinationFile) throws FileSystemException {
        boolean retval = false;
        File destination = new File(destinationFile);
        if (!destination.exists()) {
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.CanNotFindFile", (String[])new String[]{destinationFile}));
            }
            return true;
        }
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileExists", (String[])new String[]{destinationFile}));
        }
        if (this.ifFileExist == FileExistsEnum.SKIP) {
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileSkip", (String[])new String[]{destinationFile}));
            }
            return false;
        }
        if (this.ifFileExist == FileExistsEnum.FAIL) {
            this.updateErrors();
            this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileError", (String[])new String[]{destinationFile, "" + this.nrErrors}));
            return false;
        }
        if (this.ifFileExist == FileExistsEnum.OVERWRITE) {
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileOverwrite", (String[])new String[]{destinationFile}));
            }
            return true;
        }
        Long entrySize = sourceFile.getContent().getSize();
        Long destinationSize = destination.length();
        if (this.ifFileExist == FileExistsEnum.OVERWRITE_DIFF_SIZE) {
            if (entrySize != destinationSize) {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileDiffSize.Diff", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
                }
                return true;
            }
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileDiffSize.Same", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
            }
            return false;
        }
        if (this.ifFileExist == FileExistsEnum.OVERWRITE_EQUAL_SIZE) {
            if (entrySize == destinationSize) {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileEqualSize.Same", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
                }
                return true;
            }
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileEqualSize.Diff", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
            }
            return false;
        }
        if (this.ifFileExist == FileExistsEnum.OVERWRITE_ZIP_BIG) {
            if (entrySize > destinationSize) {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileBigSize.Big", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
                }
                return true;
            }
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileBigSize.Small", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
            }
            return false;
        }
        if (this.ifFileExist == FileExistsEnum.OVERWRITE_ZIP_BIG_EQUAL) {
            if (entrySize >= destinationSize) {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileBigEqualSize.Big", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
                }
                return true;
            }
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileBigEqualSize.Small", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
            }
            return false;
        }
        if (this.ifFileExist == FileExistsEnum.OVERWRITE_ZIP_BIG_SMALL) {
            if (entrySize < destinationSize) {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileSmallSize.Small", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
                }
                return true;
            }
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileSmallSize.Big", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
            }
            return false;
        }
        if (this.ifFileExist == FileExistsEnum.OVERWRITE_ZIP_BIG_SMALL_EQUAL) {
            if (entrySize <= destinationSize) {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileSmallEqualSize.Small", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
                }
                return true;
            }
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileSmallEqualSize.Big", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
            }
            return false;
        }
        if (this.ifFileExist == FileExistsEnum.UNIQ) {
            return true;
        }
        return retval;
    }

    public boolean isEvaluation() {
        return true;
    }

    protected String getTargetFilename(FileObject file) throws FileSystemException {
        Object retval = "";
        String filename = file.getName().getPath();
        if (filename != null) {
            retval = filename;
        }
        if (file.getType() != FileType.FILE) {
            return retval;
        }
        if (!(this.specifyFormat || this.addDate || this.addTime)) {
            return retval;
        }
        int lenstring = ((String)retval).length();
        int lastindexOfDot = ((String)retval).lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        retval = ((String)retval).substring(0, lastindexOfDot);
        if (daf == null) {
            daf = new SimpleDateFormat();
        }
        Date timestamp = new Date();
        if (this.addOriginalTimestamp) {
            timestamp = new Date(file.getContent().getLastModifiedTime());
        }
        if (this.specifyFormat && !Utils.isEmpty((CharSequence)this.dateTimeFormat)) {
            if (!this.dateFormatSet) {
                daf.applyPattern(this.dateTimeFormat);
            }
            String dt = daf.format(timestamp);
            retval = (String)retval + dt;
        } else {
            if (this.addDate) {
                if (!this.dateFormatSet) {
                    daf.applyPattern("yyyyMMdd");
                }
                String d = daf.format(timestamp);
                retval = (String)retval + "_" + d;
            }
            if (this.addTime) {
                if (!this.dateFormatSet) {
                    daf.applyPattern("HHmmssSSS");
                }
                String t = daf.format(timestamp);
                retval = (String)retval + "_" + t;
            }
        }
        if (daf != null) {
            this.dateFormatSet = true;
        }
        retval = (String)retval + filename.substring(lastindexOfDot, lenstring);
        return retval;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx1 = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx1, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx1, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileDoesNotExistValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "zipFilename", remarks, ctx1);
        if (2 == this.afterUnzip) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "moveToDirectory", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        }
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "sourceDirectory", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }

    @Generated
    public String getZipFilename() {
        return this.zipFilename;
    }

    @Generated
    public int getAfterUnzip() {
        return this.afterUnzip;
    }

    @Generated
    public String getWildcard() {
        return this.wildcard;
    }

    @Generated
    public String getWildcardExclude() {
        return this.wildcardExclude;
    }

    @Generated
    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    @Generated
    public String getMoveToDirectory() {
        return this.moveToDirectory;
    }

    @Generated
    public boolean isAddFileToResult() {
        return this.addFileToResult;
    }

    @Generated
    public boolean isFromPrevious() {
        return this.fromPrevious;
    }

    @Generated
    public boolean isAddDate() {
        return this.addDate;
    }

    @Generated
    public boolean isAddTime() {
        return this.addTime;
    }

    @Generated
    public boolean isSpecifyFormat() {
        return this.specifyFormat;
    }

    @Generated
    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    @Generated
    public boolean isRootZip() {
        return this.rootZip;
    }

    @Generated
    public boolean isCreateFolder() {
        return this.createFolder;
    }

    @Generated
    public String getNrLimit() {
        return this.nrLimit;
    }

    @Generated
    public String getWildcardSource() {
        return this.wildcardSource;
    }

    @Generated
    public FileExistsEnum getIfFileExist() {
        return this.ifFileExist;
    }

    @Generated
    public boolean isCreateMoveToDirectory() {
        return this.createMoveToDirectory;
    }

    @Generated
    public boolean isAddOriginalTimestamp() {
        return this.addOriginalTimestamp;
    }

    @Generated
    public boolean isSetOriginalModificationDate() {
        return this.setOriginalModificationDate;
    }

    @Generated
    public String getSuccessCondition() {
        return this.successCondition;
    }

    @Generated
    public int getNrErrors() {
        return this.nrErrors;
    }

    @Generated
    public int getNrSuccess() {
        return this.nrSuccess;
    }

    @Generated
    public boolean isSuccessConditionBroken() {
        return this.successConditionBroken;
    }

    @Generated
    public boolean isSuccessConditionBrokenExit() {
        return this.successConditionBrokenExit;
    }

    @Generated
    public int getLimitFiles() {
        return this.limitFiles;
    }

    @Generated
    public boolean isDateFormatSet() {
        return this.dateFormatSet;
    }

    @Generated
    public void setZipFilename(String zipFilename) {
        this.zipFilename = zipFilename;
    }

    @Generated
    public void setAfterUnzip(int afterUnzip) {
        this.afterUnzip = afterUnzip;
    }

    @Generated
    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    @Generated
    public void setWildcardExclude(String wildcardExclude) {
        this.wildcardExclude = wildcardExclude;
    }

    @Generated
    public void setSourceDirectory(String sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    @Generated
    public void setMoveToDirectory(String moveToDirectory) {
        this.moveToDirectory = moveToDirectory;
    }

    @Generated
    public void setAddFileToResult(boolean addFileToResult) {
        this.addFileToResult = addFileToResult;
    }

    @Generated
    public void setFromPrevious(boolean fromPrevious) {
        this.fromPrevious = fromPrevious;
    }

    @Generated
    public void setAddDate(boolean addDate) {
        this.addDate = addDate;
    }

    @Generated
    public void setAddTime(boolean addTime) {
        this.addTime = addTime;
    }

    @Generated
    public void setSpecifyFormat(boolean specifyFormat) {
        this.specifyFormat = specifyFormat;
    }

    @Generated
    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    @Generated
    public void setRootZip(boolean rootZip) {
        this.rootZip = rootZip;
    }

    @Generated
    public void setCreateFolder(boolean createFolder) {
        this.createFolder = createFolder;
    }

    @Generated
    public void setNrLimit(String nrLimit) {
        this.nrLimit = nrLimit;
    }

    @Generated
    public void setWildcardSource(String wildcardSource) {
        this.wildcardSource = wildcardSource;
    }

    @Generated
    public void setIfFileExist(FileExistsEnum ifFileExist) {
        this.ifFileExist = ifFileExist;
    }

    @Generated
    public void setCreateMoveToDirectory(boolean createMoveToDirectory) {
        this.createMoveToDirectory = createMoveToDirectory;
    }

    @Generated
    public void setAddOriginalTimestamp(boolean addOriginalTimestamp) {
        this.addOriginalTimestamp = addOriginalTimestamp;
    }

    @Generated
    public void setSetOriginalModificationDate(boolean setOriginalModificationDate) {
        this.setOriginalModificationDate = setOriginalModificationDate;
    }

    @Generated
    public void setSuccessCondition(String successCondition) {
        this.successCondition = successCondition;
    }

    @Generated
    public void setNrErrors(int nrErrors) {
        this.nrErrors = nrErrors;
    }

    @Generated
    public void setNrSuccess(int nrSuccess) {
        this.nrSuccess = nrSuccess;
    }

    @Generated
    public void setSuccessConditionBroken(boolean successConditionBroken) {
        this.successConditionBroken = successConditionBroken;
    }

    @Generated
    public void setSuccessConditionBrokenExit(boolean successConditionBrokenExit) {
        this.successConditionBrokenExit = successConditionBrokenExit;
    }

    @Generated
    public void setLimitFiles(int limitFiles) {
        this.limitFiles = limitFiles;
    }

    @Generated
    public void setDateFormatSet(boolean dateFormatSet) {
        this.dateFormatSet = dateFormatSet;
    }
}

