/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.stream;

import com.clickhouse.data.ClickHouseByteBuffer;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.stream.AbstractByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;

public class IterableByteArrayInputStream
extends AbstractByteArrayInputStream {
    private final Iterator<byte[]> it;

    public IterableByteArrayInputStream(Iterable<byte[]> source, Runnable postCloseAction) {
        super(null, null, postCloseAction);
        this.it = ClickHouseChecker.nonNull(source, "Source").iterator();
    }

    @Override
    protected int updateBuffer() throws IOException {
        this.position = 0;
        while (this.it.hasNext()) {
            byte[] bytes = this.it.next();
            int len = bytes != null ? bytes.length : 0;
            if (len <= 0) continue;
            this.buffer = bytes;
            if (this.copyTo != null) {
                this.copyTo.write(bytes);
            }
            this.limit = len;
            return this.limit;
        }
        this.buffer = ClickHouseByteBuffer.EMPTY_BYTES;
        this.limit = 0;
        return 0;
    }
}

