/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.auto.value.AutoValue;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.pubsub.AutoValue_PubsubWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.gcp.pubsub.AutoValue_PubsubWriteSchemaTransformConfiguration_ErrorHandling;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@DefaultSchema(value=AutoValueSchema.class)
@AutoValue
public abstract class PubsubWriteSchemaTransformConfiguration {
    @SchemaFieldDescription(value="The encoding format for the data stored in Pubsub. Valid options are: RAW,AVRO,JSON")
    public abstract @UnknownKeyFor @NonNull @Initialized String getFormat();

    @SchemaFieldDescription(value="The name of the topic to write data to. Format: projects/${PROJECT}/topics/${TOPIC}")
    public abstract @UnknownKeyFor @NonNull @Initialized String getTopic();

    @SchemaFieldDescription(value="The set of fields to write as PubSub attributes instead of part of the payload.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getAttributes();

    @SchemaFieldDescription(value="A map field to write as PubSub attributes instead of part of the payload.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getAttributesMap();

    @SchemaFieldDescription(value="If set, will set an attribute for each Cloud Pub/Sub message with the given name and a unique value. This attribute can then be used in a ReadFromPubSub PTransform to deduplicate messages.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getIdAttribute();

    @SchemaFieldDescription(value="If set, will set an attribute for each Cloud Pub/Sub message with the given name and the message's publish time as the value.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getTimestampAttribute();

    @SchemaFieldDescription(value="Specifies how to handle errors.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ErrorHandling getErrorHandling();

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_PubsubWriteSchemaTransformConfiguration.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setFormat(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setTopic(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setAttributes(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setAttributesMap(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setIdAttribute(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setTimestampAttribute(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setErrorHandling(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ErrorHandling var1);

        public abstract @UnknownKeyFor @NonNull @Initialized PubsubWriteSchemaTransformConfiguration build();
    }

    @AutoValue
    public static abstract class ErrorHandling {
        @SchemaFieldDescription(value="The name of the output PCollection containing failed writes.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getOutput();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_PubsubWriteSchemaTransformConfiguration_ErrorHandling.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setOutput(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized ErrorHandling build();
        }
    }
}

