/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.artifact;

import com.google.auto.value.AutoValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.beam.model.jobmanagement.v1.ArtifactApi;
import org.apache.beam.model.jobmanagement.v1.ArtifactStagingServiceGrpc;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.fnexecution.artifact.ArtifactRetrievalService;
import org.apache.beam.runners.fnexecution.artifact.AutoValue_ArtifactStagingService_ArtifactDestination;
import org.apache.beam.sdk.fn.IdGenerator;
import org.apache.beam.sdk.fn.IdGenerators;
import org.apache.beam.sdk.fn.server.FnService;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.StatusException;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.Hashing;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactStagingService
extends ArtifactStagingServiceGrpc.ArtifactStagingServiceImplBase
implements FnService {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ArtifactStagingService.class);
    private final @UnknownKeyFor @NonNull @Initialized ArtifactDestinationProvider destinationProvider;
    private final @UnknownKeyFor @NonNull @Initialized ConcurrentMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation>>> toStage = new ConcurrentHashMap<String, Map<String, List<RunnerApi.ArtifactInformation>>>();
    private final @UnknownKeyFor @NonNull @Initialized ConcurrentMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation>>> staged = new ConcurrentHashMap<String, Map<String, List<RunnerApi.ArtifactInformation>>>();

    public ArtifactStagingService(@UnknownKeyFor @NonNull @Initialized ArtifactDestinationProvider destinationProvider) {
        this.destinationProvider = destinationProvider;
    }

    public void registerJob(@UnknownKeyFor @NonNull @Initialized String stagingToken, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation>> artifacts) {
        assert (!this.toStage.containsKey(stagingToken));
        this.toStage.put(stagingToken, artifacts);
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation>> getStagedArtifacts(@UnknownKeyFor @NonNull @Initialized String stagingToken) {
        this.toStage.remove(stagingToken);
        return (Map)this.staged.remove(stagingToken);
    }

    public void removeStagedArtifacts(@UnknownKeyFor @NonNull @Initialized String stagingToken) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.destinationProvider.removeStagedArtifacts(stagingToken);
    }

    public static @UnknownKeyFor @NonNull @Initialized ArtifactDestinationProvider beamFilesystemArtifactDestinationProvider(final @UnknownKeyFor @NonNull @Initialized String root) {
        return new ArtifactDestinationProvider(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized ArtifactDestination getDestination(@UnknownKeyFor @NonNull @Initialized String stagingToken, @UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized IOException {
                ResourceId path = this.stagingDir(stagingToken).resolve(name, ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
                return ArtifactDestination.fromFile(path.toString());
            }

            @Override
            public void removeStagedArtifacts(@UnknownKeyFor @NonNull @Initialized String stagingToken) throws @UnknownKeyFor @NonNull @Initialized IOException {
                ResourceId stagingDir = this.stagingDir(stagingToken);
                ArrayList<ResourceId> toDelete = new ArrayList<ResourceId>();
                for (MatchResult match : FileSystems.matchResources((List<ResourceId>)ImmutableList.of((Object)stagingDir.resolve("*", ResolveOptions.StandardResolveOptions.RESOLVE_FILE)))) {
                    for (MatchResult.Metadata m : match.metadata()) {
                        toDelete.add(m.resourceId());
                    }
                }
                FileSystems.delete(toDelete, MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES);
                FileSystems.delete((Collection<ResourceId>)ImmutableList.of((Object)stagingDir), MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES);
            }

            private @UnknownKeyFor @NonNull @Initialized ResourceId stagingDir(@UnknownKeyFor @NonNull @Initialized String stagingToken) {
                return FileSystems.matchNewResource(root, true).resolve(Hashing.sha256().hashString((CharSequence)stagingToken, StandardCharsets.UTF_8).toString(), ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY);
            }
        };
    }

    public @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ArtifactApi.ArtifactResponseWrapper> reverseArtifactRetrievalService(final @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ArtifactApi.ArtifactRequestWrapper> responseObserver) {
        return new StreamObserver<ArtifactApi.ArtifactResponseWrapper>(){
            public static final @UnknownKeyFor @NonNull @Initialized int THREAD_POOL_SIZE = 10;
            public static final @UnknownKeyFor @NonNull @Initialized int MAX_PENDING_BYTES = 0x6400000;
            @UnknownKeyFor @NonNull @Initialized IdGenerator idGenerator = IdGenerators.incrementingLongs();
            @UnknownKeyFor @NonNull @Initialized String stagingToken;
            @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation>> toResolve;
            @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Future<// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation>>> stagedFutures;
            @UnknownKeyFor @NonNull @Initialized ExecutorService stagingExecutor;
            @UnknownKeyFor @NonNull @Initialized OverflowingSemaphore totalPendingBytes;
            @UnknownKeyFor @NonNull @Initialized State state = State.START;
            @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized String> pendingResolves;
            @UnknownKeyFor @NonNull @Initialized String currentEnvironment;
            @UnknownKeyFor @NonNull @Initialized Queue<// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation> pendingGets;
            @UnknownKeyFor @NonNull @Initialized BlockingQueue<@UnknownKeyFor @NonNull @Initialized ByteString> currentOutput;

            @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"}, justification="fallthrough intended")
            public synchronized void onNext(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArtifactApi.ArtifactResponseWrapper responseWrapper) {
                switch (this.state) {
                    case START: {
                        this.stagingToken = responseWrapper.getStagingToken();
                        LOG.info("Staging artifacts for {}.", (Object)this.stagingToken);
                        this.toResolve = (Map)ArtifactStagingService.this.toStage.get(this.stagingToken);
                        if (this.toResolve == null) {
                            responseObserver.onError((Throwable)new StatusException(Status.INVALID_ARGUMENT.withDescription("Unknown staging token " + this.stagingToken)));
                            return;
                        }
                        this.stagedFutures = new ConcurrentHashMap<String, List<Future<RunnerApi.ArtifactInformation>>>();
                        this.pendingResolves = new ArrayDeque<String>();
                        this.pendingResolves.addAll(this.toResolve.keySet());
                        this.stagingExecutor = Executors.newFixedThreadPool(10);
                        this.totalPendingBytes = new OverflowingSemaphore(0x6400000);
                        this.resolveNextEnvironment((StreamObserver<ArtifactApi.ArtifactRequestWrapper>)responseObserver);
                        break;
                    }
                    case RESOLVE: {
                        this.currentEnvironment = this.pendingResolves.remove();
                        this.stagedFutures.put(this.currentEnvironment, new ArrayList());
                        this.pendingGets = new ArrayDeque<RunnerApi.ArtifactInformation>();
                        for (RunnerApi.ArtifactInformation artifact : responseWrapper.getResolveArtifactResponse().getReplacementsList()) {
                            Optional<RunnerApi.ArtifactInformation> fetched = this.getLocal();
                            if (fetched.isPresent()) {
                                this.stagedFutures.get(this.currentEnvironment).add(CompletableFuture.completedFuture(fetched.get()));
                                continue;
                            }
                            this.pendingGets.add(artifact);
                            responseObserver.onNext((Object)ArtifactApi.ArtifactRequestWrapper.newBuilder().setGetArtifact(ArtifactApi.GetArtifactRequest.newBuilder().setArtifact(artifact)).build());
                        }
                        LOG.info("Getting {} artifacts for {}.{}.", new Object[]{this.pendingGets.size(), this.stagingToken, this.pendingResolves.peek()});
                        if (this.pendingGets.isEmpty()) {
                            this.resolveNextEnvironment((StreamObserver<ArtifactApi.ArtifactRequestWrapper>)responseObserver);
                            break;
                        }
                        this.state = State.GET;
                        break;
                    }
                    case GET: {
                        RunnerApi.ArtifactInformation currentArtifact = this.pendingGets.remove();
                        String name = this.createFilename(this.currentEnvironment, currentArtifact);
                        try {
                            LOG.debug("Storing artifacts for {} as {}", (Object)this.stagingToken, (Object)name);
                            this.currentOutput = new ArrayBlockingQueue<ByteString>(100);
                            this.stagedFutures.get(this.currentEnvironment).add(this.stagingExecutor.submit(new StoreArtifact(this.stagingToken, name, currentArtifact, this.currentOutput, this.totalPendingBytes)));
                        }
                        catch (Exception exn) {
                            LOG.error("Error submitting.", (Throwable)exn);
                            responseObserver.onError((Throwable)exn);
                        }
                        this.state = State.GETCHUNK;
                    }
                    case GETCHUNK: {
                        try {
                            ByteString chunk = responseWrapper.getGetArtifactResponse().getData();
                            if (chunk.size() > 0) {
                                this.totalPendingBytes.aquire(chunk.size());
                                this.currentOutput.put(chunk);
                            }
                            if (!responseWrapper.getIsLast()) break;
                            this.currentOutput.put(ByteString.EMPTY);
                            if (this.pendingGets.isEmpty()) {
                                this.resolveNextEnvironment((StreamObserver<ArtifactApi.ArtifactRequestWrapper>)responseObserver);
                                break;
                            }
                            this.state = State.GET;
                            LOG.debug("Waiting for {}", (Object)this.pendingGets.peek());
                        }
                        catch (Exception exn) {
                            LOG.error("Error submitting.", (Throwable)exn);
                            this.onError(exn);
                        }
                        break;
                    }
                    default: {
                        responseObserver.onError((Throwable)new StatusException(Status.INVALID_ARGUMENT.withDescription("Illegal state " + (Object)((Object)this.state))));
                    }
                }
            }

            private void resolveNextEnvironment(@UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArtifactApi.ArtifactRequestWrapper> responseObserver2) {
                if (this.pendingResolves.isEmpty()) {
                    this.finishStaging(responseObserver2);
                } else {
                    this.state = State.RESOLVE;
                    LOG.info("Resolving artifacts for {}.{}.", (Object)this.stagingToken, (Object)this.pendingResolves.peek());
                    responseObserver2.onNext((Object)ArtifactApi.ArtifactRequestWrapper.newBuilder().setResolveArtifact(ArtifactApi.ResolveArtifactsRequest.newBuilder().addAllArtifacts((Iterable)this.toResolve.get(this.pendingResolves.peek()))).build());
                }
            }

            private void finishStaging(@UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArtifactApi.ArtifactRequestWrapper> responseObserver2) {
                LOG.debug("Finishing staging for {}.", (Object)this.stagingToken);
                HashMap staged = new HashMap();
                try {
                    for (Map.Entry<String, List<Future<RunnerApi.ArtifactInformation>>> entry : this.stagedFutures.entrySet()) {
                        ArrayList<RunnerApi.ArtifactInformation> envStaged = new ArrayList<RunnerApi.ArtifactInformation>();
                        for (Future<RunnerApi.ArtifactInformation> future : entry.getValue()) {
                            envStaged.add(future.get());
                        }
                        staged.put(entry.getKey(), envStaged);
                    }
                    ArtifactStagingService.this.staged.put(this.stagingToken, staged);
                    this.stagingExecutor.shutdown();
                    this.state = State.DONE;
                    LOG.info("Artifacts fully staged for {}.", (Object)this.stagingToken);
                    responseObserver2.onCompleted();
                }
                catch (Exception exn) {
                    LOG.error("Error staging artifacts", (Throwable)exn);
                    responseObserver2.onError((Throwable)exn);
                    this.state = State.ERROR;
                    return;
                }
            }

            private @UnknownKeyFor @NonNull @Initialized Optional<// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation> getLocal() {
                return Optional.empty();
            }

            private @UnknownKeyFor @NonNull @Initialized String createFilename(@UnknownKeyFor @NonNull @Initialized String environment, // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation artifact) {
                String path;
                try {
                    path = artifact.getRoleUrn().equals("beam:artifact:role:staging_to:v1") ? RunnerApi.ArtifactStagingToRolePayload.parseFrom((ByteString)artifact.getRolePayload()).getStagedName() : (artifact.getTypeUrn().equals("beam:artifact:type:file:v1") ? RunnerApi.ArtifactFilePayload.parseFrom((ByteString)artifact.getTypePayload()).getPath() : (artifact.getTypeUrn().equals("beam:artifact:type:url:v1") ? RunnerApi.ArtifactUrlPayload.parseFrom((ByteString)artifact.getTypePayload()).getUrl() : "artifact"));
                }
                catch (InvalidProtocolBufferException exn) {
                    throw new RuntimeException(exn);
                }
                List components = Splitter.onPattern((String)"[^A-Za-z-_.]]").splitToList((CharSequence)path);
                String base = (String)components.get(components.size() - 1);
                return this.clip(String.format("%s-%s-%s", this.idGenerator.getId(), this.clip(environment, 25), base), 100);
            }

            private @UnknownKeyFor @NonNull @Initialized String clip(@UnknownKeyFor @NonNull @Initialized String s, @UnknownKeyFor @NonNull @Initialized int maxLength) {
                return s.length() < maxLength ? s : s.substring(0, maxLength);
            }

            public void onError(@UnknownKeyFor @NonNull @Initialized Throwable throwable) {
                this.stagingExecutor.shutdownNow();
                LOG.error("Error staging artifacts", throwable);
                this.state = State.ERROR;
            }

            public void onCompleted() {
                Preconditions.checkArgument((this.state == State.DONE ? 1 : 0) != 0);
            }
        };
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
    }

    public static void offer(@UnknownKeyFor @NonNull @Initialized ArtifactRetrievalService retrievalService, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ArtifactStagingServiceGrpc.ArtifactStagingServiceStub stagingService, @UnknownKeyFor @NonNull @Initialized String stagingToken) throws @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        new StagingDriver(retrievalService, stagingService, stagingToken).getCompletionFuture().get();
    }

    private static class StagingDriver
    implements StreamObserver<ArtifactApi.ArtifactRequestWrapper> {
        private final @UnknownKeyFor @NonNull @Initialized ArtifactRetrievalService retrievalService;
        private final @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized ArtifactApi.ArtifactResponseWrapper> responseObserver;
        private final @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @Nullable @Initialized Void> completionFuture;

        public StagingDriver(@UnknownKeyFor @NonNull @Initialized ArtifactRetrievalService retrievalService, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized ArtifactStagingServiceGrpc.ArtifactStagingServiceStub stagingService, @UnknownKeyFor @NonNull @Initialized String stagingToken) {
            this.retrievalService = retrievalService;
            this.completionFuture = new CompletableFuture();
            this.responseObserver = stagingService.reverseArtifactRetrievalService((StreamObserver)this);
            this.responseObserver.onNext((Object)ArtifactApi.ArtifactResponseWrapper.newBuilder().setStagingToken(stagingToken).build());
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> getCompletionFuture() {
            return this.completionFuture;
        }

        public void onNext(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized ArtifactApi.ArtifactRequestWrapper requestWrapper) {
            if (this.completionFuture.isCompletedExceptionally()) {
                try {
                    this.completionFuture.get();
                }
                catch (Throwable th) {
                    this.responseObserver.onError(th);
                    return;
                }
            }
            if (requestWrapper.hasResolveArtifact()) {
                this.retrievalService.resolveArtifacts(requestWrapper.getResolveArtifact(), new StreamObserver<ArtifactApi.ResolveArtifactsResponse>(){

                    public void onNext(// Could not load outer class - annotation placement on inner may be incorrect
                     @UnknownKeyFor @NonNull @Initialized ArtifactApi.ResolveArtifactsResponse resolveArtifactsResponse) {
                        responseObserver.onNext((Object)ArtifactApi.ArtifactResponseWrapper.newBuilder().setResolveArtifactResponse(resolveArtifactsResponse).build());
                    }

                    public void onError(@UnknownKeyFor @NonNull @Initialized Throwable throwable) {
                        completionFuture.completeExceptionally(throwable);
                        responseObserver.onError(throwable);
                    }

                    public void onCompleted() {
                    }
                });
            } else if (requestWrapper.hasGetArtifact()) {
                this.retrievalService.getArtifact(requestWrapper.getGetArtifact(), new StreamObserver<ArtifactApi.GetArtifactResponse>(){

                    public void onNext(// Could not load outer class - annotation placement on inner may be incorrect
                     @UnknownKeyFor @NonNull @Initialized ArtifactApi.GetArtifactResponse getArtifactResponse) {
                        responseObserver.onNext((Object)ArtifactApi.ArtifactResponseWrapper.newBuilder().setGetArtifactResponse(getArtifactResponse).build());
                    }

                    public void onError(@UnknownKeyFor @NonNull @Initialized Throwable throwable) {
                        completionFuture.completeExceptionally(throwable);
                        responseObserver.onError(throwable);
                    }

                    public void onCompleted() {
                        responseObserver.onNext((Object)ArtifactApi.ArtifactResponseWrapper.newBuilder().setGetArtifactResponse(ArtifactApi.GetArtifactResponse.newBuilder().build()).setIsLast(true).build());
                    }
                });
            } else {
                StatusException exn = new StatusException(Status.INVALID_ARGUMENT.withDescription("Expected either a resolve or get request."));
                this.completionFuture.completeExceptionally((Throwable)exn);
                this.responseObserver.onError((Throwable)exn);
            }
        }

        public void onError(@UnknownKeyFor @NonNull @Initialized Throwable throwable) {
            this.completionFuture.completeExceptionally(throwable);
        }

        public void onCompleted() {
            this.responseObserver.onCompleted();
            this.completionFuture.complete(null);
        }
    }

    private class StoreArtifact
    implements Callable<RunnerApi.ArtifactInformation> {
        private @UnknownKeyFor @NonNull @Initialized String stagingToken;
        private @UnknownKeyFor @NonNull @Initialized String name;
        private // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation originalArtifact;
        private @UnknownKeyFor @NonNull @Initialized BlockingQueue<@UnknownKeyFor @NonNull @Initialized ByteString> bytesQueue;
        private @UnknownKeyFor @NonNull @Initialized OverflowingSemaphore totalPendingBytes;

        public StoreArtifact(@UnknownKeyFor @NonNull @Initialized String stagingToken, @UnknownKeyFor @NonNull @Initialized String name, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized RunnerApi.ArtifactInformation originalArtifact, @UnknownKeyFor @NonNull @Initialized BlockingQueue<ByteString> bytesQueue, OverflowingSemaphore totalPendingBytes) {
            this.stagingToken = stagingToken;
            this.name = name;
            this.originalArtifact = originalArtifact;
            this.bytesQueue = bytesQueue;
            this.totalPendingBytes = totalPendingBytes;
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation call() throws @UnknownKeyFor @NonNull @Initialized IOException {
            try {
                ArtifactDestination dest = ArtifactStagingService.this.destinationProvider.getDestination(this.stagingToken, this.name);
                LOG.debug("Storing artifact for {}.{} at {}", new Object[]{this.stagingToken, this.name, dest});
                ByteString chunk = this.bytesQueue.take();
                while (chunk.size() > 0) {
                    this.totalPendingBytes.release(chunk.size());
                    chunk.writeTo(dest.getOutputStream());
                    chunk = this.bytesQueue.take();
                }
                dest.getOutputStream().close();
                return this.originalArtifact.toBuilder().setTypeUrn(dest.getTypeUrn()).setTypePayload(dest.getTypePayload()).build();
            }
            catch (IOException | InterruptedException exn) {
                this.totalPendingBytes.setException(exn);
                LOG.error("Exception staging artifacts", (Throwable)exn);
                if (exn instanceof IOException) {
                    throw (IOException)exn;
                }
                throw new RuntimeException(exn);
            }
        }
    }

    private static class OverflowingSemaphore {
        private @UnknownKeyFor @NonNull @Initialized int totalPermits;
        private @UnknownKeyFor @NonNull @Initialized int usedPermits;
        private @UnknownKeyFor @NonNull @Initialized Exception exception;

        public OverflowingSemaphore(@UnknownKeyFor @NonNull @Initialized int totalPermits) {
            this.totalPermits = totalPermits;
            this.usedPermits = 0;
        }

        synchronized void aquire(@UnknownKeyFor @NonNull @Initialized int permits) throws @UnknownKeyFor @NonNull @Initialized Exception {
            while (this.usedPermits >= this.totalPermits) {
                if (this.exception != null) {
                    throw this.exception;
                }
                this.wait();
            }
            this.usedPermits += permits;
        }

        synchronized void release(@UnknownKeyFor @NonNull @Initialized int permits) {
            this.usedPermits -= permits;
            this.notifyAll();
        }

        synchronized void setException(@UnknownKeyFor @NonNull @Initialized Exception exception) {
            this.exception = exception;
            this.notifyAll();
        }
    }

    private static enum State {
        START,
        RESOLVE,
        GET,
        GETCHUNK,
        DONE,
        ERROR;

    }

    @AutoValue
    public static abstract class ArtifactDestination {
        public static @UnknownKeyFor @NonNull @Initialized ArtifactDestination create(@UnknownKeyFor @NonNull @Initialized String typeUrn, @UnknownKeyFor @NonNull @Initialized ByteString typePayload, @UnknownKeyFor @NonNull @Initialized OutputStream out) {
            return new AutoValue_ArtifactStagingService_ArtifactDestination(typeUrn, typePayload, out);
        }

        public static @UnknownKeyFor @NonNull @Initialized ArtifactDestination fromFile(@UnknownKeyFor @NonNull @Initialized String path) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return ArtifactDestination.fromFile(path, Channels.newOutputStream(FileSystems.create(FileSystems.matchNewResource(path, false), "application/octet-stream")));
        }

        public static @UnknownKeyFor @NonNull @Initialized ArtifactDestination fromFile(@UnknownKeyFor @NonNull @Initialized String path, @UnknownKeyFor @NonNull @Initialized OutputStream out) {
            return ArtifactDestination.create("beam:artifact:type:file:v1", RunnerApi.ArtifactFilePayload.newBuilder().setPath(path).build().toByteString(), out);
        }

        public abstract @UnknownKeyFor @NonNull @Initialized String getTypeUrn();

        public abstract @UnknownKeyFor @NonNull @Initialized ByteString getTypePayload();

        public abstract @UnknownKeyFor @NonNull @Initialized OutputStream getOutputStream();
    }

    public static interface ArtifactDestinationProvider {
        public @UnknownKeyFor @NonNull @Initialized ArtifactDestination getDestination(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized String var2) throws @UnknownKeyFor @NonNull @Initialized IOException;

        public void removeStagedArtifacts(@UnknownKeyFor @NonNull @Initialized String var1) throws @UnknownKeyFor @NonNull @Initialized IOException;
    }
}

