/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import java.util.Optional;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.auth.PasswordAuthenticator;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.virtual.AbstractMutableVirtualTable;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.schema.TableMetadata;

final class CredentialsCacheKeysTable
extends AbstractMutableVirtualTable {
    private static final String ROLE = "role";
    private final Optional<PasswordAuthenticator> passwordAuthenticatorOptional;

    CredentialsCacheKeysTable(String keyspace) {
        super(TableMetadata.builder(keyspace, "credentials_cache_keys").comment("keys in the credentials cache").kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(UTF8Type.instance)).addPartitionKeyColumn(ROLE, (AbstractType)UTF8Type.instance).build());
        IAuthenticator authenticator = DatabaseDescriptor.getAuthenticator();
        this.passwordAuthenticatorOptional = authenticator instanceof PasswordAuthenticator ? Optional.of((PasswordAuthenticator)authenticator) : Optional.empty();
    }

    @Override
    public AbstractVirtualTable.DataSet data() {
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        this.passwordAuthenticatorOptional.ifPresent(passwordAuthenticator -> passwordAuthenticator.getCredentialsCache().getAll().forEach((roleName, ignored) -> result.row(roleName)));
        return result;
    }

    @Override
    protected void applyPartitionDeletion(AbstractMutableVirtualTable.ColumnValues partitionKey) {
        String roleName = (String)partitionKey.value(0);
        this.passwordAuthenticatorOptional.ifPresent(passwordAuthenticator -> passwordAuthenticator.getCredentialsCache().invalidate(roleName));
    }

    @Override
    public void truncate() {
        this.passwordAuthenticatorOptional.ifPresent(passwordAuthenticator -> passwordAuthenticator.getCredentialsCache().invalidate());
    }
}

