/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import org.apache.cassandra.utils.Shared;

@Shared(scope={Shared.Scope.SIMULATION}, inner=Shared.Recursive.INTERFACES)
public interface DebuggableTask {
    public long creationTimeNanos();

    public long startTimeNanos();

    public String description();

    public static class RunningDebuggableTask
    implements DebuggableTask {
        private final DebuggableTask task;
        private final String threadId;

        public RunningDebuggableTask(String threadId, DebuggableTask task) {
            this.task = task;
            this.threadId = threadId;
        }

        public String threadId() {
            return this.threadId;
        }

        public boolean hasTask() {
            return this.task != null;
        }

        @Override
        public long creationTimeNanos() {
            assert (this.hasTask());
            return this.task.creationTimeNanos();
        }

        @Override
        public long startTimeNanos() {
            assert (this.hasTask());
            return this.task.startTimeNanos();
        }

        @Override
        public String description() {
            assert (this.hasTask());
            return this.task.description();
        }
    }

    public static interface RunnableDebuggableTask
    extends Runnable,
    DebuggableTask {
    }
}

